<?php

/*
 *  ========================================================================
 *  * Open eClass
 *  * E-learning and Course Management System
 *  * ========================================================================
 *  * Copyright 2003-2024, Greek Universities Network - GUnet
 *  *
 *  * Open eClass is an open platform distributed in the hope that it will
 *  * be useful (without any warranty), under the terms of the GNU (General
 *  * Public License) as published by the Free Software Foundation.
 *  * The full license can be read in "/info/license/license_gpl.txt".
 *  *
 *  * Contact address: GUnet Asynchronous eLearning Group
 *  *                  e-mail: info@openeclass.org
 *  * ========================================================================
 *
 */

/* ===========================================================================
  insertMyModule.php
  @last update: 29-08-2009 by Thanos Kyritsis
  @authors list: Thanos Kyritsis <atkyritsis@upnet.gr>

  based on Claroline version 1.7 licensed under GPL
  copyright (c) 2001, 2006 Universite catholique de Louvain (UCL)

  original file: insertMyModule.php Revision: 1.22

  Claroline authors: Piraux Sebastien <pir@cerdecam.be>
  Lederer Guillaume <led@cerdecam.be>
  ==============================================================================
  @Description: This script lists all available modules and the course
  admin can add them to a learning path

  @Comments:

  @todo:
  ==============================================================================
 */

$require_current_course = TRUE;
$require_editor = TRUE;

include '../../include/baseTheme.php';
require_once 'include/lib/learnPathLib.inc.php';
require_once 'include/lib/fileDisplayLib.inc.php';
require_once 'include/lib/modalboxhelper.class.php';
require_once 'include/lib/multimediahelper.class.php';

ModalBoxHelper::loadModalBox();
$head_content .= <<<EOF
<script type='text/javascript'>
$(document).ready(function() {

    $('tr').click(function(event) {
        if (event.target.type !== 'checkbox') {
            $(':checkbox', this).trigger('click');
        }
    });

});
</script>
EOF;

$navigation[] = array("url" => "index.php?course=$course_code", "name" => $langLearnPath);
$navigation[] = array("url" => "learningPathAdmin.php?course=$course_code&amp;path_id=" . (int) $_SESSION['path_id'], "name" => $langAdm);
$toolName = $langInsertMyModulesTitle;

if (isset($_REQUEST['cmdglobal']) && ($_REQUEST['cmdglobal'] == 'add')) {
    // select all 'addable' modules of this course for this learning path
    $result = Database::get()->queryArray(buildRequestModules());
    $atLeastOne = FALSE;
    $nb = 0;
    foreach ($result as $list) {
        // see if check box was checked
        if (isset($_REQUEST['check_' . $list->module_id]) && $_REQUEST['check_' . $list->module_id]) {
            // find the order place where the module has to be put in the learning path
            $order = 1 + intval(Database::get()->querySingle("SELECT MAX(`rank`) AS max
                    FROM `lp_rel_learnPath_module`
                    WHERE learnPath_id = ?d", $_SESSION['path_id'])->max);

            //create and call the insertquery on the DB to add the checked module to the learning path
            Database::get()->query("INSERT INTO `lp_rel_learnPath_module`
                          (`learnPath_id`, `module_id`, `specificComment`, `rank`, `lock`, `visible` )
                          VALUES (?d, ?d, '', ?d, 'OPEN', 1)", $_SESSION['path_id'], $list->module_id, $order);

            $atleastOne = TRUE;
            $nb++;
        }
    }
    Session::flash('message',$langInsertedAsModule);
    Session::flash('alert-class', 'alert-info');
    redirect_to_home_page('modules/learnPath/learningPathAdmin.php?course='.$course_code);
} //end if ADD command

$result = Database::get()->queryArray(buildRequestModules());

$tool_content .= '<form name="addmodule" action="' . $_SERVER['SCRIPT_NAME'] . '?course=' . $course_code . '&amp;cmdglobal=add">' . "\n\n";
$tool_content .= '<div class="table-responsive"><table class="table-default">'
        . '<thead><tr class="list-header">'
        . '<th>'.$langLearningModule.'</th>'
        . '<th>'
        . $langSelection
        . '</th>'
        . '</tr></thead>';

// Display available modules
$atleastOne = FALSE;

foreach ($result as $list) {

    //CHECKBOX, NAME, RENAME, COMMENT
    if ($list->contentType == CTEXERCISE_) {
        $moduleImg = 'fa-square-pen';
    } else if ($list->contentType == CTLINK_) {
        $moduleImg = 'fa-link';
    } else if ($list->contentType == CTCOURSE_DESCRIPTION_) {
        $moduleImg = 'fa-info-circle';
    } else if ($list->contentType == CTMEDIA_ || $list->contentType == CTMEDIALINK_) {
        $moduleImg = 'fa-film';
    } else {
        $moduleImg = choose_image(basename($list->path));
    }

    $contentType_alt = selectAlt($list->contentType);

    $tool_content .= '<tr>'
            . '<td align="left">'
            . '<label for="check_' . $list->module_id . '" >' . icon($moduleImg, $contentType_alt) . '&nbsp;<b>' . $list->name . '</b></label>';

    // COMMENT
    if ($list->comment != null) {
        $tool_content .= '<br><br><em>' . $langComments . '</em>: <br />' . $list->comment;
    }
    $tool_content .= '</td>'
            . '<td align="center">'
            . '<label class="label-container" aria-label="'.$langSelect.'"><input type="checkbox" name="check_' . $list->module_id . '" id="check_' . $list->module_id . '">'
            . '<span class="checkmark"></span></label></td>'
            . '</tr>';

    $atleastOne = TRUE;
}//end while another module to display

if (!$atleastOne) {
    $tool_content .= "<div class='alert alert-warning'>
                        <i class='fa-solid fa-triangle-exclamation fa-lg'></i>
                        <span>$langNoMoreModuleToAdd</span>
                    </div>";
}

// Display button to add selected modules
$tool_content .= "</table></div>";

if ($atleastOne) {
    $tool_content .= "<div class='form-group'>
                    <div class='col-12 d-inline-flex justify-content-end gap-2 mt-4'> 
                    <button class='btn submitAdminBtnDefault' value='$langAddOneModuleButton'>$langAdd</button>
                    <a href='learningPathAdmin.php?course=$course_code&amp;path_id=$_SESSION[path_id]' class='btn cancelAdminBtn'>$langCancel</a>
                    <input type='hidden' name='cmdglobal' value='add'></div>";

}

$tool_content .= "</form>";

draw($tool_content, 2, null, $head_content);


/**
 * @brief select available modules
 * @global type $course_id
 * @return string
 */
function buildRequestModules() {
    global $course_id;

    $firstSql = "SELECT LPM.`module_id`
              FROM `lp_rel_learnPath_module` AS LPM
              WHERE LPM.`learnPath_id` = ?d";

    $firstResult = Database::get()->queryArray($firstSql, $_SESSION['path_id']);

    $sql = "SELECT M.*, A.`path`
         FROM `lp_module` AS M
           LEFT JOIN `lp_asset` AS A ON M.`startAsset_id` = A.`asset_id`
         WHERE M.`contentType` != \"SCORM\"
           AND M.`contentType` != \"SCORM_ASSET\"
           AND M.`contentType` != \"LABEL\"
           AND M.`course_id` = " . intval($course_id);

    foreach ($firstResult as $list) {
        $sql .=" AND M.`module_id` != " . intval($list->module_id);
    }
    return $sql;
}
