<?php

/*
 *  ========================================================================
 *  * Open eClass
 *  * E-learning and Course Management System
 *  * ========================================================================
 *  * Copyright 2003-2024, Greek Universities Network - GUnet
 *  *
 *  * Open eClass is an open platform distributed in the hope that it will
 *  * be useful (without any warranty), under the terms of the GNU (General
 *  * Public License) as published by the Free Software Foundation.
 *  * The full license can be read in "/info/license/license_gpl.txt".
 *  *
 *  * Contact address: GUnet Asynchronous eLearning Group
 *  *                  e-mail: info@openeclass.org
 *  * ========================================================================
 *
 */

/**
 *  @file info.php
 *  @brief edit or create course unit
 */

$require_current_course = true;
$require_editor = true;
$require_help = true;
$helpTopic = 'AddCourseUnits';
require_once '../../include/baseTheme.php';
require_once 'modules/tags/moduleElement.class.php';

load_js('tools.js');
load_js('select2');
load_js('bootstrap-datepicker');

$data['start_week'] = $data['finish_week'] = '';
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $pageName = $langEditUnit;
    $cu = Database::get()->querySingle("SELECT id, title, comments, 
                                        start_week, finish_week
                                    FROM course_units WHERE id = ?d AND course_id = ?d",
                                        $id, $course_id);
    $navigation[] = [ 'name' => $cu->title, 'url' => "index.php?course=$course_code&id=$id"];
    if (!$cu) {
        Session::flash('message',$langUnknownResType);
        Session::flash('alert-class', 'alert-warning');
        redirect_to_home_page("courses/$course_code/");
    }
    $unitDescr = $cu->comments;
    if (!(is_null($cu->start_week))) {
        $data['start_week'] = DateTime::createFromFormat('Y-m-d', $cu->start_week)->format('d-m-Y');
    }
    if (!(is_null($cu->finish_week))) {
        $data['finish_week'] = DateTime::createFromFormat('Y-m-d', $cu->finish_week)->format('d-m-Y');
    }
    $data['unitTitle'] = $cu->title;
    $data['unitId'] = $cu->id;

} else {
    $pageName = $langAddUnit;
    $unitDescr = '';
    $data['unitTitle'] = $data['unitId'] = null;
}

$data['postUrl'] = "index.php?course=$course_code" .
    ($data['unitId'] ? "&id=$data[unitId]": '');
$data['descriptionEditor'] = rich_text_editor('unitdescr', 10, 20, $unitDescr);
$data['tagInput'] = $data['unitId']? eClassTag::tagInput($data['unitId']): eClassTag::tagInput();

view('modules.units.info', $data);
