import { UIPlugin } from '@uppy/core';
import type { UIPluginOptions, Uppy, DefinePluginOpts, Body, Meta } from '@uppy/core';
import { type ComponentChild } from 'preact';
export interface DragDropOptions extends UIPluginOptions {
    inputName?: string;
    allowMultipleFiles?: boolean;
    width?: string | number;
    height?: string | number;
    note?: string;
    onDragOver?: (event: DragEvent) => void;
    onDragLeave?: (event: DragEvent) => void;
    onDrop?: (event: DragEvent) => void;
}
declare const defaultOptions: {
    inputName: string;
    width: string;
    height: string;
};
/**
 * Drag & Drop plugin
 *
 */
export default class DragDrop<M extends Meta, B extends Body> extends UIPlugin<DefinePluginOpts<DragDropOptions, keyof typeof defaultOptions>, M, B> {
    static VERSION: any;
    private isDragDropSupported;
    private fileInputRef;
    constructor(uppy: Uppy<M, B>, opts?: DragDropOptions);
    private addFiles;
    private onInputChange;
    private handleDragOver;
    private handleDragLeave;
    private handleDrop;
    private renderHiddenFileInput;
    private static renderArrowSvg;
    private renderLabel;
    private renderNote;
    render(): ComponentChild;
    install(): void;
    uninstall(): void;
}
export {};
//# sourceMappingURL=DragDrop.d.ts.map