import type { Locale } from '@uppy/utils/lib/Translator'

const th_TH: Locale<0 | 1> = {
  strings: {},
  pluralize(n) {
    if (n === 1) {
      return 0
    }
    return 1
  },
}

th_TH.strings = {
  addBulkFilesFailed: {
    '0': 'ไม่สามารถเพิ่ม %{smart_count} ไฟล์ เนื่องจากข้อผิดพลาดภายใน',
    '1': 'ไม่สามารถเพิ่ม %{smart_count} ไฟล์ เนื่องจากข้อผิดพลาดภายใน',
  },
  addMore: 'เพิ่ม',
  addMoreFiles: 'เพิ่มไฟล์',
  addingMoreFiles: 'กำลังเพิ่มไฟล์',
  allowAccessDescription:
    'ในการถ่ายภาพหรือบันทึกวิดีโอด้วยกล้องของคุณ โปรดอนุญาตการเข้าถึงกล้อง',
  allowAccessTitle: 'กรุณากดปุ่มยอมรับเพื่อใช้งานกล้อง',
  aspectRatioLandscape: 'ครอบตัดภาพทิวทัศน์ (16:9)',
  aspectRatioPortrait: 'ครอบตัดภาพบุคคล (9:16)',
  aspectRatioSquare: 'ครอบตัดสี่เหลี่ยม',
  authenticateWith: 'เชื่อมต่อกับ %{pluginName}',
  authenticateWithTitle: 'กรุณาเข้าใช้งานกับ %{pluginName} เพื่อเลือกไฟล์',
  back: 'ย้อนกลับ',
  browse: 'เรียกดู',
  browseFiles: 'เรียกดู',
  browseFolders: 'เรียกดูทั้งโฟลเดอร์',
  cancel: 'ยกเลิก',
  cancelUpload: 'ยกเลิกการอัปโหลด',
  chooseFiles: 'เลือกไฟล์',
  closeModal: 'ปิดหน้าต่างนี้',
  companionError: 'การเชื่อมต่อกับ Companion ล้มเหลว',
  companionUnauthorizeHint:
    'หากคุณต้องการลงชื่อออกจาก %{provider}, กรุณาไปที่ %{url}',
  complete: 'สำเร็จ',
  connectedToInternet: 'เชื่อมต่อกับอินเทอร์เน็ตสำเร็จ',
  copyLink: 'คัดลอกลิงค์',
  copyLinkToClipboardFallback: 'คัดลอก URL ด้านล่าง',
  copyLinkToClipboardSuccess: 'ลิงก์ถูกคัดลอกไปยังคลิปบอร์ด',
  creatingAssembly: 'กำลังเตรียมอัพโหลด...',
  creatingAssemblyFailed: 'Transloadit: ไม่สามารถสร้าง Assembly',
  dashboardTitle: 'ตัวอัพโหลดไฟล์',
  dashboardWindowTitle: 'หน้าต่างอัพโหลดไฟล์ (กด escape เพื่อปิด)',
  dataUploadedOfTotal: '%{complete} จาก %{total}',
  done: 'เสร็จสิ้น',
  dropHereOr: 'ลากไฟล์มาวางที่นี่ หรือเลือก %{browse}',
  dropHint: 'ลากไฟล์มาวางที่นี่',
  dropPasteBoth: 'ลากไฟล์มาวางที่นี่ หรือเลือก %{browse}',
  dropPasteFiles: 'ลากไฟล์มาวางที่นี่ หรือเลือก %{browse}',
  dropPasteFolders: 'ลากไฟล์มาวางที่นี่ หรือเลือก %{browse}',
  dropPasteImportBoth: 'ลากไฟล์มาวางที่นี่ หรือ %{browse} หรือ เปิดกล้อง',
  dropPasteImportFiles: 'ลากไฟล์มาวางที่นี่ หรือ %{browse} หรือ เปิดกล้อง',
  dropPasteImportFolders: 'ลากไฟล์มาวางที่นี่ หรือ %{browse} หรือ เปิดกล้อง',
  editFile: 'แก้ไขไฟล์',
  editImage: 'แก้ไขภาพ',
  editing: 'กำลังแก้ไข %{file}',
  emptyFolderAdded: 'ไม่สามารถเพิ่มไฟล์จากโฟลเดอร์ว่าง',
  encoding: 'กำลังเข้ารหัส...',
  enterCorrectUrl: 'URL ไม่ถูกต้อง: โปรดตรวจสอบให้แน่ใจว่าคุณป้อน direct link',
  enterUrlToImport: 'ป้อน URL เพื่อนำเข้าไฟล์',
  exceedsSize: 'ไฟล์นี้มีขนาดเกินขนาดสูงสุดที่อนุญาต %{size}',
  failedToFetch:
    'Companion ไม่สามารถเรียก URL นี้ได้, กรุณาตรวจสอบว่า URL ถูกต้อง',
  failedToUpload: 'ไม่สามารถอัปโหลด %{file}',
  fileSource: 'ตำแหน่งของไฟล์: %{name}',
  filesUploadedOfTotal: {
    '0': 'อัพโหลดสำเร็จ %{complete} จากทั้งหมด %{smart_count} ไฟล์',
    '1': 'อัพโหลดสำเร็จ %{complete} จากทั้งหมด %{smart_count} ไฟล์',
  },
  filter: 'ตัวกรอง',
  finishEditingFile: 'แก้ไขไฟล์สำเร็จ',
  flipHorizontal: 'กลับตามแนวนอน',
  folderAdded: {
    '0': 'เพิ่ม %{smart_count} ไฟล์จาก %{folder}',
    '1': 'เพิ่ม %{smart_count} ไฟล์จาก %{folder}',
  },
  generatingThumbnails: 'กำลังสร้างภาพขนาดย่อ...',
  import: 'นำเข้า',
  importFrom: 'นำเข้าจาก %{name}',
  inferiorSize: 'ไฟล์นี้มีขนาดเล็กกว่าขนาดไฟล์ที่กำหนด %{size}',
  loading: 'กำลังโหลด...',
  logOut: 'ออกจากระบบ',
  micDisabled: 'ไมโครโฟนถูกปิดโดยผู้ใช้',
  myDevice: 'ภาพในเครื่อง',
  noCameraDescription: 'ในการถ่ายภาพหรือบันทึกวิดีโอโปรดเชื่อมต่ออุปกรณ์กล้อง',
  noCameraTitle: 'กล้องไม่พร้อมใช้งาน',
  noDuplicates: "ไม่สามารถเพิ่มไฟล์ซ้ำได้ ไฟล์ '%{fileName}', มีอยู่แล้ว",
  noFilesFound: 'คุณไม่มีไฟล์หรือโฟลเดอร์ที่นี่',
  noInternetConnection: 'ไม่มีการเชื่อมต่ออินเทอร์เน็ต',
  noMoreFilesAllowed: 'ไม่สามารถเพิ่มไฟล์ใหม่: กำลังอยู่ระหว่างอัพโหลด',
  openFolderNamed: 'เปิดโฟลเดอร์ %{name}',
  pause: 'หยุดชั่วคราว',
  pauseUpload: 'หยุดการอัปโหลดชั่วคราว',
  paused: 'หยุดชั่วคราว',
  poweredBy: 'ขับเคลื่อนโดย %{uppy}',
  processingXFiles: {
    '0': 'กำลังประมวลผล %{smart_count} ไฟล์',
    '1': 'กำลังประมวลผล %{smart_count} ไฟล์',
  },
  recording: 'กำลังบันทึก',
  recordingLength: 'ความยาว %{recording_length}',
  recordingStoppedMaxSize: 'หยุดการบันทึกเนื่องจากขนาดไฟล์กำลังเกินขีดจำกัด',
  removeFile: 'ลบไฟล์',
  resetFilter: 'รีเซ็ตตัวกรอง',
  resume: 'ทำต่อ',
  resumeUpload: 'ทำการอัปโหลดต่อ',
  retry: 'ลองใหม่อีกครั้ง',
  retryUpload: 'ลองอัพโหลดใหม่',
  revert: 'เปลี่ยนกลับ',
  rotate: 'หมุน',
  save: 'บันทึก',
  saveChanges: 'บันทึกการแก้ไข',
  selectFileNamed: 'เลือกไฟล์ %{name}',
  selectX: {
    '0': 'เลือก %{smart_count}',
    '1': 'เลือก %{smart_count}',
  },
  smile: 'ยิ้ม!',
  startCapturing: 'เริ่มการจับภาพหน้าจอ',
  startRecording: 'เริ่มการบันทึกวิดีโอ',
  stopCapturing: 'หยุดการจับภาพหน้าจอ',
  stopRecording: 'หยุดการบันทึกวิดีโอ',
  streamActive: 'สตรีมทำงานอยู่',
  streamPassive: 'สตรีมแบบพาสซีฟ',
  submitRecordedFile: 'ส่งวิดีโอที่ถ่าย',
  takePicture: 'ถ่ายภาพ',
  timedOut: 'ยกเลิก, ไม่สามารถอัพโหลดไฟล์ได้เป็นเวลา %{seconds} วินาที',
  unselectFileNamed: 'ยกเลิกการเลือกไฟล์ %{name}',
  upload: 'อัพโหลด',
  uploadComplete: 'อัพโหลดไฟล์สำเร็จ',
  uploadFailed: 'อัปโหลดไฟล์ไม่สำเร็จ',
  uploadPaused: 'หยุดอัปโหลดไฟล์ชั่วคราว',
  uploadXFiles: {
    '0': 'กำลังอัพโหลด %{smart_count} ไฟล์',
    '1': 'กำลังอัพโหลด %{smart_count} ไฟล์',
  },
  uploadXNewFiles: {
    '0': 'กำลังอัพโหลด +%{smart_count} ไฟล์',
    '1': 'กำลังอัพโหลด +%{smart_count} ไฟล์',
  },
  uploading: 'Uploading',
  uploadingXFiles: {
    '0': 'กำลังอัพโหลด %{smart_count} ไฟล์',
    '1': 'กำลังอัพโหลด %{smart_count} ไฟล์',
  },
  xFilesSelected: {
    '0': '%{smart_count} ไฟล์ถูกเลือก',
    '1': '%{smart_count} ไฟล์ถูกเลือก',
  },
  xMoreFilesAdded: {
    '0': '%{smart_count} ไฟล์ที่สามารถเพิ่มได้',
    '1': '%{smart_count} ไฟล์ที่สามารถเพิ่มได้',
  },
  xTimeLeft: 'เหลืออีก %{time}',
  youCanOnlyUploadFileTypes: 'คุณสามารถอัพโหลดได้แค่: %{types}',
  youCanOnlyUploadX: {
    '0': 'คุณสามารถอัพโหลดได้แค่ %{smart_count} ไฟล์',
    '1': 'คุณสามารถอัพโหลดได้แค่ %{smart_count} ไฟล์',
  },
  youHaveToAtLeastSelectX: {
    '0': 'คุณต้องเลือกอย่างน้อย %{smart_count} ไฟล์',
    '1': 'คุณต้องเลือกอย่างน้อย %{smart_count} ไฟล์',
  },
  zoomIn: 'ซูมเข้า',
  zoomOut: 'ซูมออก',
}

export default th_TH
