export type GenericState = Record<string, unknown>;
export type Listener<T> = (prevState: T, nextState: T, patch?: Partial<T>) => void;
export interface Store<T extends GenericState> {
    getState: () => T;
    setState(patch?: Partial<T>): void;
    subscribe(listener: Listener<T>): () => void;
}
/**
 * Default store that keeps state in a simple object.
 */
declare class DefaultStore<T extends GenericState = GenericState> implements Store<T> {
    #private;
    static VERSION: any;
    state: T;
    getState(): T;
    setState(patch?: Partial<T>): void;
    subscribe(listener: Listener<T>): () => void;
}
export default DefaultStore;
//# sourceMappingURL=index.d.ts.map