import { UIPlugin } from '@uppy/core';
import type { Uppy, UIPluginOptions, DefinePluginOpts } from '@uppy/core';
import type { Body, Meta, UppyFile } from '@uppy/utils/lib/UppyFile';
declare module '@uppy/core' {
    interface UppyEventMap<M extends Meta, B extends Body> {
        'thumbnail:all-generated': () => void;
        'thumbnail:generated': (file: UppyFile<M, B>, preview: string) => void;
        'thumbnail:error': (file: UppyFile<M, B>, error: Error) => void;
        'thumbnail:request': (file: UppyFile<M, B>) => void;
        'thumbnail:cancel': (file: UppyFile<M, B>) => void;
    }
}
export interface ThumbnailGeneratorOptions extends UIPluginOptions {
    thumbnailWidth?: number | null;
    thumbnailHeight?: number | null;
    thumbnailType?: string;
    waitForThumbnailsBeforeUpload?: boolean;
    lazy?: boolean;
}
declare const defaultOptions: {
    thumbnailWidth: null;
    thumbnailHeight: null;
    thumbnailType: string;
    waitForThumbnailsBeforeUpload: boolean;
    lazy: boolean;
};
type Opts = DefinePluginOpts<ThumbnailGeneratorOptions, keyof typeof defaultOptions>;
/**
 * The Thumbnail Generator plugin
 */
export default class ThumbnailGenerator<M extends Meta, B extends Body> extends UIPlugin<Opts, M, B> {
    static VERSION: any;
    queue: string[];
    queueProcessing: boolean;
    defaultThumbnailDimension: number;
    thumbnailType: string;
    constructor(uppy: Uppy<M, B>, opts?: ThumbnailGeneratorOptions);
    createThumbnail(file: UppyFile<M, B>, targetWidth: number | null, targetHeight: number | null): Promise<string>;
    /**
     * Get the new calculated dimensions for the given image and a target width
     * or height. If both width and height are given, only width is taken into
     * account. If neither width nor height are given, the default dimension
     * is used.
     */
    getProportionalDimensions(img: HTMLImageElement, width: number | null, height: number | null, deg: number): {
        width: number;
        height: number;
    };
    /**
     * Resize an image to the target `width` and `height`.
     *
     * Returns a Canvas with the resized image on it.
     */
    resizeImage(image: HTMLCanvasElement, targetWidth: number, targetHeight: number): HTMLCanvasElement;
    /**
     * Set the preview URL for a file.
     */
    setPreviewURL(fileID: string, preview: string): void;
    addToQueue(fileID: string): void;
    processQueue(): Promise<void>;
    requestThumbnail(file: UppyFile<M, B>): Promise<void>;
    onFileAdded: (file: UppyFile<M, B>) => void;
    /**
     * Cancel a lazy request for a thumbnail if the thumbnail has not yet been generated.
     */
    onCancelRequest: (file: UppyFile<M, B>) => void;
    /**
     * Clean up the thumbnail for a file. Cancel lazy requests and free the thumbnail URL.
     */
    onFileRemoved: (file: UppyFile<M, B>) => void;
    onRestored: () => void;
    onAllFilesRemoved: () => void;
    waitUntilAllProcessed: (fileIDs: string[]) => Promise<void>;
    install(): void;
    uninstall(): void;
}
export {};
//# sourceMappingURL=index.d.ts.map