import type Uppy from '@uppy/core';
import type { UppyFile, Meta, Body } from '@uppy/utils/lib/UppyFile';
import type { RequestOptions } from '@uppy/utils/lib/CompanionClientProvider';
type CompanionHeaders = Record<string, string> | undefined;
export type Opts = {
    name?: string;
    provider: string;
    pluginId: string;
    companionUrl: string;
    companionCookiesRule?: 'same-origin' | 'include' | 'omit';
    companionHeaders?: CompanionHeaders;
    companionKeysParams?: Record<string, string>;
};
export declare const authErrorStatusCode = 401;
export default class RequestClient<M extends Meta, B extends Body> {
    #private;
    static VERSION: any;
    uppy: Uppy<M, B>;
    opts: Opts;
    constructor(uppy: Uppy<M, B>, opts: Opts);
    setCompanionHeaders(headers: Record<string, string>): void;
    get hostname(): string;
    headers(emptyBody?: boolean): Promise<Record<string, string>>;
    onReceiveResponse(res: Response): void;
    protected request<ResBody>({ path, method, data, skipPostResponse, signal, }: {
        path: string;
        method?: string;
        data?: Record<string, unknown>;
        skipPostResponse?: boolean;
        signal?: AbortSignal;
    }): Promise<ResBody>;
    get<PostBody>(path: string, options?: RequestOptions): Promise<PostBody>;
    post<PostBody>(path: string, data: Record<string, unknown>, options?: RequestOptions): Promise<PostBody>;
    delete<T>(path: string, data?: Record<string, unknown>, options?: RequestOptions): Promise<T>;
    /**
     * Remote uploading consists of two steps:
     * 1. #requestSocketToken which starts the download/upload in companion and returns a unique token for the upload.
     * Then companion will halt the upload until:
     * 2. #awaitRemoteFileUpload is called, which will open/ensure a websocket connection towards companion, with the
     * previously generated token provided. It returns a promise that will resolve/reject once the file has finished
     * uploading or is otherwise done (failed, canceled)
     */
    uploadRemoteFile(file: UppyFile<M, B>, reqBody: Record<string, unknown>, options: {
        signal: AbortSignal;
        getQueue: () => any;
    }): Promise<void>;
}
export {};
//# sourceMappingURL=RequestClient.d.ts.map