/**
 * Core plugin logic that all plugins share.
 *
 * BasePlugin does not contain DOM rendering so it can be used for plugins
 * without a user interface.
 *
 * See `Plugin` for the extended version with Preact rendering for interfaces.
 */
import Translator from '@uppy/utils/lib/Translator';
import type { I18n, Locale, OptionalPluralizeLocale } from '@uppy/utils/lib/Translator';
import type { Body, Meta } from '@uppy/utils/lib/UppyFile';
import type { State, UnknownPlugin, Uppy } from './Uppy.js';
export type PluginOpts = {
    locale?: Locale;
    id?: string;
};
export type OnlyOptionals<T> = Pick<T, {
    [K in keyof T]-?: {} extends Pick<T, K> ? K : never;
}[keyof T]>;
/**
 * DefinePluginOpts marks all of the passed AlwaysDefinedKeys as “required” or “always defined”.
 */
export type DefinePluginOpts<Opts, AlwaysDefinedKeys extends keyof OnlyOptionals<Opts>> = Opts & Required<Pick<Opts, AlwaysDefinedKeys>>;
export default class BasePlugin<Opts extends PluginOpts, M extends Meta, B extends Body, PluginState extends Record<string, unknown> = Record<string, unknown>> {
    uppy: Uppy<M, B>;
    opts: Opts;
    id: string;
    defaultLocale: OptionalPluralizeLocale;
    i18n: I18n;
    i18nArray: Translator['translateArray'];
    type: string;
    VERSION: string;
    constructor(uppy: Uppy<M, B>, opts?: Opts);
    getPluginState(): PluginState;
    setPluginState(update?: Partial<PluginState>): void;
    setOptions(newOpts: Partial<Opts>): void;
    i18nInit(): void;
    /**
     * Extendable methods
     * ==================
     * These methods are here to serve as an overview of the extendable methods as well as
     * making them not conditional in use, such as `if (this.afterUpdate)`.
     */
    addTarget(plugin: UnknownPlugin<M, B>): HTMLElement | null;
    install(): void;
    uninstall(): void;
    update(state: Partial<State<M, B>>): void;
    afterUpdate(): void;
}
//# sourceMappingURL=BasePlugin.d.ts.map