import type { Meta, Body, UppyFile } from '@uppy/utils/lib/UppyFile';
import type { Uppy, UppyEventMap, _UppyEventMap } from './Uppy.js';
/**
 * Create a wrapper around an event emitter with a `remove` method to remove
 * all events that were added using the wrapped emitter.
 */
export default class EventManager<M extends Meta, B extends Body> {
    #private;
    constructor(uppy: Uppy<M, B>);
    on<K extends keyof _UppyEventMap<M, B>>(event: K, fn: _UppyEventMap<M, B>[K]): Uppy<M, B>;
    remove(): void;
    onFilePause(fileID: UppyFile<M, B>['id'], cb: (isPaused: boolean) => void): void;
    onFileRemove(fileID: UppyFile<M, B>['id'], cb: (isPaused: UppyFile<M, B>['id']) => void): void;
    onPause(fileID: UppyFile<M, B>['id'], cb: (isPaused: boolean) => void): void;
    onRetry(fileID: UppyFile<M, B>['id'], cb: () => void): void;
    onRetryAll(fileID: UppyFile<M, B>['id'], cb: () => void): void;
    onPauseAll(fileID: UppyFile<M, B>['id'], cb: () => void): void;
    onCancelAll(fileID: UppyFile<M, B>['id'], eventHandler: UppyEventMap<M, B>['cancel-all']): void;
    onResumeAll(fileID: UppyFile<M, B>['id'], cb: () => void): void;
}
//# sourceMappingURL=EventManager.d.ts.map