<?php

/*
 *  ========================================================================
 *  * Open eClass
 *  * E-learning and Course Management System
 *  * ========================================================================
 *  * Copyright 2003-2024, Greek Universities Network - GUnet
 *  *
 *  * Open eClass is an open platform distributed in the hope that it will
 *  * be useful (without any warranty), under the terms of the GNU (General
 *  * Public License) as published by the Free Software Foundation.
 *  * The full license can be read in "/info/license/license_gpl.txt".
 *  *
 *  * Contact address: GUnet Asynchronous eLearning Group
 *  *                  e-mail: info@openeclass.org
 *  * ========================================================================
 *
 */

$langLocale = 'el_GR.UTF-8';
$langIntro = "Η πλατφόρμα <strong>$siteName</strong> είναι ένα ολοκληρωμένο Σύστημα Διαχείρισης Ηλεκτρονικών $langOfCourses και υποστηρίζει την Υπηρεσία Ασύγχρονης Τηλεκπαίδευσης στο <a href=\"$InstitutionUrl\" target=\"_blank\" class=mainpage>$Institution</a>.";
$langVersion = "Έκδοση";
$langAboutText = "Η έκδοση της πλατφόρμας είναι";
$langHostName = "Ο υπολογιστής στον οποίο βρίσκεται η πλατφόρμα είναι ο ";
$langMySqlVersion = "Έκδοση βάσης δεδομένων";
$langWebServerVersion = "Έκδοση του Web Server";
$langNoMysql = "Η MySql δεν λειτουργεί !";
$langUptime = "Λειτουργεί από τις";
$langTotalHits = "Συνολικός αριθμός προβολών";
$langLast30daysLogins = "Συνολικές προσβάσεις στην πλατφόρμα τις τελευταίες 30 μέρες";
$langTotalCourses = "Αριθμός $langsOfCourses";
$langInfo = "Ταυτότητα Πλατφόρμας";
$langAboutCourses = "Η πλατφόρμα υποστηρίζει συνολικά";
$langOperation = "Λειτουργία";
$langContactInfo = "Στοιχεία επικοινωνίας";
$langInCourses = "στο $langsCourse";
$langInCoursesL = "στο $langsCourse";
$langResourceBrowser = 'Αναζήτηση πόρων';
$langYes = "Ναι";
$langNo = "Όχι";
$langSelectReq = "Διαλέξτε τουλάχιστον μία επιλογή!";
$langBulkProcessing = "Μαζική Επεξεργασία";

// For the logged-out user:
$langAnd = "και";
$langClosed = "κλειστά";
$langOpen = "ανοικτά";
$langOpenCourseWithRegistration = "Απαιτούν εγγραφή";
$langSemiopen = "απαιτούν εγγραφή";
$langUsers = "Χρήστες";
$langUsersS = "χρήστες";
$langUsersOf = "χρηστών";
$langUser = "Χρήστης";
$langOfUser = "Χρήστη";
$langUserHeader = "Χρήστης:";
$langUserS = "χρήστης";
$langOfUserS = "χρήστη";
$langUsersWithRightsS = "Χρήστες με δικαιώματα";
$langUsersWithNoRightsS = "Χρήστες χωρίς δικαιώματα";
$langUserWithRights = "Χρήστη με δικαιώματα δημιουργίας μαθημάτων";
$langUserWithNoRights = "Χρήστη χωρίς δικαιώματα δημιουργίας μαθημάτων";
$langUsersWithTeacherRights = "Χρήστες με δικαιώματα δημιουργίας μαθημάτων";
$langUsersWithNoTeacherRights = "Χρήστες χωρίς δικαιώματα δημιουργίας μαθημάτων";
$langWithRights = "με δικαίωμα δημιουργίας μαθημάτων";
$langWithCourseCreationRights = "δημιουργίας μαθημάτων";
$langWithNoCourseCreationRights = "όχι δημιουργίας μαθημάτων";
$langSupportUser = "Υποστήριξη";
$langAdminUsers = "Διαχείριση χρηστών";
$langOnlineUsers = "Συνδεδεμένοι χρήστες";
$langActiveRooms = "Ενεργά δωμάτια";
$langVisible = "Ορατή";
$langInvisible = "Μη ορατή";
$langNoAccountPleaseRegister = 'Δεν έχετε λογαριασμό; Παρακαλούμε %sεγγραφείτε%s.';
$langAlreadyHaveAccount = "Έχετε ήδη λογαριασμό; %sΣυνδεθείτε%s";
$langGoToHomePage = 'Μετάβαση στην αρχική σελίδα';

// Toolbox
$langNumEntryFound = 'Βρέθηκε %s αποτέλεσμα για την αναζήτησή σας';
$langNumEntriesFound = 'Βρέθηκαν %s αποτελέσματα για την αναζήτησή σας';
$langNoEntriesFound = 'Δε βρέθηκαν αποτελέσματα για την αναζήτησή σας';
$langSearchForm = 'Φόρμα αναζήτησης';
$langSearchResults = 'Αποτελέσματα αναζήτησης';


/* * ******************************************
 * addadmin.php
 * ******************************************* */
$langAddAdmin = 'Προσθήκη διαχειριστή';
$langEditUser = 'Επεξεργασία χρήστη';
$langEditPrivilege = 'Επεξεργασία δικαιωμάτων';
$langDeleteAdmin = "H διαγραφή του διαχειριστή με id:";
$langNotFeasible = "δεν είναι εφικτή";
$langAdmins = "Διαχειριστές";
$langAddPowerUser = "Προσθήκη βοηθού διαχειριστή";
$langAddManageUser = "Προσθήκη διαχειριστή χρηστών";
$langPassword = "Συνθηματικό";
$langAdd = "Προσθήκη";
$langNotFound = "δεν βρέθηκε";
$langwith = "με";
$langDone = "έγινε διαχειριστής.";
$langErrorAddaAdmin = "Σφάλμα: ο χρήστης δεν προστέθηκε στους διαχειριστές. Πιθανόν να είναι ήδη διαχειριστής.";
$langInsertUserInfo = "Εισαγωγή στοιχείων χρήστη";
$langPage = "Σελίδα:";
$langBeforePage = "Προηγούμενη";
$langAfterPage = "Eπόμενη";
$langCannotDeleteAdmin = "Ο κεντρικός διαχειριστής της πλατφόρμας δεν μπορεί να διαγραφεί!";
$langNotAdmin = "Ο χρήστης δεν είναι πλέον διαχειριστής της πλατφόρμας";
$langPowerUser = "Βοηθός διαχειριστή";
$langManageUser = "Διαχειριστής Χρηστών";
$langHelpAdministrator = "Ο διαχειριστής μπορεί να διαχειριστεί όλη την πλατφόρμα";
$langHelpPowerUser = "Ο βοηθός διαχειριστή διαχειρίζεται τα $langsCourses και τους χρήστες";
$langHelpManageUser = "Ο διαχειριστής χρηστών διαχειρίζεται τους χρήστες";
$langManageDepartment = "Διαχειριστής Τμημάτων";
$langHelpManageDepartment = "Διαχειρίζεται τα τμήματα για τα οποία είναι υπεύθυνος";
$langEnableStrongPasswords = "Δημιουργία 'δύσκολων' συνθηματικών για τους λογαριασμούς χρηστών";

/* * **************************************************
 * admin.php
 * ************************************************** */
// index
$langComments = "Σχόλια";
$langCommentsUser = "Σχόλια χρηστών";
$langAdminTool = "Διαχείριση Πλατφόρμας";
$langState = "Διαχείριση εξυπηρετητή";
$langDevAdmin = "Διαχείριση Βάσης Δεδομένων";
$langSysInfo = "Πληροφορίες Συστήματος";
$langCheckDatabase = "Ελεγχος κύριας βάσης δεδομένων";
$langStatOf = "Στατιστικά του ";
$langSpeeSubscribe = "Εγγραφή ως Διαχειριστής $langOfCourse";
$langLogIdentLogout = "Καταγραφή των εισόδων και εξόδων από το σύστημα";
$langPlatformStats = "Στατιστικά Πλατφόρμας";
$langPlatformGenStats = "Γενικά στατιστικά";
$langVisitsStats = "Στατιστικά επισκέψεων";
$langMonthlyReport = "Μηνιαίες αναφορές";
$langMonthlyReportInfo = "Παρουσιάζονται συγκεντρωτικά στοιχεία (μαθήματα, χρήστες) των τελευταίων 24 μηνών.";
$langStatsReports = "Αναφορές συμμετοχής";
$langStatsReport = "Αναφορά συμμετοχής";
$langStatsReportsLP = "Αναφορές συμμετοχής στις γραμμές μάθησης";
$langStatsReportsTC = "Αναφορές συμμετοχής στη τηλεσυνεργασία";
$langReport = "Αναφορά για το μήνα";
$langNoReport = "Δεν υπάρχουν διαθέσιμα στοιχεία για το μήνα";
$langEmailNotSend = "Σφάλμα κατά την αποστολή e-mail στη διεύθυνση";
$langFound = "Βρέθηκαν";
$langFoundIt = "βρέθηκε";
$langListCours = "Λίστα $langOfCourses / Ενέργειες";
$langListUsersActions = "Λίστα Χρηστών / Ενέργειες";
$langSearchUser = "Αναζήτηση Χρήστη";
$langInfoMail = "Ενημερωτικό email";
$langProfReg = "Εγγραφή $langOfTeacher";
$langProfOpen = "Αιτήσεις $langOfTeachers";
$langUserOpen = "Αιτήσεις $langOfStudents";
$langUserRequests = "Αιτήσεις Χρηστών";
$langsUserRequests = "αιτήσεις χρηστών";
$langPHPInfo = "Πληροφορίες για την PHP";
$langManuals = "Εγχειρίδια";
$langFormatPDF = "Μορφή PDF";
$langFormatHTML = "Μορφή HTML";
$langAdminManual = "Εγχειρίδιο Διαχειριστή";
$langDBaseAdmin = "Διαχείριση Β.Δ. (phpMyAdmin)";
$langActions = "Ενέργειες";
$langAdminProf = "Διαχείριση $langOfTeachers";
$langAdminCours = "Διαχείριση $langsOfCourses";
$langGenAdmin = "Άλλα Εργαλεία";
$langBackAdmin = "Επιστροφή στη σελίδα διαχείρισης";
$langPlatformIdentity = "Σχετικά";
$langStoixeia = "Στοιχεία Πλατφόρμας";
$langThereAre = "Υπάρχουν";
$langThereIs = "Υπάρχει";
$langOpenRequests = "Ανοικτές αιτήσεις " . $langsOfTeachers;
$langNoOpenRequests = "Δεν βρέθηκαν ανοικτές αιτήσεις " . $langsOfTeachers;
$langInfoAdmin = "Ενημερωτικά Στοιχεία για τον Διαχειριστή";
$langLastLesson = "Τελευταίο $langsCourse που δημιουργήθηκε:";
$langLastProf = "Τελευταία εγγραφή $langsOfTeacher:";
$langLastStud = "Τελευταία εγγραφή $langsOfStudent:";
$langLastStudNone = "Δεν υπάρχουν εγγραφές";
$langAfterLastLogin = "Μετά την τελευταία σας είσοδο έχουν εγγραφεί στην πλατφόρμα:";
$langAfterLastLoginInfo = "Στοιχεία μετά την τελευταία σας είσοδο:";
$langOtherActions = "Άλλες Ενέργειες";
$langTeacherTutorials = "Χρήσιμοι Οδηγοί $langsOfTeacher";
$langStudentTutorials = "Χρήσιμοι Οδηγοί $langsOfStudent";
$langGeneralTutorials = "Εγχειρίδια χρήσης";
$langIndexInfo = "Ενημερωτικά στοιχεία για το Ευρετήριο";
$langIndexNumDocs = "Αριθμός Εγγράφων στο Ευρετήριο";
$langIndexIsOptimized = "Είναι βελτιστοποιημένο;";
$langOptimize = "Βελτιστοποίηση";
$langReindex = "Αναδημιουργία ευρετηρίου";
$langIndexDisabled = 'Η μηχανή ευρετηρίου είναι απενεργοποιημένη.';
$langCronInfo = "Ενημερωτικά στοιχεία για τις προγραμματισμένες εργασίες";
$langCronName = "Όνομα εργασίας";
$langCronLastRun = "Τελευταία Εκτέλεση";
$langExternalTools = 'Εξωτερικά εργαλεία';
$langDisableModules = "Απενεργοποιημένα εργαλεία";
$langDisableModulesHelp = "Μπορείτε να επιλέξετε ποια από τα παρακάτω
    εργαλεία επιθυμείτε να απενεργοποιηθούν από όλα τα $langsCourses της
    πλατφόρμας.";
$langDefaultModules = 'Προκαθορισμένα εργαλεία';
$langDefaultModulesHelp = "Τα παρακάτω εργαλεία είναι ενεργοποιημένα εξ
    ορισμού στα νέα $langsCourses της πλατφόρμας κατά τη δημιουργία τους.";
$langAutoEnroll = 'Αυτόματη εγγραφή';
$langAutoEnrollNew = 'Προσθήκη κανόνα';
$langAutoEnrollAdded = 'Ο κανόνας προστέθηκε';
$langAutoEnrollCourse = "Αυτόματη εγγραφή στα $langsCourses";
$langAutoEnrollDepartment = "Αυτόματη εγγραφή σε όλα τα $langsCourses των τμημάτων";
$langAutoEnrollRule = 'Κανόνας';
$langAutoEnrollDeleted = 'Ο κανόνας διαγράφτηκε';
$langApplyTo = 'Όταν χρήστες';
$langApplyDepartments = 'εγγράφονται στα τμήματα';
$langApplyAnyDepartment = 'εγγράφονται σε οποιοδήποτε τμήμα';
$langNoRules = 'Δεν υπάρχουν κανόνες';
$langApplyRule = 'Εφαρμογή του κανόνα στους υπάρχοντες χρήστες κατά την αποθήκευση';
$langRuleApplied = 'Ο κανόνας εφαρμόστηκε σε όλους τους υπάρχοντες χρήστες';
$langSureToDelRule = "Θέλετε σίγουρα να διαγραφεί ο κανόνας;";
$langActivityCourse = 'Μαθήματα-Δραστηριότητες';
$langPopularCourse = "Δημοφιλή $langCourses";
$langPopular = 'Δημοφιλές';
$langRemovePopular = 'Αφαίρεση από Δημοφιλές';
$langNoActivityHeadings = 'Δεν υπάρχουν τίτλοι κατηγοριών δραστηριοτήτων';
$langActivityCourseAdd = 'Προσθήκη τίτλου κατηγορίας δραστηριότητας';
$langQuickLinks = "Γρήγοροι σύνδεσμοι";
$langNewEclassVersion = 'Νέα έκδοση πλατφόρμας Open eClass';
$langNewEclassVersionInfo = 'Μια νέα έκδοση της πλατφόρμας Open eClass, %s,
είναι διαθέσιμη. Παρακαλούμε επισκεφθείτε την ιστοσελίδα %s για πληροφορίες
αναβάθμισης.';
$langUnlockPlatform = 'Ξεκλείδωμα πλατφόρμας';
$langUserLastLogins = "Ιστορικό συνδέσεων";
$langNoUserLastLogins = "Ο χρήστης δεν έχει συνδεθεί ποτέ στην πλατφόρμα.";
$langNoStoredProcedures = "ΠΡΟΣΟΧΗ! Φαίνεται ότι δεν υπάρχουν οι απαραίτητες Stored Procedures - χωρίς αυτές δεν λειτουργεί σωστά η ιεραρχία σχολών / τμημάτων.
Για να τις αναδημιουργήσετε εκτελέστε ξανά τη διαδικασία αναβάθμισης ";

// FAQ
$langAdminCreateFaq = "Δημιουργία FAQ";
$langAdminCreateHomeTexts = "Δημιουργία κειμένων στην αρχική σελίδα";
$langAdminManageHomepage = "Διαχείριση αρχικής σελίδας";
$langAdminManageFooter = "Διαχείριση footer";
$langFaq = "Συχνές ερωτήσεις";
$langFaqAbbrev = "Συχνές ερωτήσεις";
$langFaqQuestion = "Ερώτηση";
$langFaqAdd = "Προσθήκη ερώτησης";
$langFaqExpandAll = "Άνοιγμα όλων";
$langFaqCloseAll = "Κλείσιμο όλων";
$langFaqEditSuccess = "Οι αλλαγές αποθηκεύτηκαν με επιτυχία";
$langFaqAddSuccess = "Η ερώτηση αποθηκεύτηκε με επιτυχία";
$langFaqDeleteSuccess = "Η ερώτηση διαγράφτηκε με επιτυχία";
$langdoRefreshSuccess = "Κάντε ανανέωση της σελίδας!";
$langFaqNoEntries = "Δεν υπάρχουν ερωτήσεις.";
$langFaqAddNew = "Προσθέστε μία νέα πατώντας το κουμπί \"Προσθήκη ερώτησης\".";
$langFaqReorderSuccess = "Η ταξινόμηση έγινε με επιτυχία";

// Stat
$langNbProf = "Αριθμός " . $langsOfTeachers;
$langNbStudents = "Αριθμός " . $langsOfStudents;
$langNbLogin = "Αριθμός εισόδων";
$langNbCourses = "Αριθμός $langsOfCourses";
$langNbVisitors = "Αριθμός επισκεπτών";
$langToday = "Σήμερα";
$langLast7Days = "Τελευταίες 7 μέρες";
$langLast30Days = "Τελευταίες 30 μέρες";
$langLastYear = "Τελευταίος χρόνος";
$langNbAnnoucement = "Αριθμός ανακοινώσεων";
$langNbUsers = "Αριθμός χρηστών";
$langCoursVisible = "Ορατότητα";
$langErrors = "Σφάλματα:";
$langMultEmail = "Πολλαπλές εμφανίσεις διευθύνσεων e-mail";
$langMultLoginPass = "Πολλαπλά ζεύγη LOGIN - PASS";
$langOk = "Εντάξει";
$langNumUsers = "Αριθμός συμμετεχόντων στην πλατφόρμα";
$langNumGuest = "Αριθμός επισκεπτών";
$langRestoreCourse = "Ανάκτηση $langOfCourse";
$langStatCour = "Ποσοτικά στοιχεία $langsOfCourses";
$langNumCourses = "Αριθμός $langsOfCourses";
$langNumEachCourse = "Αριθμός $langsOfCourses ανά $langsFaculty";
$langNumEachLang = "Αριθμός $langsOfCourses ανά γλώσσα";
$langNunEachAccess = "Αριθμός $langsOfCourses ανά τύπο πρόσβασης";
$langNumEachCat = "Αριθμός $langsOfCourses ανά τύπο $langsOfCourses";
$langAnnouncements = "Ανακοινώσεις";
$langFrom = "Από";
$langFrom2 = "από";
$langNotExist = "Δεν υπάρχουν";
$langExist = "Υπάρχουν!";
$langResult = " Αποτέλεσμα";
$langMultiplePairs = "Πολλαπλά ζεύγη";
$langMultipleAddr = "Πολλαπλές εμφανίσεις διευθύνσεων";
$langMultipleUsers = "Πολλαπλές εγγραφές χρηστών";
$langPopularCourses = "$langCourses με τους περισσότερους $langUsersS";
$langMultipleCourseUsers = "Χρήστες που είναι γραμμένοι στα περισσότερα μαθήματα";
$langLast30Entries = "30 πρώτες εγγραφές";
$langAlert = "Σημεία Προσοχής";
$langServer = "Εξυπηρετητής";
$langServerStatus = "Κατάσταση του εξυπηρετητή Mysql : ";
$langDataBase = "Βάση δεδομένων ";
$langLanguage = "Γλώσσα";
$langUpgradeBase = "Αναβάθμιση Βάσης Δεδομένων";
$langCleanUp = "Διαγραφή παλιών αρχείων";
$langUpdatingStatistics = "Ενημέρωση μηνιαίων στατιστικών";
$langPleaseWait = "Παρακαλώ περιμένετε";
$langSupportedLanguages = "Υποστηριζόμενες Γλώσσες";
$langAvailLanguages = "Διαθέσιμες";
$langTipLangAdminAnn = "Επιλέξτε την γλώσσα στην οποία θα εμφανίζονται οι ανακοινώσεις του διαχειριστή";
$langAltAuthStudentReq = "Ενεργοποίηση αίτησης $langsOfStudent που συνδέεται με εναλλακτικό τρόπο πιστοποίησης";
$langDisableEclassStudReg = "Απενεργοποίηση εγγραφής χρηστών";
$langDisableEclassProfReg = "Απενεργοποίηση εγγραφής χρήστη (με δικαιώματα δημιουργίας $langsOfCourses)";
$langDisableEclassStudRegType = "Δυνατότητα εγγραφής $langsOfStudents";
$langDisableEclassProfRegType = "Δυνατότητα εγγραφής $langsOfTeachers";
$langDisableEclassStudRegYes = "Οι $langsStudents δεν μπορούν να εγγραφούν";
$langDisableEclassProfRegYes = "Οι $langsTeachers δεν μπορούν να εγγραφούν";
$langDisableEclassStudRegNo = "Οι $langsStudents μπορούν να εγγραφούν";
$langDisableEclassStudRegViaReq = "Οι $langsStudents μπορούν να εγγραφούν μέσω αίτησης";
$langDisableEclassProfRegNo = "Οι $langsTeachers μπορούν να εγγραφούν μέσω αίτησης";
$langUserNotLogin = "Χρήστες που δεν έχουν εισέλθει";
$langParams = 'Παράμετροι';
$langReports = "Αναφορές";
$langChecks = "Έλεγχοι";
$langCharts = "Διαγράμματα";

// listusers
$langBegin = "αρχή";
$langEnd = "τέλος";
$langPreced50 = "Προηγούμενοι";
$langFollow50 = "Επόμενοι";
$langAll = "όλοι";
$langNoSuchUsers = "Δεν υπάρχουν χρήστες σύμφωνα με τα κριτήρια που ορίσατε";
$langAsInactive = "ως μη ενεργοί";
$langChanges = "αλλαγές";
$langUserDeactivated = 'Ο λογαριασμός του χρήστη "%s" απενεργοποιήθηκε!';
$langUserActivated = 'Ο λογαριασμός του χρήστη "%s" ενεργοποιήθηκε!';

// listcours
$langOpenCourse = "Ανοικτό";
$langClosedCourse = "Κλειστό";
$langClosedCourses = "Κλειστά $langsCourses";
$langRegCourse = "Απαιτείται εγγραφή";
$langInactiveCourse = "Ανενεργό";
$langTcCourseEnabled = "Η δυνατότητα τηλεσυνεργασίας ενεργοποιήθηκε.";
$langTcCourseDisabled = "Η δυνατότητα τηλεσυνεργασίας απενεργοποιήθηκε.";

// quotacours
$langQuotaAdmin = "Διαχείριση Αποθηκευτικού Χώρου $langOfCourse";
$langQuotaSuccess = "Η αλλαγή έγινε με επιτυχία";
$langQuotaFail = "Η αλλαγή δεν έγινε!";
$langMaxQuota = "έχει μέγιστο επιτρεπτό αποθηκευτικό χώρο";
$langLegend = "Για το υποσύστημα";
$langVideo = "Πολυμέσα";

// Added by vagpits
// General
$langReturnToSearch = "Επιστροφή στα αποτελέσματα αναζήτησης";
$langReturnSearch = "Επιστροφή στην αναζήτηση";
$langNoChangeHappened = "Δεν πραγματοποιήθηκε καμία αλλαγή!";

// addfaculte
$langReturnToAddFaculte = "Επιστροφή στην προσθήκη";
$langReturnToEditFaculte = "Επιστροφή στην επεξεργασία";
$langFaculteAdd = "Προσθήκη $langOfFaculty";
$langFaculteDel = "Διαγραφή $langOfFaculty";
$langFaculteEdit = "Επεξεργασία στοιχείων $langOfFaculty";
$langFaculteIns = "Εισαγωγή Στοιχείων $langOfFaculty";
$langAcceptChanges = "Επικύρωση Αλλαγών";
$langEditFacSucces = "Η επεξεργασία της σχολής ολοκληρώθηκε με επιτυχία!";

// addusertocours
$langFormUserManage = "Φόρμα Διαχείρισης Χρηστών";
$langListNotRegisteredUsers = "Λίστα Μη Εγγεγραμμένων Χρηστών";
$langListRegisteredStudents = "Λίστα Εγγεγραμμένων " . $langOfStudents;
$langListRegisteredProfessors = "Λίστα Εγγεγραμμένων " . $langOfTeachers;
$langErrChoose = "Παρουσιάστηκε σφάλμα στην επιλογή $langsOfCourse!";
// delete course
$langCourseDel = "Διαγραφή $langsOfCourse";
$langCourseDelSuccess = "Το $langsCourse διαγράφηκε με επιτυχία!";
$langCourseDelConfirm = "Επιβεβαίωση Διαγραφής $langOfCourse";
$langCourseDelConfirm2 = "Θέλετε σίγουρα να διαγράψετε το $langsCourse";
$langNoticeDel = "ΣΗΜΕΙΩΣΗ: Η διαγραφή του $langsOfCourse θα διαγράψει επίσης τους εγγεγραμμένους " . $langsOfStudentss . " από το $langsCourse, την αντιστοιχία του $langsOfCourse στη $langsFaculty, καθώς και όλο το υλικό του $langsOfCourse.";

// edit course
$langCourseInformationText = "Επεξεργασία περιγραφής $langsOfCourse";
$langCourseEdit = "Επεξεργασία $langOfCourse";
$langCourseInfo = "Ρυθμίσεις";
$langCourseImage = "Φωτογραφία $langOfCourse";
$langCourseLayout = "Διάταξη";
$langCourseLayout1 = "Με Εικόνα";
$langCourseLayout3 = "Χωρίς Εικόνα";
$langQuota = "Όρια αποθηκευτικού χώρου";
$langCourseStatus = "Κατάσταση $langOfCourse";
$langCurrentStatus = "Τρέχουσα κατάσταση";
$langListUsers = "Λίστα Χρηστών";
$langTakeBackup = "Λήψη Αντιγράφου Ασφαλείας";
$langStatsCourse = "Στατιστικά $langOfCourse";
$langActivityEdit = 'Επεξεργασία δραστηριότητας';

// course_info.php
$langCourseEditSuccess = "Τα στοιχεία του $langsOfCourse άλλαξαν με επιτυχία!";
$langCourseInfoEdit = "Αλλαγή στοιχείων $langsOfCourse";
$langBackCourse = "Επιστροφή στην αρχική σελίδα του $langsOfCourse";
$langCourseWeeklyFormat = 'Εβδομαδιαία μορφή';
$langCourseActivityFormat = 'Μορφή δραστηριότητας';
$langCourseWallFormat = 'Μορφή τοίχου';
$langCourseSimpleFormat = 'Απλή μορφή';
$langAddWeek = 'Προσθήκη εβδομάδας';
$langEditWeek = 'Επεξεργασία εβδομάδας';
$langWeekTitle = "Τίτλος εβδομάδας";
$langBlogComment = "σχολιασμού ιστολογίου";
$langBlogRatingLog = "αξιολόγησης ιστολογίου";
$langBlogSharingLog = "διαμοιρασμού ιστολογίου";
$langsCourseSharing = "διαμοιρασμού $langsOfCourse σε κοινωνικά δίκτυα";
$langsCourseRating = "αξιολόγησης $langsOfCourse";
$langCourseComment = "σχολιασμού $langsOfCourse";
$langsCourseAnonymousRating = "σχολιασμού $langsOfCourse από ανώνυμους χρήστες";
$langForumRating = "αξιολόγησης συζητήσεων";
$langCourseSocialBookmarks = "συλλογικών συνδέσμων";
$langCourseAbuseReport = "αναφορά κατάχρησης";
$langForumNotifications = "Ενημέρωση $langsOfStudents";
$langActivateForumNotifications = "Ενεργοποίηση ενημέρωσης $langsOfStudents (μέσω email)";
$langDisableForumNotifications = "Aπενεργοποίηση ενημέρωσης $langsOfStudents (μέσω email)";
$langPublicDocumentManagement = 'Δημόσια διαχείριση εγγράφων';
$langPublicDocumentManagementExplanation = 'Επιτρέπεται αποστολή και διαχείριση αρχείων στα «Έγγραφα» από όλους τους εγγεγραμμένους χρήστες.';
$langPassCode = "Συνθηματικό πρόσβασης";
$langCourseEndDate = "Ημερομηνία λήξης $langsOfCourse";
$langExplainCourseEndDate = "Μετά την ημερομηνία λήξης το $langsOfCourse θα γίνει ανενεργό";
$langH5PUploadingEnabled = "Δημιουργία περιεχομένου H5P από τους $langsOfStudentss";
// listreq.php

$langOpenProfessorRequests = "Ανοικτές Αιτήσεις Χρηστών";
$langProfessorRequestClosed = "Η αίτηση έκλεισε!";
$langReqHaveClosed = "Κλειστές αιτήσεις";
$langReqHaveBlocked = "Απορριπτέες Αιτήσεις";
$langReqHaveFinished = "Ολοκληρωμένες αιτήσεις";

$langemailsubjectBlocked = "Απόρριψη αίτησης εγγραφής στην Πλατφόρμα Ασύγχρονης Τηλεκπαίδευσης";
$langCourseUserRequestReject = "Απόρριψη αίτησης εγγραφής";
$langemailbodyBlocked = "Η αίτηση σας για εγγραφή στην πλατφόρμα " . $siteName . " απορρίφθηκε.";
$langCloseConf = "Επιβεβαίωση κλεισίματος αίτησης";
$langReintroductionApplication = "Η επαναφορά της αίτησης ολοκληρώθηκε με επιτυχία!";
$langBackRequests = "Επιστροφή στις αιτήσεις";

// mailtoprof.php
$langSendMessageTo = "Αποστολή μηνύματος";
$langToAllUsers = "σε όλους τους χρήστες";
$langProfOnly = "σε χρήστες με δικαίωμα δημιουργίας μαθημάτων";
$langStudentsOnly = "σε χρήστες χωρίς δικαίωμα δημιουργίας μαθημάτων";

// searchcours.php
$langSearchCourse = "Αναζήτηση $langOfCourses";
$langNewSearch = "Νέα Αναζήτηση";
$langSearchCriteria = "Κριτήρια Αναζήτησης";
$langSearch = "Αναζήτηση";
$langSearchFreeText = "Ελεύθερο κείμενο";
$langSearchFreeTextPlaceholder = "Τίτλος, περιγραφή, λέξεις-κλειδιά...";

// statuscours.php
$langCourseStatusChangedSuccess = "Ο τύπος πρόσβασης του $langsOfCourse άλλαξε με επιτυχία!";
$langCourseStatusChange = "Αλλαγή τύπου πρόσβασης $langsOfCourse";

// authentication
$langNextAuthMethod = "Επόμενη επιλογή σύνδεσης";
$langPrevStep = "Πίσω";
$langMethods = "Ενεργοί τρόποι πιστοποίησης:";
$langActivate = "Ενεργοποίηση";
$langDeactivate = "Απενεργοποίηση";
$langChooseAuthMethod = "Επιλέξτε τον τρόπο πιστοποίησης χρηστών και καθορίστε τις ρυθμίσεις του";
$langConnYes = "Επιτυχής σύνδεση";
$langConnNo = "Η σύνδεση δεν λειτουργεί";
$langAuthNoValidUser = "Τα στοιχεία που δώσατε δεν είναι σωστά!";
$langConnTest = 'Δοκιμή τρόπου πιστοποίησης';
$langAuthMethod = "Τρόπος πιστοποίησης χρηστών";
$langTransitionEnable = "Ενεργοποίηση μετάβασης";
$langTransitionDisable = "Απενεργοποίηση μετάβασης";
$langTransitionExcludeReq = "Αιτήματα εξαιρέσεων μετάβασης";
$langdbhost = "Εξυπηρέτης Βάσης Δεδομένων";
$langdbname = "Όνομα Βάσης Δεδομένων";
$langdbuser = "Χρήστης Βάσης Δεδομένων";
$langdbpass = "Συνθηματικό χρήστη Βάσης Δεδομένων";
$langdbtable = "Όνομα πίνακα Βάσης Δεδομένων";
$langdbfielduser = "Όνομα πεδίου Χρήστη στον πίνακα";
$langdbfieldpass = "Όνομα πεδίου Συνθηματικού Χρήστη στον πίνακα";
$langdbpassencr = "Κρυπτογράφηση πεδίου συνθηματικού";
$langAuthTitle = "Όνομα τρόπου πιστοποίησης";
$langInstructionsAuth = "Οδηγίες σύνδεσης";
$langTestAccount = "Μπορείτε να δοκιμάσετε να πιστοποιηθείτε με ένα λογαριασμό της μεθόδου που επιλέξατε";
$langpop3host = "Εξυπηρέτης POP3";
$langpop3port = "Πόρτα λειτουργίας POP3";
$langimaphost = "Εξυπηρέτης IMAP";
$langimapport = "Πόρτα λειτουργίας IMAP";
$langldap_host_url = "Εξυπηρέτης LDAP";
$langldap_base = "LDAP Base για αναζήτηση χρηστών";
$langldap_bind_dn = "DN χρήστη για LDAP binding";
$langldap_bind_pw = "Συνθηματικό για LDAP binding";
$langldap_login_attr = "Attribute για το username του χρήστη";
$langldap_login_attr2 = "Εναλλακτικό Attribute για το username του χρήστη";
$langldapfirstnameattr = "Attribute για το όνομα του χρήστη";
$langldapsurnameattr = "Attribute για το επώνυμο του χρήστη";
$langldap_id_attr = "Attribute για τον αριθμό μητρώου του χρήστη";
$langldap_mail_attr = "Attribute για το e-mail του χρήστη";
$langcas_host = "Εξυπηρέτης CAS";
$langCASGUnetIdentity = 'Ενεργοποίηση Υπηρεσίας Κεντρικής Ταυτοποίησης GUnet';
$langSchoolDepartment = 'Σχολή - Τμήμα';
$langLocalCategory = 'Τοπική κατηγορία';
$langSchoolDepartmentAssociation = 'Αντιστοίχιση σχολών-τμημάτων με τοπικές κατηγορίες';
$langDefaultCategory = 'Προκαθορισμένη κατηγορία';
$langDefaultCategoryHelp = 'Στην προκαθορισμένη κατηγορία εντάσσονται οι χρήστες που δεν αντιστοιχίζονται σε άλλη κατηγορία.';
$langcas_port = "Πόρτα λειτουργίας CAS";
$langcas_context = "Διεύθυνση σελίδας εισόδου";
$langcas_logout = "Διεύθυνση σελίδας εξόδου";
$langcas_ssout = "Ενεργοποίηση CAS Single Sign Out";
$langcas_cachain = "Αρχείο Αλυσίδας Πιστοποιητικών του εξυπηρετητή CAS";
$langcas_altauth = "Εναλλακτικός τρόπος πιστοποίησης";
$langcas_altauth_use_mobile = "Μόνο για σύνδεση από την εφαρμογή για κινητά";
$langcas_altauth_use_all = "Για κάθε σύνδεση";
$langcas_altauth_use = "Χρήση εναλλακτικού τρόπου πιστοποίησης";
$langcasusermailattr = "CAS SAML attribute για το e-mail";
$langcasuserfirstattr = "CAS SAML attribute για το Όνομα";
$langcasuserlastattr = "CAS SAML attribute για το Επώνυμο";
$langcasuserstudentid = "CAS SAML attribute για τον Αριθμό Μητρώου";
$langSSOMailAttr = "Ιδιότητα προφίλ για το e-mail";
$langSSOGivenNameAttr = "Ιδιότητα προφίλγια το Όνομα";
$langSSOSurnameAttr = "Ιδιότητα προφίλ για το Επώνυμο";
$langSSOStudentIDAttr = "Ιδιότητα προφίλ για τον Αριθμό Μητρώου";
$langUserAuthentication = "Πιστοποίηση Χρηστών";
$langChangeUser = 'Σύνδεση με λογαριασμό άλλου χρήστη';
$langChangeUserAs = 'Σύνδεση ως';
$langChangeUserNotFound = 'Δε βρέθηκε λογαριασμός με όνομα χρήστη "%s"';
$langMultiDelUser = 'Μαζική διαγραφή λογαριασμών χρηστών';
$langMultiDelUserConfirm = "Η ενέργεια αυτή θα διαγράψει επίσης όλα τα ίχνη των χρηστών στην πλατφόρμα, όπως στατιστικά, συμμετοχές στα forums, κ.α.";
$langMultiDelUserData = "Ονόματα Λογαριασμών Χρηστών (usernames)";
$langMultiDelUserInfo = 'Εισάγετε στην παρακάτω περιοχή μια λίστα με τα ονόματα χρηστών (usernames), μία γραμμή ανα χρήστη που επιθυμείτε να διαγραφεί. Οι γραμμές που αρχίζουν από # αγνοούνται.';
$langMultiMoveCourseInfo = "Επιλέξτε τη νέα $langsFaculty στην οποία θα μεταφερθούν τα $langsCourses.";
$langActivateUserInfo = 'Εισάγετε στην παρακάτω περιοχή τα ονόματα χρηστών (usernames), ένα ανά γραμμή, των λογαριασμών που επιθυμείτε να επεκτείνετε. Οι γραμμές που αρχίζουν από # αγνοούνται.';
$langMoveUserInfo = 'Εισάγετε στην παρακάτω περιοχή τα ονόματα χρηστών
    (usernames), ένα ανά γραμμή, των λογαριασμών που επιθυμείτε να μεταφέρετε
    σε άλλο τμήμα από το τρέχον τμήμα «%s». Άλλα τμήματα στα οποία τυχόν
    ανήκουν οι χρήστες δεν αλλάζουν. Οι γραμμές που αρχίζουν από #
    αγνοούνται.';
$langUserDurationExtended = 'Στην ημερομηνία λήξης του λογαριασμού "%s" προστέθηκαν %d μήνες.';
$langUserDurationError = 'Σφάλμα επέκτασης λήξης λογαριασμού "%s".';
$langUserMoved = 'Ο λογαριασμός "%s" μεταφέρθηκε.';
$langUserMoveError = 'Σφάλμα μεταφοράς λογαριασμού "%s".';
$langActivateMonths = 'Μήνες επέκτασης διάρκειας λογαριασμών';
$langMultiRegUser = 'Μαζική δημιουργία λογαριασμών χρηστών';
$langMultiRegCourseUser = "Μαζική εγγραφή χρηστών σε $langsCourses";
$langMultiMoveCourses = "Μαζική μεταφορά $langsOfCourses";
$langConfirmMultiMoveCourses = "Επιβεβαίωση μεταφοράς $langsOfCourses σε άλλο τμήμα.";
$langCourseCodes = "Κωδικοί $langsOfCourses";
$langAskManyUsersToCourses = "Τα $langsCourses θα πρέπει να υπάρχουν και οι χρήστες θα πρέπει να έχουν ήδη λογαριασμό στην πλατφόρμα για να εγγραφούν σε αυτά. Πληκτρολογήστε τα ονόματα χρήστη (usernames) και τους κωδικούς των $langsOfCourses σε ξεχωριστές γραμμές.";
$langMultiRegUserInfo = "<p>Ανεβάστε ένα αρχείο τύπου Excel (.xls, xlsx) με τα στοιχεία των χρηστών με την ακόλουθη μορφή:</p>
<p>Η πρώτη γραμμή πρέπει να περιέχει τα πεδία των στοιχείων του χρήστη.</p>
<p>Τα πιθανά πεδία είναι τα εξής:</p>
<ul>
<li><tt>first</tt>: Όνομα</li>
<li><tt>last</tt>: Επώνυμο</li>
<li><tt>email</tt>: Διεύθυνση e-mail</li>
<li><tt>id</tt>: Αριθμός μητρώου</li>
<li><tt>phone</tt>: Τηλέφωνο</li>
<li><tt>username</tt>: Όνομα χρήστη</li>
<li><tt>password</tt>: Κωδικός χρήστη</li>
</ul>
</p>
Οι υπόλοιπες γραμμές πρέπει να περιέχουν τα αντίστοιχα στοιχεία των χρηστών που επιθυμείτε να δημιουργηθούν.
</p
<p>Αν επιθυμείτε οι χρήστες να εγγραφούν αυτόματα σε κάποια $langsCourses, προσθέστε
τους κωδικούς τους στο τέλος της γραμμής μετά τα πεδία που έχετε ορίσει. Το
e-mail είναι προαιρετικό - αν θέλετε να το παραλείψετε, βάλτε στη θέση του μια
παύλα (-). Αν δεν ορίσετε το όνομα χρήστη των χρηστών, θα πάρουν αυτόματα ονόματα χρήστη αποτελούμενα από το
πρόθεμα που μπορείτε να ορίσετε παρακάτω και έναν αύξοντα αριθμό. Αν δεν ορίσετε
το password, ορίζεται αυτόματα ένας τυχαίος κωδικός διαφορετικός για κάθε λογαριασμό</p>";
$langMultiRegCourseInvalid = "Χρήστης %s: μη έγκυρος κωδικός $langsOfCourse «%s»";
$langMultiRegFields = 'Ορισμός των πεδίων ή της σειράς τους';
$langMultiRegFieldError = 'Σφάλμα! Μη επιτρεπτή ετικέτα πεδίου:';
$langMultiRegUsernameError = 'Το όνομα χρήστη υπάρχει ήδη.';
$langMultiRegType = 'Δημιουργία λογαριασμών';
$langMultiRegSendMail = 'Αποστολή των στοιχείων των χρηστών μέσω e-mail';
$langMultiRegPrefix = 'Πρόθεμα username χρηστών';
$langSearchCourses = "Αναζήτηση $langsOfCourses";
$langActSuccess = "Μόλις ενεργοποιήσατε την ";
$langDeactSuccess = "Μόλις απενεργοποιήσατε την ";
$langThe = "Η ";
$langLdapNotWork = "Η PHP δεν υποστηρίζει LDAP. Βεβαιωθείτε ότι η υποστήριξη LDAP είναι εγκατεστημένη και ενεργοποιημένη.";
$langCASLoggedIN = "Προειδοποίηση: Θα πρέπει να βγείτε από το CAS πριν αλλάξετε τις ρυθμίσεις του";
$langCASNotWork = "Προειδοποίηση: Η PHP δεν έχει υποστήριξη για CAS. Βεβαιωθείτε ότι η phpCAS είναι εγκατεστημένη.";
$langShibEmail = "Shibboleth Email";
$langShibUsername = "Shibboleth User Name";
$langShibCn = "Shibboleth Canonical Name";
$langShibGivenname = "Shibboleth Given Name";
$langShibSurname = "Shibboleth Surname";
$langShibStudentId = "Shibboleth Student ID";
$langShibboleth = "Πιστοποίηση μέσω Shibboleth";
$langConnectWith = "γίνεται σύνδεση με";
$langNotSSL = "Δεν πραγματοποιήθηκε σύνδεση μέσω SSL γιατί δεν δόθηκε πιστοποιητικό ή το πιστοποιητικό δεν μπορεί να διαβαστεί";
$langCASRetAttr = "Ιδιότητες αντικειμένου χρήστη";
$langMergeUserWithSelf = 'Δεν μπορείτε να συγχωνεύσετε ένα λογαριασμό με τον εαυτό του.';
$langAllAuthMethodsAreDisabled = "Όλοι οι τρόποι πιστοποίησης είναι απενεργοποιημένοι.";

// other
$langVisitor = "Επισκέπτης";
$langOther = "Άλλο";
$langTotal = "Σύνολο";
$langProperty = "Ιδιότητα";
$langNoUserList = "Δεν υπάρχουν αποτελέσματα προς εμφάνιση";
$langContactAdminAuth = "Επικοινωνία με τους διαχειριστές";
$langActivateAccount = "Παρακαλώ να ενεργοποιήσετε το λογαριασμό μου";
$langLessonCode = "Συνθηματικό $langsOfCourse";

// unregister
$langConfirmDelete = "Επιβεβαίωση διαγραφής";
$langConfirmReplace = "Επιβεβαίωση αντικατάστασης";
$langConfirmDeleteQuestion1 = "Θέλετε σίγουρα να διαγράψετε τον χρήστη";
$langConfirmDeleteQuestion2 = "από το $langsCourse";
$langConfirmDeleteQuestion3 = "Η ενέργεια αυτή θα διαγράψει επίσης όλα τα ίχνη του χρήστη στην πλατφόρμα, όπως στατιστικά, συμμετοχές στα forums, κ.α.";
$langTryDeleteAdmin = "Επιχειρήσατε να διαγράψετε ένα χρήστη με δικαιώματα διαχειριστή.";
$langCantDeleteAdmin = "Ο χρήστης %s έχει δικαιώματα διαχειριστή.";
$langIfDeleteAdmin = 'Αν επιθυμείτε να προχωρήσετε στη διαγραφή, θα πρέπει να αφαιρέσετε πρώτα τα διαχειριστικά δικαιώματα.';
$langWasDeleted = "διαγράφηκε";
$langWasAdmin = "ήταν διαχειριστής";
$langWasCourseDeleted = "διαγράφηκε από το $langCourse";
$langErrorDelete = "Σφάλμα κατά τη διαγραφή του χρήστη";
$langErrorUnreguser = "Σφάλμα κατά την απεγγραφή του χρήστη από $langsCourse";
$langAfter = "Μετά από";
$langBefore = "Πριν από";
$langUserType = "Τύπος χρήστη";

// search
$langSearchUsers = "Αναζήτηση Χρηστών";
$langInactiveUsers = "Μη ενεργοί";
$langActiveUsers = "Ενεργοί";
$langWillExpireUsers = "Λήγουν μέσα στο μήνα";
$langAddSixMonths = "Επέκταση διάρκειας λογαριασμών";
$langChangeDepartment = 'Αλλαγή σχολής - τμήματος';
$langSearchInCourse = "Αναζήτηση στους πόρους";

// eclassconf
$langRestoredValues = "Επαναφορά προηγούμενων τιμών";
$langEclassConf = "Ρυθμίσεις πλατφόρμας";
$langFileUpdatedSuccess = "Το αρχείο ρυθμίσεων τροποποιήθηκε με επιτυχία!";
$langReplaceBackupFile = "Αντικατάσταση του config_backup.php.";
$langencryptedPasswd = "Υποχρεωτική κρυπτογράφηση των συνθηματικών";
$langDocQuota = "Όριο αποθηκευτικού χώρου για τα Έγγραφα";
$langVideoQuota = "Όριο αποθηκευτικού χώρου για τα Βίντεο";
$langDropboxQuota = "Όριο αποθηκευτικού χώρου για την Ανταλλαγή μηνυμάτων";
$langGroupQuota = "Όριο αποθηκευτικού χώρου για τις Ομάδες Χρηστών";
$langEclassThemes = "Εμφάνιση πλατφόρμας";
$langHomePageSettings = "Ρυθμίσεις αρχικής σελίδας";
$langHomePageTitleHelpText = "Ο τίτλος που θα εμφανίζεται στην αρχική σελίδα";
$langHomePageNavTitleHelp = "Αρχικός τίτλος συνδέσμων πλοήγησης";
$langHomePageIntroTextHelp = "Κείμενο Αρχικής Σελίδας";
$langHomePageExtUrlHelp = "Το URL του εξωτερικού συνδέσμου που θα λειτουργεί ως αρχική σελίδα της πλατφόρμας";
$langSelectHomePage = "Επιλέξτε ποια θέλετε να είναι η αρχική σελίδα";
$langHomePageDefault = "Προεπιλογή";
$langHomePageToolbox = "Toolbox";
$langHomePageExternal = "External";
$langHomePageIntroText = "Εισαγωγικό Κείμενο";
$langHomePageIntroTitle = "Τίτλος";
$langHomePageIntroUrl = "URL";
$langHomePageIntroBcrmp = "Τίτλος πλοήγησης";
$langHomePageMenuSettings = "Ρυθμίσεις αρχικού αριστερού μενού";
$langThemes = "Επιλογή θέματος";
$langOtherOptions = "Άλλες ρυθμίσεις";
$langDefaultQuota = "Αποθηκευτικός χώρος νέων $langsOfCourses";
$langCreateBackup = "Δημιουργία αντιγράφου ασφαλείας των ρυθμίσεων";
$langUploadWhitelist = "Τύποι επιτρεπτών αρχείων για ανέβασμα";
$langStudentUploadWhitelist = "Τύποι επιτρεπτών αρχείων για τους $langsOfStudentss";
$langTeacherUploadWhitelist = "Τύποι επιτρεπτών αρχείων για τους $langsTeachers";
$langUploadedFileNotAllowed = "Το αρχείο που επιχειρείτε να ανεβάσετε δεν είναι επιτρεπτό: ";
$langRenamedFileNotAllowed = "Το νέο όνομα του αρχείου που επιχειρείτε να μετονομάσετε δεν είναι επιτρεπτό: ";
$langUploadedZipFileNotAllowed = "Το zip αρχείο που επιχειρείτε να ανεβάσετε και αποσυμπιέσετε περιέχει το μη επιτρεπτό αρχείο: ";
$langContactAdmin = "Επικοινωνήστε με το διαχειριστή της πλατφόρμας για περισσότερες πληροφορίες.";
$langEnableIndexing = "Ενεργοποίηση μηχανής ευρετηρίου";
$langConfirmEnableIndexTitle = "Επιβεβαίωση έναρξης ευρετηριοποίησης";
$langConfirmEnableIndex = "Η ευρετηριοποίηση θα χρειαστεί <strong>συγκεκριμένο χρονικό διάστημα και υπολογιστικούς πόρους</strong> για να πραγματοποιηθεί, ανάλογα με το μέγεθος της βάσης δεδομένων.<br/><br/>Η διαδικασία θα ξεκινήσει σε <strong>ξεχωριστό παράθυρο</strong> μετά την αποθήκευση των ρυθμίσεων.<br/><br/>Επίσης, η ευρετηριοποίηση <strong>δεν</strong> είναι διαθέσιμη στην περίπτωση εγκατάστασης της πλατφόρμας σε <strong>NFS filesystem</strong>.<br/><br/><em>Ακυρώστε</em> την επιλογή σας αν επιθυμείτε να ξεκινήσετε την ευρετηριοποίηση σε <strong>άλλη</strong> χρονική στιγμή.";
$langConfirmEnableSolrIndex = "Η ευρετηριοποίηση θα χρειαστεί <strong>συγκεκριμένο χρονικό διάστημα και υπολογιστικούς πόρους</strong> για να πραγματοποιηθεί, ανάλογα με το μέγεθος της βάσης δεδομένων.<br/><br/>Η διαδικασία θα ξεκινήσει σε <strong>ξεχωριστό παράθυρο</strong> μετά την αποθήκευση των ρυθμίσεων.<br/><br/><em>Ακυρώστε</em> την επιλογή σας αν επιθυμείτε να ξεκινήσετε την ευρετηριοποίηση σε <strong>άλλη</strong> χρονική στιγμή.";
$langIndexingNeeded = "Αν δεν έχει ανοίξει το παράθυρο της ευρετηριοποίησης, πχ το εμπόδισε ο φυλλομετρητής, αποδεχθείτε το άνοιγμα του παράθυρου ή πατήστε";
$langIndexingAlert1 = "Παρακαλώ περιμένετε όσο η ευρετηροποίηση επεξεργάζεται όλα τα δεδομένα της πλατφόρμας, μπορεί να πάρει αρκετό χρόνο.";
$langIndexingAlert2 = "Μην κλείσετε αυτό το παράθυρο, αλλιώς η διαδικασία θα διακοπεί.";
$langIndexingOptAlert1 = "Η βελτιστοποίηση της ευρετηροποίησης επεξεργάζεται όλα τα δεδομένα της πλατφόρμας και θα χρειαστεί αρκετό χρόνο.";
$langIndexingOptAlert2 = "Μπορείτε να κλείσετε αυτό το παράθυρο, η διαδικασία θα συνεχιστεί στο παρασκήνιο.";
$langIndexingRemain = "$langCourses που απομένουν για ευρετηριοποίηση";
$langIndexingDone = "Η ευρετηριοποίηση ολοκληρώθηκε επιτυχώς, μπορείτε να κλείσετε αυτό το παράθυρο.";
$langEnableSearch = "Ενεργοποίηση μηχανής αναζήτησης";
$langConfirmEnableMobileAPITitle = "Επιβεβαίωση ενεργοποίησης επικοινωνίας με κινητές συσκευές";
$langConfirmEnableMobileAPI = "Η επικοινωνία με κινητές συσκευές (smartphones/tablets) δεν υποστηρίζει αυθεντικοποίηση/ταυτοποίηση μέσω Shibboleth ή CAS.<br/><br/><em>Ακυρώστε</em> την επιλογή σας για την αποφυγή σύγχυσης των τελικών χρηστών.";
$langUserRegistration = "Δυνατότητα εγγραφής χρηστών";
$langRegistrationLink = 'Σύνδεσμος εγγραφής χρηστών';
$langRegistrationShowText = 'Εμφάνιση οδηγιών αντί για συνδέσμους';
$langRegistrationInfo = 'Οδηγίες εγγραφής';
$langReqRegUser = "Αίτηση εγγραφής χρηστών";
$langViaAltAuthMethods = "μέσω εναλλακτικών τρόπων πιστοποίησης";
$langMonthsUnit = "σε μήνες";
$langMinPasswordLen = "Ελάχιστο μέγεθος συνθηματικού";
$langCourseSettings = "Ρυθμίσεις $langsOfCourses";
$langCourseOfflineSettings = "Κατέβασμα $langsOfCourse";
$langCourseOfflineLegend = "Οι $langsOfStudents μπορούν να κατεβάσουν το $langsCourse στον υπολογιστή τους.";
$langLoginFailCheck = "Έλεγχος αποτυχημένων εισόδων";
$langEnableLoginFailCheck = "Ενεργοποίηση ελέγχου αποτυχημένων εισόδων";
$langLoginFailThreshold = "Αριθμός επιτρεπτών αποτυχημένων εισόδων";
$langLoginFailDenyInterval = "Διάστημα αποκλεισμού";
$langLoginFailForgiveInterval = "Διάστημα καραντίνας";
$langActionsExpireInterval = "Διάστημα διατήρησης στατιστικών";
$langLogActions = "Καταγραφή ενεργειών";
$langDocumentSettings = 'Ρυθμίσεις αρχείων';
$langEnableCommonDocs = "Ενεργοποίηση λειτουργίας «Κοινόχρηστων Αρχείων»";
$langEnableDocsPublicWrite = "Ενεργοποίηση επιλογής διαχείρισης εγγράφων από χρήστες";
$langEnableMyDocs = 'Ενεργοποίηση προσωπικών αρχείων';
$langMyDocsQuota = 'Όριο αποθηκευτικού χώρου προσωπικών αρχείων';
$langEmailAnnounce = "Διεύθυνση κοινοποίησης ανακοινώσεων";
$langEmailBounces = 'Διεύθυνση λήψης σφαλμάτων (bounces)';
$langPrivacyPolicy = "Πολιτική Απορρήτου";
$langPrivacyPolicyLegend = "Αλλαγή Πολιτικής Απορρήτου";
$langText = "Κείμενο";
$langUserConsent = "Συναίνεση $langsOfStudent";
$langDisplayPrivacyPolicyLink = 'Εμφάνιση συνδέσμου προς την Πολιτική Απορρήτου στο κάτω μέρος των σελίδων';
$langAskPrivacyPolicyConsent = 'Αίτημα συναίνεσης στην Πολιτική Απορρήτου από τους χρήστες κατά τη σύνδεση';
$langPrivacyPolicyConsentAskAgain = 'Το κείμενο της Πολιτικής Απορρήτου έχει αλλάξει.
    Επιθυμείτε να ξαναζητήσετε συναίνεση των χρηστών για το νέο κείμενο;';
$langPrivacyPolicyConsentRedisplay = 'Νέο αίτημα συναίνεσης';
$langYouHaveConsentedToPrivacyPolicy = 'Συναινέσατε στην {Πολιτική Απορρήτου} στις %date.';
$langYouHaveRejectedPrivacyPolicy = 'Απορρίψατε την {Πολιτική Απορρήτου} στις %date.';
$langYouHaveNotConsentedToPrivacyPolicy = 'Δεν έχετε συναινέσει στην {Πολιτική Απορρήτου}.';
$langInvalidEmail = 'Μη έγκυρο e-mail';
$langUnsubscribeCourse = "Απενεργοποίηση απεγγραφής μαθήματος";
$langUserNotifications = "Ειδοποιήσεις μαθημάτων";
$langDisableUserNotifications = "Απενεργοποίηση ειδοποιήσεων";
$langEnableUserNotifications = "Εμφάνιση ειδοποιήσεων από την τελευταία είσοδο του χρήστη";
$langCustomEnableUserNotifications = "Εμφάνιση ειδοποιήσεων των";
$langDefaultCourseAccess = 'Προεπιλεγμένος τύπος πρόσβασης';

$langFlippedClassroom = "Μοντέλο Ανεστραμμένης Μάθησης";
$langCEnabled = "Ενεργό";
$langGoals = "Μαθησιακοί στόχοι";
$langGoalTitle = "Στόχος";
$langClassInfoTitle = "Στοιχεία μαθήματος";
$langStuNum = "Αριθμός Εκπαιδευόμενων";
$langLectNum = "Αριθμός Μαθημάτων";
$langLectHours = "Χρόνος Μαθήματος";
$langHomeHours = "Χρόνος στο σπίτι";
$langTotalHours = "Συνολικός χρόνος";
$langHoursSmall = "ώρες";
$langLectModel = "Τρόπος διδασκαλίας";
$langLectFromHome = "Εξ αποστάσεως διδασκαλία";
$langLectMixed = "Μικτή διδασκαλία";
$langUnitsTitle = "Ενότητα";
$langFinalSubmit = "Τελική Υποβολή";
$langCont = "Περιεχόμενο";
$langActivities = "Δραστηριότητες";
$langGroupActivities = "Ομαδικές Δραστηριότητες";
$langEmptyGoal ="Θα πρέπει να ορίσετε ένα τουλάχιστον μαθησιακό στόχο";
$langEmptyUnit ="Θα πρέπει να συμπληρώσετε μια τουλάχιστον ενότητα";
$langActSelect = "Επιλέξτε τις δραστηριότητες";
$langActInHome = "Πριν την τάξη";
$langActInClass = "Στην τάξη";
$langActAfterClass = "Μετά την τάξη";
$langFCEbook = "Μελέτη";
$langFCVideo = "Παρακολούθηση βίντεο";
$langFCVideoInteract = "Εκπόνηση αλληλεπιδραστικού βίντεο";
$langFCRevision = "Επανάληψη / Σύνοψη εννοιών";
$langFCGames = "Εκπαιδευτικό παιχνίδι";
$langFCDiscuss = "Συζήτηση";
$langFCBrainstorming = "Καταιγισμός ιδεών";
$langFCWorkPaper = "Φύλλα Εργασίας";
$langFCRolePlay= "Παιχνίδι ρόλων";
$langFCSimulate="Προσομοίωση";
$langFCProblemSolving = "Επίλυση προβλήματος";
$langFCMindMap="Δραστηριότητα νοητικού χάρτη";
$langFCEvaluate = "Αξιολόγηση - Αναστοχασμός";
$langFCDigitalStorytelling = "Ψηφιακή Αφήγηση";
$langFCSupportingMaterial="Υποστηρικτικό Υλικό";
$langFlippedEdit = "Επεξεργασία του Μοντέλου Ανεστραμμένης Μάθησησς";
$langJustEdited = "Μόλις ενημερώσατε το μάθημα με τίτλο ";
$langUnitActivityDeleteConfirm= "Είστε σίγουρη/σίγουρος ότι θέλετε να διαγραφεί η συγκεκριμένη δραστηριότητα;";
$langUnitJustEdited="Οι δραστηριότητες ενημερώθηκαν";
$langFlippedClassroomDataUpdated ="Οι πληροφορίες της ανεστραμμένης Τάξης ενημερώθηκαν";
$langConfirmDeleteUnit = "Θέλετε σίγουρα να αφαιρέσετε την συγκεκριμένη ενότητα;";
$langConfirmDeleteGoal = "Θέλετε σίγουρα να αφαιρέσετε το συγκεκριμένο μαθησιακό στόχο;";
$langUnits = "Θεματικές Ενότητες";
$langDoubleLoginLockOption = 'Αποκλεισμός ταυτόχρονων συνδέσεων με τον ίδιο λογαριασμό.';

// admin announcements
$langAdminAn = "Ανακοινώσεις Διαχειριστή";
$langAdminAddAnn = "Προσθήκη ανακοίνωσης διαχειριστή";
$langAdminModifAnn = "Τροποποίηση ανακοίνωσης διαχειριστή";
$langAdminAnnModify = "Η ανακοίνωση διαχειριστή τροποποιήθηκε";
$langAdminWaiting = "Αναμονή";
$langAdminPinnedOff = "Αφαίρεση σήμανσης ως σημαντικής";
$langAdminPinnedOn = "Καρφίτσωμα ως σημαντική";
$langAdminPinned = "Σημαντική ανακοίνωση";
$langAdminPinnedToTop = "Τοποθέτηση στην κορυφή";
$langAdminAnnAdd = "Η ανακοίνωση διαχειριστή προστέθηκε";
$langAdminAnnDel = "Η ανακοίνωση διαχειριστή διαγράφηκε";
$langAdminAnnMes = "τοποθετήθηκε την";
$langAdminAnnTitleEn = "Τίτλος (Αγγλικά)";
$langAdminAnnBodyEn = "Ανακοίνωση (Αγγλικά)";
$langAdminAnnCommEn = "Σχόλια (Αγγλικά)";
$langAnnouncementIsVis = "Είναι δημόσια ορατή";
$langAnnouncementIsNotVis = "Δεν είναι δημόσια ορατή";
$langAnnouncementWillBeVis = "Θα ενεργοποιηθεί στις: ";
$langAnnouncementWillNotBeVis = "Απενεργοποιήθηκε στις: ";

// cleanup.php
$langCleanupOldFiles = 'Εκκαθάριση παλαιών αρχείων';
$langCleaningUp = 'Εκκαθάριση αρχείων παλαιότερων από %s %s στον υποκατάλογο %s';
$langDaySing = 'ημέρα';
$langDayPlur = 'ημέρες';
$langCleanupInfo = 'Η λειτουργία αυτή θα διαγράψει τα παλιά αρχεία από τους υποκαταλόγους "temp", "archive", "garbage", και"tmpUnzipping". Είστε βέβαιοι;';
$langCleanup = 'Εκκαθάριση';

// common documents
$langCommonDocs = "Κοινόχρηστα Αρχεία";
$langExplainCommonDocs = "Το αρχείο που θα ανεβάσετε θα είναι προσβάσιμο από όλα τα $langsCourses μέσω του υποσυστήματος 'Εγγραφα'";
$langExternalFile = "Σύνδεση εξωτερικού αρχείου";
$langExternalFileInfo = "Διεύθυνση (URL) εξωτερικού αρχείου";
$langCommonDocLink = "Κοινόχρηστο αρχείο";
$langCommonDocLinkInvisible = "Αόρατο κοινόχρηστο αρχείο";
$langNonPublicFile = 'Ορατό μόνο στους εγγεγραμμένους χρήστες';
$langPrint = "Εκτύπωση";
$langMyDocs = 'Προσωπικά Αρχεία';

/* * ********************************************************
 * agenda.php
 * ******************************************************** */
$langModify = "Αλλαγή";
$langAddModify = "Προσθήκη / Αλλαγή";
$langAddIntro = "Προσθήκη Εισαγωγικού Κειμένου";
$langBackList = "Επιστροφή στον κατάλογο";
$langEvents = "Γεγονότα";
$langAgenda = "Ημερολόγιο";
$langDay = "Μέρα";
$langMonth = "Μήνας";
$langPreviousMonth = "Προηγούμενος $langMonth";
$langNextMonth = "Επόμενος $langMonth";
$langYear = "Έτος";
$langHour = "Ώρα";
$langHours = "Ώρες";
$langMinute = "Λεπτά";
$langsecond = 'δευτερόλεπτο';
$langseconds = 'δευτερόλεπτα';
$langminute = 'λεπτό';
$langminutes = 'λεπτά';
$langhour = 'ώρα';
$langhours = 'ώρες';
$langDateNow = "Σημερινή ημερομηνία:";
$langDelEventConfirm = "Θέλετε σίγουρα να διαγράψετε το συγκεκριμένο γεγονός;";
$langConfirmDeleteRecursiveEvents = "Το γεγονός ανήκει σε μια σειρά επαναλαμβανόμενων γεγονότων. Επιθυμείτε να διαγραφούν όλα;";
$langConfirmUpdateRecursiveEvents = "Το γεγονός ανήκει σε μια σειρά επαναλαμβανόμενων γεγονότων. Επιθυμείτε να ενημερωθούν όλα;";
$langConfirmUpdate = "Επιβεβαίωση ενημέρωσης";
$langNoJustThisOne = "Όχι, μόνο αυτό";
$langConfirmDeleteRecursive = "Διαγραφή ομάδας επαλαμβανόμενων γεγονότων";
$langConfirmDeleteEvent = "Επιθυμείτε σίγουρα να διαγραφεί το γεγονός;";
$langDeleteError = "Πρόβλημα κατά τη διαγραφή";
$langUpdateError = "Πρόβλημα κατά την ενημέρωση";
$langTitleDateNotEmpty = "Ο τίτλος και η ημερομηνία του γεγονότος δεν επιτρέπεται να είναι κενά.";
$langDetail = "Λεπτομέρειες";
$langChooseDate = "Επιλέξτε Ημερομηνία";
$langOldToNew = "Αντιστροφή σειράς παρουσίασης";
$langStoredOK = "Το γεγονός αποθηκεύτηκε";
$langDeleteOK = "Το γεγονός διαγράφηκε";
$langNoEvents = "Δεν υπάρχουν γεγονότα";
$langSureToDel = "Είστε σίγουρος ότι θέλετε να διαγράψετε το γεγονός με τίτλο";
$langDelete = "Διαγραφή";
$langInsert = "Εισαγωγή";
$langInHour = "(σε ώρες)";
$langEmptyAgendaTitle = "Παρακαλώ πληκτρολογήστε τον τίτλο του γεγονότος";
$langAgendaNoTitle = "Γεγονός χωρίς τίτλο";
$langListAll = "Λίστα όλων";
$langListCalendar = "Μορφή ημερολογίου";
$langAgendaDueDay = "Προθεσμία";
$langAgendaCourseEvent = "Γεγονός $langsOfCourse";
$langAgendaPersonalEvent = "Προσωπικό γεγονός";
$langAgendaSystemEvent = "Γεγονός συστήματος";

// week days
$langDay_of_weekNames['init'] = array('Κ', 'Δ', 'Τ', 'Τ', 'Π', 'Π', 'Σ');
$langDay_of_weekNames['short'] = array('Κυρ', 'Δευ', 'Τρι', 'Τετ', 'Πεμ', 'Παρ', 'Σαβ');
$langDay_of_weekNames['long'] = array('Κυριακή', 'Δευτέρα', 'Τρίτη', 'Τετάρτη', 'Πέμπτη', 'Παρασκευή', 'Σάββατο');

// month names
$langMonthNames['init'] = array('Ι', 'Φ', 'Μ', 'Α', 'Μ', 'Ι', 'Ι', 'Α', 'Σ', 'Ο', 'Ν', 'Δ');
$langMonthNames['short'] = array('Ιαν', 'Φεβ', 'Μαρ', 'Απρ', 'Μάι', 'Ιουν', 'Ιουλ', 'Αυγ', 'Σεπ', 'Οκτ', 'Νοε', 'Δεκ');
$langMonthNames['long'] = array('Ιανουάριος', 'Φεβρουάριος', 'Μάρτιος', 'Απρίλιος', 'Μάιος', 'Ιούνιος', 'Ιούλιος', 'Αύγουστος', 'Σεπτέμβριος', 'Οκτώβριος', 'Νοέμβριος', 'Δεκέμβριος');
$langMonthNames['fine'] = array('Ιανουαρίου',
    'Φεβρουαρίου',
    'Μαρτίου',
    'Απριλίου',
    'Μαΐου',
    'Ιουνίου',
    'Ιουλίου',
    'Αυγούστου',
    'Σεπτεμβρίου',
    'Οκτωβρίου',
    'Νοεμβρίου',
    'Δεκεμβρίου');

/* * *********************************************************
 * announcements.php
 * ********************************************************** */
$langOn = "Σε";
$langRegUser = "εγγεγραμμένους χρήστες του $langsOfCourse";
$langInvalidMail = "Μη έγκυρες διευθύνσεις email";
$langModifAnn = "Αλλαγή της ανακοίνωσης";
$langAnnouncement = "Ανακοίνωση";
$langMove = "Μετακίνηση";
$langAnnModify = "η ανακοίνωση άλλαξε";
$langAnnAddWithEmail = "Η ανακοίνωση προστέθηκε και στάλθηκε σε ";
$langAnnAdd = "Η ανακοίνωση προστέθηκε";
$langAnnDel = "η ανακοίνωση διαγράφηκε";
$langPubl = "αναρτήθηκε την";
$langAddAnn = "Προσθήκη ανακοίνωσης";
$langContent = "Περιεχόμενο";
$langAnnTitle = "Τίτλος ανακοίνωσης";
$langAnnBody = "Σώμα ανακοίνωσης";
$langEmptyAnn = "Διαγραφή ανακοινώσεων";
$professorMessage = "Μήνυμα $langsOfTeacher";
$langEmailOption = "Αποστολή (με email) της ανακοίνωσης στους εγγεγραμμένους χρήστες";
$langUp = "Επάνω";
$langDown = "Κάτω";
$langReorder = "Ταξινόμηση";
$langNoAnnounce = "Δεν υπάρχουν ανακοινώσεις";
$langNoRecentAnnounce = "Δεν υπάρχουν πρόσφατες ανακοινώσεις";
$langSureToDelAnnounce = "Είστε σίγουρος ότι θέλετε να διαγράψετε την ανακοίνωση";
$langSureToDelAnnounceAll = "Είστε σίγουρος ότι θέλετε να διαγράψετε όλες τις ανακοινώσεις";
$langAnn = "Ανακοινώθηκε την";
$langEmptyAnTitle = "Παρακαλώ πληκτρολογήστε τον τίτλο της ανακοίνωσης";
$langAnnouncementNoTille = "Ανακοίνωση χωρίς τίτλο";
$langCourseAnnouncements = "Ανακοινώσεις $langsOfCourse";
$langLinkUnsubscribe = "Λάβατε αυτό το μήνυμα επειδή είστε γραμμένος στο $langsCourse '%s'. Αν δεν επιθυμείτε να σας αποστέλλονται άλλα e-mails από το συγκεκριμένο $langsCourse κάντε κλικ";
$langLinkUnsubscribeFromPlatform = "Σημείωση: Λάβατε αυτό το μήνυμα επειδή είστε γραμμένος στην πλατφόρμα '%s'.<br />
                Αν δεν επιθυμείτε να σας αποστέλλονται άλλα e-mails κάντε κλικ";
$langEmailUnsubscribe = "Ειδοποιήσεις $langsOfCourse";
$langInfoUnsubscribe = "Μπορείτε να ρυθμίσετε τη λήψη ειδοποιήσεων από τα παρακάτω $langsCourses. Αν δεν επιθυμείτε
        να δέχεστε e-mails από κάποιο $langsCourse, αποεπιλέξτε το και κάντε κλικ στο 'Ύποβολή'. <br />(Σημείωση: Δεν απεγγράφεστε από το $langsCourse).";
$langEmailUnsubSuccess = "Δεν θα λαμβάνετε πλέον e-mails από το $langsCourse '%s'";
$langEmailFromCourses = "Λήψη e-mails από τα $langsCourses μου";
$langEmailUnsubscribeWarning = "Έχετε απενεργοποιήσει τη λήψη μηνυμάτων από την πλατφόρμα.
Δεν μπορείτε να ρυθμίσετε τη λήψη από συγκεκριμένα $langsCourses πριν την επανενεργοποιήσετε.";
$langDisplay = "Εμφάνισε";
$langLast = "Τελευταία";
$langFirst = "Πρώτη";
$langTotalResults = "συνολικά αποτελέσματα";
$langDisplayed = "Εμφανίζονται";
$langTill = "έως";
$langAnnouncementActivePeriod = "Διάστημα εμφάνισης";
$langAnnHasPublished = "Έχει δημοσιευθεί ανακοίνωση στο $langsCourse";
$langInvalidEmailRecipients = 'Παραλήπτες με μη έγκυρη διεύθυνση e-mail';
$langDisabledEmailRecipients = 'Παραλήπτες με απενεργοποιημένη λήψη e-mail';
$langInfoBulkProcessing = "Επιλέξτε από την στήλη (#) του πίνακα τις ανακοινώσεις τις οποίες θέλετε να επεξεργαστείτε.";

/* * *****************************************
 * archive_course.php
 * ***************************************** */
$langArchiveCourse = "Αντίγραφο Ασφαλείας";
$langCreatedIn = "δημιουργήθηκε την";
$langCreateDirMainBase = "Δημιουργία του καταλόγου για την ανάκτηση της κεντρικής βάσης";
$langCreateDirCourseBase = "Δημιουργία του καταλόγου για την ανάκτηση των βάσεων των $langsOfCourses";
$langCopyDirectoryCourse = "Αντιγραφή των αρχείων του $langsOfCourse";
$langDisk_free_space = "Ελεύθερος χώρος";
$langBuildTheCompressedFile = "Δημιουργία του αρχείου αντίγραφου ασφαλείας";
$langFileCopied = "αρχεία αντιγράφηκαν";
$langArchiveLocation = "Τοποθεσία";
$langSizeOf = "Μέγεθος του";
$langBackupSuccesfull = "Δημιουργήθηκε με επιτυχία το αντίγραφο ασφαλείας!";
$langBUCourseDataOfMainBase = "Αντίγραφο ασφαλείας των δεδομένων του $langsOfCourse";
$langBackupOfDataBase = "Αντίγραφο ασφαλείας της βάσης δεδομένων του $langsOfCourse";
$langDownloadIt = "Κατεβάστε το";
$langBackupEnd = "Ολοκληρώθηκε το αντίγραφο ασφαλείας σε μορφή";

/* * *******************************************
 * auth_methods.php
 * ******************************************** */
$langAddNewAuthMethod = 'Προσθήκη νέου τρόπου πιστοποίησης';
$langViaeClass = "Πιστοποίηση μέσω πλατφόρμας";
$langViaPop = "Πιστοποίηση μέσω POP3";
$langViaImap = "Πιστοποίηση μέσω IMAP";
$langViaLdap = "Πιστοποίηση μέσω LDAP";
$langViaDB = "Πιστοποίηση μέσω άλλης Βάσης Δεδομένων";
$langViaShibboleth = "Πιστοποίηση μέσω Shibboleth";
$langViaCAS = "Πιστοποίηση μέσω CAS";
$langViaSocialNetwork = "Πιστοποίηση μέσω κοινωνικού δικτύου";
$langViaFacebook = "Πιστοποίηση μέσω Facebook";
$langViaTwitter ="Πιστοποίηση μέσω Twitter";
$langViaGoogle = "Πιστοποίηση μέσω Google";
$langViaLive = "Πιστοποίηση μέσω Microsoft Live";
$langViaYahoo = "Πιστοποίηση μέσω Yahoo!";
$langViaLinkedIn = "Πιστοποίηση μέσω Linked In";
$langViaOAuth2 = 'Πιστοποίηση μέσω OAuth 2.0';
$langHasActivate = "O τρόπος πιστοποίησης που επιλέξατε έχει ενεργοποιηθεί";
$langAlreadyActiv = "O τρόπος πιστοποίησης που επιλέξατε είναι ήδη ενεργοποιημένος";
$langCASnochange = "Πρέπει να κλείσετε τον browser σας για να αλλάξετε τις ρυθμίσεις του CAS";
$langErrActiv = "Ο τρόπος πιστοποίησης δεν μπορεί να ενεργοποιηθεί";
$langActFailure = " διότι δεν έχετε καθορίσει τις ρυθμίσεις του.";
$langAuthSettings = "Ρυθμίσεις πιστοποίησης";
$langWrongAuth = "Πληκτρολογήσατε λάθος όνομα χρήστη / συνθηματικό";
$langExplainShib = "Πληκτρολογήστε τα ονόματα των μεταβλητών που επιστρέφει ο εξυπηρέτης Shibboleth. Οι μεταβλητές θα γραφτούν στο αρχείο %s. Σημειώστε ότι, αν το Shibboleth Canonical Name περιλαμβάνει το ονοματεπώνυμο του χρήστη, τότε θα πρέπει να ορίσετε τον χαρακτήρα που χωρίζει το όνομα από το επώνυμο.";
$langCharSeparator = "Χαρακτήρας χωρισμού";
$langPrimaryAuthType = "Κύριος τρόπος πιστοποίησης";
$langSecondaryAuthType = "Δευτερεύων τρόπος πιστοποίησης";
$langPrimaryAuthTypeChanged = "Ο τρόπος πιστοποίησης έγινε κύριος.";
$langSecondaryAuthTypeChanged = "Ο τρόπος πιστοποίησης έγινε δευτερεύων.";

/* * **********************************************************
 * auth_change.php
 * **************************************************************** */
$langAuthChangeUser = "Αλλαγή Τρόπου Πιστοποίησης";
$langAuthChangeto = "Αλλαγή σε";
$langAuthChangeno = "Δεν υπάρχει ενεργοποιημένος άλλος τρόπος πιστοποίησης.";
$langAuthChangeYes = "Ο τρόπος πιστοποίησης άλλαξε με επιτυχία";
$langAuthWarnInactive = 'Προσοχή! Ανενεργός τρόπος πιστοποίησης';

/* * **********************************************************
 * check
 * **************************************************************** */

$langCheckTools = "Έλεγχος προαπαιτούμενων εργαλείων λογισμικού";
$langCheckIntro = "Για να δείτε όλο το υλικό που περιέχεται στις σελίδες της Πλατφόρμας, πρέπει να έχετε εγκατεστημένα στον υπολογιστή σας τα κατάλληλα εργαλεία.";
$langCheckIntro2 = "Στον πίνακα που ακολουθεί, μπορείτε να δείτε ποια από τα απαιτούμενα εργαλεία δεν είναι εγκατεστημένα ή δεν έχουν την κατάλληλη έκδοση. Για τα εργαλεία αυτά ακολουθήστε τις οδηγίες εγκατάστασης επιλέγοντας το αντίστοιχο κουμπί και εγκαταστήστε το λογισμικό ακολουθώντας τις οδηγίες.";
$langSoftware = "Λογισμικό";
$langBrowser = "Φυλλομετρητής (Browser)";
$langIE = "Internet Explorer, έκδοση 7 ή νεότερη";
$langFirefox = "Mozilla Firefox, έκδοση 2.6 ή νεότερη";
$langSafari = "Safari, έκδοση 4 ή νεότερη";
$langChrome = "Chrome";
$langOpera = "Opera";
$langBrowserSupported = "Ο φυλλομετρητής σας είναι στην κατάλληλη έκδοση.";
$langBrowserNotSupported = "Ο φυλλομετρητής σας δεν υποστηρίζεται. Παρακαλούμε αναβαθμίστε τον";
$langAcrobatReader = "Adobe Acrobat Reader, έκδοση 7 ή νεότερη";
$langAcrobatReaderInstalled = "Ο Αcrobat Reader είναι εγκατεστημένος στην κατάλληλη έκδοση.";
$langAcrobatReaderNotInstalled = "Ο Acrobat Reader δεν είναι εγκατεστημένος ή είναι παλαιότερης έκδοσης. Για να εγκαταστήσετε την τελευταία έκδοση πατήστε";
$langAgreeAndInstall = 'Στη νέα σελίδα επιλέξτε "Agree and Install now".';
$langFlashPlayer = "Adobe Flash Player, έκδοση 10 ή νεότερη";
$langFlashPlayerInstalled = "Ο Flash Player είναι εγκατεστημένος στην κατάλληλη έκδοση.";
$langFlashPlayerNotInstalled = "Ο Flash Player δεν είναι εγκατεστημένος ή είναι παλαιότερης έκδοσης. Για να εγκαταστήσετε την τελευταία έκδοση πατήστε";
$langShockInstalled = "Ο Shockwave Player είναι εγκατεστημένος στην κατάλληλη έκδοση.";
$langShockNotInstalled = "Ο Shockwave Player δεν είναι εγκατεστημένος ή είναι παλαιότερης έκδοσης. Για να εγκαταστήσετε την τελευταία έκδοση πατήστε";
$langCheckNotOk1 = "Διαδικασία εγκατάστασης";
$langInstallMsg = "Παρακαλώ περιμένετε! H εγκατάσταση μπορεί να διαρκέσει μερικά λεπτά.";
$langCheckNotOk2 = "Ελέγξτε από το διαγνωστικό πινάκα ποια προαπαιτούμενα εργαλεία λογισμικού δεν είναι εγκατεστημένα (εμφανίζονται με κόκκινα γράμματα). Ακολουθήστε τις οδηγίες εγκατάστασης που σας δίνονται από τις επίσημες ιστοσελίδες των προγραμμάτων και προχωρήστε στην εγκατάστασή τους.";
$langCheckNotOk3 = "Πρέπει να εγκαταστήσετε κάθε προαπαιτούμενο πρόγραμμα που δεν είναι εγκατεστημένο στη σωστή έκδοση.";
$langCheckNotOk4 = "Όταν ολοκληρώσετε την εγκατάσταση όλων των προαπαιτούμενων εργαλείων λογισμικού, για να επαληθεύσετε εάν έχουν γίνει σωστά οι εγκαταστάσεις πατήστε";
$langCheckNotOk5 = 'Εάν δεν υπάρχουν μηνύματα με κόκκινα γράμματα στο διαγνωστικό πίνακα, έχουν γίνει ορθά οι εγκαταστάσεις και θα εμφανιστεί το μήνυμα: "Έχετε εγκαταστήσει όλα τα προαπαιτούμενα προγράμματα στον υπολογιστή σας και μπορείτε να περιηγηθείτε στην Πλατφόρμα χωρίς προβλήματα".';
$langCheckOk = "Έχετε εγκαταστήσει όλα τα προαπαιτούμενα προγράμματα στον υπολογιστή σας και μπορείτε να περιηγηθείτε στην Πλατφόρμα χωρίς προβλήματα.";


/* * **********************************************************
 * chat
 * **************************************************************** */
$langWash = "Καθάρισμα";
$langWashSuccess = "Οι συνομιλίες διαγράφηκαν με επιτυχία.";
$langWashFrom = "Οι συνομιλίες διαγράφηκαν από";
$langSave = "Αποθήκευση";
$langClearedBy = "καθαρισμός από";
$langChatError = "Δεν είναι δυνατόν να ξεκινήσει η Ζωντανή Τηλεσυνεργασία";
$langsetvideo = "Σύνδεσμος παρουσίασης βίντεο";
$langButtonVideo = "Μετάδοση";
$langButtonPresantation = "Μετάδοση";
$langActivateConference = "Ενεργοποίηση τηλεσυνεργασίας";
$langpresantation = "Σύνδεσμος παρουσίασης ιστοσελίδας";
$langSaveChat = "Αποθήκευση συνομιλίας";
$langSaveMessage = "Η συνομιλία αποθηκεύθηκε στα Έγγραφα";
$langSaveErrorMessage = "Η συνομιλία δεν μπόρεσε να αποθηκευθεί";
$langNoGuest = "Οι χρήστες-επισκέπτες δεν μπορούν να χρησιμοποιήσουν το υποσύστημα!";
$langChatToSpecUsers = "Στην συνομιλία θα συμμετέχουν οι παρακάτω χρήστες";
$langChatDeleted ="Η συνομιλία διαγράφηκε";
$langNoChatAvailable = "Δεν υπάρχουν συνομιλίες";
$langChatActive = "Ενεργή";
$langChatInactive = "Ανενεργή";
$langChatTitleError = "Παρακαλώ συμπληρώστε τον τίτλο της συνομιλίας";
$langUntitledChat = "Ελεύθερη κουβεντούλα $langsOfCourse";
$langChatActivity = "Συνομιλία Δραστηριότητας ColMOOC";
$langCreateAgent = "Δημιουργία Agent";
$langEditAgent = "Επεξεργασία Agent";

/* * ***************************************************************
 * copyright.php
 * **************************************************************** */
$langCopyright = "Πληροφορίες Πνευματικών Δικαιωμάτων";
$langCopyrightNotice = '
<a href="http://www.openeclass.org" target=_blank>Open eClass</a> © 2003 - 2024<br>&nbsp;<br>
Η πλατφόρμα ' . $siteName . ' βασίζεται στην ανοικτή πλατφόρμα <a href="http://www.openeclass.org" target=_blank>Open eClass</a>
η οποία είναι ένα ολοκληρωμένο Σύστημα Διαχείρισης Ηλεκτρονικών '.$langOfCourses.' και αποτελεί
την πρόταση του Ακαδημαϊκού Διαδικτύου GUnet για την υποστήριξη της Υπηρεσίας
Ασύγχρονης Τηλεκπαίδευσης. Aναπτύχθηκε και υποστηρίζεται ενεργά από την Ομάδα
Ασύγχρονης Τηλεκπαίδευσης του GUnet και <a
href="http://download.eclass.gunet.gr" target="_blank">διανέμεται ελεύθερα</a>
ως Λογισμικό Ανοικτού Κώδικα σύμφωνα με τη γενική δημόσια άδεια GNU General
Public License (GNU GPL).<br><br>
Το περιεχόμενο των ηλεκτρονικών ' . $langsOfCourses . ' που φιλοξενεί η πλατφόρμα ' . $siteName . ',
καθώς και τα πνευματικά δικαιώματα του υλικού αυτού, ανήκουν στους συγγραφείς τους
και το GUnet δεν διεκδικεί δικαιώματα σε αυτό. Για οποιαδήποτε χρήση ή αναδημοσίευση του περιεχομένου
παρακαλούμε επικοινωνήστε με τους υπεύθυνους των αντίστοιχων ' . $langsOfCourses;
$langUsageTerms = 'Όροι Χρήσης';

/* * *****************************************************
 * course_description.php
 * ***************************************************** */
$langCourseProgram = "Περιγραφή $langOfCourse";
$langThisCourseDescriptionIsEmpty = "Το $langsCourse δεν διαθέτει περιγραφή";
$langEditCourseProgram = "Δημιουργία";
$langQuestionPlan = "Ερώτηση στον διδάσκοντα";
$langAddCat = "Κατηγορία";
$langBackAndForget = "Ακύρωση και επιστροφή";
$langBlockDeleted = "Η περιγραφή διαγράφηκε!";

$titreBloc = array(
    "Περιεχόμενο $langsOfCourse",
    'Μαθησιακοί στόχοι',
    'Βιβλιογραφία',
    'Μέθοδοι διδασκαλίας',
    'Μέθοδοι αξιολόγησης',
    'Προαπαιτούμενα',
    'Διδάσκοντες',
    'Ομάδα στόχος',
    'Προτεινόμενα συγγράμματα',
    'Περισσότερα');
$titreBlocNotEditable = array(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE);

/* * ******************************************************
 * course_home.php
 * ******************************************************* */
$langViewAs = "Προβολή ως";
$langAdminOnly = "Μόνο για Διαχειριστές";
$langInLnk = "Απενεργοποιημένοι σύνδεσμοι";
$langDelLk = "Θέλετε πραγματικά να διαγράψετε αυτό τον σύνδεσμο";
$langRemove = "διαγραφή";
$langEnter = "Είσοδος";
$langUpdate = "Αλλαγή Τίτλου";
$langIcon = "Εικονίδιο";
$langRegistered = "εγγεγραμμένοι";
$langOneRegistered = "εγγεγραμμένος";
$langIdentity = "Ταυτότητα $langOfCourse";
$langCourseS = $langsCourse;
$langRSSFeed = 'Ροή RSS';
$langRefernce = "Αναφορά";
$langCitation = "Βιβλιογραφική αναφορά $langsOfCourse";
$langAccessed = "Ανακτήθηκε την ";
$langUserEmailNotification = "Λαμβάνετε ειδοποιήσεις του $langsOfCourse μέσω email.";
$langNoUserEmailNotification = "Δεν λαμβάνετε ειδοποιήσεις του $langsOfCourse μέσω email.";
$langNoUserEmailLegend = "Ο χρήστης δεν λαμβάνει ειδοποιήσεις του $langsOfCourse μέσω email.";
$langCourseInvalidDepartment = "Το $langsCourse βρίσκεται σε τμήμα όπου δεν
    επιτρέπεται πλέον η δημιουργία $langsOfCourses.";
$langCourseInvalidDepartmentPrompt = "Παρακαλούμε %s μεταφέρετέ το
    μέσω των ρυθμίσεων $langsOfCourse %s.";
$langReadMore = "Περισσότερα";
$langReadLess = "Λιγότερα";
$langNoInfoAvailable = "Δεν υπάρχουν διαθέσιμες πληροφορίες";
$langDownloadCourse = "Κατέβασμα του μαθήματος";
$langConfEnableMailNotification = "Θέλετε να ενεργοποιήσετε τη λήψη ειδοποιήσεων του $langsOfCourse μέσω email;";
$langConfDisableMailNotification = "Θέλετε να απενεργοποιήσετε τη λήψη ειδοποιήσεων του $langsOfCourse μέσω email;";
$langOfNotifications = "ειδοποιήσεων";
$langSyllabus = "Περίγραμμα";
$langNoSyllabus = "Δεν υπάρχει περίγραμμα";
$langImageSelected = "Εικόνα επιλογής";


/* * *******************************************
 * course_info.php
 * ******************************************* */
$langCourseIden = "Ταυτότητα $langOfCourse";
$langBackupCourse = "Αντίγραφο ασφαλείας";
$langCloneCourse = "Κλώνος $langsOfCourse";
$langModifDone = "Οι ρυθμίσεις του $langsOfCourse άλλαξαν.";
$langHome = "Αρχική";
$langCode = "Κωδικός";
$langDelCourse = "Διαγραφή του $langsOfCourse";
$langDelUsers = "Διαγραφή χρηστών";
$langDelUser = "Διαγραφή χρήστη";
$langCourseTitle = "Τίτλος $langOfCourse";
$langConfidentiality = "Πρόσβαση";
$langPrivOpen = "Ελεύθερη Πρόσβαση (με εγγραφή) σε όσους διαθέτουν λογαριασμό στην πλατφόρμα";
$langPrivOpenShort = "Ελεύθερη (με εγγραφή)";
$langForbidden = "Μη επιτρεπτή ενέργεια";
$langConfTip = "Επιλέξτε τον τύπο πρόσβασης του $langsOfCourse από τους χρήστες.";
$langOptPassword = "Προαιρετικό συνθηματικό";
$langNoCourseTitle = "Δεν πληκτρολογήσατε τον τίτλο του $langsOfCourse";
$langCourseWeeklyFormatNotice = "Για εβδομαδιαία απεικόνιση πρέπει να επιλέξετε τουλάχιστον την ημερομηνία έναρξης $langsOfCourse";
$langCourseUserRequests = "Αιτήσεις εγγραφής χρηστών στο $langsCourse";
$langCourseUserRequestsDisabled = "Αιτήσεις εγγραφής χρηστών δεν υπάρχουν για τα μη κλειστά $langsCourses.";
$langUsersListAccess = "Εμφάνιση χρηστών του $langsOfCourse";
$langUsersListAccessInfo = "αφορά μόνο τους εγγεγραμμένους χρήστες του $langsOfCourse";
$langCourseAdminTools = "Διαχείριση εργαλείων";

// delete_course.php
$langModifGroups = "Ομάδες Εργασίας";
$langTheCourse = "Tο $langsCourse";
$langHasDel = "έχει διαγραφεί";
$langByDel = "Διαγράφοντας το $langsCourse θα διαγράψετε μόνιμα όλα τα περιεχόμενά του και όλους τους " . $langsOfStudentss . " που είναι γραμμένοι σε αυτό (δεν θα διαγραφούν από τα άλλα $langsCourses).";
$langByDel_A = "Θέλετε πράγματι να διαγράψετε το $langsCourse:";
$langTipLang = "Επιλέξτε την γλώσσα στην οποία θα εμφανίζονται τα μηνύματα του $langsOfCourse.";
$langTipLang2 = "Επιλέξτε την γλώσσα στην οποία θα εμφανίζονται τα μηνύματα της πλατφόρμας.";
$langCourseDeleted = "Διαγραφή του $langsOfCourse";
$langCourseDeletedBy = "Πραγματοποιήθηκε η διαγραφή από τον";
$langNoticeCourseDeleted = "Αν η διαγραφή του $langsOfCourse έγινε από εσάς, τότε αγνοήστε το παρόν email. Αν η διαγραφή έγινε κατά λάθος και
		θέλετε να επαναφέρετε το $langsCourse σας, τότε επικοινωνήστε με τους διαχειριστές της πλατφόρμας.";

// deluser_course.php
$langConfirmDel = "Επιβεβαίωση διαγραφής $langsOfCourse";
$langUserDel = "Πρόκειται να διαγράψετε όλους τους " . $langsOfStudentss . " από το $langsCourse (δεν θα διαγραφούν από τα άλλα $langsCourses).<p>Θέλετε πράγματι να προχωρήσετε στη διαγραφή τους από το $langsCourse;";

// refresh course.php
$langRefreshCourse = "Ανανέωση $langsOfCourse";
$langRefreshInfo = "Προκειμένου να προετοιμάσετε το $langsCourse για μια νέα ομάδα " . $langsOfStudents . " μπορείτε να διαγράψετε το παλιό περιεχόμενο.";
$langRefreshInfo_A = "Επιλέξτε ποιες ενέργειες θέλετε να πραγματοποιηθούν.";
$langUserDelCourseInfo = "Τσεκάρετε τα κριτήρια βάση των οποίων οι χρήστες θα απεγγραφούν από το $langsCourse.";
$langUserDelCourse = "Διαγραφή χρηστών από το $langsCourse";
$langUserDelNotice = "Σημ.: Οι χρήστες δεν θα διαγραφούν από άλλα $langsCourses";
$langAnnouncesDel = "Διαγραφή ανακοινώσεων του $langsOfCourse";
$langAgendaDel = "Διαγραφή εγγραφών από το ημερολόγιο του $langsOfCourse";
$langHideDocuments = "Απόκρυψη των εγγράφων του $langsOfCourse";
$langHideWork = "Απόκρυψη των εργασιών του $langsOfCourse";
$langHideExercises = "Απόκρυψη των ασκήσεων του $langsOfCourse";
$langDelAllWorkSubs = "Διαγραφή των υποβολών των εργασιών του $langsOfCourse";
$langDelWallPosts = "Διαγραφή αναρτήσεων τοίχου του $langsOfCourse";
$langDelBlogPosts = "Διαγραφή αναρτήσεων ιστολογίου του $langsOfCourse";
$langSubmitActions = "Εκτέλεση ενεργειών";
$langOptions = "Επιλογές";
$langRefreshSuccess = "Η ανανέωση του $langsOfCourse ήταν επιτυχής. Εκτελέστηκαν οι ακόλουθες ενέργειες:";
$langUsersDeleted = "Οι χρήστες διαγράφηκαν από το $langsCourse";
$langAnnDeleted = "Οι ανακοινώσεις διαγράφηκαν από το $langsCourse";
$langAgendaDeleted = "Οι εγγραφές του ημερολογίου διαγράφτηκαν από το $langsCourse";
$langWorksDelConfirm = "Αυτή η εργασία θα διαγραφεί. Είστε σίγουρος";
$langWorksDeleted = "Οι εργασίες απενεργοποιήθηκαν";
$langExercisesDeleted = "Οι ασκήσεις απενεργοποιήθηκαν";
$langDocsDeleted = "Τα έγγραφα απενεργοποιήθηκαν";
$langBlogPostsDeleted = "Οι αναρτήσεις του ιστολογίου διαγράφηκαν από το $langsCourse";
$langWallPostsDeleted = "Οι αναρτήσεις του τοίχου διαγράφηκαν από το $langsCourse";
$langWallPostsShow = "Αναρτήσεις";
$langBeforeRegDate = "με ημερομηνία εγγραφής πριν από";
$langPurgeExercise = "Διαγραφή άσκησης";
$langPurgeExerciseSuccess = "Η Άσκηση διαγράφηκε.";
$langExerciseCompleted = "Η Άσκηση ολοκληρώθηκε με επιτυχία.";
$langConfirmPurgeExercise = "Επιβεβαίωση διαγραφής άσκησης";
$langPurgeExerciseResults = "Εκκαθάριση αποτελεσμάτων";
$langPurgeExercisesResults = "Διαγραφή αποτελεσμάτων ασκήσεων";
$langPurgeExerciseResultsSuccess = "Τα αποτελέσματα της ερώτησης της άσκησης διαγράφηκαν";
$langPurgeExercisesResultsSuccess = "Τα αποτελέσματα των ασκήσεων διαγράφηκαν";
$langChangeAttemptStatus = "Η κατάσταση της προσπάθειας άλλαξε";
$langConfirmPurgeExerciseResults = "Επιβεβαίωση διαγραφής αποτελεσμάτων άσκησης";
$langNotAvailable = "Μη διαθέσιμα";
$langLeaveExerciseWarning = "ΠΡΟΣΟΧΗ! Με την έξοδο σας από την άσκηση η προσπάθεια σας καταγράφεται σαν να μην έχετε δώσει καμία απάντηση. Για μην συμβεί αυτό ολοκληρώστε την άσκηση ή κάντε προσωρινή αποθήκευση (αν αυτό επιτρέπεται).";
$langTemporarySave = "Προσωρινή αποθήκευση";
$langTemporarySaveNotice = "Έχετε αποθηκεύσει προσωρινά τις παρακάτω προσπάθειες της άσκησης";
$langTemporarySaveNotice2 = "Υπάρχει μια προσωρινά αποθηκευμένη προσπάθεια προς ολοκλήρωση η οποία θα εκτελεστεί αν συνεχίσετε. Θέλετε να συνεχίσετε?";
$langPendingExercise = "Υπάρχουν υποβολές προς βαθμολόγηση στις ασκήσεις";
$langAttemptWasCanceled = "Η προσπάθεια ακυρώθηκε.";
$langExerciseAttemptLeft = 'Προσοχή! Σας απομένει μία προσπάθεια.';
$langExerciseAttemptsLeft = 'Προσοχή! Σας απομένουν %d προσπάθειες.';
$langExerciseAttemptContinue = 'Πατώντας στο κουμπί «Συνέχεια» η προσπάθειά σας θα καταγραφεί.';
$langWithRegistrationDate = 'Με ημερομηνία εγγραφής';
$langWho = 'Που';
$langWithDepartment = 'ανήκουν στα';
$langWithoutDepartment = 'δεν ανήκουν στα';
$langWith = 'Με';
$langWithStudentId = 'αριθμούς μητρώου';
$langWithUsernames = 'ονόματα χρηστών';
$langUnansweredQuestions = 'Αναπάντητες ερωτήσεις';
$langUnansweredQuestionsWarningOne = 'Δεν έχετε απαντήσει σε μία ερώτηση.';
$langUnansweredQuestionsWarningMany = 'Δεν έχετε απαντήσει σε _ ερωτήσεις.';
$langUnansweredQuestionsWarningThisOne = 'Δεν έχετε απαντήσει στην ερώτηση αυτή.';
$langUnansweredQuestionsWarningUnseen = 'Δεν έχετε δει ακόμα όλες τις ερωτήσεις.';
$langUnansweredQuestionsQuestion = 'Θέλετε να προχωρήσετε στην υποβολή ή να επιστρέψετε στην πρώτη αναπάντητη ερώτηση;';
$langUnansweredQuestionsNoTurnBack = 'Θέλετε σίγουρα να προχωρήσετε στην επόμενη ερώτηση; Δε θα μπορείτε να επιστρέψετε.';
$langNoDeadline = "Χωρίς προθεσμία";
$langExerciseFinalSubmit = 'Οριστική υποβολή';
$langExerciseFinalSubmitWarn = 'Προσοχή! Η άσκηση θα υποβληθεί οριστικά. Θέλετε να προχωρήσετε;';
$langConvertedTo = "μετατράπηκε σε";
$langNextQuestion = 'Επόμενη ερώτηση';


/* * ***************************************************
 * contact.php
 * **************************************************** */
$langContactProf = "Επικοινωνία με τους $langsTeachers";
$langEmailEmpty = "Η διεύθυνση ηλεκτρονικού ταχυδρομείου σας είναι κενή.
Για να μπορείτε να επικοινωνήσετε με τον $langsOfTeacher, θα πρέπει να έχετε ορίσει
τη διεύθυνσή σας, ώστε να μπορείτε να λάβετε απάντηση. Μπορείτε να ορίσετε τη
διεύθυνσή σας από την επιλογή <a href='%s'>«Αλλαγή του προφίλ μου»</a> στη
σελίδα του χαρτοφυλακίου σας.";

$langEmptyMessage = "Αφήσατε το κείμενο της αίτησης κενό. Η αίτηση δε στάλθηκε.";
$langSendMessage = "Αποστολή μηνύματος";
$langContactMessage = "Πληκτρολογήστε το κείμενο του μηνύματός σας. Αυτό θα σταλεί μεσω email στους υπεύθυνους $langsTeachers του $langsOfCourse.";
$langSendingMessage = "Η αίτηση στάλθηκε στους $langsTeachers του $langsOfCourse:";
$langErrorSendingMessage = "Σφάλμα αποστολής! Η αίτηση δε στάλθηκε.";
$langContactIntro = "Ο χρήστης της πλατφόρμας $siteName με όνομα %s (%s <%s>) σας έστειλε την παρακάτω αίτηση εγγραφής.";
$langContactIntroFooter = "Για να διαχειριστείτε τις αιτήσεις εγγραφής στο $langsCourse κάντε κλικ ";

$langNonUserContact = "Για να επικοινωνήσετε με τους υπεύθυνους $langsTeachers
του $langsOfCourse, θα πρέπει να έχετε λογαριασμό στο σύστημα και
να έχετε συνδεθεί. Παρακαλούμε επισκεφθείτε την <a href='%s'>αρχική σελίδα</a>.";
$langIntroMessage = "Σύνταξη μηνύματος";
$langInfoAboutRegistration = "Το $langsCourse που επιλέξατε είναι κλειστό. Για να εγγραφείτε, θα πρέπει
να συμπληρώσετε την παρακάτω αίτηση, η οποία θα καταγραφεί και θα αποσταλεί στους διαχειριστές του $langsOfCourse.";
$langLabelCourseUserRequest = "Αίτηση εγγραφής στο $langsCourse";
$langReasonReject = "Αιτιολογία απόρριψης";
$langRequestReasons = "Αναφέρετε τους λόγους που επιθυμείτε την εγγραφή σας στο $langsCourse.";

/* * **************************************************
 * create_course.php
 * *************************************************** */
$langDescrInfo = "Σύντομη περιγραφή";
$langFieldsRequ = "Όλα τα πεδία είναι υποχρεωτικά!";
$langFieldsOptional = "Προαιρετικά πεδία";
$langFieldsOptionalNote = "Σημ.: Μπορείτε να αλλάξετε οποιεσδήποτε από τις πληροφορίες αργότερα";
$langEx = "π.χ. <i>Ιστορία της Τέχνης</i>";
$langDivision = "Τομέας";
$langTargetFac = "Η $langsFaculty στην οποία υπάγεται το $langsCourse";
$langDoubt = "Αν δεν ξέρετε το κωδικό του $langsOfCourse συμβουλευτείτε";
$langExFac = "* Αν επιθυμείτε να δημιουργήσετε $langsCourse σε άλλη $langsFaculty από αυτή που ανήκετε, τότε επικοινωνήστε με
την Ομάδα Ασύγχρονης Τηλεκπαίδευσης";
$langCreate = "Δημιουργία";
$langCourseKeywords = "Λέξεις Κλειδιά:";
$langCourseAddon = "Συμπληρωματικά Στοιχεία:";
$langErrorDir = "Ο υποκατάλογος του $langsOfCourse δεν δημιουργήθηκε και το $langsCourse δεν θα λειτουργήσει!<br><br>Ελέγξτε τα δικαιώματα πρόσβασης του καταλόγου <em>courses</em>.";
$langSubsystems = "Επιλέξτε τα υποσυστήματα που θέλετε να ενεργοποιήσετε για το νέο σας $langsCourse:";
$langLanguageTip = "Επιλέξτε σε ποια γλώσσα θα εμφανίζονται οι σελίδες του $langsOfCourse";
$langAccess = "Τύπος Πρόσβασης:";
$langAvailableTypes = "Διαθέσιμοι τύποι πρόσβασης";
$langModules = "Υποσυστήματα";
$langTestForum = "Γενικές συζητήσεις";
$langDelAdmin = "Περιοχή συζητήσεων για κάθε θέμα που αφορά το $langsCourse";
$langExMessage = "Παράδειγμα Μηνύματος";
$langAnonymous = "Ανώνυμος";
$langExerciceEx = "Υπόδειγμα άσκησης";
$langManyAnswers = "(περισσότερες από μία απαντήσεις μπορεί να είναι σωστές)";
$langDoc = "Έγγραφα";
$langVideoLinks = "Βιντεοσκοπημένα $langCourses";
$langWorks = "Εργασίες";
$langForums = "Συζητήσεις";
$langPinTopic = "Καρφίτσωμα ως σημαντική";
$langForumViewAll = "Εμφάνιση όλων";
$langForumViewPage = "Εμφάνιση ανά σελίδα";
$langUnpinTopic = "Αφαίρεση σήμανσης ως σημαντικής";
$langExercices = "Ασκήσεις";
$langAddPageHome = "Ανέβασμα Ιστοσελίδας";
$langModifyInfo = "Διαχείριση $langOfCourse";
$langDropBox = "Μηνύματα";
$langDropBoxInbox = "Εισερχόμενα";
$langDropBoxOutbox = "Εξερχόμενα";
$langMyDropBox = "Τα μηνύματά μου";
$langLearnPath = "Γραμμή μάθησης";
$langDescription = "Περιγραφή";
$langWiki = "Σύστημα Wiki";
$langWikiNoModifications = "Δεν υπάρχουν αλλαγές";
$langWikiLastModification = "Τελευταία αλλαγή";
$langUsage = "Στατιστικά";
$langClearStats = "Καθαρισμός στατιστικών";
$langStatsCleared = "Τα στατιστικά καθαρίστηκαν";
$langVideoText = "Παράδειγμα ενός αρχείου RealVideo. Μπορείτε να ανεβάσετε οποιοδήποτε τύπο αρχείου ήχου ή βίντεο (.mov, .rm, .mpeg...), εφόσον οι " . $langsStudents . " έχουν το αντίστοιχο plug-in για να το δούν";
$langGoogle = "Μηχανή αναζήτησης";
$langIntroductionText = "Εισαγωγικό κείμενο του $langsOfCourse. Αντικαταστήστε το με το δικό σας, κάνοντας κλίκ στην <strong>Αλλαγή</strong>.";
$langJustCreated = "Μόλις δημιουργήσατε με επιτυχία το $langsCourse με τίτλο ";
$langCreateCourseNotAllowedNode = "Επιλέξατε μη επιτρεπτές $langsFaculties. Παρακαλώ ξαναπροσπαθήστε.";
$langUploadRecAudio = "Ηχογράφηση";
$langUploadRecVideo = "Βιντεοσκόπηση";
$langPause = "Παύση";
$langStopRecording = "Τέλος καταγραφής";
$langReleaseMic = "Αποδέσμευση μικροφώνου";
$langEnterFile = "Δώστε το όνομα αρχείου";
$langOpenCamera = "Άνοιγμα κάμερας";
$langMaxRecAudioTime = "μέγιστος χρόνος ηχογράφησης: 5 λεπτά";
$langMaxRecAudioTimeInExericses = "μέγιστος χρόνος ηχογράφησης: 20 λεπτά";
$langMaxRecAudioTimeTmp = "μέγιστος χρόνος ηχογράφησης:";
$langMaxRecVideoTime = "μέγιστος χρόνος βιντεοσκόπησης: 2 λεπτά";
$langQRCodePresence = "Παρουσία μέσω QR code";
$langAddPresenceSuccess = "Η παρουσία σας καταχωρήθηκε επιτυχώς.";
$langAttendance = "Παρουσιολόγιο";
$langAttendances = "Παρουσιολόγια";
$langAttendanceManagement = "Διαχείριση παρουσιολογίου";
$langAttendanceAbsencesYes = "Παρουσία";
$langAttendanceAbsencesNo = "Απουσία";
$langAttendanceAbsences = "Παρουσίες";
$langAttendanceAbsencesFrom = "παρουσίες από τις";
$langAttendanceAbsencesFrom2 = "υποχρεωτικές του $langsOfCourse.";
$langAttendanceAbsencesYesNo = "Παρουσία/απουσία";
$langAttendanceAddActivity = "Δραστηριότητας";
$langAttendanceActivityDate = "Ημερομηνία διεξαγωγής";
$langAttendanceActivity = "Δραστηριότητα";
$langAttendanceBook = "Καταχώριση παρουσιών δραστηριότητας";
$langAttendanceBooking = "Καταχώριση";
$langAttendanceUpdate = "Ενημέρωση";
$langAttendanceSucInsert = "Η δραστηριότητα προστέθηκε";
$langAttendanceLimit = "Επιτυχής ενημέρωση αριθμού παρουσιών";
$langAttendanceDel = "H δραστηριότητα διαγράφηκε";
$langAttendanceDelFailure = "Δεν υπάρχει η δραστηριότητα που προσπαθείτε να διαγράψετε";
$langAttendanceDeleted = "To παρουσιολόγιο διαγράφηκε με επιτυχία";
$langAttendanceUsers = "Επιτυχής ενημέρωση αριθμού $langsOfStudents.";
$langAttendanceNewBookRecord = "Θα πρέπει να κάνετε κλικ στο καταχώριση για να δημιουργηθεί καρτέλα παρουσιολογίου για το χρήστη";
$langAttendanceNoActMessage1 = "Δεν υπάρχουν δραστηριότητες στο παρουσιολόγιο. Κάντε κλικ στο 'Προσθήκη' για να εισάγετε.";
$langAttendanceNoActMessage4 = "Δεν υπάρχουν δραστηριότητες για αυτόματη καταχώριση";
$langAttendanceNoActMessageAss4 = "Δεν υπάρχουν εργασίες για αυτόματη καταχώριση";
$langAttendanceNoActMessageExe4 = "Δεν υπάρχουν ασκήσεις για αυτόματη καταχώριση";
$langAttendanceNoActMessageLp4 = "Δεν υπάρχουν γραμμές μάθησης για αυτόματη καταχώριση";
$langAttendanceNoActMessageTc = "Δεν υπάχουν τηλεσυνεργασίες για αυτόματη καταχώριση";
$langAttendanceNoActMessage5 = "Δεν υπάρχουν δραστηριότητες στο παρουσιολόγιο.";
$langAttendanceActCour = "Δραστηριότητα $langsOfCourse";
$langAttendanceInsAut = "αυτόματη καταχώριση παρουσίας";
$langAttendanceInsMan = "μη αυτόματη καταχώριση παρουσίας";
$langAttendanceActAttend = "Δραστηριότητα παρουσιολογίου";
$langAttendanceActList = "Δραστηριότητες";
$langAttendanceActToAdd = "Δραστηριότητες προς εισαγωγή στο παρουσιολόγιο";
$langAttendanceActToAddAss = "Εργασίες προς εισαγωγή στο παρουσιολόγιο";
$langAttendanceActToAddExe = "Ασκήσεις προς εισαγωγή στο παρουσιολόγιο";
$langAttendanceLimitTitle = "Υποχρεωτικές παρουσίες";
$langAttendanceLimitNumber = "Αριθμός υποχρεωτικών παρουσιών";
$langAttendanceStudentFailure = "Δεν έχει γίνει ακόμη καταχώριση παρουσιών";
$langAttendanceActiveUsers = "Χρήστες παρουσιολογίου";
$langAttendanceAutoBook = "Αυτόματη καταχώριση παρουσίας";
$langAttendanceInfoForUsers = "Επιλογή χρηστών που θα συμμετέχουν στο παρουσιολόγιο";
$langAttendance6Months = "Συμμετέχουν οι $langsStudents τελευταίου εξαμήνου";
$langAttendance3Months = "Συμμετέχουν οι $langsStudents τελευταίου τριμήνου";
$langAttendanceAllMonths = "Συμμετέχουν όλοι οι εγγεγραμμένοι $langsStudents";
$langAttendanceDeleteUsers = "Αν θέλετε να διαγράψετε κάποιους από το παρουσιολόγιο επιλέξτε τους από τη παρακάτω λίστα και κάντε κλικ στο κουμπί διαγραφή";
$langAttendanceDelete = "Διαγραφή χρήστη από το παρουσιολόγιο";
$langNewAttendance = "Νέο Παρουσιολόγιο";
$langNewAttendance2 = "Δημιουργία νέου παρουσιολογίου για το $langsCourse";
$langChangeAttendanceSuccess = "Το παρουσιολόγιο ενεργοποιήθηκε με επιτυχία";
$langChangeAttendanceCreateSuccess = "Το παρουσιολόγιο δημιουργήθηκε με επιτυχία";
$langAttendanceNoTitle2 = "Παρουσιολόγιο χωρίς τίτλο";
$langNoAttendances = "Δεν υπάρχουν διαθέσιμα παρουσιολόγια";
$langAvailableAttendances = "Διαθέσιμα παρουσιολόγια";
$langImportAttendances = "Εισαγωγή παρουσιών από αρχείο";
$langAttendancesImported = "Οι παρουσίες καταχωρήθηκαν";
$langImportExtraAttendanceUsers = "Οι παρακάτω χρήστες δεν συμμετείχαν στο παρουσιολόγιο";
$langAttendanceUsers = "Χρήστες του Παρουσιολογίου";
$langImportAttendancesHelp = "Μπορείτε να αποστείλετε ένα αρχείο τύπου Excel (π.χ. xls, xlsx) με τις παρουσίες των χρηστών.
    Η παρουσία των χρηστών πρέπει να συμπληρωθεί στην τελευταία στήλη του αρχείου που θα κατεβάσετε από το παρακάτω σύνδεσμο.<br><br>
    <strong>MHN</strong> αλλάξετε τη δομή του αρχείου (π.χ. αριθμό στηλών) γιατί η εισαγωγή των παρουσιών θα αποτύχει. <br><br>
    Σημειώστε επίσης, ότι αν θέλετε να εισάγετε παρουσία σημειώστε το <strong>1</strong>. Οτιδήποτε άλλο δεν θεωρείται παρουσία.";

$langGradebook = "Βαθμολόγιο";
$langGradebooks = "Βαθμολόγια";
$langAvailableGradebooks = "Διαθέσιμα βαθμολόγια";
$langNoGradeBooks = "Δεν υπάρχουν διαθέσιμα βαθμολόγια";
$langGradebookManagement = "Διαχείριση Βαθμολογίου";
$langGradebookAddActivity = "Δραστηριότητας";
$langOfGradebookActivity = "δραστηριότητας";
$langOfGradebookUsers = "χρηστών";
$langOfGradebookUser = "χρήστη";
$langOfGradebookGroups = "ομάδων";
$langOfGradebookVisibility = "ορατότητας";
$langOfGradebookSettings = "ρυθμίσεων βαθμολογίου";
$langGradebookActivityDate = "Ημερομηνία διεξαγωγής";
$langGradebookActivityDate2 = "Ημερομηνία";
$langGradebookActivityWeight = "Ποσοστό συμμετοχής στη βαθμολογία";
$langGradebookActivityWeightLeft = "Διαθέσιμο";
$langGradebookBook = "Καταχώριση βαθμών";
$langSGradebookBook = "Καταχώριση βαθμού";
$langGradebookBooking = "Καταχώριση";
$langGradebookUpdate = "Ενημέρωση βαθμών";
$langGradebookAutoUpdate = "Αυτόματα ενημέρωση βαθμών";
$langGradebookEdit = "Επιτυχής αλλαγή";
$langGradebookSucInsert = "Πραγματοποιήθηκε η εισαγωγή της δραστηριότητας του βαθμολογίου";
$langGradebookLimit = "Επιτυχής ενημέρωση βαθμών";
$langGradebookDel = "Η δραστηριότητα του βαθμολογίου διαγράφηκε";
$langGradebookDelFailure = "Δεν υπάρχει η δραστηριότητα που προσπαθείτε να διαγράψετε";
$langGradebookNewBookRecord = "Θα πρέπει να κάνετε κλικ στο καταχώριση για να δημιουργηθεί καρτέλα βαθμολογίου για το χρήστη.";
$langGradebookNoActMessage1 = "Δεν υπάρχουν δραστηριότητες στο βαθμολόγιο. Κάντε κλικ στο 'Προσθήκη' για να εισάγετε.";
$langGradebookNoActMessage4 = "Δεν υπάρχουν δραστηριότητες για αυτόματη βαθμολόγηση";
$langGradebookNoActMessageAss4 = "Δεν υπάρχουν εργασίες για αυτόματη βαθμολόγηση";
$langGradebookNoActMessageExe4 = "Δεν υπάρχουν ασκήσεις για αυτόματη βαθμολόγηση";
$langGradebookNoActMessage5 = "Δεν υπάρχουν δραστηριότητες στο βαθμολόγιο";
$langGradebookActCour = "Δραστηριότητα $langsOfCourse";
$langGradebookActAttend = "Δραστηριότητα βαθμολογίου";
$langGradebookActList = "Δραστηριότητες του βαθμολογίου";
$langGradebookActToAdd = "Δραστηριότητες προς εισαγωγή στο βαθμολόγιο";
$langGradebookActToAddAss = "Εργασίες προς εισαγωγή στο βαθμολόγιο";
$langGradebookActToAddExe = "Ασκήσεις προς εισαγωγή στο βαθμολόγιο";
$langGradebookStudentFailure = "Δεν έχει γίνει ακόμη καταχώριση βαθμών";
$langGradebookMEANS = "Τιμές";
$langGradebookInfoForUsers = "Επιλογή χρηστών που θα συμμετέχουν στο βαθμολόγιο";
$langGradebookAllBetweenRegDates = "Όλοι όσοι έχουν εγγραφεί στο $langsCourse το παρακάτω χρονικό διάστημα";
$langGradebookActiveUsers = "Χρήστες βαθμολογίου";
$langGradebookActiveUsersSemester = "Φοιτητές μόνο τελευταίου εξαμήνου";
$langGradebookRange = "Κλίμακα βαθμολογίου";
$langGradebookDateRange = "χρονικού διαστήματος";
$langGradebookDateOutOf = "εκτός";
$langGradebookDateIn = "εντός";
$langGradebookRegistrationDateRange = "Χρονικό διάστημα εγγραφής";
$langGradeNoBookAlert = "Δεν μπορείτε να εισάγετε βαθμολογία. Βαρύτητα που δεν έχετε δηλώσει σε δραστηριότητα";
$langGradebookNewUser = "Θα πρέπει να κάνετε κλικ στο καταχώριση για να δημιουργηθεί καρτέλα βαθμολογίου για το χρήστη";
$langGradebookWeight = "Ποσοστό συμμετοχής";
$langGradebookAutoGrade = "αυτόματη καταχώριση βαθμού";
$langGradebookNoAutoGrade = "μη αυτόματη καταχώριση βαθμού";
$langGradebookGrade = "Βαθμός";
$langGradebookRemainingGrade = "υπόλοιπο βαρύτητας";
$langGradebookGradeAlert = "Προσοχή στο υπόλοιπο βαρύτητας";
$langGradebookGradeAlert3 = "Υπάρχουν δραστηριότητες που δεν συμμετέχουν στο τελικό βαθμό (ποσοστό συμμετοχής 0%).";
$langGradebookActivityAct = "Δραστηριότητα γραμμής μάθησης";
$langGradebookActivityLpExe = "Άσκηση γραμμής μάθησης";
$langGradebookActToAddLp = "Δραστηριότητες γραμμής μάθησης προς εισαγωγή στο βαθμολόγιο";
$langGradebookNoTitle = "Δραστηριότητα χωρίς τίτλο";
$langGradebookUpToDegree = "* γίνεται αναγωγή της αυτόματης βαθμολογίας των ασκήσεων με άριστα το ";
$langGradebookDeleteAlert = "Είστε σίγουροι ότι θέλετε να διαγράψετε τη δραστηριότητα; (θα διαγραφούν και οι βαθμολογίες που έχετε καταχωρήσει για τη δραστηριότητα)";
$langGradebookDelete = "Διαγραφή χρήστη από το βαθμολόγιο";
$langGradebookOutRange = "Προσοχή: έχετε εισάγει βαθμούς μεγαλύτερους από την κλίμακα";
$langGradebookExams = "Γραπτές εξετάσεις";
$langGradebookLabs = "Βαθμός εργαστηρίου";
$langGradebookOral = "Προφορικός βαθμός";
$langGradebookProgress = "Βαθμός προόδου";
$langGradebookOtherType = "Άλλη δραστηριότητα";
$langGradebookAssignSpecific = "Η εργασία αφορά συγκεκριμένους $langsStudents";
$langGradebookTotalGrade = "Τελικός βαθμός";
$langGradebookSum = "Σύνολο";
$langGradebookTotalGradeNoInput = "Δεν έχει γίνει ακόμη καταχώριση βαθμών ή δεν υπάρχουν δραστηριότητες στο βαθμολόγιο.";
$langGradebookGrades = "Βαθμοί";
$langGradebookAlertToChange = "Προσοχή το βαθμολόγιο είναι σε επεξεργασία και μπορεί οι βαθμοί να αλλάξουν.";
$langGradebookAlertNoInput = "Δεν υπάρχει καταχώριση";
$langGradeTotal = "Οι βαθμοί μου ";
$langMeanValue = "Μέσος όρος";
$langMinValue = "Ελάχιστη";
$langMaxValue = "Μέγιστη";
$langRefreshList = "Ανανέωση λίστας";
$langStudLastSemester = "$langStudents μόνο τελευταίου τριμήνου";
$langAllRegStudents = "Όλοι οι εγγεγραμμένοι";
$langNoRegStudent = "Δεν υπάρχουν $langsStudents που συμμετέχουν στο βαθμολόγιο. Μπορείτε να προσθέσετε εκπαιδευόμενους κάνοντας κλικ";
$langNoStudents = "Δεν υπάρχουν $langsStudents στο διάστημα που επιλέξατε";
$langNoStudentsInAttendance = "Δεν υπάρχουν $langsStudents στο παρουσιολόγιο.  Μπορείτε να προσθέσετε εκπαιδευόμενους κάνοντας κλικ";
$langUsersGradebook = "$langStudents βαθμολογίου";
$langNoGradebook = "Δεν συμμετέχετε σε $langsCourses με βαθμολόγηση.";
$langGradeVisible = "Εμφάνιση βαθμολογίας στους χρήστες";
$langNewGradebook = "Νέο βαθμολόγιο";
$langNewGradebook2 = "Δημιουργία νέου βαθμολογίου για το $langsCourse";
$langChangeGradebook = "Επιλογή βαθμολογίου";
$langChangeGradebookSuccess = "Το βαθμολόγιο ενεργοποιήθηκε με επιτυχία";
$langCreateGradebookSuccess = "Το βαθμολόγιο δημιουργήθηκε με επιτυχία";
$langChangeGradebook2 = "(επιλογή ενεργού βαθμολογίου για το $langsCourse)";
$langGradebookNoTitle2 = "Βαθμολόγιο χωρίς τίτλο";
$langGradebookDeleted = "To βαθμολόγιο διαγράφηκε με επιτυχία";
$langSpecificUsers = "συγκεκριμένοι $langsStudents";
$langExportGradebookWithUsers = "Εξαγωγή αποτελεσμάτων ανά χρήστη";
$langExportGradebook = "Εξαγωγή αποτελεσμάτων ανά δραστηριότητα";
$langRefreshGrades = 'Ανανέωση βαθμών από δραστηριότητες';
$langRefreshGrade = 'Ανανέωση βαθμών από δραστηριότητα';
$langRefreshGradesDone = 'Οι βαθμοί των δραστηριοτήτων του βαθμολογίου με αυτόματη καταχώρηση ανανεώθηκαν.';
$langGradebookUsers = "Χρήστες του βαθμολογίου";

// ------------------
// Certification - Badge
// ------------------
$langCertificate = "Πιστοποιητικό";
$langCertificates = "Πιστοποιητικά";
$langNewCertificateSuc = "Το πιστοποιητικό δημιουργήθηκε με επιτυχία";
$langNewCertificate = "Νέο πιστοποιητικό";
$langNewBadge = "Νέα επιβράβευση";
$langBadge = "Επιβράβευση";
$langBadges = "Επιβραβεύσεις";
$langNewCertificateAuto = "Αυτόματη ανάθεση";
$langCertificateInsertAct = "Πραγματοποιήθηκε η εισαγωγή της δραστηριότητας";
$langCommentsBlog = "Σχόλια σε ιστολόγιο";
$langCommentsCourse = "Σχόλια στο $langsCourse";
$langOfLikesSocial = "Likes στους κοινωνικούς συνδέσμους";
$langOfLikesForum = "Likes στις περιοχές συζητήσεων";
$langMult = "Προβολή πολυμέσου";
$langVideoLink = "Προβολή video link";
$langEbook = "Προσπέλαση ηλ. βιβλίου";
$langAnsQuest = "Απάντηση σε ερωτηματολόγιο";
$langWikiPages = "Αριθμός δημιουργημένων σελίδων στο wiki";
$langAllActivities = "Όλες οι δραστηριότητες";
$langNoActivCert = "Δεν υπάρχουν δραστηριότητες. Κάντε κλικ στο 'Προσθήκη' για να εισάγετε.";
$langNoInsCert = "Δεν υπάρχουν δραστηριότητες για εισαγωγή";
$lanfCertNoValMes  = "Αν δεν επιλέξετε τιμή, λαμβάνεται υπόψη η ολοκλήρωση της δραστηριότητας";
$langNoCertificates = "Δεν έχουν οριστεί πιστοποιητικά. Μπορείτε να ορίσετε πατώντας \"Νέο πιστοποιητικό\"";
$langNoBadges = "Δεν έχουν οριστεί επιβραβεύσεις. Μπορείτε να ορίσετε πατώντας \"Νέα επιβράβευση\"";
$langTemplate = "Πρότυπο";
$langProgress = "Πρόοδος";
$langOfCourseCompletion = "Δραστηριοτήτων ολοκλήρωσης $langsOfCourse";
$langGradeOfCourseCompletion = "Βαθμού ολοκλήρωσης $langsOfCourse";
$langGradeCourseCompletion = "Βαθμός ολοκλήρωσης $langsOfCourse";
$langOfAssignment = "Εργασίας";
$langOfBlog = "Ιστολογίου";
$langOfMultimediaLinks = "πολυμεσικών συνδέσμων";
$langOfEBook = "Ηλεκτρονικού βιβλίου";
$langOfPoll = "Ερωτηματολογίου";
$langOfGradebook = "Βαθμολογίου";
$langOfProgress = "Προόδου";
$langNumInForum = "Πλήθος δημοσιεύσεων στις συζητήσεις";
$langNumInForumTopic = "Πλήθος δημοσιεύσεων σε θέμα συζητήσης";
$langOfBlogComments = "Σχολίων ιστολογίου";
$langOfCourseComments = "Σχολίων στο $langsCourse";
$langOfLearningPath = "Γραμμής μάθησης";
$langOfLearningPathDuration = "Διάρκεια Γραμμής μάθησης";
$langNoCertificateUsers = "Δεν υπάρχουν $langsStudents που συμμετέχουν στο συγκεκριμένο πιστοποιητικό.";
$langUsedCertRes = "Το πιστοποιητικό περιέχει δραστηριότητες που έχουν χρησιμοποιηθεί από κάποιον $langsstudent_acc";
$langWarningAboutUsedCert = "Αν θέλετε να το διαγράψετε κάντε κλικ παρακάτω. Σημειώστε ότι θα διαγραφεί η πρόοδος όλων των χρηστών για το πιστοποιητικό που έχετε ορίσει!";
$langNoUserActivity = "Ο $langsStudent δεν έχει εκτελέσει καμία δραστηριότητα.";
$langTotalPercentCompleteness = "Συνολικό ποσοστό ολοκλήρωσης";
$langUsersCertResults = "Έχει ολοκληρωθεί από ";
$langHasBeenCompleted = "Ολοκληρώθηκε από";
$langNumOfBlogs = "Αριθμός δημιουργημένων ιστολογίων";
$langNumOfForums = "Αριθμός δημοσιεύσεων";
$langResourceAlreadyAdded = "Η δραστηριότητα έχει ήδη προστεθεί";
$langNotActivated = "Η ενεργοποίηση δεν είναι δυνατή επειδή δεν έχετε ορίσει δραστηριότητες.";
$langCertBadgeAdmin = "Πρότυπα πιστοποιητικών / επιβραβεύσεων";
$langAddNewCertTemplate = "Προσθήκη προτύπου πιστοποιητικού";
$langAddNewBadgeTemplate = "Προσθήκη εικονιδίου επιβράβευσης";
$langTemplateName = "Όνομα προτύπου";
$langAvailableBadges = "Διαθέσιμα εικονίδια επιβραβεύσεων";
$langAvailableCertTemplates = "Διαθέσιμα πρότυπα πιστοποιητικών";
$langDelWithSuccess = "Η διαγραφή πραγματοποιήθηκε με επιτυχία";
$langCertBadge = "Πιστοποιητικά / Επιβραβεύσεις";
$langCertificateDetails = "Στοιχεία Πιστοποιητικού";
$langBadgeDetails = "Στοιχεία Επιβράβευσης";
$langCourseParticipation = "Διάρκεια συμμετοχής";
$langCourseHoursParticipation = "Ώρες συμμετοχής";
$langNoCertBadge = "Δεν έχει οριστεί κάποιο πιστοποιητικό ή επιβράβευση.";
$langResourceBelongsToCert = "Η ενέργεια δεν μπορεί να εκτελεστεί επειδή ο πόρος ανήκει σε κάποιο πιστοποιητικό ή επιβράβευση.";
$langTemplateBelongsToCert = "Η ενέργεια δεν μπορεί να εκτελεστεί επειδή το πρότυπο χρησιμοποιείται σε κάποιο πιστοποιητικό.";
$langIconBelongsToBadge = "Η ενέργεια δεν μπορεί να εκτελεστεί επειδή το εικονίδιο χρησιμοποιείται σε κάποια επιβράβευση.";
$langProgressBasicInfo = "Βασικά Στοιχεία";
$langCourseCompletion = "Ολοκλήρωση $langsOfCourse";
$langCourseCompletionCreated = "Η ολοκλήρωση $langsOfCourse δημιουργήθηκε";
$langCourseCompletionMessage = "Το $langsCourse ολοκληρώθηκε με επιτυχία";
$langDeleteCourseActivities = "Διαγραφή δραστηριοτήτων";
$langPurge = "Πλήρης διαγραφή";
$langConfirmPurgeCourseCompletion = "Προσοχή! Θα διαγραφεί η πρόοδος όλων των χρηστών σχετικά με την ολοκλήρωση του μαθήματος!";
$langConfirmPurgeBadge = "Προσοχή! Θα διαγραφεί η πρόοδος όλων των χρηστών για την επιβράβευση που έχετε ορίσει!";
$langConfirmPurgeCert = "Προσοχή! Θα διαγραφεί η πρόοδος όλων των χρηστών για το πιστοποιητικό που έχετε ορίσει!";
$langCertAddress = "Δημόσια διεύθυνση πιστοποιητικού";
$langCertificateDeadline = "Λήξη πιστοποιητικού";
$langCertDeadlineHelp = "κάντε κλικ για να ορίσετε (προαιρετικά) ημερομηνία λήξης πιστοποιητικού";
$langOrientation = "Προσανατολισμός";
$langPortrait = "Κάθετος";
$langLandscape = "Οριζόντιος";
$langMyCertificates = "Τα πιστοποιητικά μου";
$langCertAuthenticity = "Αναγνωριστικό γνησιότητας";
$langRefreshProgress = "Ανανέωση από δραστηριότητες";
$langRefreshProgressInfo = "Η ανανέωση αφορά μόνο τις ασκήσεις, εργασίες και τις γραμμές μάθησης.";
$langRefreshProgressResults = "Η πρόοδος των $langsOfStudents ανανεώθηκε";
$langCompletedIn = "Ολοκληρώθηκε στις";
$langNoThumbnail = "Δεν υπάρχει εικονίδιο";
//------------------------------------


$langCopyrighted="Πνευματικά Δικαιώματα";
$langWithoutCopyright="Ελεύθερο δικαιωμάτων";
$langCopyrightedNotFree="Προστατεύονται όλα τα δικαιώματα";
$langCopyrightedUnknown="Άγνωστο";
$langLicenseUnset = 'Δεν έχει οριστεί';
$langCreativeCommonsCCBY = "CC - Αναφορά Δημιουργού";
$langCreativeCommonsCCBYSA = "CC - Αναφορά - Παρόμοια Διανομή";
$langCreativeCommonsCCBYND = "CC - Αναφορά - Όχι Παράγωγα Έργα";
$langCreativeCommonsCCBYNC = "CC - Αναφορά - Μη Εμπορική Χρήση";
$langCreativeCommonsCCBYNCSA = "CC - Αναφορά - Μη Εμπορική Χρήση - Παρόμοια Διανομή";
$langCreativeCommonsCCBYNCND = "CC - Αναφορά - Μη Εμπορική Χρήση - Όχι Παράγωγα Έργα";
$langCommercialUse = "Εμπορική χρήση";
$langAllowModification = "Επιτρέψτε διασκευή";



// Groups
$langCreateCourseGroups = "Ομάδες χρηστών";
$langCatagoryMain = "Αρχή";
$langCatagoryGroup = "Συζητήσεις Ομάδων χρηστών";
$langNoGroup = "Δεν έχουν οριστεί ομάδες χρηστών";
$langGroupMembersNum = "Μέλη";
$langCategorisedGroups = "Κατηγορίες ομάδων χρηστών";
$langNoGroupCategories = "Δεν υπάρχουν κατηγορίες ομάδων χρηστών";
$langGroupDelconfirm = "Θέλετε να διαγράψετε την ομάδα χρηστών;";
$langNoGroupInCategory = "Δεν υπάρχουν ομάδες χρηστών σε αυτή την κατηγορία";
$langGroupCatDel = "Οταν διαγράψετε μια κατηγορία, θα διαγραφούν όλες οι ομάδες χρηστών της κατηγορίας. Είστε βέβαιος ότι θέλετε να διαγράψετε την κατηγορία;";
$langGroupCategoryDeleted = "Η κατηγορία διαγράφηκε μαζί με όλες τις ομάδες χρηστών της";
$langGroupDeleted = "Η ομάδα χρηστών διαγράφηκε";
$langGroupTeam = "Γενικές Ομάδες Χρηστών";
$langInvalidNumericValue = "άκυρη τιμή πεδίου";
$langGroupFull = "η ομάδα είναι πλήρης";
$langGroupManyUsers = "<strong>Σημείωση</strong>: Οι χρήστες θα πρέπει να είναι ήδη εγγεγραμμένοι στο $langsCourse.";
$langUsersNotFound = 'Οι παρακάτω χρήστες δε βρέθηκαν στην πλατφόρμα';
$langUsersNotRegistered = "Οι παρακάτω χρήστες δεν έχουν εγγραφεί στο $langsCourse";
$langUsersNotAdded = 'Δεν προστέθηκε κανένας χρήστης. Παρακαλούμε διορθώστε τα παρακάτω προβλήματα και επανυποβάλλετε τη φόρμα.';
$langUsersInOtherGroups = 'Οι παρακάτω χρήστες βρέθηκαν σε άλλες ομάδες του μαθήματος και δεν επιτρέπεται η εγγραφή τους σε αυτήν';
$langUsersOverMaximum = 'Ο τελικός αριθμός (%d) υπερβαίνει το μέγιστο πλήθος μελών της ομάδας (%d).';
$langUsersAddedToGroup = 'Οι χρήστες προστέθηκαν στην ομάδα.';
$langGroupsManagment = "Διαχείριση ομάδων";
$langSearchByCategory = "Αναζήτηση μέσω : ";
$langAllGroups = "Όλες οι ομάδες";
$langAllGroupsWithoutCategory = "Ομάδες που δεν ανήκουν σε κατηγορία";

//neos odhgos dhmiourgias mathimaton
$langEnterMetadata = "Μπορείτε να αλλάξετε τις ρυθμίσεις του $langsOfCourse μέσα από τη 'Διαχείριση $langOfCourse'";
$langCreateCourse = "Οδηγός δημιουργίας $langsOfCourse";
$langCreateCourseStep = "Βήμα";
$langCreateCourseStep2 = "από";
$langCreateCourseStep2Title = "Συμπληρωματικές πληροφορίες $langsOfCourse";
$langCreateCourseStep3Title = "Υποσυστήματα και τύπος πρόσβασης";
$langcourse_objectives = "Στόχοι του $langsOfCourse";
$langcourse_prerequisites = "Προαπαιτούμενες γνώσεις";
$langNextStep = "Επόμενο βήμα";
$langPreviousStep = "Προηγούμενο βήμα";
$langFinalize = "Δημιουργία $langsOfCourse";
$langCourseCategory = "Η κατηγορία στην οποία ανήκει το $langsCourse";
$langProfessorsInfo = "Ονοματεπώνυμα $langsOfTeachers του $langsOfCourse χωρισμένα με κόμματα (π.χ.<i>Νίκος Τζικόπουλος, Κώστας Αδαμόπουλος</i>)";
$langPublic = "Ελεύθερη Πρόσβαση (χωρίς εγγραφή) από τη αρχική σελίδα χωρίς σύνδεση";
$langPublicShort = "Ελεύθερη (χωρίς εγγραφή)";
$langClosedCourseShort = "Πρόσβαση στο $langsCourse έχουν μόνο όσοι βρίσκονται στη Λίστα Χρηστών του $langsOfCourse";
$langCourseInactive= "Πρόσβαση στο $langsCourse έχουν μόνο οι $langsTeachers του $langsOfCourse";
$langCourseInactiveShort = "Ανενεργά $langsCourses";
$langCourseActiveShort = "Ενεργά $langsCourses";
$langPrivateShort = "Περιορισμένη (με Λίστα Χρηστών)";
$langAlertTitle = "Παρακαλώ συμπληρώστε τον τίτλο του $langsOfCourse!";
$langAlertProf = "Παρακαλώ συμπληρώστε τον διδάσκοντα του $langsOfCourse!";
$langFacultyUsersRegistrationLegend = "Η εγγραφή επιτρέπεται μόνο στους $langsOfStudentss της σχολής του $langsOfCourse.";

// Admin mutiple course creation
$langMultiCourse = "Μαζική δημιουργία $langsOfCourses";
$langMultiCourseInfo = "Εισαγάγετε στην παρακάτω περιοχή μια λίστα με τους
τίτλους των $langsOfCourses που επιθυμείτε να δημιουργηθούν, με τον κάθε
τίτλο σε ξεχωριστή γραμμή. Αν επιθυμείτε να προστεθεί αυτόματα
καθηγητής στο $langsCourse, σημπληρώστε το ονοματεπώνυμο ή το όνομα χρήστη
του μετά τον τίτλο, διαχωρισμένο με το χαρακτήρα \"|\".";
$langMultiCourseTitles = "Τίτλοι / Καθηγητές $langOfCourses";
$langMultiCourseData = "Στοιχεία $langOfCourses";
$langMultiCourseCreated = "το $langsCourse δημιουργήθηκε";

/* * ****************************************************
 * document.php
 * **************************************************** */
$langUpload = "Ανέβασμα";
$langDownload = "Λήψη";
$langDownloadFile = "Ανέβασμα αρχείου";
$langCloudFile = "Δικτυακό αρχείο";
$langPathUploadFile = "Αρχείο";
$langCreateDir = "Δημιουργία καταλόγου";
$langCreateDoc='Δημιουργία εγγράφου';
$langEditDoc='Επεξεργασία εγγράφου';
$langEditChange='Επεξεργασία';
$langName = "Όνομα";
$langNameDir = "Όνομα νέου καταλόγου";
$langSize = "Μέγεθος";
$langDate = "Ημερομηνία";
$langMoveFrom = "Μετακίνηση του αρχείου";
$langRename = "Μετονομασία";
$langReplace = "Αντικατάσταση";
$langReplaceFile = "Αντικατάσταση %s με το";
$langReplaceOK = "Το αρχείο αντικαταστάθηκε";
$langResourceAccess = "Δικαίωμα πρόσβασης";
$langResourceAccessLock = "Κλείδωμα";
$langResourceAccessUnlock = "Ξεκλείδωμα";
$langCopy = "Αντιγραφή";
$langNoSpace = "To ανέβασμα του αρχείου απέτυχε. Έχετε υπερβεί το όριο χώρου αποθήκευσης.
        Για περισσότερες πληροφορίες, επικοινωνήστε με το διαχειριστή του συστήματος.";
$langUnwantedFiletype = 'Μη αποδεκτός τύπος αρχείου';
$langDownloadEnd = "Το ανέβασμα ολοκληρώθηκε";
$langFileExists = "Δεν είναι δυνατή η λειτουργία.<br>Υπάρχει ήδη ένα αρχείο με το ίδιο όνομα.";
$langDocCopied = "Tο έγγραφο αντιγράφηκε";
$langDocDeleted = "Το έγγραφο διαγράφηκε";
$langElRen = "Η μετονομασία έγινε";
$langDirCr = "Ο κατάλογος δημιουργήθηκε";
$langDirMv = "Η μετακίνηση ολοκληρώθηκε";
$langComMod = "Τα σχόλια τροποποιήθηκαν";
$langIn = "σε";
$langNewDir = "Όνομα του νέου καταλόγου";
$langImpossible = "Δεν είναι δυνατή η λειτουργία";
$langViMod = "Η ορατότητα άλλαξε";
$langMoveOK = "Η μεταφορά έγινε με επιτυχία!";
$langMoveNotOK = "Η μεταφορά δεν πραγματοποιήθηκε!";
$langRoot = "Αρχικός κατάλογος";
$langNoDocuments = "Δεν υπάρχουν έγγραφα";
$langNoRead = "Δεν έχετε δικαίωμα ανάγνωσης σε αυτή την περιοχή";
$langDownloadDir = "Λήψη όλου του καταλόγου";
$langNew = 'Νέο';
$langNewAddedSingular = 'Προστέθηκε %d';
$langNewAddedPlural = 'Προστέθηκαν %d';
$langCloudFileError = 'Αδυναμία λήψης απομακρυσμένου πόρου - μη συμβατός τύπος αρχείου.';

// Special for group documents
$langGroupSpace = "Περιοχή ομάδας χρηστών";
$langGroupSpaceLink = "Ομάδα χρηστών";
$langGroupForumLink = "Περιοχή συζητήσεων ομάδας χρηστών";
$langGroupPublicUserList = "Εμφάνιση των χρηστών στα μέλη της ομάδας";
$langZipNoPhp = "Το αρχείο zip δεν πρέπει να περιέχει αρχεία .php";
$langUncompress = "Αποσυμπίεση του αρχείου (.zip) στον εξυπηρετητή";
$langReplaceSameName = "Αντικατάσταση αρχείων με το ίδιο όνομα";
$langDownloadAndZipEnd = "Το αρχείο .zip ανέβηκε και αποσυμπιέστηκε";
$langParentDir = "αρχικό κατάλογο";
$langInvalidDir = "Άκυρο ή μη υπαρκτό όνομα καταλόγου";
$langInvalidGroupDir = "Σφάλμα! Ο κατάλογος των ομάδων χρηστών δεν υπάρχει!";
$langCreateOneGroup = "Δημιουργία μιας ομάδας";
$langCreationGroups = "Δημιουργία πολλών ομάδων";
$langGroupAssignments =  "Ομαδικές Εργασίες";

//prosthikes gia v2 - metadata
$langCategory = "Κατηγορία";
$langCreatorEmail = "Ηλ. Διεύθυνση Συγγραφέα";
$langFormat = "Τύπος-Κατηγορία";
$langSubject = "Θέμα";
$langAuthor = "Συγγραφέας";
$langUserForum = "Μέλος";
$langCopyrightedFree = "Ελεύθερο δικαιωμάτων";
$langChangeMetadata = "Αλλαγή πληροφοριών εγγράφου";
$langEditMeta = "Επεξεργασία Πληροφοριών";
$langCategoryExample = "Παράδειγμα";
$langCategoryTheory = "Θεωρία";
$langCategoryLecture = "Διάλεξη";
$langCategoryNotes = "Σημειώσεις";
$langCategoryOther = "Άλλο";
$langNotRequired = "Η συμπλήρωση των πεδίων είναι προαιρετική.";
$langQuotaBar = "Επισκόπηση αποθηκευτικού χώρου";
$langQuotaUsed = "Χρησιμοποιούμενος Χώρος";
$langQuotaTotal = "Συνολικός Διαθέσιμος Χώρος";
$langQuotaPercentage = "Ποσοστό χρήσης";
$langEnglish = "Αγγλικά";
$langFrench = "Γαλλικά";
$langGerman = "Γερμανικά";
$langGreek = "Ελληνικά";
$langItalian = "Ιταλικά";
$langSpanish = "Ισπανικά";
$langDirectory = "Κατάλογος";

$langAddMetadata = "Προσθήκη / αλλαγή μεταδεδομένων";
$langMetadata = "Μεταδεδομένα";
$langMetadataMod = "Τα μεταδεδομένα τροποποιήθηκαν";
$langLearningResourceType = "Είδος Μαθησιακού Αντικειμένου";
$langSubjectArea = "Γνωστικό Αντικείμενο";
$langSubTopic = "Γνωστικό Υποαντικείμενο";
$langLevel = "Επίπεδο";
$langTypicalAgeRange = "Ηλικία μαθητών στην οποία απευθύνεται";
$langIntentedEndUserRole = "Σε ποιον απευθύνεται";
$langTitleHelp = "Δώστε τον τίτλο του μαθησιακού αντικειμένου (έως 1000 χαρακτήρες)";
$langDescriptionHelp = "Δώστε μία σύντομη περιγραφή του μαθησιακού αντικειμένου (έως 2000 χαρακτήρες)";
$langAuthorHelp = "Συμπληρώστε τα ονόματα των συγγραφέων του μαθησιακού αντικειμένου (έως 10 ονόματα, ο διαχωρισμός γίνεται με το κόμμα)";
$langLanguageHelp = "Επιλέξτε τη γλώσσα που χρησιμοποιείται στο μαθησιακό αντικείμενο";
$langLearningResourceTypeHelp = "Συμπληρώστε το είδος του μαθησιακού αντικειμένου.";
$langKeywordsHelp = "Δώστε έως 10 λέξεις κλειδιά ή φράσεις που περιγράφουν το μαθησιακό αντικείμενο (ο διαχωρισμός γίνεται με το κόμμα)";
$langTopicHelp = "Σημειώστε το γνωστικό αντικείμενο στο οποίο προτείνετε να αξιοποιηθεί το μαθησιακό αντικείμενο, π.χ. Φυσική";
$langSubTopicHelp = "Εφόσον κρίνετε σκόπιμο σημειώστε επιπλέον εξειδίκευση του γνωστικού αντικειμένου: πχ Ηλεκτρομαγνητισμός";
$langLevelHelp = "Σημειώστε το περιβάλλον όπου προτείνετε να αξιοποιηθεί το μαθησιακό αντικείμενο.";
$langTypicalAgeRangeHelp = "Σημειώστε την ηλικία του τυπικού στοχευμένου χρήστη σε ηλικιακές ομάδες (έως 5 τιμές, ο διαχωρισμός γίνεται με το κόμμα) πχ. 5-7, 0-5, 18-25";
$langCommentHelp = "Σημειώστε σχόλια ή οδηγίες για την εκπαιδευτική χρήση αυτού του μαθησιακού αντικειμένου";
$langCopyrightHelp = "Δώστε στοιχεία για τα πνευματικά δικαιώματα και τις συνθήκες χρήσης του μαθησιακού αντικειμένου (έως 1000 χαρακτήρες)";
$langIntentedEndUserRoleHelp = "Σημειώστε ποιος είναι ο κύριος χρήστης ή η ομάδα χρηστών για τους οποίους σχεδιάστηκε αυτό το μαθησιακό αντικείμενο.";

$langMetaOther = "Άλλο";
// "narrative text", "photo", "image", "figure", "diagram", "graph", "table", "sound", "music",
//	     "narration", "video", "animation", "3danimation", "slide", "presentation", "lecture", "textbook", "learningscenario",
//	     "simulation", "experiment", "microexperiment", "map", "interactivemap", "exploration", "interactivegame",
//	     "conceptualmap", "index", "problem statement", "self assessment", "questionnaire", "quiz", "exam", "exercise"
$langMetaNarrativetext = "Κείμενο";
$langMetaPhoto = "Φωτογραφία";
$langMetaImage = "Εικόνα";
$langMetaFigure = "Σχήμα";
$langMetaDiagram = "Διάγραμμα";
$langMetaGraph = "Γράφημα";
$langMetaTable = "Πίνακας";
$langMetaSound = "Ήχος";
$langMetaMusic = "Μουσική";
$langMetaNarration = "Αφήγηση";
$langMetaVideo = "Βίντεο";
$langMetaAnimation = "Κινούμενα γραφικά";
$langMeta3danimation = "Τρισδιάστατα κινούμενα γραφικά";
$langMetaSlide = "Διαφάνεια";
$langMetaPresentation = "Παρουσίαση";
$langMetaLecture = "Διάλεξη";
$langMetaTextbook = "Βιβλίο / Ενότητα Βιβλίου";
$langMetaLearningscenario = "Εκπαιδευτικό Σενάριο";
$langMetaSimulation = "Προσομοίωση";
$langMetaExperiment = "Πείραμα";
$langMetaMicroexperiment = "Μικροπείραμα";
$langMetaMap = "Χάρτης";
$langMetaInteractivemap = "Διαδραστικός Χάρτης";
$langMetaExploration = "Διερεύνηση";
$langMetaInteractivegame = "Διαδραστικό παιχνίδι";
$langMetaConceptualmap = "Νοητικός Χάρτης";
$langMetaIndex = "Ευρετήριο";
$langMetaProblemstatement = "Διατύπωση Προβλήματος";
$langMetaSelfassessment = "Αυτοαξιολόγηση";
$langMetaQuestionnaire = "Ερωτηματολόγιο";
$langMetaQuiz = "Quiz/test";
$langMetaExam = "Διαγώνισμα";

$langMetaManager = "Διαχειριστής";

$langMetaNursery = "Νηπιαγωγείο";
$langMetaPrimary = "Δημοτικό";
$langMetaSecondary = "Γυμνάσιο";
$langMetaHighschool = "Λύκειο";
$langMetaTechnical = "Τεχνική - Επαγγελματική Εκπαίδευση";
$langMetaTraining = "Ειδική Αγωγή";
$langMetaHighereducation = "Ανώτερη/Ανώτατη Εκπαίδευση";

/* * ***********************************************
 * dropbox.php
 * *********************************************** */
$langNewPersoMessage = "Νέο προσωπικό μήνυμα";
$langNewCourseMessage = "Νέο μήνυμα $langsOfCourse";
$langBadFormData = "Η αποστολή του αρχείου απέτυχε";
$langSendTo = "Προς";
$langReceivedFiles = "Εισερχόμενα";
$langSentFiles = "Απεσταλμένα";
$langSentTo = "Στάλθηκε στον/στην";
$langlastUpdated = "Τελευταία ενημέρωση στις";
$langlastResent = "Τελευταία επαναποστολή στις";
$langTableEmpty = "Ο κατάλογος είναι κενός.";
$langNoFileSpecified = "Δεν επιλέξατε αρχείο";
$langdocAdd = "Το μήνυμα στάλθηκε με επιτυχία";
$langMailToUsers = "Ειδοποίηση χρηστών μέσω ηλεκτρονικού ταχυδρομείου";
$langDropboxMailNotify = "σας έχει αποσταλεί ένα νέο μήνυμα. Θα το βρείτε στο υποσύστημα 'Ανταλλαγή Μηνυμάτων' αφού προηγουμένως κάνετε login στην πλατφόρμα ή κάνοντας κλικ στο παρακάτω σύνδεσμο:";
$langNewDropboxFile = "Ενημέρωση για νέο μήνυμα";
$langDropBoxIncompatible = "Προσοχή! Το υποσύστημα 'Ανταλλαγής Αρχείων' πιθανόν
    να μην έχει ανακτηθεί σωστά λόγω ασυμβατότητας. Ελέγξτε τα id του πίνακα
    dropbox_file στη βάση του $langsOfCourse.";
$langPurgeFile = "Προσοχή! Το μήνυμα θα διαγραφεί από όλους τους χρήστες";
$langOtherDropBoxFiles = "Λοιπές αποστολές";
$langRecipient = "Παραλήπτης";
$langRecipients = "Παραλήπτες";
$langAttachedFile = "Συνημμένο αρχείο";
$langDoNotReply = "Αν απαντήσετε απευθείας στο παραπάνω μήνυμα, η απάντηση θα φθάσει σε λάθος παραλήπτη. Για να απαντήσετε κάντε κλικ";
$langParticipants = "Συμμετέχοντες";
$langLoading = "Φόρτωση...";
$langMessageDeleteSuccess = "Η διαγραφή του μηνύματος πραγματοποιήθηκε με επιτυχία!";
$langDeleteAllMsgs = "Διαγραφή όλων των μηνυμάτων";
$langConfirmDeleteAllMsgs = "Προσοχή! Όλα τα μηνύματα θα διαγραφούν!";
$langMessageDeleteAllSuccess = "Η διαγραφή των μηνυμάτων πραγματοποιήθηκε με επιτυχία!";
$langMsgRe = "Απ:";
$langMsgFw = "Πρ:";
$langNoRecipients = "Δεν έχετε ορίσει παραλήπτες";
$langSearchSurname = "Η αναζήτηση παραληπτών γίνεται με βάση το επώνυμο ή το όνομα χρήστη (username)";
$langDropboxFreeSpace = "Διαγραφή παλιών συνημμένων αρχείων για την απελευθέρωση χώρου %s";
$langDropboxFreeSpaceConfirm = "Αυτή η ενέργεια θα διαγράψει τα συνημμένα αρχεία στα παλαιότερα μηνύματα του $langsOfCourse ώστε να απελευθερωθεί χώρος %s! Οι χρήστες δε θα μπορούν πλέον να τα κατεβάσουν!";
$langDropboxFreeSpaceSuccess = "Απελευθερώθηκαν με επιτυχία %s χώρου!";
$langDropboxNoMessage = "Δεν υπάρχουν πρόσφατα μηνύματα";
$langDropboxMassDelete = 'Διαγραφή όλων των μηνυμάτων';
$langAllMessages = "Όλα";
$langMesageNoSent = "To μήνυμα δεν στάλθηκε επειδή το συνημμένο υπερβαίνει το όριο του αποθηκευτικού χώρου.
        Για περισσότερες πληροφορίες, επικοινωνήστε με το διαχειριστή του συστήματος.";
/* * ********************************************************
 * exercise
 * ******************************************************** */
$langExercicesView = "Προβολή Άσκησης";
$langExercicesResult = "Αποτελέσματα Άσκησης";
$langQuestion = "Ερώτηση";
$langQuestions = "Ερωτήσεις";
$langsQuestions = "ερωτήσεις";
$langAnswer = "Απάντηση";
$langAnswers = "Απαντήσεις";
$langComment = "Σχόλιο";
$langMaj = "Ενημέρωση";
$langEvalSet = "Ρυθμίσεις βαθμολογίας";
$langExercice = "Άσκηση";
$langActive = "ενεργό";
$langInactive = "μη ενεργό";
$langNewEx = "Νέα Άσκηση";
$langExerciseType = "Τύπος Άσκησης";
$langExerciseName = "Όνομα Άσκησης";
$langExerciseScaleGrade = "Κλίμακα βαθμολογίας";
$langExerciseNoScaleGrade = "χωρίς κλίμακα";
$langExerciseDescription = "Περιγραφή Άσκησης";
$langSimpleExercise = "Σε μία μόνο σελίδα";
$langAboutExercise = "Σχετικά με την άσκηση";
$langEditQuestions = "Σχετικά με τις ερωτήσεις";
$langSequentialExercise = "Μία ερώτηση ανά σελίδα με δυνατότητα πλοήγησης";
$langOneWayExercise = "Μία ερώτηση ανά σελίδα χωρίς επιστροφή σε προηγούμενες ερωτήσεις";
$langRandomQuestions = "Τυχαίες Ερωτήσεις";
$langGiveExerciseName = "Δώστε το όνομα της άσκησης";
$langGiveExerciseInts = "Τα πεδία Χρονικός Περιορισμός & Επιτρεπόμενες Επαναλήψεις πρέπει να είναι ακέραιοι αριθμοί";
$langQuestCreate = "Δημιουργία ερωτήσεων";
$langExRecord = "Η άσκησή σας αποθηκεύτηκε";
$langBackModif = "Επιστροφή στη διόρθωση της άσκησης";
$langDoEx = "Κάντε την άσκηση";
$langDefScor = "Καθορίστε τις ρυθμίσεις βαθμών";
$langCreateModif = "Δημιουργία / Αλλαγή των ερωτήσεων";
$langSub = "Υπότιτλος";
$langNewQu = "Νέα ερώτηση";
$langNewLa = "Νέα ετικέτα/σχόλιο";
$langTrue = "Σωστό";
$langMoreAnswers = "+απάντ.";
$langLessAnswers = "-απάντ.";
$langMoreElements = "Προσθήκη";
$langLessElements = "Αφαίρεση";
$langRecEx = "Αποθήκευση άσκησης";
$langRecQu = "Αποθήκευση ερώτησης";
$langRecAns = "Αποθήκευση απαντήσεων";
$langTitleAssistant = "Βοηθός δημιουργίας ασκήσεων";
$langQuesList = "Κατάλογος ερωτήσεων";
$langSaveEx = "Αποθήκευση απάντησης";
$langClose = "Κλείσιμο";
$langCancel = "Ακύρωση";
$langQImage = "Ερώτηση-Εικόνα";
$langAddQ = "Προσθήκη ερώτησης";
$langInfoQuestion = "Στοιχεία ερώτησης";
$langInfoLabel = "Στοιχεία ετικέτας/σχολίου";
$langInfoExercise = "Ρυθμίσεις άσκησης";
$langAmong = "μεταξύ";
$langTake = "διάλεξε";
$langAnswersNotDisp = "Απόκρυψη απαντήσεων μετά το τέλος της άσκησης";
$langAnswersDisp = "Εμφάνιση απαντήσεων μετά το τέλος της άσκησης";
$langAnswersDispLastAttempt = "Εμφάνιση απαντήσεων μετά το τέλος της τελευταίας προσπάθειας του $langsOfStudent";
$langAnswersDispEndDate = "Εμφάνιση απαντήσεων μετά την Ημερομηνία Λήξης της άσκησης";
$langShuffleAnswers = "Εμφάνιση των απαντήσεων των ερωτήσεων με τυχαία σειρά.";
$langShuffleAnswersLegend = "αφορά μόνο τις ερωτήσεις πολλαπλής επιλογής";
$langScoreNotDisp = "Απόκρυψη βαθμολογίας μετά το τέλος της άσκησης";
$langScoreDisp = "Εμφάνιση βαθμολογίας μετά το τέλος της άσκησης";
$langScoreDispLastAttempt = "Εμφάνιση βαθμολογίας μετά το τέλος της τελευταίας προσπάθειας του $langsOfStudent";
$langScoreDispEndDate = "Εμφάνιση βαθμολογίας μετά την Ημερομηνία Λήξης της άσκησης";
$langInfoGrades = "βαθμοί";
$langInfoGrade = "βαθμός";
$langChooseRandomQuestions = "Επιλογή τυχαίων ερωτήσεων από τις ερωτήσεις της άσκησης";
$langFromRandomQuestions = "τυχαίες ερωτήσεις από το σύνολο των ερωτήσεων της άσκησης";
$langFromRandomDifficultyQuestions = "ερωτήσεις με βαθμό δυσκολίας";
$langFromRandomCategoryQuestions = "ερωτήσεις από την κατηγορία";
$langRandomQuestionsWithCriteria = "Δυναμική επιλογή ερωτήσεων";
$langSelectRandomCriteria = "Επιλέξτε κριτήρια τυχαιοποίησης";
$langAvailable = "διαθέσιμες";
$langPurgeExercises = "Εκκαθάριση αποτελεσμάτων";
$langConfirmPurgeExercises = "Επιβεβαίωση διαγραφής αποτελεσμάτων";
$langConfirmModifyAttemptTitle = "Επιβεβαίωση αλλαγής κατάστασης";
$langConfirmModifyAttemptText = "Η παρακάτω ενέργεια θα αλλάξει την κατάσταση της προσπάθειας. Επιβεβαιώστε ότι η άσκηση δεν είναι σε εξέλιξη";
$langAnswerUngraded = "Η απάντηση δεν έχει ακόμα βαθμολογηθεί";
$langAttempts = "Προσπάθειες";
$langAttempt = "Προσπάθεια";
$langAttemptStarted = "Πρώτη φορά";
$langAttemptAccessed = "Τελευταία ενημέρωση";
$langAttemptsNb = "Αριθμός προσπαθειών";
$langOfAttempt = "προσπάθειας";
$langAttemptActive = "Μη ολοκληρωμένη";
$langAttemptActiveButDeadMsg = "Ο χρόνος ολοκλήρωσης της συγκεκριμένης προσπάθειας έχει παρέλθει. Μπορεί να διαγραφεί με ασφάλεια.";
$langAttemptActiveMsg = "Η προσπάθεια δεν έχει ακόμα ολοκληρωθεί.";
$langAttemptCompleted = "Oλοκληρωμένη";
$langAttemptsCompleted = "Oλοκληρωμένες";
$langAttemptPending = "Προς Βαθμολόγηση";
$langAttemptPaused = "Προσωρινά Αποθηκευμένη";
$langAttemptPausedS = "προσωρινά αποθηκευμένη";
$langAttemptsPaused = "προσωρινά αποθηκευμένες";
$langAttemptCanceled = "Ακυρωμένη";
$langAttemptsCanceled = "Ακυρωμένες";
$langLowestGrade = "Μικρότερος Βαθμός";
$langHighestGrade = "Μεγαλύτερος Βαθμός";
$langAverage = "Μέση";
$langStudentsExerciseCompleted = "$langStudents που ολοκλήρωσαν την άσκηση";
$langGradeTooBig = "Ο βαθμός που βάλατε ξεπερνάει τον μέγιστο επιτρεπτό βαθμό της ερώτησης";
$langQuestionCats = "Κατηγορίες ερωτήσεων";
$langQuestionCat = "Κατηγορία ερώτησης";
$langQuestionAllCats = "Όλες οι Κατηγορίες";
$langQuestionWithoutCat = "Χωρίς Κατηγορία";
$langNoQuestionCats = "Δεν έχουν ορισθεί κατηγορίες ερωτήσεων";
$langQuestionCatDelConfirrm = "Είστε βέβαιος ότι θέλετε να διαγράψετε την συγκεκριμένη κατηγορία ερωτήσεων?";
$langNewCat = "Νέα Κατηγορία";
$langEditCat = "Επεξεργασία Κατηγορίας";
$langNewCatSuccess = "Η κατηγορία δημιουργήθηκε με επιτυχία";
$langEditCatSuccess = "Η κατηγορία τροποποιήθηκε με επιτυχία";
$langDelCatSuccess = "Η κατηγορία διαγράφηκε με επιτυχία";
$langImportQTI = "Εισαγωγή από IMS QTI";
$langExportQTI = "Εξαγωγή σε IMS QTI";
$langImportQTIAnswer = "Η εισαγωγή της ερώτησης έγινε με επιτυχία";
$langIMSQTIUploadFile = "Αρχείο IMS QTI";
$langImportAiken = "Εισαγωγή από Aiken";
$langAikenFormatExample = "Υπόδειγμα Ερώτησης
1. Ποια είναι η πρωτεύουσα της Ελλάδας; (μονάδες: 5)
α) Πάτρα
*β) Αθήνα
γ) Θεσσαλονίκη
";
$langAikenFormatNote = "Συμπληρώστε τις ερωτήσεις σε μορφή Aiken. Σημειώστε ότι υποστηρίζονται <strong>μόνο</strong> οι ερωτήσεις πολλαπλής επιλογής με <strong>μοναδική απάντηση</strong>.";
$langAikenFormatExplain = "
<ul>
<li>Η ερώτηση πρέπει να έχει έναν αριθμό ακολουθούμενο από μιά τελεία ή παρένθεση.</li>
<li>Αν θέλετε να καθορίσετε τη βαθμολογία της γράψτε τη έκφραση <em>(μονάδες: χχ)</em>. Μπορείτε να χρησιμοποιήσετε αντί για τη λέξη <em>μονάδες</em> μία από τις λέξεις:
<em>score</em>, <em>βαθμός</em>, <em>points</em>, <em>weight</em>. Διαφορετικά, σαν βαθμός θα θεωρηθούν οι 'Μονάδες' που δηλώνονται στο πεδίο της φόρμας πάνω από το κουμπί 'Έλεγχος'.</li>
<li>Η απάντηση πρέπει να ξεκινάει με γράμμα ελληνικό ή λατινικό και μετά παρένθεση ή τελεία. Η σωστή απάντηση πρέπει να έχει μπροστά ένα αστεράκι.</li>
<li>Οι κενές γραμμές αγνοούνται</li>
<li>Όταν αντιγράψουμε την άσκηση στο αριστερό πλαίσιο, πατάμε το κουμπί έλεγχος. Στο δεξιό πλαίσιο εμφανίζονται τυχόν μηνύματα λάθους στη μορφή των ερωτήσεων.</li>
<li>Όταν όλα είναι σωστά, πατάμε το κουμπί 'Εισαγωγή'.</li>
</ul>
";
$langQtiImportNote = "Μπορείτε να ανεβάσετε το αρχείο των ερωτήσεων σε μορφή <strong>QTI</strong>.
<br><br>Σημειώστε ότι υποστηρίζονται <strong>μόνο</strong>
<ul>
<li>οι ερωτήσεις πολλαπλής επιλογής με <strong>μοναδική απάντηση</strong>.</li>
<li>οι ερωτήσεις πολλαπλής επιλογής με <strong>πολλαπλές απαντήσεις</strong>.</li>
<li>οι ερωτήσεις <strong>σωστού - λάθους</strong>.</li>
</ul>
";
$langImportWithSuccess = "Η εισαγωγή ολοκληρώθηκε με επιτυχία";
$langAikenWithNoGrades = "εφαρμόζεται στις ερωτήσεις που δεν έχουν μονάδες";
$langExportWithAnswers = 'με απαντήσεις';
$langCheckGrades = 'Έλεγχος βαθμολογιών';
$langCheckResults = "Αποτελέσματα ελέγχου";
$langCheckGradesConsistent = 'Έλεγχος βαθμολογιών για ασυνέπειες';
$langCheckFinished = 'Ο έλεγχος ολοκληρώθηκε.';
$langRegradeAttemptsList = 'Εντοπίστηκαν ασυνέπειες στις βαθμολογίες και μπορεί να γίνει αναβαθμολόγηση στις παρακάτω προσπάθειες:';
$langRegradeNotNeeded = 'Δεν απαιτείται αναβαθμολόγηση.';
$langRegradeAll = 'Αναβαθμολόγηση όλων';
$langHasAnswered = "έχει απαντηθεί";
$langPendingAnswered = "εκκρεμεί απάντηση";
$langExercisesSubmission = "υποβολή";
$langExercisesSubmissions = "υποβολές";
$langQuestionPoolPurge = "Διαγραφή αχρησιμοποίητων ερωτήσεων";
$langConfirmQuestionPoolPurge = "Οι ερωτήσεις που δεν χρησιμοποιούνται σε καμία άσκηση θα διαγραφούν.";
$langQuestionPoolPurgeSuccess = "Η διαγραφή των αχρησιμοποίητων ερωτήσεων από την τράπεζα ερωτήσεων πραγματοποιήθηκε.";
$langShuffleQuestions = "Ανακάτεμα όλων των ερωτήσεων";
$langClear = 'Εκκαθάριση';
$langClearChoice = 'Εκκαθάριση επιλογής';
$langExerciseFeedback = "Κείμενο Ολοκλήρωσης";
$langExerciseFeedbackInfo = "εμφανίζεται μετά την ολοκλήρωση της άσκησης";
$langExercisePreventCopy = 'Αποτροπή αντιγραφής κειμένου';
$langExercisePreventCopyExplanation = 'Αποτροπή αντιγραφής και επικόλλησης κειμένου από την οθόνη κατά την εκτέλεση της άσκησης';
$langStricterExamRestriction = "Αυστηρός περιορισμός";
$langExerciseWillBeCanceledInStrictMode = "Η εξέταση ακυρώνεται σε παράλληλες ενέργειες χρηστών όπως ανακατεύθυνση σε νέα σελίδα ή άνοιγμα νέου παραθύρου";

// admin.php
$langExerciseManagement = "Διαχείριση Άσκησης";
$langExerciseModify = "Τροποποίηση Άσκησης";
$langQuestionManagement = "Διαχείριση ερώτησης";
$langQuestionsManagement = "Διαχείριση ερωτήσεων";
$langQuestionNotFound = "Δεν βρέθηκε η ερώτηση";
$langAlertAdmin = "Παρακαλώ δηλώστε τουλάχιστον έναν διαχειριστή για το $langsCourse!";
$langBackExerciseManagement = "Επιστροφή στη διαχείριση άσκησης";
$langExerciseExecute = "Εκτέλεση";
$langExercisePeriod = 'Περίοδος εκτέλεσης';

// question_admin.php
$langNoAnswer = "Δεν υπάρχει απάντηση αυτή την στιγμή!";
$langGoBackToQuestionPool = "Επιστροφή στις διαθέσιμες ερωτήσεις";
$langGoBackToQuestionList = "Επιστροφή στη λίστα ερωτήσεων";
$langQuestionAnswers = "Απαντήσεις στην ερώτηση";
$langNegativeScoreLegend = "Μπορείτε, αν θέλετε, να ορίσετε αρνητική βαθμολογία στις λάθος απαντήσεις.
Σημειώστε, ότι αν ο $langsStudent βαθμολογηθεί με αρνητική βαθμολογία σε μία ερώτηση, τότε αυτή θα μετατραπεί σε μηδέν.";
$langUsedInSeveralExercises = "Η ερώτηση (και οι απαντήσεις της) χρησιμοποιείται σε αρκετές ασκήσεις.<br><br>
<ul>
<li>Αν επιλέξετε <i>σε όλες τις ασκήσεις</i> η αλλαγή θα γίνει σε όλες.</li>
<li>Αν επιλέξετε <i>μόνο στην τράπεζα ερωτήσεων</i> θα δημιουργηθεί ένα αντίγραφο της αρχικής ερώτησης.</li>
</ul>";
$langUsedInSeveralExercises2 = "Η ερώτηση (και οι απαντήσεις της) χρησιμοποιείται σε αρκετές ασκήσεις.<br><br>
<ul>
<li>Αν επιλέξετε <i>σε όλες τις ασκήσεις</i> η αλλαγή θα γίνει σε όλες.</li>
<li>Αν επιλέξετε <i>μόνο στην τρέχουσα άσκηση</i> η αλλαγή θα γίνει μόνο στην τρέχουσα.</li>
</ul>";
$langModifyInAllExercises = "σε όλες τις ασκήσεις";
$langModifyInThisExercise = "μόνο στην τρέχουσα άσκηση";
$langModifyInQuestionPool = "μόνο στην τράπεζα ερωτήσεων";
$langQuestionView = "Προβολή";
$langWarnAboutAnsweredQuestion = "Προσοχή! Η ερώτηση έχει ήδη απαντηθεί! Η διαγραφή της θα αλλάξει τα αποτελέσματα της άσκησης.";
$langQuestionPreview = 'Προεπισκόπιση ερώτησης';
$langDumpPDF = 'Εξαγωγή σε PDF';
$langDumpExcel = "Εξαγωγή σε Excel";
$langQuestionUsedInExercises = 'Ασκήσεις όπου χρησιμοποιείται';

// statement_admin.php
$langAnswerType = "Τύπος Απάντησης";
$langUniqueSelect = "Πολλαπλής Επιλογής (Μοναδική Απάντηση)";
$langMultipleSelect = "Πολλαπλής Επιλογής (Πολλαπλές Απαντήσεις)";
$langFillBlanks = "Συμπλήρωση Κενών";
$langFillBlanksStrict = "Αυστηρή Ταυτοποίηση";
$langFillBlanksTolerant = "Χαλαρή Ταυτοποίηση";
$langFillBlanksStrictExample = "(Αθήνα ≠ αθηνα ≠ ΑΘΗΝΑ)";
$langFillBlanksTolerantExample = "(Αθήνα = αθηνα = ΑΘΗΝΑ)";
$langFillFromSelectedWords = "Επιλογή από προκαθορισμένες απαντήσεις";
$langMatching = "Αντιστοίχιση";
$langTrueFalse = "Σωστό / Λάθος";
$langFreeText = "Ελεύθερου Κειμένου";
$langOral = "Προφορικά";
$langSaveOralMsg = "Η απάντησή σας θα αποθηκευτεί προσωρινά. Η τελική αποθήκευση ολοκληρώνεται με την υποβολή της άσκησης. Θέλετε να προχωρήσετε?";
$langDeleteRecordingOk = "Το αρχείο διαγράφηκε επιτυχώς!";
$langListenToRecordingAudio = "Ακούστε την ηχογραφημένη απάντησή σας εδώ: ";
$langFileUploadingOkReplaceWithNew = "Το αρχείο αποθηκεύτηκε με επιτυχία. Σε περίπτωση νέας προσπάθειας στην άσκηση, αν απαντήσετε την ίδια ερώτηση τότε το παλιό αρχείο θα αντικατασταθεί με το καινούριο.";
$langScale = "Κλίμακας";
$langFalse = "Λάθος";
$langAddPicture = "Προσθήκη εικόνας";
$langReplacePicture = "Αντικατάσταση της εικόνας";
$langDeletePicture = "Διαγραφή της εικόνας";
$langQuestionDescription = "Προαιρετικό σχόλιο";
$langQuestionFeedback = "Σχόλιο ανατροφοδότησης";
$langGiveQuestion = "Δώστε την ερώτηση";
$langInvalidPicture = "Μη υποστηριζόμενος τύπος εικόνας";
$langQuestionDiffGrade = "Βαθμός δυσκολίας";
$langNumQuestions = "Αρ. ερωτήσεων";
$langQuestionAllDiffs = "Όλοι οι βαθμοί δυσκολίας";
$langQuestionAllTypes = "'Όλοι οι τύποι ερωτήσεων";
$langQuestionNotDefined = "Μη προσδιορισμένη";
$langQuestionVeryEasy = "Πολύ εύκολη";
$langQuestionEasy = "Εύκολη";
$langQuestionModerate = "Μέτρια";
$langQuestionDifficult = "Δύσκολη";
$langQuestionVeryDifficult = "Πολύ δύσκολη";
$langCheckAccess = "Έλεγχος πρόσβασης";
$langDragAndDropText = "Μεταφορά και Απόθεση σε Κείμενο ";
$langInfoDragAndDropText = 'Πληκτρολογήστε την <strong class="text-dark">εκφώνηση</strong> της ερώτησης χρησιμοποιώντας αγκύλες με τον μοναδικό τους αριθμό. </br>
                            Κάθε αγκύλη του κειμένου αντιστοιχεί στην ανάλογη επιλογή του πίνακα.</br></br>
                            Καταχωρήστε τις προκαθορισμένες απαντήσεις του κειμένου συμπληρώνοντας τον βαθμό τους.
                            Μπορείτε προαιρετικά να προσθέσετε περισσότερες προκαθορισμένες απαντήσεις από τον συνολικό αριθμό των σωστών απαντήσεων του κειμένου.
                            Με αυτόν τον τρόπο αυξάνετε το βαθμό δυσκόλιας της ερώτησης καθώς μία ή περισσότερες προκαθορισμένες απαντήσεις θα περισσέψει κατα την εκτέλεση της άσκησης.</br></br>
                            <strong class="text-dark">Για παράδειγμα</strong>, στο κείμενο `Πρωτεύουσα της Ελλάδας είναι [1] ενώ πρωτεύουσα της Ιταλίας είναι [2]` συμπληρώνουμε τις εξής απαντήσεις:</br></br>
                            <ul>
                                <li><strong class="text-dark">Επιλογή[1]</strong> = Αθήνα και <strong class="text-dark">βαθμό</strong> = 1</li>
                                <li><strong class="text-dark">Επιλογή[2]</strong> = Ρώμη και <strong class="text-dark">βαθμό</strong> = 1</li>
                                <li><strong class="text-dark">Επιλογή[3]</strong> = Μιλάνο και <strong class="text-dark">βαθμό</strong> = 0. Η λέξη `Μιλάνο` θα περισσέψει ως μη σωστή απάντηση του κειμένου.</li>
                            </ul>';

$langPlaceholderDragAndDropText = "Πρωτεύουσα της Ελλάδας είναι [1] ενώ πρωτεύουσα της Γερμανίας είναι [2] ."; ;
$langAthens = "Αθήνα";
$langBerlin = "Βερολίνο";
$langErrorWithChoicesAsAnswers = "Υπάρχει λάθος στην αντιστοιχία των απαντήσεων";
$langPredefinedAnswerExists = "Δεν μπορείτε να καταχωρήσετε κενή απάντηση. Δοκιμάστε πάλι.";
$langCalcelDroppableItem = "Μπορείτε να αναιρέσετε την απάντησή σας κάνοντας αριστερό κλικ πάνω στην λέξη.";
$langAllowMoreDefinedAnswersThanBlanks = "Οι προκαθορισμένες απαντήσεις να είναι περισσότερες απο τον αριθμό των κενών";
$langErrorWithUniqueNumberOfBlank = "Καταχωρήσατε τον ίδιο μοναδικό αριθμό σε παραπάνω από ένα κενά.";
$langDragAndDropMarkersTextAnswers = "Μεταφορά και απόθεση σημείων εικόνας: ";
$lanFieldGradeNotHasNumericValue = "Το πεδίο `βαθμός` δεν περιέχει τιμή!";

$langDragAndDropMarkers = "Μεταφορά και απόθεση σε προκαθορισμένα σημεία ή εικόνα";
$langMarker = "Σημείο";
$langShape = "Σχήμα";
$langRectangle = "Ορθογώνιο";
$langCircle = "Κύκλος";
$langPolygon = "Πολύγωνο";
$langPoint = "Σημείο";
$langThisAnswerIsNotCorrect = "Δεν αντιστοιχεί σε σωστή απάντηση";
$langBracket = "Αγκύλη";

$langAddAnswerThroughImg = "Η προκαθορισμένη απάντηση θα εμφανίζεται μέσω της εικόνας";
$langMarkerDeletedError = "Σφάλμα κατά τη διαγραφή εικόνας.";
$langImageHasBeenDeleted = "Η εικόνα διαγράφηκε.";
$langImageUploaded = "Η εικόνα φορτώθηκε";
$langImageNotSelected = "Δεν έχετε επιλέξει εικόνα";
$langInvalidAnswerValue = "Υπάρχει κενή απάντηση στο πεδίο `Απάντηση`.";
$chooseShapeAndAnswerToContinue = "Σχηματίστε πάνω στην εικόνα της ερώτησης την απάντηση που ορίσατε στο πεδίο `απάντηση` μέσω του σχήματος που επιλέξατε.";
$chooseDrawAShapeForTheAnswerToContinue = "Σχηματίστε την απάντηση του σημείου μέσω του σχήματος που επιλέξατε.";
$langSomethingWentWrong = "Κάτι πήγε στραβά. Δοκιμάστε πάλι.";
$langConstantValue = "Σταθερή τιμή";
$langRandomValue = "Τυχαία τιμή";
$langBlankNotEmpty = "Υπάρχει ήδη μια λέξη στο κενό!";
$langBlankOtherQuestion = "Το κενό ανήκει σε άλλη ερώτηση!";
$langAddGradeToMarkerAnswer = "Συμπληρώστε το βαθμό της απάντησης στο πεδίο `Βαθμός`.";
$langNotChooseShape = "Δεν έχει επιλεγεί κανένα σχήμα από το πεδίο `Σχήμα`.";
$langNotDrawingTheAnswer = "Βεβαιωθείτε ότι έχετε συμπληρώσει την απάντηση στην εικόνα χρησιμοποιώντας το σχήμα ";
$langSaveAnswer = "Αποθήκευση απάντησης";
$langDeleteAnswer = "Διαγραφή απάντησης";
$langDeleleImage = "Διαγραφή εικόνας";
$langAnswerHasBeenAdded = "Η απάντηση προστέθηκε!";
$langSelectedPoint = "Επιλεγμένο σημείο";
$langStartDrawing = "Ξεκινήστε να σχηματίζετε την απάντηση πάνω στην εικόνα ...";
$langStartDrawingHelp = "Πατώντας ΑΠΟΘΗΚΕΥΣΗ ΑΠΑΝΤΗΣΗΣ αποθηκεύεται εκ νεόυ η καινούρια απάντηση. Tο σχήμα της προηγούμενης απάντησης στην εικόνα θα διαγραφεί (αν υπάρχει) και θα αντικατασταθεί με το καινούριο.";

$langInfoDragAndDropMarkersCreation = '
<ul class="text-dark">
<li class="text-dark">
    Επιλέξτε το σημείο για το οποίο θέλετε να προσθέσετε μία προκαθορισμένη απάντηση.
</li>
<li class="text-dark">
    Αν για παράδειγμα θέλετε να δημιουργήσετε την απάντηση στο σημείο [1], τότε στον πίνακα παρακάτω
    πηγαίνετε στο συγκεκριμένο σημείο και επιλέξτε το σχήμα του από το πεδίο <strong class="text-dark">Σχήμα</strong>. Αφού το επιλέξατε (π.χ ορθογώνιο), ξεκινήστε να σχηματίζετε
    πάνω στην εικόνα την προκαθορισμένη απάντηση.
</li>
<li class="text-dark">Δώστε το κείμενο της προκαθορισμένης απάντησης στο πεδίο <strong class="text-dark">Απάντηση</strong> (Υποχρεωτικό).</li>
<li class="text-dark">Αν επιθυμείτε η προκαθορισμένη απάντηση να εμφανίζεται μέσω εικόνας και όχι κειμένου τότε συμπληρώστε το πεδίο <strong class="text-dark">Απάντηση</strong> και ανεβάστε την εικόνα μέσω της επιλογής <strong class="text-dark">η προκαθορισμένη απάντηση θα εμφανίζεται μέσω της εικόνας</strong>.</li>
<li class="text-dark">Δώστε βαθμό στην απάντηση στο πεδίο <strong class="text-dark">Βαθμός</strong> (Υποχρεωτικό).</li>
<li class="text-dark">Επιλέγετε <strong class="text-dark">Αποθήκευση</strong> για να αποθηκεύσετε την απάντηση προσωρινά.</li>
<li class="text-dark">Επιλέγετε <strong class="text-dark">Διαγραφή</strong> για να αφαιρέσετε την απάντηση προσωρινά.</li>
<li class="text-dark">Η διαδικασία για την δημιουργία των προκαθορισμένων απαντήσεων ολοκληρώνεται πατώντας <strong class="text-dark">Υποβολή</strong>.</li>
</ul>';
$langRequiresImageUploadedForThisType = "Για την μεταφορά και απόθεση σε προκαθορισμένα σημεία απαιτείται η προσθήκη εικόνας.";
$langYourOwnAnswerIs = "Η απάντηση που δώσατε είναι";
$langCorrectAnswerIs = "Η σωστή απάντηση είναι";
$langCalculated = "Υπολογισμός αριθμητικών πράξεων";
$langEditItems = "Επεξεργασία στοιχείων";
$langItIsNotWildCard = "Δεν αποτελεί στοιχείο της άσκησης";
$langItIsWildCard = "Αποτελεί στοιχείο της άσκησης";
$langAddCorrectMandatoryWildCrds = "Ένα ή περισσότερα στοιχεία της ερώτησης δεν διαθέτουν τυχαία ή σταθερή τιμή. Δοκιμάστε πάλι.";
$langTypeOfAnswer = "Τύπος απάντησης";
$langRangeOfValues = "Έυρος τιμών";
$langItem = "Στοιχείο";
$langDecimalValues = "Δεκαδικά ψηφία";
$langZeroForNoDecimal = "Τιμή 0 για παράλειψη δεκαδικών";
$langAutoCompleteValues = "Προσθήκη τιμής";
$langItemToAdd = "Στοιχείο για προσθήκη:";
$langAutoCompleteWildCardInfo = 'Καταχωρήστε την τιμή του τρέχοντος στοιχείου.</br>
Η τιμή του μπορεί να είναι είτε <strong class="text-dark">σταθερή</strong> είτε <strong class="text-dark">τυχαία</strong>.</br>
Αν επιλέξετε μία τυχαία τιμή, τότε ορίστε το εύρος τιμών του στα πεδία <strong class="text-dark">(ελάχιστη, μέγιστη, δεκαδικά ψηφία)</strong>.Το στοιχείο θα εμφανίζεται με διαφορετική τιμή σε κάθε εκτέλεση της άσκησης ανάλογα με το εύρος τιμών που ορίσατε.';
$langMissingFieldsInRangeOfWildCard = "Αφήσατε κενά πεδία στο εύρος τιμών του στοιχείου.";
$langMissingFieldsInConstantValOfWildCard = "Αφήσατε κενό το πεδίο της σταθερής τιμής του στοιχείου.";
$langAddRandomOrConstantValOfWildCard = "Θα πρέπει να καταχωρήσετε μία τυχαία ή σταθερή τιμή στο στοιχείο.";
$langCompleteTheTextOfTheQuestion = "Εκφώνηση";
$langCompleteVariablesOfQuestionInfo = '
<ul class="text-dark">
<li class="text-dark">Συμπληρώστε την εκφώνηση στο πεδίο κειμένου <strong class="text-dark">Εκφώνηση</strong>.</li>
<li class="text-dark">Κάθε στοιχείο θα πρέπει να ορίζεται μέσα σε <strong class="text-dark">άγκιστρα {}</strong>.</li>
<li class="text-dark">Συμπληρώστε τον αριθμητικό τύπο που δίνει το απότελεσμα της άσκησης καθώς και τον βαθμό στα πεδία <strong class="text-dark">Τύπος απάντησης</strong> και <strong class="text-dark">Βαθμός</strong> αντίστοιχα. Το σύστημα υπολογίζει αυτόματα το τελικό αποτέλεσμα της άσκησης βασισμένο στον τύπο που δώσατε.</li>
<li class="text-dark">Καταχωρήστε τις τιμές των στοιχείων από την <strong class="text-dark">επεξεργασία στοιχείων</strong>. Μπορείτε επίσης να ορίσετε τυχαίες τιμές από το εύρος τιμών.</li>
</ul>
<div class="mt-4 text-dark">
Για παράδειγμα, αν θέλουμε να υπολογίσουμε το αποτέλεσμα της αριθμητικής πράξης 15+30 τότε ακολουθούμε τα εξής βήματα:
<ul class="mt-3 text-dark">
<li class="text-dark">Στο πεδίο <strong class="text-dark">Εκφώνηση</strong> γράφουμε την εκφώνηση που θέλουμε συμπεριλαμβανομένου και των στοιχείων εαν αυτά υπάρχουν. Μπορούμε λοιπόν να δώσουμε την εκφώνηση `Υπολογίστε το αποτέλεσμα της αριθμητικής πράξης {X}+{Y}`.</li>
<li class="text-dark">Στο πεδίο <strong class="text-dark">Τύπος απάντησης</strong> συμπληρώνουμε τον τύπο που θα δώσει το τελικό αποτέλεσμα. Στο παραδειγμά μας γράφουμε τον τύπο {X}+{Y}.</li>
<li class="text-dark">Στο πεδίο <strong class="text-dark">Βαθμός</strong> συμπληρώνουμε τον βαθμό του.</li>
<li class="text-dark">Στην συνέχεια από την <strong class="text-dark">Επεξεργασία στοιχείων</strong>, ορίζουμε τις τιμές των στοιχείων X = 15,Y = 30 μέσω της επιλογής <strong class="text-dark">Αποτελεί στοιχείο της άσκησης</strong>.</li>
<li class="text-dark">Τέλος, πατάμε <strong class="text-dark">Υποβολή</strong>.</li>
</ul>
</div>';
$langCompleteVariablesOfQuestionWarning = '
<strong class="text-dark">Προσοχή!</strong></br></br>
Αν η άσκηση <strong class="text-dark">ΔΕΝ</strong> περιλαμβάνει κάποιο στοιχείο και πρέπει να υπολογιστεί, τότε θα πρέπει στον πεδίο <strong class="text-dark">Τύπος απάντησης</strong> να συμπληρώσετε την αριθμητική έκφραση όπως την συμπληρώσατε στην εκφώνηση μαζί με το τελικό της αποτέλεσμα χωρισμένα με το διπλό σύμβολο Vertical Bar <strong>(||)</strong></br>
<div class="mt-3 text-dark">
Για παράδειγμα, αν θέλουμε να υπολογίσουμε τον άγνωστο <strong class="text-dark">x</strong> στην εξίσωση <strong class="text-dark">3x - 2 = 2x</strong> τότε ακολουθούμε τα εξής βήματα:
<ul class="mt-4 text-dark">
<li class="text-dark">Στο πεδίο <strong class="text-dark">Εκφώνηση</strong> γράφουμε την εκφώνηση που θέλουμε. Στο παράδειγμά μας μπορούμε να γράψουμε `Βρείτε τον άγνωστο <strong class="text-dark">x</strong> της εξίσωσης <strong class="text-dark">3x - 2 = 2x</strong>`.</li>
<li class="text-dark">Στο πεδίο <strong class="text-dark">Τύπος απάντησης</strong> συμπληρώνουμε την αριθμητική έκφραση μαζί με την τελική τιμή του <strong class="text-dark">χ</strong> που ψάχνουμε ως αποτέλεσμα χωρισμένα με το σύμβολο (<strong class="text-dark">||</strong>) δηλαδή γράφουμε <strong class="text-dark">3x - 2 = 2x||2</strong></li>
<li class="text-dark">Στο πεδίο <strong class="text-dark">Βαθμός</strong> συμπληρώνουμε τον βαθμό του.</li>
<li class="text-dark">Στην συνέχεια στην <strong class="text-dark">Επεξεργασία στοιχείων</strong> πατάμε <strong class="text-dark">Υποβολή</strong>.</li>
</ul>
</div>';
$langNoExistVariables = "Δεν περιέχονται στοιχεία στην ερώτηση. </br> Πατήστε <strong>Υποβολή</strong> για να ολοκληρώσετε την δημιουργία της ερώτησης.";
$langFinalValueOfWildCard = "Τιμή στοιχείου";
$langSeperateCorrectlyTheTypeOfAnswer = "Δεν υπάρχουν διαθέσιμα {στοιχεία} στην εκφώνηση ή στους τύπους των απαντήσεων. </br>
Συνεπώς θα πρέπει στο πεδίο <strong>Τύπος απάντησης</strong> να προσθέσετε τον αριθμητικό τύπο που προσθέσατε στην εκφώνηση μαζί με το τελικό της αποτέλεσμα, χωρισμένα με το σύμβολο (<strong>||</strong>)";
$langOrdering = "Ταξινόμηση";
$langLayoutItems = "Διάταξη στοιχείων";
$langHorizontal = "Οριζόντια";
$langVertical = "Κατακόρυφη";
$langItemsSelectionType = "Τύπος επιλογής στοιχείου";
$langSelectAllItems = "Επιλογή όλων των στοιχείων";
$langSelectRandomSubSetOfItems = "Επιλογή τυχαίου υποσυνόλου στοιχείων";
$langSelectContiguousSubSetOfItems = "Επιλογή συνεχόμενου υποσυνόλου στοιχείων";
$langSizeOfSubset = "Μέγεθος υποσυνόλου";
$langFillInTheSizeOfSubset = "Συμπληρώστε το μέγεθος του υποσυνόλου.";
$langTheSizeOfSubsetIsBiggerThanPrAnswers = "Το μέγεθος του υποσυνόλου είναι μεγαλύτερο από τον συνολικό αριθμό των προκαθορισμένων απαντήσεων.";
$langCorrectOrdering = "Η σωστή ταξινόμηση είναι";
$langInfoOrderingQuestion = 'Για την δημιουργία σωστής ταξινόμησης των στοιχείων, το σύστημα αντιλαμβάνεται ως σωστή απάντηση την ταξινόμηση από το μικρότερο προς το μεγαλύτερο στοιχείο.</br></br>
                             <strong class="text-dark">Για παράδειγμα</strong>, αν η ερώτητη της ασκήσης ζητάει την ταξινόμηση των αριθμών 1,5,3,9,7 από το μεγαλύτερο στο μικρότερο, τότε θα πρέπει να δηλώσετε τα εξής ως σωστή απάντηση:</br>
                             <ul class="mt-3">
                                <li><strong class="text-dark">Στοιχείο(1)</strong> = 9 και τον βαθμό του ως σωστή απάντηση</li>
                                <li><strong class="text-dark">Στοιχείο(2)</strong> = 7 και τον βαθμό του ως σωστή απάντηση</li>
                                <li><strong class="text-dark">Στοιχείο(3)</strong> = 5 και τον βαθμό του ως σωστή απάντηση</li>
                                <li><strong class="text-dark">Στοιχείο(4)</strong> = 3 και τον βαθμό του ως σωστή απάντηση</li>
                                <li><strong class="text-dark">Στοιχείο(5)</strong> = 1 και τον βαθμό του ως σωστή απάντηση</li>
                             </ul></br>
                             Στην συνέχεια, επιλέγετε την διάταξη των στοιχείων κατά την εκτέλεση της άσκησης.</br>
                             Αν επιθυμείτε να εμφανίζεται στην άσκηση ένα συγκεκριμένο υποσύνολο των στοιχείων που ορίσατε τότε
                             επιλέγετε τον <strong class="text-dark">τύπο επιλογής στοιχείου</strong> και το <strong class="text-dark">μέγεθος υποσυνόλου</strong>.
                             ';
$langEvaluationFreeText = "Βαθμολόγηση ερωτήσεων ελεύθερου κειμένου";

// answer_admin.php
$langWeightingForEachBlank = "Δώστε ένα βάρος σε κάθε κενό";
$langWeightingForEachBlankandChoose = "Δώστε ένα βάρος σε κάθε κενό και διαλέξτε την σωστή απάντηση";
$langUseTagForBlank = "χρησιμοποιήστε αγκύλες [...] για να ορίσετε ένα ή περισσότερα κενά και τον χαρακτήρα | αν θέλετε να ορίσετε περισσότερες από μία σωστές απαντήσεις για το ίδιο κενό (π.χ. [Ιωάννινα|Γιάννενα])";
$langUseTagForSelectedWords = "χρησιμοποιήστε αγκύλες [...] για να ορίσετε ένα ή περισσότερα κενά και τον χαρακτήρα | για να ορίσετε τις πιθανές απαντήσεις";
$langQuestionWeighting = "Βάρος";
$langTypeTextBelow = "Πληκτρολογήστε το κείμενό σας παρακάτω";
$langDefaultTextInBlanks = "Πρωτεύουσα της Ελλάδας είναι η [Αθήνα].";
$langDefaultMissingWords = "Πρωτεύουσα της Ελλάδας είναι η [Πάτρα|Αθήνα|Θεσσαλονίκη].";
$langDefaultMatchingOpt1 = "Αθήνα";
$langDefaultMatchingOpt2 = "Λονδίνο";
$langDefaultMakeCorrespond1 = "Πρωτεύουσα της Ελλάδας είναι η";
$langDefaultMakeCorrespond2 = "Πρωτεύουσα της Αγγλίας είναι το";
$langDefineOptions = "Καθορίστε τις επιλογές";
$langMakeCorrespond = "Κάντε την αντιστοιχία";
$langFillLists = "Συμπληρώστε τις δύο λίστες που ακολουθούν";
$langGiveText = "Πληκτρολογήστε το κείμενο";
$langDefineBlanks = "Πληκτρολογήστε τουλάχιστον ένα κενό με αγκύλες [...]";
$langGiveAnswers = "Δώστε τις απαντήσεις στις ερωτήσεις";
$langChooseGoodAnswer = "Διαλέξτε την σωστή απάντηση";
$langChooseGoodAnswers = "Διαλέξτε μία ή περισσότερες σωστές απαντήσεις";
$langColumnA = "Στήλη Α";
$langColumnB = "Στήλη B";
$langMoreLessChoices = "Προσθήκη/Αφαίρεση επιλογών";
$langQuestionUpdated = "Τα στοιχεία της ερώτησης ενημερώθηκαν";
$langMarkerDeleted = "Το σχήμα διαγράφηκε!";

// question_list_admin.php
$langQuestionList = "Ερωτήσεις της άσκησης";
$langGetExistingQuestion = "Ερώτηση από άλλη άσκηση";
$langWithCriteria = 'Εισαγωγή με κριτήρια από τράπεζα ερωτήσεων';
$langWithoutCriteria = 'Εισαγωγή από τράπεζα ερωτήσεων';
$langSelectionRule = 'Κανόνας Επιλογής';

// question_pool.php
$langQuestionPool = "Τράπεζα Ερωτήσεων";
$langOrphanQuestions = "Ορφανές Ερωτήσεις";
$langNoQuestion = "Δεν έχουν ορισθεί ερωτήσεις για τη συγκεκριμένη άσκηση";
$langAllExercises = "Όλες οι ερωτήσεις";
$langFilter = "Φιλτράρισμα";
$langGoBackToEx = "Επιστροφή στην άσκηση";
$langReuse = "Επαναχρησιμοποίηση";
$langUsed = "Χρησιμοποιούμενης";
$langQuestionReused = "Η ερώτηση προστέθηκε στην άσκηση";
$langNoQuestionWeight = "Η ερώτηση δεν έχει βαθμό";
$langNoQuestionAnswers = "Η ερώτηση δεν έχει απαντήσεις";

// exercise_result.php
$langElementList = "Το στοιχείο";
$langScore = "Βαθμολογία";
$langQuestionScore = "Βαθμολογία ερώτησης";
$langCorrespondsTo = "Αντιστοιχεί σε";
$langExpectedChoice = "Αναμενόμενη Απάντηση";
$langQuestionAlreadyDeleted = "Η ερώτηση έχει διαγραφεί.";
$langScoreDiffers = 'Η αποθηκευμένη βαθμολογία της άσκησης διαφέρει από την τρέχουσα. Επιθυμείτε να γίνει αναβαθμολόγηση;';
$langRegrade = 'Αναβαθμολόγηση';
$langNewScoreRecorded = 'Η νέα βαθμολογία αποθηκεύτηκε';
$langQuestionStoredScore = 'Αποθηκευμένη βαθμολογία ερώτησης';
$langEvaluatingResponseWithAI = "Αξιολόγηση της απάντησης με χρήση Τ.Ν.";

// exercise_submit.php
$langDoAnEx = "Κάντε μια άσκηση";
$langCorrect = "Σωστό";
$langIncorrect = "Λάθος";
$langCorrectS = "σωστό";
$langIncorrectS = "λάθος";
$langExerciseNotFound = "Η άσκηση δεν βρέθηκε";
$langIPUnlock = "Πρόσβαση από διευθ. δικτύου (IP(s) ή CIDR(s))";
$langExercisePasswordModalTitle = "Παρακαλώ πληκτρολογήστε τον κωδικό της άσκησης";
$langIPHasNoAccess = "Η IP διεύθυνση σας δεν έχει πρόσβαση στην συγκεκριμένη άσκηση.";
$langIPInvalid = "περιέχει άκυρη διεύθυνση IP ή IP CIDR";
$langAlreadyAnswered = "Απαντήσατε ήδη στην ερώτηση";
$langRemainingTime = "Υπολειπόμενος χρόνος";
$langCancelExConfirmation = "Προσοχή! Η άσκηση θα ακυρωθεί. Επιβεβαιώστε την ενέργειά σας.";
$langCancelAttempt = "Ακύρωση προσπάθειας";
$langExerciseAttemptGone = 'Η τρέχουσα προσπάθειά σας έχει ακυρωθεί, είτε
    επειδή διαγράφτηκε από τους υπεύθυνους του μαθήματος, είτε επειδή
    συνεχίσατε την προσπάθεια από άλλο υπολογιστή.';
$langContinueAttemptNotice = 'Προσοχή! Μια προσπάθειά σας να απαντήσετε στην
    άσκηση αυτή βρίσκεται ήδη σε εξέλιξη, πιθανόν από άλλο υπολογιστή ή παράθυρο.
    Αν επιθυμείτε, μπορείτε να συνεχίσετε την προσπάθεια αυτή.';
$langContinueAttempt = 'Συνέχιση προσπάθειας';
$langContinueAttemptExplanation = 'Ενεργοποίηση δυνατότητας συνέχισης προσπαθειών που
    διακόπηκαν απότομα, για περιορισμένο χρονικό διάστημα από την τελευταία ενέργεια
    του χρήστη.';
$langContinueAttemptTime = 'Χρονικό περιθώριο: [] λεπτά.';
$langWarnOneWayExercise = "Προσοχή: οι ερωτήσεις εμφανίζονται μία ανά σελίδα και δεν έχετε δυνατότητα επιστροφής σε προηγούμενες σελίδες.";
$langExam = "Εξέταση";
$langRequireCourseUserLogin = "Οι χρήστες πρέπει να είναι συνδεδεμένοι στη πλατφόρμα και εγγεγραμμένοι στο $langsCourse.";
$langExerciseRequireLogin = "Θα πρέπει να συνδεθείτε πρώτα στην πλατφόρμα έτσι ώστε να εκτελέσετε την άσκηση";
$langWarningNewPageOpened = "<strong>Προσοχή!</strong><br>Παρακαλούμε να διατηρείτε την τρέχουσα σελίδα ανοικτή καθόλη τη διάρκεια της εξέτασης.<br> Οποιαδήποτε παράλληλη ενέργεια, όπως ανακατεύθυνση σε νέα σελίδα ή άνοιγμα νέου παραθύρου, θα οδηγήσει στην αυτόματη ακύρωση της προσπάθειάς σας.";
$langWarningNewPageOpened2 = "<strong>Προσοχή!</strong><br>Έχετε εισέλθει στον χώρο της εξέτασης.<br> Οποιαδήποτε παράλληλη ενέργεια, όπως ανακατεύθυνση σε νέα σελίδα ή άνοιγμα νέου παραθύρου, θα οδηγήσει στην αυτόματη ακύρωση της προσπάθειάς σας.";
$langExWillBeCanceled = "Η προσπάθειά σας θα ακυρωθεί.";
$langGoToExam = "Έναρξη εξέτασης";

// exercise result.php
$langStart = "Έναρξη";
$langFinish = "Λήξη";
$langExerciseStartHelpBlock = "Κάντε κλικ για να ορίσετε μια διαφορετική (μελλοντική) Ημερομηνία Εναρξης Άσκησης";
$langExerciseEndHelpBlock = "Κάντε κλικ για να ορίσετε Ημερομηνία Λήξης Άσκησης";
$langExerciseDuration = "Διάρκεια Εκτέλεσης";
$langExerciseConstrain = "Χρονικός περιορισμός";
$langExerciseGradePass = "Βαθμός Επιτυχίας";
$langExerciseGradePassLegend = "Η άσκηση θεωρείται ότι εκτελέστηκε με επιτυχία αν ο βαθμός του $langsOfStudent είναι μεγαλύτερος ή ίσος από το βαθμό επιτυχίας";
$langExerciseEg = "π.χ.";
$langExerciseConstrainUnit = "λεπτά";
$langExerciseConstrainExplanation = "0 για καθόλου περιορισμό";
$langExerciseAttemptsAllowedExplanation = "0 για απεριόριστο αριθμό επαναλήψεων";
$langExerciseAttemptsAllowed = "Επιτρεπόμενες επαναλήψεις";
$langExerciseAttemptsUnlimited = 'Απεριόριστες';
$langExerciseAttemptsAllowedUnit = "φορές";
$langExerciseMaxAttemptsReached = "Έχετε φτάσει τον μέγιστο επιτρεπτό αριθμό επαναλήψεων της άσκησης.";
$langExerciseExpiredTime = "Έχετε ξεπεράσει το επιτρεπτό χρονικό όριο εκτέλεσης της άσκησης. Οι απαντήσεις σας υποβλήθηκαν αυτόματα.";
$langExerciseExpired = "Η άσκηση έχει λήξει ή η ημερομηνία έναρξης της δεν έχει παρέλθει";
$langExerciseLis = "Λίστα ασκήσεων";
$langResults = "Αποτελέσματα";
$langResults2="αποτελέσματα";
$langResultsFailed = "Αποτυχία";
$langStudentTotalScore = "Βαθμολογία $langsOfStudent";
$langTotalScore = "Συνολική βαθμολογία";
$langNotRecorded = "μη καταγεγραμμένη";
$langHasExpiredS = "έχει λήξει";
$langHasExpired = "Έχει λήξει";
$langSuccessPercentage = "Ποσοστό Επιτυχίας";

// import exercise.php
$langImportExercise = "Εισαγωγή Άσκησης";
$langAskExercise = "Εντοπισμός του αρχείου Άσκησης";
$langExerciseNoTitle = "Η άσκηση δεν έχει τίτλο!";
$langExerciseWrongDates = "Η άσκηση έχει λάθος ημερομηνίες!";
$langNoUsersForExerSubmission = "Δεν υπάρχουν χρήστες χωρίς υποβολή στην άσκηση.";
$langNotifyUnSubmittedUsers = "Σας υπενθυμίζουμε ότι δεν έχετε υποβάλει τις απαντήσεις σας στην άσκηση του μάθηματος.";
$langNotifyUsersViaEmail = "Ειδοποίηση χρηστών στην ηλεκτρονική τους διεύθυνση ώστε να υποβάλουν τις απαντήσεις τους.";
$langUsersListWithNoSubmission = "Η άσκηση δεν έχει εκτελεσθεί από τους παρακάτω %d χρήστες.";
$langNotifyEmailToUsers = "Η υπενθύμιση στάλθηκε σε";
/* * *********************************************
 * external_module.php
 * ********************************************* */
$langSubTitle = "<br><strong>Σημείωση:</strong> Αν θέλετε να προσθέσετε ένα σύνδεσμο σε μια σελίδα,
	πηγαίνετε σε αυτή τη σελίδα, κάντε αποκοπή και επικόλληση τη διεύθυνσή της στη μπάρα των URL
	στο πάνω μέρος του browser και εισάγετέ το στο πεδίο \"Σύνδεσμος\" παρακάτω.<br><br>";
$langLink = "Σύνδεσμος";
$langInvalidLink = "Ο σύνδεσμος (ή η περιγραφή του) είναι κενός και δεν προστέθηκε!";
$langNotAllowed = "Μη επιτρεπτή ενέργεια";
$langExternalLinks = "Εξωτερικοί Σύνδεσμοι";

/* * *********************************************
 * faculty.php
 * ********************************************* */
$langCodeFaculte1 = "Κωδικός $langOfFaculty";
$langCodeFaculte2 = "με λατινικούς χαρακτήρες μόνο, π.χ. MATH";
$langAddFaculte = "Προσθήκη $langOfFaculties";
$langFaculte2 = "(π.χ. Μαθηματικό)";
$langAddSuccess = "Η εισαγωγή πραγματοποιήθηκε με επιτυχία!";
$langNoSuccess = "Πρόβλημα κατά την εισαγωγή των στοιχείων!";
$langProErase = "Υπάρχουν διδασκόμενα $langsCourses!";
$langNoErase = "Η διαγραφή του $langOfFaculty δεν είναι δυνατή.";
$langErase = "Η $langFaculty διαγράφηκε!";
$langFCodeExists = "Ο κωδικός που βάλατε υπάρχει ήδη! Δοκιμάστε ξανά επιλέγοντας διαφορετικό";
$langFaculteExists = "Η $langFaculty που βάλατε υπάρχει ήδη! Δοκιμάστε ξανά επιλέγοντας διαφορετικό";
$langEmptyFaculte = "Αφήσατε κάποιο από τα πεδία κενά! Δοκιμάστε ξανά.";
$langGreekCode = "Ο κωδικός της κατηγορίας περιέχει μη λατινικούς χαρακτήρες!";

/* * *********************************************
 * hierarchy.php
 * ********************************************* */
$langNoRootNodes = "Παρουσιάστηκε πρόβλημα με την ιεραρχία των τμημάτων!";
$langEditNodeSuccess = "Η επεξεργασία πραγματοποιήθηκε επιτυχώς!";
$langEmptyNodeName = "Αφήσατε το όνομα κενό! Δοκιμάστε ξανά";
$langHierarchyActions = "Κατάλογος $langOfFaculties - Ενέργειες";
$langNCodeExists = "Ο κωδικός που βάλατε υπάρχει ήδη! Δοκιμάστε ξανά επιλέγοντας διαφορετικό";
$langNodeAdd = "Επιλογή $langOfFaculty";
$langNodeDel = "Διαγραφή $langOfFaculty";
$langNodeEdit = "Επεξεργασία $langOfFaculty";
$langNodeCode1 = "Κωδικός $langOfFaculty";
$langNodeName = "Όνομα $langOfFaculty";
$langNodeDescription = "Περιγραφή $langOfFaculty";
$langNodeParent = "Γονική $langFaculty";
$langNodeParent2 = "(στην οποία θα ανήκει η $langsFaculty που επεξεργάζεστε)";
$langNodeAllowCourse = "Εγγραφή $langsOfCourses";
$langNodeAllowCourse2 = "(έλεγχος αν θα μπορούν να ανήκουν $langsCourses στη $langsFaculty)";
$langNodeAllowUser = "Εγγραφή χρηστών";
$langNodeAllowUser2 = "(έλεγχος αν θα μπορούν να ανήκουν χρήστες στη $langsFaculty)";
$langNodePublic = "Δημόσια προβολή";
$langNodePublic2 = "Η $langsFaculty θα εμφανίζεται για όλους τους χρήστες";
$langNodeSubscribed = "Προβολή Εγγεγραμμένων";
$langNodeSubscribed2 = "Η $langsFaculty θα εμφανίζεται μόνο για τους εγγεγραμμένους σε αυτήν χρήστες";
$langNodeHidden2 = "Η $langsFaculty θα παραμένει κρυμμένη από όλους τους χρήστες";
$langNodeOrderPriority = "Προτεραιότητα Ταξινόμησης";
$langNodeOrderPriority2 = "(όσο ψηλότερη τιμή, τόσο ψηλότερα στην ταξινόμηση)";
$langNodeProErase = "Υπάρχουν $langsCourses ή χρήστες που ανήκουν σε αυτόν τον κόμβο ($langsFaculty) ή στα παιδιά του!";
$langNodeNoErase = "Η διαγραφή της $langsOfFaculty δεν είναι δυνατή.";
$langNodeErase = "Η $langsFaculty διαγράφηκε!";
$langReturnToAddNode = "Επιστροφή στην προσθήκη";
$langReturnToEditNode = "Επιστροφή στην επεξεργασία $langsOfFaculty";
$langEmptyNodeSelect = "Παρακαλώ κάντε μια επιλογή από τη λίστα και μετά πατήστε Επιλογή";
$langEmptyAddNode = "Παρακαλώ επιλέξτε $langFaculty και ξαναπροσπαθήστε";
$langOneNodeSelect = "Παρακαλώ επιλέξτε μόνο μία κατηγορία";
$langFacultyImage = "Φωτογραφία $langOfFaculty";

/* * *************************************************************
 * grades.php
 * ************************************************************** */
$m['grades'] = "Βαθμολογία";

/* * ***********************************************************
 * group
 * *********************************************************** */
$langGroupManagement = "Διαχείριση ομάδων χρηστών";
$langNewGroupCreateData = "Στοιχεία Ομάδας (αριθμητικά)";
$langNewGroupCreate = "Δημιουργία καινούριας ομάδας χρηστών";
$langNewGroups = "Αριθμός ομάδων χρηστών";
$langNewGroupMembers = "Αριθμός συμμετεχόντων";
$langMax = "Μέγ.";
$langPlaces = "συμμετέχοντες στην ομάδα χρηστών";
$langGroupPlacesThis = "συμμετέχοντες";
$langDeleteGroups = "Διαγραφή όλων των ομάδων";
$langGroupsAdded2 = "Οι ομάδες χρηστών δημιουργήθηκαν.";
$langGroupAdded2 = "Η ομάδα χρηστών έχει προστεθεί";
$langGroupsAdded = "ομάδες χρηστών έχουν προστεθεί";
$langGroupAdded = "ομάδα χρηστών έχει προστεθεί";
$langGroupsDeleted = "Ολες οι ομάδες χρηστών έχουν διαγραφεί";
$langGroupDel = "Η ομάδα χρηστών διαγράφηκε";
$langGroupsEmptied = "Όλες οι ομάδες χρηστών είναι άδειες";
$langEmptyGroups = "Εκκαθάριση όλων των ομάδων";
$langEmptyGroupsAll = "Εκκαθάριση Όλων";
$langGroupsFilled = "Όλες οι ομάδες χρηστών έχουν συμπληρωθεί";
$langFillGroups = "Συμπλήρωση των ομάδων χρηστών";
$langFillGroupsAll = "Αυτόματη συμπλήρωση όλων των ομάδων";
$langStudentRegAllowed = "Οι χρήστες επιτρέπεται να γραφτούν στις ομάδες";
$langStudentRegNotAllowed = "Οι χρήστες δεν επιτρέπεται να γραφτούν στις ομάδες";
$langTools = "Εργαλεία";
$langExistingGroups = "Υπάρχουσες Ομάδες Χρηστών";
$langEdit = "Διόρθωση";
$langDeleteGroupWarn = "Επιβεβαίωση διαγραφής της ομάδας χρηστών";
$langDeleteGroupAllWarn = "Επιβεβαίωση διαγραφής όλων των ομάδων χρηστών";
$langEmptyGroupName = "Αφήσατε κενό το όνομα της ομάδας χρηστών";
$langAddDescription = "Προσθήκη περιγραφής";
$langGroupDescInfo = "Πληκτρολογήστε μια περιγραφή ή ένα σχόλιο σχετικά με εσάς ή/και με την ομάδα χρηστών.
        Σημειώστε ότι θα είναι ορατό στον υπεύθυνο της ομάδας χρηστών και στα υπόλοιπα μέλη της ομάδας";
$langNoChanges = "Δεν πραγματοποιήθηκαν αλλαγές";
$langGroupMembersUnchanged = "Τα μέλη της ομάδας είναι περισσότερα από τον μέγιστο αριθμό που δώσατε. Ο αριθμός ορίστηκε ίσος με το τρέχον πλήθος μελών.";
$langGroupPrefs = "Λειτουργικά Χαρακτηριστικά Ομάδων";
$langGroupPropertiesSum = "Σύνοψη Ρυθμίσεων";
$langGroup = "Ομάδα Χρηστών";
$langInGroup = "στην ομάδα χρηστών";
$langGroupInfiniteUsers = "0 = απεριόριστος αριθμός χρηστών";
$langSingleGroupRegInfo = "Μπορείτε να εγγραφείτε σε μία μόνο ομάδα χρηστών (εφόσον δεν είναι πλήρης και επιτρέπεται η εγγραφή σε αυτήν)";
$langCategoryGroupRegInfo = "Μπορείτε να εγγραφείτε στις γενικές ομάδες και σε μία ομάδα ανά κατηγορία (εφόσον δεν είναι πλήρεις και επιτρέπεται η εγγραφή σε αυτές)";
$langMultipleGroupRegInfo = "Μπορείτε να εγγραφείτε σε πολλές ομάδες χρηστών (εφόσον δεν είναι πλήρεις και επιτρέπεται η εγγραφή σε αυτές)";
$langNoGroupAvailable = "Δεν υπάρχουν διαθέσιμες ομάδες.";
$langSearchGroupByName = "Αναζήτηση ομάδων μέσω ονόματος:";
$langSearchGroupByCategory = "Αναζήτηση ομάδων μέσω κατηγορίας:";

// Group Properties
$langGroupAllowStudentRegistration = "Οι " . $langsStudents . " επιτρέπεται να εγγραφούν";
$langGroupAllowStudentUnregister = "Οι " . $langsStudents . " επιτρέπεται να απεγγραφούν";
$langGroupAllowRegistration = "Εγγραφή χρηστών σε μια ομάδα";
$langGroupAllowCategoryRegistration = "Εγγραφή χρηστών στις γενικές ομάδες και σε μία ομάδα ανά κατηγορία";
$langGroupAllowMultipleRegistration = "Εγγραφή χρηστών σε περισσότερες από μία ομάδες";
$langGroupAllowStudentGroupDescription = "Δυνατότητα προσθήκης περιγραφής ομάδας από τα μέλη της ομάδας";
$langGroupStudentRegistrationType = "Δυνατότητα εγγραφής";
$langGroupAllowUnregister = "Δυνατότητα απεγγραφής";
$langGroupPrivatise = "Κλειστές περιοχές συζητήσεων ομάδων χρηστών";
$langGroupForum = "Περιοχή συζητήσεων";
$langGroupPropertiesModified = "Αλλάχτηκαν οι ρυθμίσεις της ομάδας χρηστών";
$langPrivate_1 = "Πρόσβαση στις περιοχές συζητήσεων ομάδων χρηστών";
$langPrivate_2 = "μόνο στα μέλη της ομάδας";
$langPrivate_3 = "ελεύθερη πρόσβαση (μόνο για ανάγνωση)";

// Group space
$langGroupThisSpace = "Περιοχή για την ομάδα χρηστών";
$langGroupName = "Όνομα ομάδας χρηστών";
$langOptional = "(προαιρετικό)";
$langNoGroupStudents = "Μη εγγεγραμμένοι " . $langsStudents . " ";
$langGroupMembers = "Μέλη ομάδας χρηστών";
$langGroupValidate = "Επικύρωση";
$langGroupCancel = "Ακύρωση";
$langGroupSettingsModified = "Οι ρυθμίσεις της ομάδας χρηστών έχουν αλλάξει";
$langNameSurname = "Όνομα Επίθετο";
$langEmail = "E-mail";
$langGroupTooManyMembers = "Ο αριθμός που προτάθηκε υπερβαίνει το μέγιστο επιτρεπόμενο (μπορείτε να το αλλάξετε παρακάτω).
	Η σύνθεση της ομάδας δεν άλλαξε";
$langGroupNoTutor = "κανένας";
$langGroupNoneMasc = "Δεν υπάρχουν $langsStudents στην ομάδα";
$langAddTutors = "Διαχείριση καταλόγου χρηστών";
$langForumGroup = "Περιοχή συζητήσεων της ομάδας";
$langMyGroup = "η ομάδα μου";
$langOneMyGroups = "επιβλέπων";
$langRegIntoGroup = "Προσθέστε με στην ομάδα";
$langGroupNowMember = "Εγγραφήκατε στην ομάδα με επιτυχία.";
$langGroupNowNotMember = "Απεγγραφήκατε από την ομάδα με επιτυχία.";
$langPublicAccess = "ανοικτό";
$langForumType = "Τύπος περιοχής συζητήσεων";
$langPropModify = "Αλλαγή ρυθμίσεων";
$langGroupAccess = "Πρόσβαση";
$langGroupFilledGroups = "Οι ομάδες χρηστών έχουν συμπληρωθεί από " . $langsOfStudentss . " που βρίσκονται στον κατάλογο «Χρήστες».";
$langGroupInfo = "Στοιχεία Ομάδας";
$langGroupMembersInfo = "Μέλη Ομάδας";

// Group - bookings
$langBooking = "Κράτηση";
$langBookings = "Κρατήσεις";
$langAddAvailableDateForGroupAdmin = "Προσθήκη διαθεσιμότητας στην ομάδα";
$langAddAvailability = "Προσθήκη διαθέσιμης ημερομηνίας";
$langRedInfoRentezvousOtherProgram = "<div style='color:#C44601;' class='TextBold'>Με ΚΟΚΚΙΝΟ χρώμα εμφανίζονται οι διαθέσιμες ημέρες επικοινωνίας που έχετε καταχωρίσει ως υπεύθυνος ομάδας σε άλλα μαθήματα.</div>";
$langSuccessInfoRentezvous = "<div style='color:#1E7E0E;' class='TextBold'>Με ΠΡΑΣΙΝΟ χρώμα εμφανίζονται οι διαθέσιμες ημέρες επικοινωνίας που έχετε καταχωρίσει στο τρέχων μάθημα</br>
                           στην τρέχων ομάδα ως υπεύθυνος.</div>";
$langWarningInfoRentezvous = "<div style='color:#F57600;' class='TextBold'>Με ΠΟΡΤΟΚΑΛΙ χρώμα εμφανίζονται οι διαθέσιμες ημέρες επικοινωνίας που έχει καταχωρίσει κάποιος άλλος</br>
                              υπεύθυνος ομάδας στο τρέχων μάθημα στη τρέχων ομάδα.</div>";
$langInfoInfoRentezvous = "<div style='color:#74AFE9;' class='TextBold'>Με ΓΑΛΑΖΙΟ χρώμα εμφανίζονται οι διαθέσιμες ημέρες επικοινωνίας που έχετε καταχωρίσει ως</br>
                              υπεύθυνος ομάδας στο τρέχων μάθημα σε άλλη ομάδα.</div>";
$langPinkInfoRentezvous = "<div style='color:#ffc0cb;' class='TextBold'>Με ΡΟΖ χρώμα εμφανίζεται η κράτηση που έχει γίνει από κάποιο μέλος της ομάδας.</div>";
$langChangeDateSuccess = "Η ημερομηνία άλλαξε επιτυχώς.";
$langNoChangeDateOtherUser = "Δεν μπορείτε να αλλάξατε την ημερομηνία άλλου χρήστη.";
$langExistBookingForThisDate = "Δεν μπορείτε να αλλάξατε την συγκεκριμένη ημερομηνία.";
$langDeleteDateSuccess = "Η ημερομηνία διαγράφηκε επιτυχώς.";
$langDeleteDateNoUser = "Δεν μπορείτε να διαγράψετε την ημερομηνία άλλου χρήστη.";
$langExistBookingForThisDateMessageDetlete = "Δεν μπορείτε να διαγράψετε την συγκεκριμένη ημερομηνία.
                                              Κάποιος χρήστης έχει κάνει κράτηση στο συγκεκριμένο slot.
                                              Επεξεργαστείτε το αίτημα από την επιλογή -- Οι κρατήσεις μου -- και δοκιμάστε πάλι.
                                              Αν το slot που επιλέξατε είναι με πορτοκαλί χρώμα, τότε αφορά άλλον υπεύθυνο της ίδιας ομάδας και σε κάθε περίπτωση δεν μπορεί να διαγραφεί.
                                              Επικοινωνήστε με τον διαχειριστή του μαθήματος αν αντιμετωπίζετε κάποιο πρόβλημα.";
$langDateHasExpired = "Παρακαλούμε επιλέξτε ώρα και ημερομηνία μετά την τρέχουσα.";
$langAddDatesSuccess = "Η ημερομηνία προστέθηκε με επιτυχία.";
$langDateMaxHour = "Η διαθέσιμη ώρα σας θα πρέπει να έχει διάρκεια μισής ή μίας ώρας";
$langDeleteAvailableDate = "Θέλετε να προχωρήσετε στην διαγραφή της συγκεκριμένης ημερομηνίας;";
$langAddAVailableDateWith ="Προσθήκη διαθέσιμης ημερομηνίας για τον χρήστη: ";
$langAvailableDateForGroupAdmin = "Διαθέσιμη ημερομηνία υπεύθυνου ομάδας";
$langDoBooking = "Κάντε κράτηση";
$langNextAvailableDate = "Επόμενη διαθέσιμη ημερομηνία";
$langAddBooking = "Κράτηση στον υπεύθυνο ομάδας";
$langdobookingwithtutor = "Θέλετε να κάνετε κρατήση για να επικοινωνήσετε με τον συγκεκριμένο υπεύθυνο?";
$langAddBookingSuccess = "Η κράτησή σας έγινε επιτυχώς. Έχει σταλθεί ενημερωτικό email στον υπεύθυνο.";
$langAddBookingNoSuccess = "Η κράτηση δεν ολοκληρώθηκε καθώς κάποιος άλλος χρήστης χρησιμοποίησε την συγκεκριμένη ημερομηνία.";
$langTutorHasRemovedTheDate = "Η κράτηση δεν ολοκληρώθηκε καθώς ο υπεύθυνος έχει αφαιρέσει την διαθέσιμη ημερομηνία του.";
$langDeleteBookingSuccess = "Η κράτησή σας διαγράφηκε επιτυχώς.";
$langdelbookingwithtutor = "Θέλετε να ακυρώσετε την συγκεκριμένη κράτηση?";
$langAddBookingByUser = "Κράτηση για επικοινωνία";
$langDetailsBooking = "Τα στοιχεία της κράτησης είναι τα εξής:";
$langDeleteBookingByUser = "Ακύρωση κράτησης";
$langPlsWait = "Περιμένετε...";
$langHaveDoneBooking = "ΑΚΥΡΩΣΗ ΚΡΑΤΗΣΗΣ";
$langDoBooking = "ΚΑΝΤΕ ΚΡΑΤΗΣΗ";
$langDisableBooking = "ΜΗ ΔΙΑΘΕΣΙΜΟ";
$langBookingIsDone = "ΕΙΝΑΙ ΚΛΕΙΣΜΕΝΟ";
$langAcceptBooking = "Αποδοχή από τον υπεύθυνο";
$langWarningInfoBooking = "<div class='TextBold' style='color:#ffa500;'>Με ΠΟΡΤΟΚΑΛΙ χρώμα εμφανίζεται η κράτηση προς τον υπεύθυνου ομάδας από άλλον χρήστη.</div>";
$langBlueInfoBooking = "<div class='TextBold' style='color:#337ab7;'>Με ΜΠΛΕ χρώμα εμφανίζεται η διαθέσιμη ημερομηνία του υπευθύνου ομάδας για να κάνετε κράτηση.</br>Κάντε κλικ στο διαθέσιμο slot για υποβολή κράτησης.</div>";
$langSuccessInfoBooking = "<div class='TextBold' style='color:#1E7E0E;'>Με ΠΡΑΣΙΝΟ χρώμα εμφανίζεται κράτηση που κάνετε προς τον υπεύθυνο ομάδας (Αναμονή έγκρισης ή απορρίψης από τον υπεύθυνο).</br>Δυνατότητα ακύρωσης κάνοντας κλικ στο slot της κράτησης.</div>";
$langPinkInfoBooking = "<div class='TextBold' style='color:#ffc0cb;'>Με ΡΟΖ χρώμα εμφανίζεται η κράτηση σας προς τομ υπεύθυνο ομάδας (Εγκριση αιτήματος από τον υπεύθυνο).</br>Κάντε κλικ στο διαθέσιμο slot για ακύρωση κράτησης.</div>";
$langAvailableTutorBookings = "Κρατήσεις υπεύθυνου";
$langAVailableBookingsForTutor = "Διαθέσιμες κρατήσεις για τον υπεύθυνο:";
$langMyAvailableBookings = "Οι κρατήσεις μου";
$langContinueToBooking = "Θέλετε να προχωρήσετε στην συγκεκριμένη ενέργεια?";
$langCancelBooking = "Ακύρωση κράτησης";
$langAcceptBooking = "Αποδοχή κράτησης";
$langBookingHasAccepted = "Έγινε αποδοχή της κράτησης. Έχει σταλθεί ενημερωτικό email στον χρήστη ";
$langYourBookingHasAccepted = "Η κράτηση σας έγινε αποδεκτή";
$langDetailsBooking = "Τα στοιχεία της κράτησης είναι τα εξής:";
$langUpdateSoon = "Θα ενημερωθείτε σύντομα σχετικά με την συναντήση σας με τον υπεύθυνο.";
$langHasAcceptedBookingAndContinue = "Έχει γίνει αποδοχή της κράτησης.</br> Μπορείτε να την ακυρώσετε ανά πάσα στιγμή.";
$langBookingHasCalceled = "Η κράτηση ακυρώθηκε επιτυχώς. Έχει σταλθεί ενημερωτικό email στον χρήστη.";
$langYourBookingHasCanceled = "Η κράτηση σας ακυρώθηκε";
$langNoAcceptanceOfBooking = "Δεν έχει γίνει αποδοχή της κράτησης.</br> Πατώντας το κουμπί «Αποδοχή κράτησης» αποδέχεστε το αίτημα.";
$langMYBookings = "Οι κρατήσεις μου";
$langBookingWithTutor = "Οι κρατήσεις μου με τον υπεύθυνο:";
$langBookingAgenda = "Κάντε κράτηση στον υπεύθυνο";
$langAvailableHistoryBookings = "Κρατήσεις που έχουν παρέλθει";
$langDelHistoryBook = "Η διαγραφή ολοκληρώθηκε με επιτυχία!";
$langInfoColourEvent = "Πληροφορίες";

// group - email
$langEmailGroup = "Αποστολή μηνύματος στην ομάδα";
$langSend = "Αποστολή";
$langEmailSuccess = "Το e-mail σας στάλθηκε με επιτυχία !";
$langMailError = "Σφάλμα κατά την αποστολή e-mail !";
$langMailSubject = "Θέμα: ";
$langMailBody = "Μήνυμα: ";
$langProfLesson = "Διδάσκων του $langsOfCourse";

/* * ***************************************************
 * guest.php
 * *************************************************** */
$langAskGuest = "Πληκτρολογήστε το συνθηματικό του λογαριασμού επισκέπτη";
$langAddGuest = "Προσθήκη χρήστη επισκέπτη";
$langGuests = "Επισκέπτες";
$langGuestName = "Επισκέπτης";
$langGuestSurname = "$langOfCourse";
$langGuestUserName = "guest";
$langGuestExist = "Υπάρχει ήδη λογαριασμός επισκέπτη, μπορείτε όμως αν θέλετε να αλλάξετε το συνθηματικό του.";
$langGuestSuccess = "Ο λογαριασμός επισκέπτη (guest account) δημιουργήθηκε με επιτυχία !";
$langGuestFail = "Πρόβλημα κατά την δημιουργία λογαριασμού επισκέπτη";
$langGuestChange = "Η αλλαγή συνθηματικού επισκέπτη έγινε με επιτυχία!";
$langGuestLoginLabel = "Λογαριασμοί επισκεπτών $langsOfCourses";
$langGuestLogin = 'Σύνδεση με λογαριασμό επισκέπτη';
$langGuestLoginLinks = "Ενεργοποίηση και προσθήκη συνδέσμων στον κατάλογο $langsOfCourses";
$langGuestWarnEmptyPassword = 'Προσοχή! Ορίσατε κενό συνθηματικό για τον
    επισκέπτη. Αυτό σημαίνει ότι είναι δυνατή η σύνδεση χωρίς την εισαγωγή
    συνθηματικού.';

/* * ******************************************************
 * registration.php
 * ****************************************************** */
$infoprof = "Σύντομα θα σας σταλεί e-mail από την Ομάδα Διαχείρισης της Πλατφόρμας Ασύγχρονης Τηλεκπαίδευσης $siteName, με τα στοιχεία του λογαριασμού σας.";
$profinfo = "Η ηλεκτρονική πλατφόρμα $siteName διαθέτει 2 εναλλακτικούς τρόπους εγγραφής διδασκόντων";
$userinfo = "Η ηλεκτρονική πλατφόρμα $siteName διαθέτει 2 εναλλακτικούς τρόπους εγγραφής χρηστών:";
$regprofldap = "Εγγραφή διδασκόντων που έχουν λογαριασμό στην Υπηρεσία Καταλόγου (LDAP Directory Service) του ιδρύματος που ανήκουν";
$regldap = "Εγγραφή χρηστών που έχουν λογαριασμό στην Υπηρεσία Καταλόγου (LDAP Directory Service) του ιδρύματος που ανήκουν";
$regprofnoldap = "Εγγραφή διδασκόντων που δεν έχουν λογαριασμό στην Υπηρεσία Καταλόγου του ιδρύματος που ανήκουν";
$regnoldap = "Εγγραφή χρηστών που δεν έχουν λογαριασμό στην Υπηρεσία Καταλόγου του ιδρύματος που ανήκουν";
$mailbody1 = "\n$Institution\n\n";
$mailbody2 = "Ο Χρήστης\n\n";
$mailbody3 = "επιθυμεί να έχει πρόσβαση ";
$mailbody4 = "στην υπηρεσία Ασύγχρονης Τηλεκπαίδευσης ";
$mailbody5 = "του $siteName ";
$mailbody6 = "ως $langTeacher.";
$mailbody7 = "$langFaculty:";
$mailbody8 = "ως $langStudent.";
$logo = "Πλατφόρμα Ασύγχρονης Τηλεκπαίδευσης $siteName";
$gunet = "Ομάδα Ασύγχρονης Τηλεκπαίδευσης $siteName";
$langSendInfoMail = "Αποστολή e-mail στους χρήστες";
$langAdminMessage = "Μήνυμα Διαχειριστή $siteName";

$langRequestForTeacherRights = "επιθυμεί να αποκτήσει δικαιώματα δημιουργίας μαθημάτων";

// contact.php
$introcontact = "Μπορείτε να επικοινωνείτε με την Ομάδα Υποστήριξης της πλατφόρμας <strong>" . $siteName . "</strong> με τους παρακάτω τρόπους:";
$langPostMail = "Ταχυδρομική Διεύθυνση:";
$langPhone = "Τηλέφωνο";
$langFax = "Fax:";
$langForm = "Συμπλήρωση Φόρμας";
$langReturn = "Eπιστροφή";

/* * **********************************************************
 * course_tools.php
 * ********************************************************** */
$langAddPage = "Προσθήκη μιας σελίδας";
$langPageAdded = "Η σελίδα προστέθηκε";
$langPageUpdated = "Η σελίδα ενημερώθηκε";
$langPageDeleted = "Η σελίδα διαγράφτηκε";
$langPageTitleModified = "Ο τίτλος της σελίδας άλλαξε";
$langSendPage = "Όνομα αρχείου της σελίδας";
$langCouldNotSendPage = "Το αρχείο δεν είναι σε μορφή HTML και δεν ήταν δυνατόν να σταλεί. Αν θέλετε να στείλετε αρχεία που
δεν είναι σε μορφή HTML (π.χ. PDF, Word, Power Point, Video, κ.λπ.)
χρησιμοποιήστε τα <a href='../document/document.php'>Έγγραφα</a>.";
$langAddPageToSite = "Προσθήκη μιας σελίδας σε ένα site";
$langCouldNot = "Το αρχείο δεν ήταν δυνατόν να σταλεί";
$langOkSent = "<strong>Η σελίδα σας στάλθηκε</strong><br/>Δημιουργήθηκε σύνδεσμος προς αυτήν στο αριστερό μενού";
$langTooBig = "Το αρχείο είναι πολύ μεγάλο.";
$langExplanation_0 = "Αν έχετε  δημιουργήσει κάποια σελίδα για το $langsCourse σας σε μορφή HTML (π.χ. \"my_page.htm\"), τότε μπορείτε να χρησιμοποιήσετε την παρακάτω φόρμα για να κατασκευάσετε έναν σύνδεσμο στο μενού του $langsOfCourse (αριστερά). Η σελίδα σας με αυτό τον τρόπο  δημοσιεύεται (ανεβαίνει) στην πλατφόρμα και εμφανίζεται μαζί με τα υπόλοιπα εργαλεία του $langsOfCourse. <br/>";
$langExplanation_1 = "Στοιχεία σελίδας";
$langExplanation_2 = "Το όνομα που θα εμφανίζεται στο αριστερό μενού.";
$langExplanation_3 = "Αν θέλετε να δημιουργήσετε συνδέσμους για αρχεία που <u>δεν</u> είναι σε μορφή HTML (π.χ. PDF, Word, Power Point, Video, κ.λπ.) τότε χρησιμοποιήστε το υποσύστημα <a href='../document/document.php'>Έγγραφα</a>.";
$langExplanation_4 = "Στοιχεία εξωτερικού συνδέσμου";
$langNoticeExpl = "Σημ: Το μέγιστο επιτρεπτό μέγεθος του αρχείου της σελίδας είναι 20MB.";
$langPgTitle = "Τίτλος σελίδας";
$langNoPgTitle = "Δεν πληκτρολογήσατε τίτλο σελίδας.";

/* * *************************************************************
 * php
 * ************************************************************* */
$langHomePage = 'Αρχική Σελίδα';
$langInvalidId = 'Τα στοιχεία που πληκτρολογήσατε δεν αναγνωρίζονται. Αν δεν μπορείτε να συνδεθείτε και έχετε σίγουρα λογαριασμό, δοκιμάστε να κάνετε ανάκτηση του συνθηματικού σας ή να επικοινωνήσετε με τους διαχειριστές.';
$langEnterPlatform = 'Για να μπείτε στην πλατφόρμα κάντε κλικ';
$langInvalidGuestAccount = "Το $langsCourse για το οποίο έχει δημιουργηθεί ο λογαριασμός 'χρήστη επισκέπτη' δεν υπάρχει πλέον.";
$langAccountInactive1 = 'Μη ενεργός λογαριασμός.';
$langAccountInactive2 = 'Παρακαλώ επικοινωνήστε με τον διαχειριστή για την ενεργοποίηση του λογαριασμού σας';
$langAccountActivate = 'Ενεργοποίηση λογαριασμού χρήστη';
$langAccountActivateMessage = 'Ο φοιτητής με τα παρακάτω στοιχεία επιθυμεί την επανενεργοποίηση του λογαριασμού του:';
$langMyCoursesProf = "Τα $langsCourses που υποστηρίζω";
$langMyCoursesUser = "Τα $langsCourses που παρακολουθώ";
$langNoCourses = "Δεν υπάρχουν $langsCourses";
$langCourseCreate = "Δημιουργία $langsOfCourse";
$langCreationDate = 'Ημερομηνία δημιουργίας';
$langMoreCourseInfo = 'Περισσότερες πληροφορίες';
$langMyAgenda = 'Το ημερολόγιό μου';
$langMyAnnouncements = 'Οι ανακοινώσεις μου';
$langAdmin = 'Διαχείριση πλατφόρμας';
$langPass = 'Συνθηματικό (password)';
$langHelp = 'Βοήθεια';
$langSelection = 'Επιλογή';
$langSelect = "Επιλογή";
$langMenu = "Μενού";
$langLogout = "Έξοδος";
$langLogout2 = "Αποσύνδεση";
$langSupportForum = "Περιοχή Υποστήριξης";
$langInvalidAuth = "Λάθος τρόπος πιστοποίησης";
$langContact = 'Επικοινωνία';
$lang_forgot_pass = "Ξεχάσατε το συνθηματικό σας;";
$langMoreLogin = 'Περισσότερες επιλογές σύνδεσης';
$langViewMoreLogin = "Δείτε όλες τις επιλογές";
$langNewAnnounce = "Νέα!";
$langUnregUser = "Διαγραφή λογαριασμού";
$langListCourses = "$langCourses";
$langHierarchy = "Ιεραρχία $langOfFaculties";
$langAsynchronous = "Ομάδα Ασύγχρονης Τηλεκπαίδευσης";
$langUserLogin = "Σύνδεση";
$langAdminLoginPage = "Σύνδεση διαχειριστή";
$langLoginSSO = "Σύνδεση μέσω SSO λογαριασμού";
$langLoginSocialNetwork = "Σύνδεση μέσω κοινωνικών δικτύων";
$langLoginVia = "Σύνδεση μέσω";
$langWelcomeToPortfolio = "Καλωσορίσατε στο προσωπικό σας χαρτοφυλάκιο";
$langUnregCourse = "Απεγγραφή από $langsCourse";
$langUnCourse = "Απεγγραφή";
$langCourseCode = "$langCourse (Κωδικός)";
$langWelcomeStud = "Επιλέξτε «<strong>$langListCourses</strong>» για να παρακολουθήσετε τα διαθέσιμα ηλεκτρονικά $langsCourses.";
$langWelcomeProf = "Επιλέξτε «<strong>$langCourseCreate<strong>» για να δημιουργήσετε τα ηλεκτρονικά σας $langsCourses.";
$langWelcomeSelect = "Επιλέξτε";
$langWelcomeStudPerso = "«<strong>$langListCourses</strong>» για να παρακολουθήσετε τα διαθέσιμα ηλεκτρονικά $langsCourses.";
$langWelcomeProfPerso = "«<strong>$langCourseCreate</strong>» για να δημιουργήσετε τα ηλεκτρονικά σας $langsCourses.";
$langBasicOptions = "Βασικές Επιλογές";
$langUserOptions = "Επιλογές Χρήστη";
$langAdminOptions = "Επιλογές Διαχείρισης";
$langCourseOptions = "Επιλογές $langOfCourse";
$langAlternateLogin = "Εναλλακτική σύνδεση";
$langTooManyFails = "Έχετε κάνει πολλές αποτυχημένες προσπάθειες. Πρέπει να περιμένετε για ένα μικρό διάστημα μέχρι την επόμενη προσπάθεια.";
$langMyStats = "Τα στατιστικά μου";
$langCompactProfile = "Συνοπτικό προφίλ";
$langDoubleLoginLock = 'Συνδεθήκατε στην πλατφόρμα από κάποια άλλη συσκευή με
    τον ίδιο λογαριασμό. Η παράλληλη σύνδεση δεν επιτρέπεται, και έτσι ο τρέχων
    λογαριασμός σας έχει αποσυνδεθεί.';

/* * *********************************************************
 * install.php
 * ********************************************************* */
$langTitleInstall = "Οδηγός εγκατάστασης Open eClass";
$langWelcomeWizard = "Καλωσορίσατε στον οδηγό εγκατάστασης του Open eClass!";
$langInstallProgress = "Πορεία εγκατάστασης";
$langThisWizard = "Ο οδηγός αυτός:";
$langWizardHelp1 = "Θα σας βοηθήσει να ορίσετε τις ρυθμίσεις για τη βάση δεδομένων";
$langWizardHelp2 = "Θα σας βοηθήσει να ορίσετε τις ρυθμίσεις της πλατφόρμας";
$langWizardHelp3 = "Θα δημιουργήσει το αρχείο";
$langRequiredPHP = "Απαιτούμενα PHP modules";
$langOptionalPHP = "Προαιρετικά PHP modules";
$langOtherReq = "Άλλες απαιτήσεις συστήματος";
$langInstallBullet1 = "Μια βάση δεδομένων MySQL.";
$langInstallBullet3 = "Δικαιώματα εγγραφής στον κατάλογο όπου το Open eClass έχει αποσυμπιεστεί.";
$langCheckReq = "Έλεγχος προαπαιτούμενων για τη λειτουργία του Open eClass";
$langInfoLicence = "Tο Open eClass είναι ελεύθερη εφαρμογή και διανέμεται σύμφωνα με την άδεια <a href='https://www.gnu.org/licenses/old-licenses/gpl-2.0.html' target='_blank' aria-label='GNU General Public Licence - (opens in a new tab)'>GNU General Public Licence (GPL). </a><br />
                Παρακαλούμε διαβάστε την άδεια και κάνετε κλικ στο 'Αποδοχή'";
$langAccept = "Αποδοχή";
$langLater = 'Αργότερα';
$langEG = "π.χ.";
$langDBLogin = "Όνομα Χρήστη για τη Βάση Δεδομένων";
$langDBPassword = "Συνθηματικό για τη Βάση Δεδομένων";
$langMainDB = "Όνομα Βάσης Δεδομένων";
$langAllFieldsRequired = "όλα τα πεδία είναι υποχρεωτικά";
$langPrintVers = "Εκτυπώσιμη μορφή";
$langLocalPath = "Path του Open eClass στον εξυπηρετητή";
$langAdminEmail = "Email Διαχειριστή";
$langAdminName = "Όνομα Διαχειριστή";
$langAdminSurname = "Επώνυμο Διαχειριστή";
$langAdminLogin = "Όνομα Χρήστη του Διαχειριστή";
$langAdminPass = "Συνθηματικό του Διαχειριστή";
$langHelpDeskPhone = "Τηλέφωνο Helpdesk";
$langHelpDeskEmail = "Email Helpdesk";
$langCampusName = "Όνομα Πλατφόρμας";
$langSiteIntroText = "Εισαγωγικό Κείμενο";
$langInstituteShortName = "Όνομα Ιδρύματος - Οργανισμού";
$langInstituteShortNameSecondary = "Ιδρύμα - Οργανισμός";
$langInstituteName = "Website Ιδρύματος - Οργανισμού";
$langInstitutePostAddress = "Ταχ. Διεύθυνση";
$langLandingPageUrl = 'URL αρχικής σελίδας πλατφόρμας';
$langLandingPageName = 'Τίτλος αρχικής σελίδας πλατφόρμας';
$langWarnHelpDesk = "Εδώ αποστέλλονται αιτήσεις για λογαριασμό στην πλατφόρμα και άλλα αιτήματα χρηστών";
$langWarnAdminEmail = 'Χρησιμοποιείται ως διεύθυνση αποστολέα των μηνυμάτων ηλεκτρονικού ταχυδρομείου της πλατφόρμας';
$langDBSettingIntro = "Το πρόγραμμα εγκατάστασης θα δημιουργήσει την βάση δεδομένων της πλατφόρμας αν δεν υπάρχει.";
$langStep = "Βήμα";
$langBasicCfgSetting = "Βασικές ρυθμίσεις";
$langOptionalCfgSetting = "Προαιρετικές ρυθμίσεις";
$langDBSetting = "Ρυθμίσεις της MySQL";
$langMainLang = "Γλώσσα Πλατφόρμας";
$langLicense = "Άδεια Χρήσης";
$langLastCheck = "Τελευταίος έλεγχος";
$langRequirements = "Απαιτήσεις Συστήματος";
$langInstallEnd = "Ολοκλήρωση";
$langModuleNotInstalled = "Δεν είναι εγκατεστημένο";
$langReadHelp = "Διαβάστε περισσότερα";
$langWarnConfig = "Προσοχή! Το αρχείο <strong>config.php</strong> υπάρχει ήδη στο σύστημά σας! Το πρόγραμμα εγκατάστασης δεν πραγματοποιεί αναβάθμιση. Αν θέλετε να ξανατρέξετε την εγκατάσταση της πλατφόρμας, παρακαλούμε διαγράψτε το αρχείο config.php!";
$langWarnConfig1 = "Το αρχείο ρυθμίσεων config.php υπάρχει ήδη στο σύστημά σας.";
$langWarnConfig2 = "Αν θέλετε να εγκαταστήσετε την πλατφόρμα θα πρέπει να το διαγράψετε.";
$langInstallError = "Σφάλμα κατά την εγκατάσταση";
$langErrorConfig = "Παρουσιάστηκε σφάλμα!. Δεν είναι δυνατή η δημιουργία του αρχείου config.php Παρακαλούμε ελέγξτε τα δικαιώματα πρόσβασης στους υποκαταλόγους του Open eClass και δοκιμάστε ξανά την εγκατάσταση.";
$langBackStep3 = "Επιστροφή στο βήμα 3";
$langBackStep3_2 = "Επιστρέψτε στο βήμα 3 για να τα διορθώσετε.";
$langNotNeedChange = "Δεν χρειάζεται να το αλλάξετε";
$langNeedChangeDB = "αν υπάρχει ήδη κάποια Β.Δ. με το όνομα eclass αλλάξτε το";
$langWillWrite = "Τα παρακάτω θα γραφτούν στο αρχείο";
$langProtect = "Σημείωση: Για να προστατέψετε το Open eClass, αλλάξτε τα δικαιώματα πρόσβασης του config/config.php και επιτρέψτε μόνο ανάγνωση (CHMOD 444).";
$langInstallSuccess = "Η εγκατάσταση ολοκληρώθηκε με επιτυχία! Κάντε κλικ παρακάτω για να μπείτε στο Open eClass";
$langEnterFirstTime = "Είσοδος στο Open eClass";
$langCancelAndEnter = "Παράλειψη και Είσοδος";
$langSiteUrl = "URL της Πλατφόρμας";
$langInstall = "Εγκατάσταση του Open eClass";
$langphpMyAdminURL = "URL του phpMyAdmin";
$langSystemInfoURL = "URL του System Info";
$langAddOnStreaming = "Επιπρόσθετη λειτουργικότητα";
$langRequiredFieldUserRegistration = "Υποχρεωτικά πεδία κατά την εγγραφή χρηστών";
$langWarningInstall1 = "<strong>Προσοχή!</strong> Φαίνεται πως η επιλογή <em>register_globals</em> στο αρχείο <em>php.ini</em> είναι ενεργοποιημένη.
                        Για την ομαλή λειτουργία της πλατφόρμας και για λόγους ασφάλειας θα πρέπει να την απενεργοποιήσετε.";
$langWarningInstall2 = "<strong>Προσοχή!</strong> Φαίνεται πως η επιλογή <em>short_open_tag</em> στο αρχείο <em>php.ini</em> είναι ενεργοποιημένη.
                        Προτείνεται να την απενεργοποιήσετε.";
$langWarningInstall3 = "<strong>Προσοχή!</strong> Φαίνεται πως ο οδηγός εγκατάστασης δεν έχει δικαιώματα δημιουργίας του κατάλογου <strong>%s</strong>.<br/>Χωρίς δικαιώματα δημιουργίας, ο οδηγός εγκατάστασης δεν μπορεί να συνεχίσει. Παρακαλούμε διορθώστε τα δικαιώματα.<br><br>";
$langWarnInstallNotice1 = "Πιθανόν επίσης να χρειάζονται και κάποιες άλλες αλλαγές. Διαβάστε τις οδηγίες εγκατάστασης στο αρχείο";
$langWarnInstallNotice2 = " και ξανατρέξτε τον οδηγό εγκατάστασης.";
$langReviewSettings = "Τα στοιχεία που δηλώσατε εμφανίζονται παρακάτω. Σημειώστε ότι μπορείτε να αλλάξετε όλες τις παρακάτω ρυθμίσεις (καθώς και πολλές άλλες) μέσα από το διαχειριστικό εργαλείο της πλατφόρμας.";
$langToReq = "Η εγγραφή χρηστών θα γίνεται με αίτηση προς τον διαχειριστή της πλατφόρμας";
$langToReqOpen = "Οι χρήστες εγγράφονται ελεύθερα χωρίς έγκριση του διαχειριστή";
$langLDAPBaseDn = "Base DN του LDAP Εξυπηρέτη";
$langChooseLang = "Επιλογή Γλώσσας";
$langBeforeInstall1 = "Πριν προχωρήσετε στην εγκατάσταση διαβάστε τις ";
$langBeforeInstall2 = "Επίσης, γενικές οδηγίες για την πλατφόρμα μπορείτε να διαβάσετε ";
$langInstallInstr = "Οδηγίες Εγκατάστασης";
$langPHPVersion = "Έκδοση της PHP";
$lang_max_glossary_terms = "Δεν επιτρέπεται η εμφάνιση ορισμών όρων στις σελίδες $langsOfCourses, εφόσον ο συνολικός αριθμός όρων στο γλωσσάριο είναι μεγαλύτερος από:";
$langCaseInsensitiveUsername = "Χωρίς διάκριση πεζών/κεφαλαίων στο όνομα χρήστη";
$lang_email_verification_required = "Να ζητείται επιβεβαίωση του e-mail του $langOfUserS";
$lang_email_prevent_autoset_change = "Να μην επιτρέπεται η αλλαγή e-mail που έχει οριστεί αυτόματα κατά την πιστοποίηση";
$langEmailUpdatedAutomaticaly = 'Το e-mail σας ενημερώθηκε αυτόματα από το σύστημα πιστοποίησης σε "%s" (από "%s").';
$lang_am_prevent_autoset_change = "Να μην επιτρέπεται η αλλαγή αριθμού μητρώου που έχει οριστεί αυτόματα κατά την πιστοποίηση";
$lang_dont_mail_unverified_mails = "Να μην γίνεται αποστολή e-mail σε $langUsersS που δεν έχουν επιβεβαιώσει την ηλεκτρονική τους διεύθυνση";
$lang_email_from = "Τα emails θα στέλνονται από την προσωπική διεύθυνση αποστολέα των χρηστών";
$langEmailTransport = "Μέθοδος αποστολής μηνυμάτων";
$langEmailSMTPServer = 'Διακομιστής SMTP';
$langEmailSMTPPort = 'Θύρα SMTP';
$langEmailEncryption = 'Ασφαλής σύνδεση';
$langEmailSendmail = 'Εντολή sendmail';
$lang_dropbox_allow_student_to_student = "Να επιτρέπεται η ανταλλαγή μηνυμάτων $langsOfCourse μεταξύ $langsOfStudents στο υποσύστημα 'Ανταλλαγή Μηνυμάτων'";
$lang_dropbox_allow_personal_messages = "Να επιτρέπεται η ανταλλαγή προσωπικών μηνυμάτων στο υποσύστημα 'Ανταλλαγή Μηνυμάτων'";
$lang_login_form = "Οθόνη Σύνδεσης";
$lang_testimonials = "Αναφορές (testimonials)";
$lang_dont_display_courses_menu = "Να μην εμφανίζεται η λίστα $langsOfCourses";
$lang_dont_display_contact_menu = "Να μην εμφανίζονται τα στοιχεία επικοινωνίας";
$lang_dont_display_manual_menu = "Να μην εμφανίζονται τα εγχειρίδια";
$lang_dont_display_faq_menu = "Να μην εμφανίζονται οι 'Συχνές ερωτήσεις'";
$lang_dont_display_about_menu = "Να μην εμφανίζονται πληροφορίες για την πλατφόρμα";
$lang_dont_display_login_form = "Να μην εμφανίζεται η φόρμα σύνδεσης";
$lang_dont_display_login_link = "Να μην εμφανίζεται ο σύνδεσμος 'Σύνδεση'";
$lang_dont_display_login_testimonials = "Να μην εμφανίζεται στην αρχική σελίδα";
$lang_visible_in_homepage = "Να εμφανίζεται στην αρχική σελίδα";
$lang_invisible_in_homepage = "Να μην εμφανίζεται στην αρχική σελίδα";
$lang_display_login_form_and_image = "Εμφάνιση φόρμας σύνδεσης και εικόνων";
$lang_block_username_change = "Να μην επιτρέπεται να αλλάζουν οι χρήστες το 'όνομα χρήστη'";
$lang_block_duration_account = "Απενεργοποίηση λήξης λογαριασμών";
$lang_block_duration_alt_account = "Απενεργοποίηση λήξης λογαριασμών χρηστών που χρησιμοποιούν εναλλακτικό τρόπο πιστοποίησης";
$lang_message_block_duration_account = "Οι λογαριασμοί των χρηστών δεν λήγουν ποτέ.";
$lang_display_captcha = "Εμφάνιση κωδικού ασφαλείας κατά την εγγραφή χρηστών";
$lang_display_captcha_label = "Κωδικός ασφαλείας (CAPTCHA)";
$lang_display_captcha_unsupported = 'Για την ενεργοποίηση του κωδικού ασφαλείας, απαιτείται υποστήριξη γραμματοσειρών TrueType (TTF) από τη βιβλιοθήκη GD της PHP';
$lang_insert_xml_metadata = "Μετασχολιασμός αρχείων υποσυστήματος «Έγγραφα» σύμφωνα με το πρότυπο LOM";
$lang_enable_mobileapi = "Να επιτρέπεται η επικοινωνία με κινητές συσκευές (smartphones/tablets)";
$lang_course_multidep = "Να επιτρέπεται τα $langsCourses να ανήκουν σε πολλές $langsFaculties";
$lang_user_multidep = "Να επιτρέπεται η εγγραφή χρηστών σε πολλές $langsFaculties";
$lang_restrict_owndep = "Να μην επιτρέπεται η αλλαγή τμήματος από τους χρήστες";
$lang_restrict_teacher_owndep = "Να μην επιτρέπεται η δημιουργία $langsOfCourses από τους $langsTeachers στα τμήματα που δεν ανήκουν";
$lang_allow_teacher_clone_course = "Να επιτρέπεται η κλωνοποίηση $langsOfCourses από τους $langsTeachers";
$lang_enable_user_consent = "Ενεργοποίηση επιβεβαίωσης συμμετοχής των χρηστών στις συνεδρίες";
$lang_allow_rec_video = "Να επιτρέπεται η δημιουργία βιντεοσκοπημένου αρχείου στο $langsCourse";
$lang_allow_rec_audio = "Να επιτρέπεται η δημιουργία ηχογραφημένου αρχείου στο $langsCourse";
$lang_openCourse_inModal = "Να εμφανίζονται οι πληροφορίες του μαθήματος σε Modal (πλαίσιο) στα ανοικτά μαθήματα";
$lang_openCourse_inModal_Info = "Σε περίπτωση που δεν επιλέξετε αυτήν την επιλογή, οι πληροφορίες του μαθήματος θα εμφανίζονται σε καινούρια σελίδα.";
$lang_disable_log_actions = "Απενεργοποίηση καταγραφής ενεργειών";
$lang_disable_cron_jobs = "Απενεργοποίηση μηνιαίων ενεργειών στατιστικών";
$lang_disable_log_course_actions = "Απενεργοποίηση καταγραφής ενεργειών χρηστών μέσα στα $langsCourses";
$lang_disable_log_system_actions = "Απενεργοποίηση καταγραφής ενεργειών χρηστών εκτός $langsOfCourses";
$lang_disable_name_surname_change = "Να μην επιτρέπεται να αλλάζουν οι χρήστες το όνομα και το επώνυμο";
$lang_disable_email_change = "Να μην επιτρέπεται να αλλάζουν οι χρήστες το e-mail";
$lang_disable_am_change = "Να μην επιτρέπεται να αλλάζουν τον αριθμό μητρώου";
$langPossibleReasons = 'Πιθανοί λόγοι';
$langTroubleshooting = 'Αντιμετώπιση';
$langDefaultAdminName = 'Διαχειριστής Πλατφόρμας';
$langDefaultInstitutionName = 'Ακαδημαϊκό Διαδίκτυο GUNet';
$lang_course_metadata = "Μετασχολιασμός $langOfCourses";
$lang_opencourses_enable = "Υποστήριξη GUnet Open Courses";
$langHierarchyTestDepartment = 'Δοκιμαστικό Τμήμα';
$langHierarchyTestCategory = 'Δοκιμαστική Κατηγορία';
$langHierarchyTestSubCategory = 'Υποκατηγορία';
$langEmailSendWarn = 'Για την επιτυχή αποστολή ανακοινώσεων μέσω e-mail
    από την πλατφόρμα, θα πρέπει είτε να επιλέξετε μέθοδο αποστολής μηνυμάτων
    SMTP ή sendmail, είτε να ορίσετε τη διεύθυνση κοινοποίησης ανακοινώσεων.';

/* * ******************************************************
 * learnpath.php
 * ******************************************************* */
$langAddComment = "Προσθήκη / αλλαγή σχολίου";
$langLearningModule = "Ενότητα";
$langLearningObjects = "Εκπαιδευτικά Αντικείμενα";
$langLearningObject = "Εκπαιδευτικό Αντικείμενο";
$langLearningObjectsInUse = "Χρησιμοποιούμενα Εκπαιδευτικά Αντικείμενα";
$langLearningObjectsInUse_sort = "Αντικείμενα σε χρήση";
$langLearningPathStructure = "Ενότητες γραμμής μάθησης";
$langLearningPath = "Γραμμή μάθησης";
$langLearningPathConfigure = "Διαμόρφωση γραμμής μάθησης";
$langContents = "Περιεχόμενα";
$langLearningPathUploadFile = "Εντοπισμός θέσης του αρχείου γραμμής μάθησης στον Η/Υ σας (τοπικά)";
$langAddModulesButton = "Προσθήκη επιλεγμένων";
$langAddOneModuleButton = "Προσθήκη ενότητας";
$langAlertBlockingMakedInvisible = "Αυτή η ενότητα είναι φραγμένη. Κάνοντάς την αόρατη, θα επιτραπεί στους " . $langsOfStudentss . " η είσοδος στην επόμενη ενότητα χωρίς να χρειάζεται να ολοκληρώσουν την παρούσα. Επιβεβαιώστε την επιλογή σας";
$langAlertBlockingPathMadeInvisible = "Αυτή η γραμμή είναι φραγμένη. Κάνοντάς την μη ορατή θα επιτραπεί στους " . $langsOfStudentss . " η είσοδος στην επόμενη γραμμή χωρίς να χρειάζεται να ολοκληρώσουν την παρούσα. Επιβεβαιώστε την επιλογή σας";
$langAlreadyBrowsed = "Ολοκληρώθηκε";
$langCompleted = 'Ολοκληρώθηκε';
$langAltMakeNotBlocking = "Αποδέσμευση";
$langAltScorm = "Scorm";
$langAreYouSureDeleteModule = "Επιβεβαίωση διαγραφής της ενότητας";
$langAreYouSureToDeleteScorm = "H γραμμή μάθησης αποτελεί μέρος ενός πακέτου SCORM. Αν διαγράψετε αυτή τη γραμμή, όλες οι ενότητες που συμβαδίζουν με το SCORM και όλα τα σχετικά αρχεία θα διαγραφούν απο την πλατφόρμα. Σίγουρα θέλετε να διαγράψετε τη γραμμή μάθησης ";
$langAreYouSureToReplaceScorm = "H γραμμή μάθησης αποτελεί μέρος ενός πακέτου SCORM. Αν αντικαταστήσετε αυτή τη γραμμή, όλες οι ενότητες που συμβαδίζουν με το SCORM, τα στατιστικά για την απόδοση των $langsOfStudents και όλα τα σχετικά αρχεία θα διαγραφούν απο την πλατφόρμα. Σίγουρα θέλετε να αντικαταστήσετε τη γραμμή μάθησης ";
$langAreYouSureToRemove = "Σίγουρα θέλετε να αφαιρέσετε την παρακάτω ενότητα από τη γραμμή μάθησης: ";
$langAreYouSureToRemoveLabel = "Διαγράφοντας μία ενότητα θα διαγραφούν και όλες οι ενότητες που περιέχει.";
$langAreYouSureToRemoveSCORM = "Ενότητες σύμφωνες με το SCORM θα αφαιρεθούν οριστικά, όταν διαγράψετε τη γραμμή μάθησης.";
$langAreYouSureToRemoveStd = "Η ενότητα θα παραμείνει διαθέσιμη στην ομάδα των ενοτήτων.";
$langBackModule = "Επιστροφή στη γραμμή μάθησης";
$langBackToLPAdmin = "Επιστροφή στη διαχείριση της γραμμής μάθησης";
$langBlock = "Φραγή";
$langNoBlock = "Μη φραγή";
$langRestrictedLPath = "Για την παρακολούθηση αυτής της Γραμμής Μάθησης καθώς και των επακόλουθων, θα πρέπει να έχει προηγηθεί η παρακολούθηση των ανωτέρων";
$langBrowserCannotSeeFrames = "Ο browser σας δεν αναγνωρίζει frames.";
$langChangeRaw = "Αλλαγή του ελάχιστου αρχικού σημείου για να περάσει αυτή η ενότητα (ποσοστό): ";
$langChat = "Συνομιλία";
$langConfirmYourChoice = "Παρακαλώ επιβεβαιώστε την επιλογή σας";
$langCourseDescription = "Πληροφορίες";
$langCourseDescriptionAsModule = "Χρήση Πληροφοριών $langOfCourse";
$langCourseDescriptionAsModuleLabel = "Πληροφοριών $langOfCourse";
$langCourseHome = "Αρχική σελίδα $langsOfCourse";
$langCreateLabel = "Δημιουργία ετικέτας";
$langCreateNewLearningPath = "Δημιουργία νέας γραμμής μάθησης";
$langDOCUMENTTypeDesc = "Έγγραφο";
$langDefaultLearningPathComment = "Εισαγωγικό κείμενο της γραμμής μάθησης.";
$langDefaultModuleAddedComment = "Πρόσθετο εισαγωγικό κείμενο σχετικά με την παρουσία της ενότητας στη γραμμή μάθησης.";
$langDefaultModuleComment = "Εισαγωγικό κείμενο της ενότητας. Θα εμφανίζεται σε κάθε γραμμή μάθησης που θα περιέχει αυτή την ενότητα";
$langInstructions = "Οδηγίες";
$langModuleComment_inCurrentLP = "<u>Μόνο</u> για τη συγκεκριμένη γρ. μάθησης";
$langModuleComment_inCourse = "Εμφανίζεται με την <u>επαναχρησιμοποίηση</u> του αντικειμένου σε άλλη γραμμή μάθησης";
$langDescriptionCours = "Περιγραφή $langsOfCourse";
$langDocumentAsModule = "Χρήση Εγγράφου";
$langDocumentAsModuleLabel = "Εγγράφου";
$langDocumentInModule = "Έγγραφο σε ενότητα";
$langEXERCISETypeDesc = "Άσκηση πλατφόρμας";
$langEndOfSteps = "Κάντε κλικ στη λήξη αφού ολοκληρώσετε το τελευταίο βήμα.";
$langErrorAssetNotFound = "Το στοιχείο δεν βρέθηκε: ";
$langErrorCopyAttachedFile = "Δεν είναι δυνατή η αντιγραφή αρχείου: ";
$langErrorCopyScormFiles = "Σφάλμα κατά την αντιγραφή των αρχείων SCORM";
$langErrorCopyingScorm = "Σφάλμα αντιγραφής περιεχομένου SCORM";
$langErrorCreatingDirectory = "Δεν είναι δυνατή η δημιουργία καταλόγου: ";
$langErrorCreatingFile = "Δεν είναι δυνατή η δημιουργία αρχείου: ";
$langErrorCreatingFrame = "Δεν είναι δυνατή η δημιουργία στα πλαίσια του αρχείου ";
$langErrorCreatingManifest = "Δεν είναι δυνατή η δημιουργία του αρχείου imsmanifest.xml";
$langErrorCreatingScormArchive = "Δεν είναι δυνατή η δημιουργία του καταλόγου αρχείων SCORM/IMSCP ";
$langErrorEmptyName = "Το όνομα πρέπει να συμπληρωθεί";
$langErrorFileMustBeZip = "Το αρχείο πρέπει να είναι σε μορφή αρχείου .zip";
$langErrorInvalidParms = "Σφάλμα: μη έγκυρη παράμετρος (χρησιμοποιήστε μόνο αριθμούς)";
$langErrorNameAlreadyExists = "Σφάλμα: Το όνομα υπάρχει ήδη στη γραμμή μάθησης ή στο σύνολο των ενοτήτων ";
$langErrorNoModuleInPackage = "Δεν υπάρχει ενότητα στο πακέτο";
$langErrorOpeningManifest = "Δεν μπορεί να βρεθεί το αρχείο <i>manifest</i> στο πακέτο.<br /> Αρχείο που δε βρέθηκε: imsmanifest.xml";
$langErrorOpeningXMLFile = "Δεν μπορεί να βρεθεί το δευτερεύον αρχείο έναρξης στο πακέτο.<br /> Αρχείο που δε βρέθηκε: ";
$langErrorReadingManifest = "Σφάλμα ανάγνωσης αρχείου <i>manifest</i>";
$langErrorValidatingManifest = "Το αρχείο <i>manifest</i> περιέχει σφάλματα: ";
$langErrorReadingXMLFile = "Σφάλμα ανάγνωσης δευτερεύοντος αρχείου ρύθμισης έναρξης: ";
$langErrorReadingZipFile = "Σφάλμα ανάγνωσης αρχείου zip.";
$langErrorSql = "Σφάλμα στη δήλωση SQL";
$langErrorValuesInDouble = "Σφάλμα: μία ή δύο τιμές είναι διπλές";
$langErrortExtractingManifest = "Δεν μπορεί να εμφανιστεί απόσπασμα από το αρχείο zip.";
$langExIncompatibleWithLP = "Αυτή η άσκηση περιέχει ερωτήσεις τύπου \"Ελεύθερου Κειμένου\" ο οποίος δεν είναι συμβατός με το υποσύστημα της γραμμής μάθησης";
$langExercise = "Άσκηση";
$langExerciseAsModule = "Χρήση Άσκησης";
$langExerciseAsModuleLabel = "Άσκησης";
$langExerciseCancelled = "Η άσκηση ακυρώθηκε.";
$langExerciseDone = "Η άσκηση ολοκληρώθηκε.";
$langExerciseInModule = "Ασκηση στην ενότητα";
$langExercises = "Ασκήσεις";
$langExport = "Εξαγωγή";
$langExport2004 = "Εξαγωγή σε SCORM 2004";
$langExport12 = "Εξαγωγή σε SCORM 1.2";
$langExportIMSCP = "Εξαγωγή σε IMS CP 1.1.4";
$langFailed = "Ολοκληρώθηκε ανεπιτυχώς";
$langFileScormError = "Το αρχείο που θα ενημερωθεί δεν είναι έγκυρο.";
$langFileName = "Αρχείο";
$langHtmlFile = "Όνομα html αρχείου";
$langFullScreen = "Πλήρης οθόνη ";
$langNewTab = "Νέο Παράθυρο";
$langGlobalProgress = "Πρόοδος της γραμμής μάθησης: ";
$langImport = "Εισαγωγή";
$langInFrames = "Σε πλαίσια";
$langInfoProgNameTitle = "Πληροφορία";
$langInsertMyDescToolName = "Εισαγωγή πληροφοριών $langsOfCourse";
$langInsertMyDocToolName = "Εισαγωγή εγγράφου";
$langInsertMyExerciseToolName = "Εισαγωγή άσκησης";
$langInsertMyLinkToolName = "Εισαγωγή συνδέσμου";
$langInsertMyMediaToolName = "Εισαγωγή πολυμέσου";
$langInsertMyModuleToolName = "Εισαγωγή ενότητας";
$langInsertMyModulesTitle = "Επαναχρησιμοποίηση ενότητας του $langsOfCourse";
$langInsertNewModuleName = "Νέο όνομα";
$langInstalled = "Η εισαγωγή της γραμμής μάθησης ολοκληρώθηκε με επιτυχία!";
$langIntroLearningPath = "Χρησιμοποήστε αυτό το εργαλείο για να παράσχετε στους " . $langsOfStudentss . " μια γραμμή μάθησης μεταξύ εγγράφων, ασκήσεων, σελίδες HTML, συνδέσεις κ.λπ.<br /><br />Εάν επιθυμείτε να παρουσιάσετε στους " . $langsOfStudentss . " τη γραμμή μάθησής σας, κάντε κλικ παρακάτω.<br />";
$langLastName = "Επίθετο";
$langLastSessionTimeSpent = "Τελευταία χρονική συνεδρία";
$langLearningPaths = "Γραμμές μάθησης";
$langLearningPath1 = "γραμμής μάθησης";
$langLearningPathEmpty = "Η γραμμή μάθησης είναι κενή";
$langLearningPathImportFromDocuments = "Εισαγωγή γραμμής μάθησης από τα έγγραφα";
$langLearningPathList = "Διαθέσιμες γραμμές μάθησης";
$langLearningPathData = "Στοιχεία γραμμής μάθησης";
$langLearningObjectData = "Στοιχεία Εκπαιδευτικού Αντικείμενου";
$langLearningPathNotFound = "Η γραμμή μάθησης δεν βρέθηκε ";
$langLessonStatus = "Κατάσταση ενότητας";
$langLinkAsModule = "Χρήση Συνδέσμου";
$langLinkAsModuleLabel = "Συνδέσμου";
$langInsertedAsModule = "Προστέθηκε σαν ενότητα στη γραμμή μάθησης";
$langLogin = "Είσοδος";
$langMaxFileSize = "Μέγιστο μέγεθος αρχείου: ";
$langMaxFileSizeExceeded = 'Το μέγεθος του αρχείου υπερβαίνει το μέγιστο επιτρεπτό όριο.';
$langAlreadyUsed = "Χρησιμοποιείται ήδη σαν ενότητα στη γραμμή μάθησης";
$langMediaAsModule = "Χρήση Πολυμέσου";
$langMediaAsModuleLabel = "Πολυμέσου";
$langMediaTypeDesc = "Πολυμέσο";
$langMinuteShort = "ελαχ.";
$langModuleMoved = "Μετακίνηση ενότητας";
$langModuleOfMyCourse = "Πόρου από ενότητα";
$langModuleOfMyCourseLabel = "Ετικέτας του $langsOfCourse";
$langModuleOfMyCourseLabel_onom = "Ετικέτα του $langsOfCourse";
$langModuleStillInPool = "Σημειώστε ότι οι ενότητες αυτής της γραμμής θα είναι ακόμα διαθέσιμες στο σύνολο των ενοτήτων";
$langModulesPoolToolName = "Σύνολο ενοτήτων";
$langMyCourses = "Τα $langsCourses μου";
$langNeverBrowsed = "Δεν έχει ολοκληρωθεί";
$langNewLabel = "Δημιουργία νέου κεφαλαίου";
$langLabel = "Ετικέτα";
$langLabel2 = "Ετικέτας";
$langNext = "Επόμενο";
$langNextPage = "Επόμενη Σελίδα";
$langNoEmail = "Δεν έχει οριστεί email";
$langNoLearningPath = "Δεν υπάρχουν γραμμές μάθησης";
$langNoModule = "Δεν έχουν χρησιμοποιηθεί εκπαιδευτικά αντικείμενα";
$langNoMoreModuleToAdd = "Όλες οι ενότητες αυτού του $langsOfCourse ήδη χρησιμοποιήθηκαν σε αυτή τη γραμμή μάθησης.";
$langNoStartAsset = "Δεν υπάρχει κανένα απόκτημα/στοιχείο έναρξης που να ορίζεται για αυτή την ενότητα.";
$langNotAttempted = "Δεν έχει επιχειρηθεί";
$langNotInstalled = "Σφάλμα! Η εισαγωγή της γραμμής μάθησης απέτυχε.";
$langOkChapterHeadAdded = "Ο τίτλος προστέθηκε: ";
$langOkDefaultCommentUsed = "Σημείωση: Η γραμμή μάθησης δεν έχει περιγραφή.";
$langOkDefaultTitleUsed = "Σημείωση: Η γραμμή μάθησης δεν έχει όνομα.";
$langOkFileReceived = "Διαβάστηκε το αρχείο: ";
$langOkManifestFound = "Η ανακοίνωση βρέθηκε σε αρχείο zip: ";
$langOkManifestRead = "H ανακοίνωση διαβάστηκε.";
$langOkModuleAdded = "Προσθήκη ενότητας: ";
$langOrder = "Εντολή ";
$langOtherCourses = "Λίστα $langOfCourses";
$langPassed = "Ολοκληρώθηκε με επιτυχία";
$langPathContentTitle = "Περιεχόμενο γραμμής μάθησης";
$langPathsInCourseProg = "Πρόοδος $langsOfCourse ";
$langPeriodDayShort = "μ.";
$langPeriodHourShort = "ω.";
$langPersoValue = "Αξιολόγηση";
$langPlatformAdministration = "Διαχείριση Πλατφόρμας";
$langPrevious = "Προηγούμενο";
$langPreviousPage = "Προηγούμενη Σελίδα";
$langProgInModuleTitle = "Η πρόοδός σας σε αυτή την ενότητα";
$langQuitViewer = "Επιστροφή στη λίστα";
$langRawHasBeenChanged = "Ο ελάχιστος βαθμός για προαγωγή έχει αλλαχθεί";
$langSCORMTypeDesc = "SCORM προσαρμοσμένο περιεχόμενο";
$langScormIntroTextForDummies = "Τα εισαγόμενα πακέτα πρέπει να αποτελούνται από ένα αρχείο zip και να είναι συμβατά με <strong>SCORM 2004</strong> ή  <strong>SCORM 1.2</strong> ή <strong>IMS CP 1.1.4</strong>";
$langScormEmptyDocsList = "Ανεβάστε πακέτα SCORM στα έγγραφα του $langsOfCourse ώστε να σας εμφανιστεί η αντίστοιχη επιλογή εισαγωγής τους";
$langSecondShort = "δευτ.";
$langStartModule = "Έναρξη ενότητας";
$langStatsOfLearnPath = "Παρακολούθηση γραμμής μάθησης";
$langTrackAllPath = "Παρακολούθηση γραμμών μάθησης";
$langSwitchEditorToTextConfirm = "Η εντολή θα αφαιρέσει την τρέχουσα διάταξη κειμένου. Θέλετε να συνεχίσετε;";
$langTextEditorDisable = "Απενεργοποίηση επεξεργαστή κειμένου";
$langTextEditorEnable = "Ενεργοποίηση επεξεργαστή κειμένου";
$langTimeInLearnPath = "Χρόνος στη γραμμή μάθησης";
$langTo = "στο";
$langTotalTimeSpent = "Σύνολο χρόνου";
$langTrackAllPathExplanation = "Αναφορές προόδου";
$langTrackAllPathExplanationAnalysis = "Αναλυτικές αναφορές πρόοδου";
$langTrackUser = "Πρόοδος " . $langOfStudent;
$langTracking = "Αναφορά Προόδου";
$langTypeOfModule = "Τύπος ενότητας";
$langUnamedModule = "Ενότητα χωρίς όνομα";
$langUnamedPath = "Γραμμή χωρίς όνομα";
$langUseOfPool = "Μπορείτε να δείτε όλες τις διαθέσιμες ενότητες στο $langsCourse. <br>Αν ένας εκπαιδευτικός πόρος έχει προστεθεί στη γραμμή μάθησης εμφανίζεται παρακάτω.";
$langViewShow = "Εμφάνιση";
$langViewHide = "Απόκρυψη";
$langViewMode = "Παρουσίαση τρόπου";
$langVisibility = "Ορατό / Αόρατο";
$langVisibleVals = array('Αόρατο', 'Ορατό');
$langWork = "Εργασίες " . $langOfStudents;
$langWrongOperation = "Λανθασμένη λειτουργία";
$langYourBestScore = "Η καλύτερή σου βαθμολογία";
$langimportLearningPath = "Εισαγωγή γραμμής μάθησης";
$langScormErrorExport = "Σφάλμα κατά την εξαγωγή του πακέτου SCORM";
$langLPViewerToggleLeftTOC = "Εναλλαγή εμφάνισης περιεχομένων";
$langLearnPathDeleted = 'Η γραμμή μάθησης διαγράφηκε';
$langZipError = "Το αρχείο δεν μπόρεσε να αποσυμπιεστεί";
$langLearningPathCleanAttempt = "Ξεκινήστε από την αρχή στην επόμενη προσπάθεια";
$langConfirmLpCleanAttemptTitle = "Επιβεβαίωση επανεκκίνησης επόμενης προσπάθειας";
$langConfirmLpCleanAttemptBody = "Με την επιλογή αυτή η επόμενη προσπάθεια στη Γραμμή Μάθησης <u>δεν</u> θα χρησιμοποιήσει τα αποθηκευμένα δεδομένα για συνέχεια από το σημείο που την αφήσατε την τελευταία φορά.<br/><br/><em>Ακυρώστε</em> την επιλογή σας αν <u>δεν</u> επιθυμείτε να ξεκινήσετε από την αρχή την επόμενη προσπάθεια";
$langShowResults = "Εμφάνιση αποτελεσμάτων";
$langDistribute = "Διαμοιρασμός";
$langCancelDistribute = "Ακύρωση διαμοιρασμού";
$langCorrectByQuestion = "Διόρθωση ανά ερώτηση";
$langDistributionSuccess = "Ο διαμοιρασμός της άσκησης έγινε";
$langCancelDistributionSuccess = "Η ακύρωση του διαμοιρασμού έγινε.";
$langUpdateFailure = "Η ενημέρωση απέτυχε, παρακαλώ προσπαθήστε ξανά.";
$langUpdateSuccess = "Ο βαθμός καταχωρήθηκε.";
$langDistributeExercise = "Διαμοιρασμός αβαθμολόγητων απαντήσεων ανοιχτού τύπου.";
$langNextAnswer = "Επόμενη απάντηση";
$landQuestionsInExercise = "Ερωτήσεις ανοιχτού τύπου στην άσκηση";
$langCorrectionMethod = "Επιλέξτε τρόπο διόρθωσης της άσκησης";
$langExerciseNumber = "Αριθμός ασκήσεων";
$langOpenQuestionTitle = "Τίτλος ερώτησης";
$langOpenQuestionPageTitle ="Επιλέξτε την ερώτηση ανοιχτού τύπου που θέλετε να βαθμολογήσετε";
$langCorrectionMessage = "Με την επιλογή 'Διόρθωση' μπορείτε να διορθώσετε αβαθμολόγητες απαντήσεις των ερωτήσεων ανοιχτού τύπου. Επιλέξτε 'Ακύρωση' για να επιστρέψετε στην κεντρική σελίδα.";
$langTableFreeText = "Ποσοστό επιτυχίας ερωτήσεων ανοιχτού τύπου";
$langQuestionCorrectionTitle = "Βαθμολογήστε την απάντηση και επιλέξτε 'Υποβολή' για να προχωρήσετε στην επόμενη αβαθμολόγητη απάντηση. ";
$langQuestionCorrectionTitle2 = "Υπολείπονται ";
$langUngradedAnswers = " αβαθμολόγητες απαντήσεις.";
$langDistributeError = "Ο συνολικός αριθμός διαμοιρασμού δεν πρέπει να είναι μεγαλύτερος από το σύνολο των ασκήσεων.";
$langGradeCorrect = 'Διόρθωση';

/* * ***********************************************
 * lessontools.php
 * ************************************************ */
$langActiveTools = "Ενεργά εργαλεία";
$langAdministrationTools = "Διαχείριση $langsOfCourse";
$langAdministratorTools = "Εργαλεία διαχειριστή";
$langCourseTools = "Εργαλεία $langsOfCourse";

/* * ************************************************
 * link.php
 * ************************************************* */
$langLinks = "Σύνδεσμοι";
$langListDeleted = "Ο κατάλογος έχει διαγραφεί";
$langLinkMod = "Ο σύνδεσμος τροποποιήθηκε";
$langLinkModify = "Αλλαγή σύνδεσμου";
$langLinkDeleted = "Ο σύνδεσμος διαγράφηκε";
$langLinkName = "Όνομα συνδέσμου";
$langLinkAdd = "Προσθήκη συνδέσμου";
$langLinkAdded = "Ο σύνδεσμος προστέθηκε";
$langLinksAdded = "Οι σύνδεσμοι προστέθηκαν";
$langLinkNotPermitted = "Άκυρη μορφή συνδέσμου";
$langLinkDelconfirm = "Θέλετε να διαγράψετε τον σύνδεσμο;";
$langCategoryName = "Όνομα κατηγορίας";
$langCategoryAdd = "Προσθήκη κατηγορίας";
$langCategoryAdded = "Η κατηγορία προστέθηκε";
$langCategoryMod = "Αλλαγή κατηγορίας";
$langCategoryModded = "Η κατηγορία άλλαξε";
$langCategoryDel = "Διαγραφή κατηγορίας";
$langCategoryDeleted = "Η κατηγορία διαγράφηκε μαζί με όλους τους συνδέσμους της";
$langCategoryDeletedGlossary = "Η κατηγορία διαγράφηκε. Οι όροι που ανήκαν σε αυτή είναι πλέον μη κατηγοριοποιημένοι.";
$langCatDel = "Οταν διαγράψετε μια κατηγορία, θα διαγραφούν όλοι οι σύνδεσμοι της κατηγορίας. Είστε βέβαιος ότι θέλετε να διαγράψετε την κατηγορία;";
$langAllCategoryDel = "Διαγραφή όλων των καταλόγων και όλων των συνδέσμων";
$langAllCategoryDeleted = "Όλες οι κατηγορίες και όλοι οι σύνδεσμοι έχουν διαγραφεί";
$langGiveURL = "Δώστε το URL του συνδέσμου";
$langGiveCategoryName = "Όνομα κατηγορίας";
$langNoCategory = "Γενικοί σύνδεσμοι";
$langNoLinkInCategory = "Δεν υπάρχουν σύνδεσμοι σε αυτή την κατηγορία";
$langNoLinkCategories = "Δεν υπάρχουν κατηγορίες συνδέσμων";
$langCategorisedLinks = "Κατηγορίες συνδέσμων";
$langProfNoLinksExist = "Μπορείτε να χρησιμοποιήσετε τις λειτουργίες του εργαλείου για να προσθέσετε συνδέσμους.";
$langNoLinksExist = "Δεν υπάρχουν σύνδεσμοι!";
$langEmptyLinkURL = "Δεν πληκτρολογήσατε το URL του συνδέσμου";
$langLinkSettings = "Ρυθμίσεις υποσυστήματος συνδέσμων";
$langLinkSettingsSucc = "Οι ρυθμίσεις αποθηκεύθηκαν επιτυχώς";
$langSocialBookmarksFunct = "Λειτουργικότητα συλλογικών συνδέσμων";
$langSocialCategory = "Συλλογικοί σύνδεσμοι";
$langLinkNotOwner = "Αποτυχία! Δεν είστε ο δημιουργός αυτού του συνδέσμου";
$langLinkSubmittedBy = "υποβλήθηκε από τον χρήστη";

/* * ***************************************************************
 * lostpass.php
 * *************************************************************** */
$langFaqAnswer = "Απάντηση";
$lang_remind_pass = 'Ορισμός νέου συνθηματικού';
$lang_pass_intro = '<p>Αν έχετε ξεχάσει τα στοιχεία του λογαριασμού σας, συμπληρώστε το <em>όνομα χρήστη</em>
και την διεύθυνση ηλεκτρονικού ταχυδρομείου με την οποία είστε εγγεγραμμένος
(<em>προσοχή: αυτή που έχετε δηλώσει στην πλατφόρμα</em>).</p> <p>Στη συνέχεια θα παραλάβετε ένα μήνυμα σε αυτή τη
διεύθυνση με οδηγίες για να αλλάξετε το συνθηματικό σας.</p>';
$langPassResetIntro = "
Έχει ζητηθεί να οριστεί νέο συνθηματικό πρόσβασης σας στην
πλατφόρμα τηλεκπαίδευσης $siteName.";
$langPassResetIntro2 = "Αν δεν ζητήσατε εσείς αυτή την ενέργεια,
απλώς αγνοήστε τις οδηγίες αυτού του μηνύματος και αναφέρετε το γεγονός αυτό
στο διαχειριστή του συστήματος, στην διεύθυνση: ";
$langHowToResetTitle = "Οδηγίες ορισμού νέου συνθηματικού";

$langPassResetGoHere = "
Για να ορίσετε νέο συνθηματικό πηγαίνετε στην παρακάτω διεύθυνση.
Αν δεν μπορείτε να μεταβείτε κάνοντας κλικ πάνω στη διεύθυνση αυτή, αντιγράψτε
την στη μπάρα διευθύνσεων του φυλλομετρητή σας. Η διεύθυνση αυτή έχει ισχύ
μίας (1) ώρας. Πέραν αυτού του χρονικού ορίου θα πρέπει να κάνετε από την αρχή
τη διαδικασία ορισμού νέου συνθηματικού.
";

$langAccountResetSuccess1 = "Ο ορισμός νέου συνθηματικού σας έχει ολοκληρωθεί";
$langAccountResetInvalidLink = "Ο σύνδεσμος που ακολουθήσατε δεν ισχύει πλέον. Παρακαλούμε επαναλάβετε από την αρχή την διαδικασία.";
$langAccountEmailError1 = "Παρουσιάστηκε σφάλμα κατά την αποστολή των στοιχείων σας";
$langAccountEmailError2 = "Δεν ήταν δυνατή η αποστολή των οδηγιών ορισμού νέου συνθηματικού στη διεύθυνση";
$langAccountEmailError3 = 'Αν χρειαστεί, μπορείτε να επικοινωνήσετε με τους διαχειριστές της πλατφόρμας στη διεύθυνση';
$lang_pass_email_ok = 'Τα στοιχεία του λογαριασμού σας βρέθηκαν και στάλθηκαν
	μέσω ηλεκτρονικού ταχυδρομείου στη διεύθυνση';
$langAccountNotFound = "Δε βρέθηκε λογαριασμός στην πλατφόρμα με τα στοιχεία που δώσατε. Αν παρ' όλα αυτά είστε σίγουρος/η ότι έχετε ήδη λογαριασμό, παρακαλούμε επικοινωνήστε με τους διαχειριστές της πλατφόρμας";
$lang_email = "e-mail";
$lang_username = "Όνομα χρήστη";
$langPassCannotChange1 = "Το συνθηματικό του λογαριασμού δεν μπορεί να αλλαχθεί.";
$langPassCannotChange2 = "Ο λογαριασμός αυτός πιστοποιείται με";
$langPassCannotChange3 = "Παρακαλούμε επικοινωνήστε με τον διαχειριστή της πλατφόρμας στη διεύθυνση";
$langPassCannotChange4 = "για περισσότερες πληροφορίες.";
$langLostPassPending = "Έχετε κάνει ήδη προσπάθεια ανάκτησης του συνθηματικού μέσα στην τελευταία ώρα. Παρακαλούμε προσπαθήστε αργότερα.";

/* * ****************************************************
 * manual.php
 * ***************************************************** */
$langFinalDesc = "Αναλυτική Περιγραφή $siteName";
$langShortDesc = "Σύντομη Περιγραφή $siteName";
$langManS = "Εγχειρίδιο $langOfStudent";
$langManT = "Εγχειρίδιο $langOfTeacher";
$langVideoManS = "Οδηγοί $langOfStudent";
$langVideoManT1 = "Οδηγοί $langOfTeacher (μέρος 1ο)";
$langVideoManT2 = "Οδηγοί $langOfTeacher (μέρος 2ο)";
$langVideoManT3 = "Οδηγοί $langOfTeacher (μέρος 3ο)";
$langOr = "ή";
$langOrYet = "ή ακόμη";
$langor =  "η";
$langNote = "Σημείωση";
$langAcrobat = "Για να διαβάσετε τα αρχεία PDF μπορείτε να χρησιμοποιήσετε το %sπρόγραμμα Acrobat Reader%s ή άλλα %sελεύθερα διαθέσιμα προγράμματα που θα βρείτε εδώ%s.";
$langTutorials = "Οδηγοί";
$langTut = "Οδηγός";
$langScormVideo = "Βιντεοπαρουσίαση";
$langIntroToCourse = "Γνωριμία με το Ηλεκτρονικό $langCourse";
$langForumParticipation = 'Συμμετοχή σε Περιοχές Συζητήσεων';
$langAdministratorCourse = "Διαχείριση Ηλεκτρονικού $langOfCourse";
$langAdministratorForum = 'Διαχείριση Περιοχών Συζητήσεων';
$langAdministratorGroup = 'Διαχείριση Ομάδων Εκπαιδευόμενων';
$langCreateAccount = "Δημιουργία Λογαριασμού";
$langAllTutorials = "Γενικοί οδηγοί";
$langVideoTutorials = "Βίντεο - Οδηγοί";
$langOnlyInEnglish = "Μόνο στα Αγγλικά";

/* * *******************************************************
 * courses.php
 * ******************************************************* */
$langSelectFac = "Επιλογή $langOfFaculty";
$listtomeis = "Τομείς";
$langDepartmentsList = "Ακολουθεί ο κατάλογος τμημάτων του ιδρύματος.
	Επιλέξτε οποιοδήποτε από αυτά για να δείτε τα διαθέσιμα σε αυτό $langsCourses.";
$langWrongPassCourse = "Λάθος συνθηματικό $langsOfCourse";
$langAvCourses = "διαθέσιμα $langsCourses";
$langAvCours = "διαθέσιμο $langsCourse";
$m['open'] = "Ανοικτά $langsCourses (Ελεύθερη Πρόσβαση)";
$m['closed'] = "Κλειστά $langsCourses";
$langMaxGrade = 'Μέγιστη βαθμολογία';
$m['legend'] = 'Υπόμνημα';
$langNoCourses = "Δεν υπάρχουν διαθέσιμα $langsCourses στην συγκεκριμένη κατηγορία!";
$m['code'] = "Συνθηματικό $langsOfCourse";
$m['mailprof'] = "Για να εγγραφείτε στο $langsCourse θα πρέπει να στείλετε mail στον διδάσκοντα του $langsOfCourse
κάνοντας κλικ";
$langWarningUnsub = "Το $langsCourse είναι κλειστό και δεν θα μπορέσετε να επανεγγραφείτε.";
$langMyPersoAnnouncements = "Οι τελευταίες μου ανακοινώσεις";
$langMyPersoMessages = "Τα τελευταία μου μηνύματα";
$langAssignment = "Εργασία";
$langAssignmentParticipation = "Συμμετοχή σε Εργασία";
$langAssignmentStartHelpBlock = "Κάντε κλικ για να ορίσετε μια διαφορετική (μελλοντική) Ημερομηνία Εναρξης Εργασίας";
$langAssignmentEndHelpBlock = "Κάντε κλικ για να ορίσετε μία προθεσμία υποβολής";
$langAssignmentFeedbackReleaseHelpBlock = "Κάντε κλικ για να ορίσετε μία προθεσμία αποτελεσμάτων";
$langDeadline = "Λήξη";
$langNoEventsExist = "Δεν υπάρχουν γεγονότα";
$langNoAssignmentsExist = "Δεν υπάρχουν εργασίες προς παράδοση";
$langNoAnnouncementsExist = "Δεν υπάρχουν ανακοινώσεις";
$langNoDocsExist = "Δεν υπάρχουν έγγραφα";
$langNoPosts = "Δεν υπάρχουν αποστολές στις περιοχές συζητήσεων";
$langNotEnrolledToLessons = "Δεν έχετε εγγραφεί σε $langsCourses";
$langMore = "περισσότερα";
$langSender = "Από";
$langUnknown = "μη ορισμένη";
$langDuration = "Διάρκεια";
$langClassic = "Συνοπτικό";
$langModern = "Αναλυτικό";
$langFavorite = "Αγαπημένο";

/* * *********************************************************
 * forum.php
 * ********************************************************** */
$langAdm = "Διαχείριση";
$langCatForumAdmin = "Διαχείριση κατηγοριών";
$langForumAdmin = "Διαχείριση περιοχών συζητήσεων";
$langEditDel = "αλλαγή/διαγραφή";
$langSeen = "Το έχουν δει";
$langLastMsg = "Τελευταίο μήνυμα";
$langLoginBeforePost1 = "Για να στείλετε μηνύματα, ";
$langLoginBeforePost2 = "πρέπει προηγουμένως να ";
$langLoginBeforePost3 = "κάνετε login στην πλατφόρμα";
$langPages = "Σελίδες";
$langNoForums = "Δεν υπάρχουν διαθέσιμες περιοχές συζητήσεων";
$langNoForumsCat = "Δεν υπάρχουν περιοχές συζητήσεων σε αυτή την κατηγορία.";
$langNewTopic = "Νέο θέμα";
$langTopicStored = "Το θέμα δημιουργήθηκε";
$langTopicDeleted = "Το θέμα διαγράφηκε";
$langTopicData = "Στοιχεία θέματος";
$langTopicAnswer = "Απάντηση στο θέμα συζήτησης";
$langGroupDocumentsLink = "Έγγραφα ομάδας ";
$langForumFrom = "Απο μέλος";
$langNotify = "Ειδοποίηση μέσω email αν σταλούν απαντήσεις";
$langStopNotify = "Απενεργοποίηση ειδοποίησης μέσω email αν σταλούν απαντήσεις";
$langNotifyActions = "Ειδοποιήσεις";
$langNotificationsExist = 'Υπάρχουν ειδοποιήσεις';
$langGoToPage = "Μετάβαση στη σελίδα";
$langClick = "Κάντε κλικ";
$langSubjectNotify = "Ειδοποίηση για νέο μήνυμα";
$langNewForumNotify = "Ειδοποίηση για νέο θέμα";
$langCatNotify = "Ειδοποίηση για καινούρια περιοχή συζητήσεων";
$langInForum = "στο θέμα";
$langInForums = "στην περιοχή συζητήσεων";
$langInCat = "στην κατηγορία";
$langBodyForumNotify = "Ένα νέο θέμα έχει προστεθεί στο $langsCourse";
$langBodyTopicNotify = "Ένα νέο μήνυμα έχει προστεθεί";
$langBodyCatNotify = "Μια νέα περιοχή συζητήσεων έχει προστεθεί";
$langOfForum = "της περιοχής συζητήσεων";
$langTopics = "Θέματα";
$langTopic = "Θέμα";
$langPosts = "Αποστολές";
$langMessage = "Μήνυμα";
$langMessages = "Μηνύματα";
$langAllOfThem = "όλα";
$langBodyMessage = "Σώμα μηνύματος";
$langPostTitle = "Θέμα δημοσίευσης";
$langAnonymousExplain = "Οι χρήστες που εμφανίζονται με διαφορετικό χρώμα δεν είναι αυτή τη στιγμή εγγεγραμμένοι στο $langsCourse, ενώ όσοι έχουν την ένδειξη «Ανώνυμος» έχουν διαγραφεί από το σύστημα.";
$langNoPost = "Δεν έχετε δικαίωμα αποστολής μηνυμάτων σε αυτή την περιοχή.";
$langReturnIndex = "Επιστροφή στο ευρετήριο περιοχών συζητήσεων";
$langReturnTopic = "Επιστροφή στην περιοχή συζητήσεων";
$langLastPost = "Τελευταία ανάρτηση";
$langNoTopics = "Δεν υπάρχουν θέματα σε αυτή την περιοχή.";
$langStartNewTopic = "Κάντε κλικ για να δημιουργήσετε ένα νέο.";
$langPrivateForum = "Η πρόσβαση σε αυτή τη περιοχή συζητήσεων είναι μόνο για τα μέλη της ομάδας.";
$langPrivateNotice = "$langPrivateForum<br>Σημείωση: πρέπει να έχετε ενεργοποιημένα τα cookies για να χρησιμοποιήσετε προσωπικές περιοχές.";
$langSent = "Στάλθηκε";
$langViewMessage = "Εμφάνιση μηνύματος";
$langNotEdit = "Δεν μπορείτε να αλλάξετε μήνυμα που δεν είναι δικό σας.";
$langStored = "Το μήνυμα στάλθηκε";
$langReturnMessages = "Επιστροφή στο θέμα";
$langViewMsg = " για να εμφανίσετε το μήνυμα";
$langDeletedMessage = "Το μήνυμα διαγράφηκε";
$langDeleteMessage = "Διαγραφή του μηνύματος";
$langEmptyMsg = "Το μήνυμα σας είναι κενό!";
$langEmptyNewTopic = "Δεν πληκτρολογήσατε τίτλο θέματος ή/και μήνυμα";
$langCancelPost = "Ακύρωση αποστολής";
$langTopicReview = "Ανασκόπηση θέματος";
$langReply = "Απάντηση";
$langReplyEdit = "Αλλαγή απάντησης";
$langForward = "Προώθηση";
$langErrorTopicSelect = "Η περιοχή συζητήσεων που επιλέξατε δεν υπάρχει. Παρακαλώ προσπαθήστε ξανά.";
$langNewForumCat = "Νέα κατηγορία";
$langForCat = "Περιοχές συζητήσεων της κατηγορίας";
$langBackCat = "επιστροφή στις κατηγορίες";
$langForName = "Όνομα περιοχής συζητήσεων";
$langFunctions = "Λειτουργίες";
$langAddForCat = "Προσθήκη περιοχής συζητήσεων";
$langChangeCat = "Αλλαγή της κατηγορίας";
$langChangeForum = "Τροποποίηση της περιοχής συζήτησης";
$langModCatName = "Αλλαγή ονόματος κατηγορίας";
$langNameCatMod = "Το όνομα της κατηγορίας έχει αλλάξει";
$langBack = "Επιστροφή";
$langCatAdded = "Προστέθηκε κατηγορία";
$langEmptyCat = "Πληκτρολογήστε το όνομα της κατηγορίας";
$langCategories = "Κατηγορίες";
$langNbFor = "Συζητήσεις";
$langForumDataChanged = "Τα στοιχεία της περιοχής συζητήσεων έχουν αλλάξει";
$langForumCategoryAdded = "Προστέθηκε νέα περιοχή συζητήσεων στην κατηγορία που επιλέξατε";
$langForumDelete = "Η περιοχή συζητήσεων έχει διαγραφεί";
$langCatForumDelete = "Η κατηγορία της περιοχής συζητήσεων έχει διαγραφεί";
$langID = "Α/Α";
$langForumOpen = "Ανοικτή";
$langForumClosed = "Κλειστή";
$langNewForum = "Νέα περιοχή συζητήσεων";
$langEditedBy = "Διορθώθηκε από";
$langForumDefaultCat = "Γενικές Περιοχές Συζητήσεων";
$langEditTopic = "Τροποποίηση θέματος";
$langChangeTopicForum = "Αλλαγή περιοχής συζητήσεων";
$langTopicDataChanged = "Το θέμα τροποποιήθηκε!";
$langForumPost = "Μήνυμα περιοχής συζητήσεων";
$langForumPostReply = "Απάντηση σε αυτό το μήνυμα";
$langForumPostParent = " απάντηση στο μήνυμα ";
$langForumPostParentDel = "απάντηση σε μήνυμα που έχει διαγραφεί";
$langErrorTopicLocked = "Το θέμα συζήτησης είναι κλειδωμένο.";
$langLockTopic = "Κλείδωμα θέματος";
$langUnlockTopic = "Ξεκλείδωμα θέματος";
$langLockedTopic = "To θέμα κλειδώθηκε!";
$langUnlockedTopic = "To θέμα ξεκλειδώθηκε!";
$langNoForumTopic = "Δεν υπάρχουν περιοχές συζητήσεων";
$langForumPostFlatViewAsc = "Με ημερομηνία (πρόσφατο τελευταίο)";
$langForumPostFlatViewDesc = "Με ημερομηνία (πρόσφατο πρώτο)";
$langForumPostThreadedView = "Ομαδοποιημένα";
$langForumAttachmentDeleted = "Το αρχείο διαγράφηκε";
$langTheForumInGroupNotDeleted = "Η περιοχή συζητήσεων δεν μπορεί να διαγραφεί γιατί ανήκει σε ομάδα χρηστών. Αν θέλετε να τη διαγράψετε θα πρέπει να την απενεργοποιήσετε από την αντίστοιχη ομάδα χρηστών.";
$langForumCategoryNotDeleted = "Η κατηγορία δεν μπορεί να διαγραφεί.";

/* * ***************************************************************
 * questionnaire.php
 * **************************************************************** */
$langCreateSurvey = 'Δημιουργία Έρευνας Μαθησιακού Προφίλ';
$langCreatePoll = 'Δημιουργία Ερωτηματολογίου';
$langInfoPoll = "Στοιχεία ερωτηματολογίου";
$langEditPoll = 'Τροποποίηση Ερωτηματολογίου';
$langPollManagement = "Διαχείριση Ερωτηματολογίου";
$langBackPollManagement = "Επιστροφή στη διαχείριση ερωτηματολογίου";
$langQuestionnaire = "Ερωτηματολόγια";
$langNoAccessPrivilages = "Δεν έχετε δικαίωμα πρόσβασης";
$langSurvey = "Ερωτηματολόγιο";
$langSurveys = "Ερωτηματολόγια";
$langParticipate = "Συμμετοχή";
$langParticipateSimple = "Απλή Συμμετοχή";
$langSurveysActive = "Ενεργές Έρευνες Μαθησιακού Προφίλ";
$langSurveysInactive = "Ανενεργές Έρευνες Μαθησιακού Προφίλ";
$langSurveyDateCreated = "Δημιουργήθηκε την";
$langSurveyStart = "Ξεκίνησε την";
$langSurveyEnd = "και τελείωσε την";
$langSurveyMC = "Πολλαπλής Επιλογής";
$langSurveyFillText = "Συμπληρώστε το κενό";
$langSurveyMoreAnswers = "+ απαντήσεις";
$langSurveyMoreQuestions = "+ ερωτήσεις";
$langSurveyCreated = "Η Έρευνα Μαθησιακού Προφίλ δημιουργήθηκε με επιτυχία.";
$langSurveyCreationError = "Σφάλμα κατά την δημιουργία του Ερωτηματολογίου. Παρακαλώ προσπαθήστε ξανά.";
$langSurveyDeleted = "Η Έρευνα Μαθησιακού Προφίλ διαγράφηκε με επιτυχία.";
$langSurveyDeactivated = "Η Έρευνα Μαθησιακού Προφίλ απενεργοποιήθηκε με επιτυχία.";
$langSurveyActivated = "Η Έρευνα Μαθησιακού Προφίλ ενεργοποιήθηκε με επιτυχία.";
$langSurveySubmitted = "Ευχαριστούμε για την συμμετοχή σας!";
$langSurveyTotalAnswers = "Συνολικές απαντήσεις";
$langSurveyNone = "Δεν έχουν δημιουργηθεί έρευνες μαθησιακού προφίλ για το $langsCourse";
$langSurveyInactive = "Η Έρευνα Μαθησιακού Προφίλ έχει λήξει ή δεν έχει ενεργοποιηθεί ακόμα.";
$langSurveyCharts = "Αποτελέσματα έρευνας";
$langHasParticipated = "Έχετε ήδη συμμετάσχει";
$langOpenParticipation = "Οι συμμετοχές είναι ανοικτές";
$langSurveyNotStarted = "Δεν έχει ξεκινήσει";
$langQQuestionNotGiven = "Δεν έχετε εισάγει την τελευταία ερώτηση.";
$langQFillInAllQs = "Παρακαλώ απαντήστε σε όλες τις ερωτήσεις.";
$langCreateDuplicate = "Δημιουργία Αντιγράφου";
$langCopy2 = "Αντίγραφο";
$langCopyDuplicate = "(Αντίγραφο)";
$langCreateDuplicateIn = "Δημιουργία Αντιγράφου στο ...";
$langCurrentCourse = "Τρέχον $langCourse";
$langCopySuccess = "Το αντίγραφο δημιουργήθηκε με επιτυχία!";
$langGeneralSurvey = "Γενικό ερωτηματολόγιο";
$langCollesSurvey = "COLLES";
$langATTLSSurvey = "A.T.T.L.S.";
$langLimeSurvey = "Lime Survey";
$langPollNoQuestions = "Στο ερωτηματολόγιο δεν έχουν οριστεί ερωτήσεις!";
$langActivateParticipation = "Ενεργοποίηση Παρουσιολογίου";
$langQuickSurvey = "Γρήγορη ερώτηση";


//COLLES survey
$qcolles1 = "Σε αυτή την ενότητα εστιάζω μόνο σε ό,τι με ενδιαφέρει";
$qcolles2 = "Σε αυτή την ενότητα ό,τι μαθαίνω είναι σημαντικό για την επιστημονική μου πρακτική";
$qcolles3 = "Σε αυτή την ενότητα μαθαίνω πως να βελτιώνω την επιστημονική μου πρακτική";
$qcolles4 = "Σε αυτή την ενότητα ό,τι μαθαίνω συνδέεται καλά με την επιστημονική μου πρακτική";
$qcolles5 = "Σε αυτή την ενότητα σκέφτομαι κριτικά για ό,τι μαθαίνω";
$qcolles6 = "Σε αυτή την ενότητα σκέφτομαι κριτικά για τις ιδέες μου";
$qcolles7 = "Σε αυτή την ενότητα σκέφτομαι κριτικά για τις ιδέες των άλλων μαθητών";
$qcolles8 = "Σε αυτή την ενότητα σκέφτομαι κριτικά για τις ιδέες των αναγνωσμάτων";
$qcolles9 = "Σε αυτή την ενότητα εξηγώ τις ιδέες μου στους άλλους μαθητές";
$qcolles10 = "Σε αυτή την ενότητα ρωτώ άλλους μαθητές να εξηγήσουν τις ιδέες τους";
$qcolles11 = "Σε αυτή την ενότητα άλλοι μαθητές μου ζητούν να εξηγήσω τις ιδέες μου";
$qcolles12 = "Σε αυτή την ενότητα άλλοι μαθητές απαντούν στις ιδέες μου";
$qcolles13 = "Σε αυτή την ενότητα ο εκπαιδευτής διεγείρει τη σκέψη μου";
$qcolles14 = "Σε αυτή την ενότητα ο εκπαιδευτής με ενθαρρύνει να συμμετέχω";
$qcolles15 = "Σε αυτή την ενότητα ο εκπαιδευτής προβάλει τη σωστή συζήτηση";
$qcolles16 = "Σε αυτή την ενότητα ο εκπαιδευτής προβάλει την κριτική θεώρηση του εαυτού μας";
$qcolles17 = "Σε αυτή την ενότητα οι άλλοι μαθητές ενθαρρύνουν τη συμμετοχή μου";
$qcolles18 = "Σε αυτή την ενότητα οι άλλοι μαθητές επαινούν τη συνεισφορά μου";
$qcolles19 = "Σε αυτή την ενότητα οι άλλοι μαθητές εκτιμούν τη συνεισφορά μου";
$qcolles20 = "Σε αυτή την ενότητα οι άλλοι μαθητές κατανοούν την προσπάθειά μου για μάθηση";
$qcolles21 = "Σε αυτή την ενότητα βγάζω νόημα από τα μηνύματα των άλλων μαθητών";
$qcolles22 = "Σε αυτή την ενότητα οι άλλοι μαθητές κατανοούν τα μηνύματά μου";
$qcolles23 = "Σε αυτή την ενότητα κατανοώ τα μηνύματα του εκπαιδευτή";
$qcolles24 = "Σε αυτή την ενότητα ο εκπαιδευτής κατανοεί τα μηνύματά μου";
$lcolles1 = "Συνάφεια";
$lcolles2 = "Στοχαστική σκέψη";
$lcolles3 = "Αλληλεπίδραση";
$lcolles4 = "Υποστήριξη εκπαιδευτή";
$lcolles5 = "Υποστήριξη συμμαθητών";
$lcolles6 = "Ερμηνεία";
$scolles1 = "εστιάζει σε ό,τι ενδιαφέρει";
$scolles2 = "σημαντικό για την εργασία";
$scolles3 = "βελτίωση της εργασίας";
$scolles4 = "σχετικά θέματα με την εργασία";
$scolles5 = "κριτική για τη μάθηση";
$scolles6 = "κριτική για τις ιδέες μου";
$scolles7 = "κριτική για τις ιδέες άλλων συμμαθητών";
$scolles8 = "κριτική για τις ιδέες των αναγνωσμάτων";
$scolles9 = "εξηγώ τις ιδέες μου";
$scolles10 = "ζητώ να μου εξηγήσουν τις ιδέες τους";
$scolles11 = "μου ζητούν να εξηγήσω τις ιδέες μου";
$scolles12 = "απαντούν στις ιδέες μου";
$scolles13 = "ο εκπαιδευτικός διεγείρει τη σκέψη μου";
$scolles14 = "ο εκπαιδευτικός ενθαρρύνει τη συμμετοχή μου";
$scolles15 = "ο εκπαιδευτικός προβάλει τη σωστή συζήτηση";
$scolles16 = "ο εκπαιδευτικός προβάλει την κριτική θεώρηση του εαυτού μας";
$scolles17 = "οι άλλοι μαθητές ενθαρρύνουν τη συμμετοχή μου";
$scolles18 = "οι άλλοι μαθητές επαινούν τη συνεισφορά μου";
$scolles19 = "οι άλλοι μαθητές εκτιμούν τη συνεισφορά μου";
$scolles20 = "οι άλλοι μαθητές κατανοούν την προσπάθειά μου για μάθηση";
$scolles21 = "βγάζω νόημα από τα μηνύματα των άλλων μαθητών";
$scolles22 = "οι άλλοι μαθητές κατανοούν τα μηνύματά μου";
$scolles23 = "κατανοώ τα μηνύματα του εκπαιδευτικού";
$scolles24 = "ο εκπαιδευτικός κατανοεί τα μηνύματά μου";

$colles_desc = "Το ερωτηματολόγιο COLLES (Constructive On Line Learning Environment Survey) χρησιμοποιείται για να διερευνηθούν οι απόψεις για το μαθησιακό περιβάλλον που
				έχουν διαμορφώσει οι συμμετέχοντες. Aποτελείται από 24 ερωτήσεις. Κάθε ερώτηση έχει ως απάντηση έναν αριθμό από το 1 (Σχεδόν Ποτέ),
				2 (Σπάνια), 3 (Μερικές φορές), 4 (Συχνά), μέχρι το 5 (Σχεδόν πάντα)";
$langCollesLegend = "1 (Σχεδόν Ποτέ), 2 (Σπάνια), 3 (Μερικές φορές), 4 (Συχνά), 5 (Σχεδόν πάντα)";
$colles_detail_answer = "Εδώ μπορείτε να δείτε συγκεντρωτικά τι απάντησε ο εκπαιδευόμενος";

//ATTLS survey
$question1 = "Όταν εκτιμώ τι λέει κάποιος, εστιάζω πάνω στην ποιότητα των λόγων του και όχι στο πρόσωπο που τα παρουσιάζει";
$question2 = "Μου αρέσει να κάνω το δικηγόρο του διαβόλου - υποστηρίζοντας το αντίθετο από αυτό που κάποιος λέει";
$question3 = "Μου αρέσει να κατανοώ από που 'προέρχονται' οι άλλοι άνθρωποι, ποιες εμπειρίες τους έχουν οδηγήσει στο να σκέφτονται έτσι";
$question4 = "Το πιο σημαντικό μέρος της εκπαίδευσής μου είναι να μάθω να καταλαβαίνω τους ανθρώπους οι οποίοι είναι πολύ διαφορετικοί από εμένα";
$question5 = "Αισθάνομαι ότι ο καλύτερος τρόπος για μένα στο να επιτύχω την προσωπική μου ταυτότητα, είναι να αλληλεπιδράσω με πολλούς άλλους ανθρώπους";
$question6 = "Απολαμβάνω να ακούω τις απόψεις ανθρώπων οι οποίοι προέρχονται από διαφορετικά υπόβαθρα από το δικό μου - με βοηθάει να καταλάβω πώς τα ίδια πράγματα μπορούν να φαίνονται με τόσους διαφορετικούς τρόπους";
$question7 = "Μπορώ να ενισχύσω τη δική μου γνώμη μέσω της συζήτησης με κάποιον που διαφωνεί μαζί μου";
$question8 = "Πάντα με ενδιέφερε να μαθαίνω γιατί οι άνθρωποι λένε και πιστεύουν τα πράγματα που κάνουν";
$question9 = "Συχνά πιάνω τον εαυτό μου να διαφωνεί με τους συντάκτες των βιβλίων που διαβάζω, προσπαθώντας με τη λογική να καταλάβω γιατί είναι λάθος";
$question10 = "Είναι σημαντικό για μένα να παραμένω όσο αντικειμενικός γίνεται όταν αναλύω κάτι.";
$question11 = "Προσπαθώ να σκέφτομαι με τους ανθρώπους παρά να είμαι αντίθετος σε αυτούς";
$question12 = "Έχω συγκεκριμένα κριτήρια που χρησιμοποιώ στην εκτίμηση μιας συζήτησης";
$question13 = "Είναι πιο πιθανό να προσπαθήσω να κατανοήσω τη γνώμη κάποιου άλλου παρά να την αξιολογήσω";
$question14 = "Προσπαθώ να επισημάνω αδυναμίες στη σκέψη των άλλων για να τους βοηθήσω να διευκρινήσουν την άποψή τους";
$question15 = "Έχω την τάση να βάζω τον εαυτό μου στη θέση των άλλων όταν συζητώ αμφιλεγόμενα θέματα, για να δω γιατί σκέφτονται κατ' αυτόν τον τρόπο";
$question16 = "Κάποιος θα μπορούσε να χαρακτηρίσει τον τρόπο με τον οποίο αναλύω τα πράγματα ότι 'τα περνάω από  κόσκινο', επειδή είμαι προσεκτικός στο να εκτιμήσω όλα τα στοιχεία";
$question17 = "Αξιολογώ με τη χρήση της λογικής και της αιτιολόγησης, περισσότερο από την εμπλοκή των δικών μου ανησυχιών, όταν επιλύω προβλήματα";
$question18 = "Μπορώ να αποκτήσω διορατικότητα σχετικά με τις απόψεις που διαφέρουν από τη δική μου, μέσω της ταύτισης";
$question19 = "Όταν συναντώ άτομα των οποίων οι απόψεις μου φαίνονται παράξενες, κάνω συνειδητή προσπάθεια να 'επεκτείνω' τον εαυτό μου στη θέση τους, να δω για ποιο λόγο έχουν αυτές τις απόψεις";
$question20 = "Αφιερώνω χρόνο προσπαθώντας να καταλάβω τι είναι 'λάθος'. Για παράδειγμα, θα ψάξω κάτι σε βάθος όταν δεν μου ακούγεται καλά";
$rate_scale = "To ερωτηματολόγιο A.T.T.L.S. (Attitudes Towards Thinking Learning Survey) χρησιμοποιείται για να διερευνήσει το κατά πόσο μαθαίνει ο χρήστης σε συνεργασία με άλλους ή μόνος του. Αποτελείται από 20 ερωτήσεις. Κάθε ερώτηση έχει ως απάντηση έναν αριθμό από το 1 (Διαφωνώ πλήρως) μέχρι το 5 (Συμφωνώ πλήρως)";
$lang_Results = "Αποτελέσματα ερωτηματολογίου";
$langCKW = "Ο χρήστης μαθαίνει συνδεδεμένα με τους άλλους μαθητές: ";
$langSKW = "Ο χρήστης μαθαίνει διαχωρισμένα από τους άλλους μαθητές: ";
$langCKW_SKW = "Ο χρήστης μαθαίνει τόσο συνδεδεμένα όσο και διαχωρισμένα από τους άλλους μαθητές: ";
$lang_ckw = "(Σ.Γ.:";
$lang_skw = ", Δ.Γ.:";
$lang_rate1 ="Δεν συμφωνώ καθόλου";
$lang_rate2 ="Δεν συμφωνώ";
$lang_rate3 ="Ούτε συμφωνώ ούτε διαφωνώ";
$lang_rate4 ="Συμφωνώ";
$lang_rate5 ="Συμφωνώ πολύ";
$lang_result_summary = "Συνοπτικά αποτελέσματα";
$lang_ckw_skw_chart = "Εδώ παρουσιάζονται συνοπτικά πόσοι μαθητές μαθαίνουν συνδεδεμένα, πόσοι διαχωρισμένα και πόσοι και με τους δύο τρόπους";
$langConnected = "Συνδεδεμένα";
$langSeparated = "Χωρισμένα";
$langBothWays = "Και με τους 2 τρόπους";

// polls
$langPollsActive = "Ενεργά Ερωτηματολόγια";
$langPollsInactive = "Ανενεργά Ερωτηματολόγια";
$langPollStarted = "Ξεκίνησε την";
$langPollEnd = "Λήξη";
$langPollEnded = "και τελείωσε την";
$langPollOperations = "Λειτουργίες";
$langPollAddAnswer = "Προσθήκη απαντήσεων";
$langPollMC = "Πολλαπλής Επιλογής";
$langPollFillText = "Συμπληρώστε το κενό";
$langPollMoreAnswers = "+";
$langPollEndMessage = 'Μήνυμα ολοκλήρωσης';
$langPollEndMessageText = 'Σας ευχαριστούμε για τη συμμετοχή σας στο ερωτηματολόγιο!';
$langPollAddMultiple = "Νέα ερώτηση πολλαπλής επιλογής";
$langPollAddFill = "Νέα ερώτηση συμπλήρωσης κενού";
$langPollCreated = "Το Ερωτηματολόγιο δημιουργήθηκε με επιτυχία.";
$langPollEdited = "Το Ερωτηματολόγιο τροποποιήθηκε με επιτυχία.";
$langPollCreation = "Ημ/νία Δημιουργίας";
$langPollCreateDate = "Το Ερωτηματολόγιο δημιουργήθηκε την";
$langPollDeleted = "Το Ερωτηματολόγιο διαγράφηκε με επιτυχία.";
$langPollResultsDeleted = "Τα αποτελέσματα του Ερωτηματολογίου διαγράφηκαν με επιτυχία.";
$langPollResultsAccess = "Δεν έχετε δικαίωμα πρόσβασης στα αποτελέσματα του Ερωτηματολογίου.";
$langPollAlreadyParticipated = "Έχετε ήδη συμμετάσχει στο ερωτηματολόγιο";
$langPollDeactivated = "Το Ερωτηματολόγιο απενεργοποιήθηκε με επιτυχία!";
$langPollActivated = "Το Ερωτηματολόγιο ενεργοποιήθηκε με επιτυχία!";
$langPollLocked = "Ο περιορισμός πρόσβασης ενεργοποιήθηκε με επιτυχία!";
$langPollUnlocked = "Ο περιορισμός πρόσβασης άρθηκε με επιτυχία!";
$langPollSubmitted = "Ευχαριστούμε για την συμμετοχή σας!";
$langPollTotalAnswers = "Συνολικός αριθμός συμμετοχών";
$langPollNone = "Δεν υπάρχουν διαθέσιμα Ερωτηματολόγια.";
$langPollInactive = "Το Ερωτηματολόγιο έχει λήξει ή δεν έχει ενεργοποιηθεί ακόμα.";
$langPollCharts = "Αποτελέσματα Ερωτηματολογίου";
$langPollUnknown = "Δεν ξέρω / Δεν απαντώ";
$langPollAnonymize = "Ανωνυμοποίηση αποτελεσμάτων";
$langPollShowResults = "Εμφάνιση αποτελεσμάτων στους $langsOfStudentss";
$langIndividuals = "Αποτελέσματα ανά χρήστη";
$langCollectiveCharts = "Συγκεντρωτικά αποτελέσματα";
$langHasNotParticipated = "Δεν έχετε συμμετάσχει";
$langThereAreParticipants = "Στο Ερωτηματολόγιο έχουν ήδη συμμετάσχει χρήστες. Η τροποποίηση των ερωτήσεων πιθανόν να αλλάξει τα αποτελέσματα!";
$langPollEmpty = "Παρακαλώ προσθέστε ερωτήσεις στο Ερωτηματολόγιο!";
$langPollPercentResults = 'Ποσοστιαία αποτελέσματα';
$langPollFullResults = 'Αναλυτικά αποτελέσματα';
$langPollParticipantInfo = 'Συμπληρώστε μια έγκυρη email διεύθυνση.
            Μόλις ολοκληρώσετε το ερωτηματολόγο θα σας σταλεί ένα email σε αυτήν.
            Εκεί θα υπάρχει ένας σύνδεσμος επιβεβαίωσης στον οποίο θα πρέπει να κάνετε κλικ υποχρεωτικά.
            Διαφορετικά οι απαντήσεις σας δεν θα ληφθούν υπόψη.';
$langPollParticipateConfirm = "Κάντε κλικ στον παρακάτω σύνδεσμο για να επιβεβαιώστε τη συμμετοχή σας στο ερωτηματολόγιο";
$langPollEmailUsed = 'περιέχει ένα λογαριασμό που έχει χρησιμοποιηθεί για την απάντηση του ερωτηματολογίου';
$langPollParticipateConfirmation = "Επιβεβαίωση Συμμετοχής σε Ερωτηματολόγιο";
$langPollParticipationValid = "Οι απαντήσεις σας καταγράφηκαν με επιτυχία.";
$langActivateMulSubmissions = "Ενεργοποίηση πολλαπλών υποβολών από τους $langsOfStudentss";
$langActivateDefaultAnswer = "Ενεργοποίηση απάντησης 'δεν ξέρω / δεν απαντώ'";
$langPollOutcomeClose = "Μπορείτε να κλείσετε αυτό το παράθυρο ή να επιστρέψετε στην προηγούμενη σελίδα.";
$langOnlySubmissions = 'Μόνο συμμετέχοντες';
$langOnlyNonSubmissions = 'Μόνο μη συμμετέχοντες';
$langShowFront = 'Εμφάνιση στην αρχική';
$langNumberScaleDiffAnswers = "Ο μέγιστος αριθμός κλίμακας που καταχωρίσατε θα πρέπει να ισούται με τον αριθμό των πιθανών απαντήσεων που δώσατε.";
$langInfoAddSliderLabels = "Προσθέστε στο πεδίο κειμένου τις πιθανές απαντήσεις που θα περιλαμβάνει η κλίμακα με βάση τον μέγιστο αριθμό της.</br>
                            Η κάθε απάντηση χωρίζεται με το σύμβολο | .</br>
                            Π.χ αν ο μέγιστος αριθμός της κλίμακας είναι 5 τότε θα πρέπει να δώσετε 5 πιθανές απαντήσεις της μορφής: (καθόλου|πολύ λίγο|λίγο|πολύ|πάρα πολύ).";
$langTableDimension = "Δημιουργήστε την διάσταση του πίνακα (N*N) καταχωρόντας τον αριθμό των στηλών και γραμμών του.</br></br>
                       <ul><li>Στήλες = Ερωτήσεις προς τον χρήστη</li><li>Γραμμές = Απαντήσεις από τον χρήστη</li></ul>";
$langNumberOfColumns = "Αριθμός στηλών";
$langNumberOfRows = "Αριθμός γραμμών";
$langWriteQuestion = "Γράψτε την ερώτηση...";
$langNumberRowColBigger = "Ο αριθμός των γραμμών και στηλών του πίνακα θα πρέπει να είναι μεγαλυτερος του μηδέν.";
$langRowsColumnsInsertd = "Οι γραμμές και οι στήλες του πίνακα καταχωρήθηκαν με επιτυχία.";
$langSubmitQuestions = "Υποβολή ερωτήσεων";
$langEditRowsColsTable = "Επεξεργασία διαστάσεων και ερωτήσεων του πίνακα";
$langQuestionsInsertd = "Οι ερωτήσεις προστέθηκαν με επιτυχία.";
$langNumberColumnsSmallerThanQ = "Ο αριθμός των στηλών που καταχωρίσατε είναι μικρότερος από τις διαθέσιμες καταχωρημένες ερωτήσεις.";
$langUserAnswer = "Απάντηση χρήστη";
$langAddRowsColumns = "Καταχώριση";
$langUsersAnswers = "Απαντήσεις χρηστών";
$langEnablePagination = "Ενεργοποίηση σελιδοποίησης";
$langPreviousQuestion = "Προηγούμενη";
$langNextQuestion = "Επόμενη";
$langEnableRequiredAnswer = "Υποχρεωτική απάντηση σε κάθε ερώτηση";
$langGenQrCode = "Δημιουργία QR code";

/* * **********************************************************
 * registration.php
 * *********************************************************** */
$langSee = "Προεπισκόπηση";
$langCourseName = "Τίτλος $langOfCourse";
$langNoCoursesAvailable = "Δεν υπάρχουν διαθέσιμα $langsCourses";
$langRegistration = "Εγγραφή";
$langSurname = "Επώνυμο";
$langUsername = "Όνομα χρήστη (username)";
$langConfirmation = "Επιβεβαίωση συνθηματικού";
$langUserNotice = "Μέχρι 30 χαρακτήρες";
$langEmailInfo = "Μπορείτε να δηλώσετε μια διεύθυνση email στη παρακάτω φόρμα.";
$langEmailNotice = "Η διεύθυνση email δεν είναι απαραίτητη, αλλά χωρίς αυτή δε θα μπορείτε να λαμβάνετε
ανακοινώσεις και ειδοποιήσεις.";
$langAm = "Αριθμός μητρώου";
$langVisibleInfo = "εμφανίζεται μόνο στους $langsTeachers.";
$langAmShort = "Α.Μ.";
$langEmailVerified = "Το e-mail έχει επιβεβαιωθεί";
$langUserDetails = "Εγγραφή Χρήστη";
$langSubmitNew = "Υποβολή Αίτησης";
$langPassTwice = "Πληκτρολογήσατε δύο διαφορετικά συνθηματικά.";
$langPassShort = "Το συνθηματικό είναι πολύ σύντομο.";
$langUserFree = "Το όνομα χρήστη που επιλέξατε χρησιμοποιείται.";
$langUserFree2 = " Πιθανόν να έχετε ήδη λογαριασμό στην πλατφόρμα.";
$langUserFree3 = "Υπάρχει ήδη αίτηση εγγραφής με το ίδιο όνομα χρήστη στην πλατφόρμα.";
$langYourReg = "Η εγγραφή σας στο";
$langYouAreReg = "\nΟ λογαριασμός σας στην πλατφόρμα";
$langWithSuccess = "δημιουργήθηκε με επιτυχία!";
$langSettings = "Τα προσωπικά στοιχεία του λογαριασμού σας είναι τα εξής:";
$langUserCodename = "Όνομα χρήστη";
$langAddressOf = "\n\nΗ διεύθυνση";
$langProblem = "\nΣε περίπτωση που αντιμετωπίζετε προβλήματα, επικοινωνήστε με την Ομάδα Ασύγχρονης Τηλεκπαίδευσης";
$langFormula = "\n\nΦιλικά,\n";
$langManager = "Υπεύθυνος";
$langPersonalSettings = "Η εγγραφή σας ολοκληρώθηκε και σας στάλθηκε ένα e-mail για να θυμάστε το όνομα χρήστη και το συνθηματικό σας. ";
$langPersonalSettingsLess = "Η εγγραφή σας ολοκληρώθηκε.";
$langPersonalSettingsMore = "για να εισέλθετε στο προσωπικό σας χαρτοφυλάκιο. Εκεί μπορείτε:";
$langPersonalSettingsMore1 = "να περιηγηθείτε στο περιβάλλον της πλατφόρμας και τις προσωπικές σας επιλογές";
$langPersonalSettingsMore2 = "να επιλέξετε από την επιλογή '$langCourses' τα $langsCourses που επιθυμείτε να παρακολουθήσετε.";
$langYourRegTo = "Ο κατάλογος $langsOfCourses σας περιέχει";
$langIsReg = "έχει ενημερωθεί";
$langCanEnter = "Είσοδος στην ψηφιακή αίθουσα.";
$langChoice = "Επιλογή";
$langLessonName = "Όνομα $langsOfCourse";
$langCaptchaWrong = "Ο κωδικός ασφαλείας που έχετε εισαγάγει είναι λάθος.";
$langCaptcha = "Κωδικός ασφάλειας";
$langWrongPassword = "Λάθος κωδικός";
$langUserAltAuth = "Το όνομα χρήστη με το οποίο προσπαθήσατε να συνδεθείτε χρησιμοποιεί διαφορετικό τρόπο πιστοποίησης. Παρακαλώ επικοινωνήστε με τους διαχειριστές της πλατφόρμας";
$langUserRightsChanged = "Τα δικαιώματα του χρήστη αλλάξανε με επιτυχία.";

// profile.php
$langPassTwo = 'Έχετε πληκτρολογήσει δύο διαφορετικά νέα συνθηματικά';
$langAgain = "Ξαναπροσπαθήστε!";
$langEmailWrong = "Η διεύθυνση ηλεκτρονικού ταχυδρομείου δεν είναι συμπληρωμένη ή περιέχει άκυρους χαρακτήρες";
$langUsersEmailWrong = "Η διεύθυνση ηλεκτρονικού ταχυδρομείου κάποιου χρήστη δεν είναι έγκυρη";
$langPassChanged = "Το συνθηματικό πρόσβασης στην πλατφόρμα έχει αλλάξει";
$langPassOldWrong = "Το παρόν συνθηματικό πρόσβασης που δώσατε είναι λάθος";
$langNewPass1 = "Νέο συνθηματικό";
$langNewPass2 = "Νέο συνθηματικό (ξανά)";
$langInvalidCharsPass = "Έχετε χρησιμοποιήσει μη επιτρεπτούς χαρακτήρες στο συνθηματικό σας";
$langInvalidCharsUsername = "Έχετε χρησιμοποιήσει μη επιτρεπτούς χαρακτήρες στο όνομα χρήστη σας";
$langProfileReg = "Οι αλλαγές στο προφίλ σας αποθηκεύτηκαν";
$langOldPass = "Παρόν συνθηματικό";
$langChangePass = "Αλλαγή συνθηματικού";
$langUserProfile = 'Στοιχεία χρήστη';
$langDisplayProfile = "Δημόσια Εμφάνιση Προφίλ";
$langProfileInfoPrivate = 'ιδιωτικό';
$langProfileInfoProfs = "εμφάνιση στους $langsTeachers";
$langProfileInfoUsers = 'εμφάνιση σε όλους';
$langEmailSettings = 'Ρυθμίσεις ηλεκτρονικού ταχυδρομείου';
$langProfileSendMail = 'Αποστολή προσωπικού μηνύματος';
$langProfileNotAvailable = 'Μη διαθέσιμο';
$langProfilePersInfo = 'Προσωπικά Στοιχεία';
$langProfileAboutMe = 'Σχετικά με μένα';
$langStatus = "Ιδιότητα";
$langProfileMemberSince = 'Μέλος από';
$langSumCoursesEnrolled = "$langCourses που συμμετέχω";
$langSumCoursesSupport = "$langCourses που υποστηρίζω";
$langProfileLastVisit = "Τελευταία επίσκεψη";
$langProfileQuickPassword = "Αλλαγή Συνθηματικού";
$langShowSettingsInfo = "αφορά την εμφάνιση στους υπόλοιπους χρήστες (εκτός των $langsOfTeachers)";
$langProviderIdAlreadyExists = 'Η ρύθμιση δεν αποθηκεύθηκε γιατί υπάρχει ήδη λογαριασμός στο σύστημα που είναι συνδεδεμένος με αυτόν τον πάροχο';
$langAuthSettingsSaved = "Οι ρυθμίσεις σας έχουν αποθηκευτεί";
$langProviderConnectWithAlternativeProviders = 'Σύνδεση ή εγγραφή με εναλλακτικούς παρόχους';
$langProviderConnectWith = 'Σύνδεση με λογαριασμό';
$langProviderConnectWithTooltip = 'Ο λογαριασμός σας θα συνδεθεί με το αντίστοιχο προφίλ σας ώστε να μπορείτε να εισέρχεστε στην πλατφόρμα με αυτό';
$langProviderConnected = 'Έχετε δυνατότητα σύνδεσης με το ';
$langProviderError = 'Οι ρυθμίσεις σχετικά με τον πάροχο αυθεντικοποίησης δεν είναι ορθές';
$langProviderError1 = 'Άγνωστο σφάλμα αυθεντικοποίησης';
$langProviderError2 = 'Σφάλμα ρύθμισης της βιβλιοθήκης HybridAuth';
$langProviderError3 = 'Οι ρυθμίσεις για τον συγκεκριμένο πάροχο δεν είναι σωστές';
$langProviderError4 = 'Άγνωστος ή απενεργοποιημένος πάροχος';
$langProviderError5 = 'Τα στοιχεία σύνδεσης για την εφαρμογή στον πάροχο δεν είναι σωστά';
$langProviderError6 = 'Η αυθεντικοποίηση απέτυχε λόγω αναφοράς σφάλματος από τον πάροχο';
$langProviderError7 = 'Η λήψη του προφίλ απέτυχε διότι δεν είστε συνδεδεμένοι με τον πάροχο. Δοκιμάστε να επανασυνδεθείτε';
$langProviderError8 = 'Ο χρήστης δεν είναι συνδεδεμένος με τον πάροχο';
$langProviderError9 = 'Υπάρχει ήδη χρήστης πιστοποιημένος με αυτόν τον πάροχο.';

// user.php
$langCompulsory = "(υποχρεωτικό)";
$langModRight = "Αλλαγή των δικαιωμάτων διαχειριστή του";
$langNone = "κανένας";
$langNoAdmin = "δεν έχει<strong>δικαιώματα διαχειριστή σε αυτό το site</strong>";
$langAllAdmin = "έχει τώρα<strong>όλα τα δικαιώματα διαχειριστή σε αυτό το site</strong>";
$langModRole = "Αλλαγή του ρόλου του";
$langRole = "Ρόλος";
$langAddRole = "Ανάθεση ρόλου";
$langIsNow = "είναι τώρα";
$langInC = "σε αυτό το $langsCourse";
$langUserNo = "Το όνομα χρήστη που διαλέξατε";
$langTaken = "χρησιμοποιείται ήδη. Διαλέξτε άλλο.";
$langRegYou = "σας έχει εγγράψει στο $langsCourse";
$langTheU = "Ο χρήστης";
$langAddedU = "έχει προστεθεί. Στάλθηκε ένα email σε αυτόν με το όνομα χρήστη του";
$langAndP = "και το συνθηματικό του";
$langUserDeleted = "Ο χρήστης διαγράφηκε από το $langsCourse";
$langAddAU = "Προσθέστε ένα χρήστη";
$langAddHereSomeCourses = "<p>Για να εγγραφείτε / απεγγραφείτε σε / από ένα $langsCourse,
πρώτα επιλέξτε τη $langsFaculty που βρίσκεστε και στη συνέχεια επιλέξτε / αποεπιλέξτε το $langsCourse.<br>
<p>Για να καταχωρηθούν οι προτιμήσεις σας πατήστε 'Υποβολή αλλαγών'</p><br>";
$langDeleteUser = "Επιβεβαίωση απεγγραφής";
$langDeleteUser2 = "από το $langsCourse";
$langSurnameName = "Ονοματεπώνυμο";
$langAskUser = "Αναζητήστε τον χρήστη που θέλετε να προστεθεί. Ο χρήστης θα πρέπει να έχει ενεργό λογαριασμό στην πλατφόρμα για να εγγραφεί στο $langsCourse.";
$langAskManyUsers = "Οι χρήστες θα πρέπει να
                έχουν ήδη λογαριασμό στην πλατφόρμα για να γραφτούν στο $langsCourse.
                Εισάγετε τα ονόματα χρήστη (usernames) ή τους αριθμούς μητρώου σε ξεχωριστές γραμμές.";
$langAddUser = "Προσθήκη ενός χρήστη";
$langAddManyUsers = "Προσθήκη πολλών χρηστών";
$langOneUser = "ενός χρήστη";
$langManyUsers = "πολλών χρηστών";
$langGUser = "χρήστη επισκέπτη";
$langAddGUser = "Προσθήκη χρήστη επισκέπτη";
$langNoUsersFound = "Δε βρέθηκε κανένας χρήστης με τα στοιχεία που δώσατε ή ο χρήστης υπάρχει ήδη στο $langsCourse.";
$langNoUsersFound2 = "Δε βρέθηκε κανένας χρήστης με τα στοιχεία που δώσατε";
$langUserAlreadyRegisterd = 'έχει ήδη εγγραφεί';
$langRegister = "Εγγραφή";
$langUnRegister = "Απεγγραφή";
$langAdded = " προστέθηκε στο $langsCourse.";
$langAddError = "Σφάλμα! Ο χρήστης δεν προστέθηκε στο $langsCourse. Παρακαλούμε προσπαθήστε ξανά ή επικοινωνήστε με το διαχειριστή του συστήματος.";
$langAddBack = "Επιστροφή στη σελίδα εγγραφής χρηστών";
$langUsersNotExist = "Οι χρήστες με τα παρακάτω στοιχεία δεν βρέθηκαν:";
$langCourseNotExist = "Ο κωδικός $langsOfCourse δεν υπάρχει.";
$langUsersAlreadyRegistered = "Οι παρακάτω χρήστες είναι ήδη γραμμένοι στο $langsCourse:";
$langUsersRegistered = "Οι παρακάτω χρήστες προστέθηκαν στο $langsCourse:";
$langNotifyRegUser1 = "Πραγματοποιήθηκε η εγγραφή σας στο $langsCourse ";
$langNotifyRegUser2 = " από τον διαχειριστή του $langsOfCourse.";
$langToUser = "στον χρήστη";
$langRegistrationDenied = 'Η εγγραφή σας στην πλατφόρμα δεν επιτρέπεται.';
$langInvalidEmailRecipient = "Η διεύθυνση του αποστολέα δεν είναι συμπληρωμένη ή περιέχει άκυρους χαρακτήρες οπότε το email δεν στάλθηκε! Παρακαλούμε επικοινωνήστε με τον διαχειριστή της πλατφόρμας.";

// search_user.php
$langUserNoneMasc = "-";
$langTutor = "Υπεύθυνος Ομάδας";
$langTutorDefinition = "Διδάσκων (δικαίωμα να επιβλέπει τις ομάδες χρηστών)";
$langAdminDefinition = "Διαχειριστής (δικαίωμα να αλλάζει το περιεχόμενο των $langsOfCourses)";
$langDeleteUserDefinition = "Διαγραφή (διαγραφή από τον κατάλογο χρηστών του <strong>παρόντος</strong> $langsOfCourse)";
$langNoTutor = "δεν είναι διδάσκων σε αυτό το $langsCourse";
$langYesTutor = "είναι διδάσκων σε αυτό το $langsCourse";
$langUserRights = "Δικαιώματα χρηστών";
$langNow = "τώρα";
$langOneByOne = "Προσθήκη χρήστη";
$langUserMany = "Εισαγωγή καταλόγου χρηστών μέσω αρχείων κειμένου";
$langUserAddExplanation = "κάθε γραμμή του αρχείου που θα στείλετε θα περιέχει 5 πεδία:
         <strong>Όνομα&nbsp;&nbsp;&nbsp;Επίθετο&nbsp;&nbsp;&nbsp;
        Όνομα Χρήστη&nbsp;&nbsp;&nbsp;Συνθηματικό&nbsp;
        &nbsp;&nbsp;email</strong> και θα ειναι χωρισμένο με tab.
        Οι χρήστες θα λάβουν ειδοποίηση μέσω email με το όνομα χρήστη / συνθηματικό.";
$langDownloadUserList = "Ανέβασμα καταλόγου";
$langUserNumber = "αριθμός";
$langGiveRight = "έδωσε δικαίωμα";
$langRemovedRight = "αφαίρεσε δικαίωμα";
$langGiveRightTutor = "Δικαίωμα υπεύθυνου ομάδας";
$langGiveRightEditor = "Δικαίωμα $langsOfEditor";
$langGiveRightAdmin = "Δικαίωμα $langsOfTeacher";
$langGiveRightCourseReviewer = "Δικαίωμα $langsOfCourseReviewer";
$langGiveRightReviewer = "Δικαίωμα OpenCourses Reviewer";
$langRemoveRightTutor = "Αφαίρεση δικαιώματος υπεύθυνου ομάδας";
$langRemoveRightEditor = "Αφαίρεση δικαιώματος $langsOfEditor";
$langRemoveRightAdmin = "Αφαίρεση δικαιώματος $langsOfTeacher";
$langRemoveRightCourseReviewer = "Αφαίρεση δικαιώματος $langsOfCourseReviewer";
$langRemoveRightReviewer = "Αφαίρεση δικαιώματος OpenCourses Reviewer";
$langRemoveRight = "Αφαίρεση δικαιώματος";
$langUserOneByOneExplanation = "Αυτός (αυτή) θα λάβει ειδοποίηση μέσω email με όνομα χρήστη και συνθηματικό";
$langBackUser = "Επιστροφή στη λίστα χρηστών";
$langUserAlreadyRegistered = "Ενας χρήστης με ίδιο όνομα / επίθετο είναι ήδη γραμμένος σε αυτό το $langsCourse.
                Δεν μπορείτε να τον (την) ξαναγράψετε.";
$langAddedToCourse = "είναι ήδη γραμμένος στην πλατφόρμα αλλά όχι σε αυτό το $langsCourse. Τώρα έγινε.";
$langGroupUserManagement = "Διαχείριση ομάδας χρηστών";
$langRegDone = "Οι αλλαγές σας κατοχυρώθηκαν.";
$langPassTooEasy = "Το συνθηματικό σας είναι πολύ απλό. Χρησιμοποιήστε ένα συνθηματικό σαν και αυτό";
$langChoiceLesson = "Επιλογή $langsOfCourses";
$langRegCourses = "Εγγραφή σε $langsCourse";
$langRegEnterCourse = "Εγγραφή και είσοδος στο $langsCourse";
$langChoiceDepartment = "Επιλογή $langOfFaculty";
$langCoursesRegistered = "Η εγγραφή σας στα $langsCourses που επιλέξατε έγινε με επιτυχία!";
$langNoCoursesRegistered = "<p>Δεν επιλέξατε $langsCourse για εγγραφή.</p><p> Μπορείτε να εγγραφείτε σε $langsCourse, την
επόμενη φορά που θα μπείτε στην πλατφόρμα.</p>";
$langIfYouWantToAddManyUsers = "Αν θέλετε να προσθέσετε ένα κατάλογο με χρήστες στο μάθημά σας, παρακαλώ συμβουλευτείτε τον διαχειριστή συστήματος.";
$langLastVisits = "Οι τελευταίες μου επισκέψεις";
$langLastUserVisits = "Τελευταίες επισκέψεις στο $langsCourse";
$langDumpUser = "Excel";
$langCsv = "αρχείο csv";
$langcsvenc1 = "κωδικοποίηση windows-1253";
$langcsvenc2 = "κωδικοποίηση UTF-8";
$langFieldsMissing = "Αφήσατε κάποια από τα υποχρεωτικά πεδία κενά!";
$langFillAgain = "Παρακαλούμε συμπληρώστε την ξανά";
$langFillAgainLink = "αίτηση";
$langReqRegProf = "Αίτηση δημιουργίας $langsOfCourses";
$langProfUname = "Επιθυμητό Όνομα Χρήστη (Username)";
$langReasonsForCreatingCourses = "Αναφέρατε τους λόγους δημιουργίας μαθημάτων";
$langProfEmail = "e-mail Χρήστη";
$reguserldap = "Εγγραφή Χρήστη μέσω LDAP";
$langByLdap = "Μέσω LDAP";
$langNewProf = "Εισαγωγή στοιχείων νέου λογαριασμού $langsOfTeacher";
$langRequestSuccess = "Η αίτηση σας στάλθηκε με επιτυχία.";
$langBackPage = "για να επιστρέψετε στην αρχική σελίδα.";
$emailprompt = "Δώστε την διεύθυνση e-mail σας:";
$ldapprompt = "Δώστε το συνθηματικό LDAP σας:";
$univprompt = "Επιλέξτε Πανεπιστημιακό Ίδρυμα";
$ldapnamesur = "Ονοματεπώνυμο:";
$langInstitution = 'Ίδρυμα:';
$ldapuserexists = "Στο σύστημα υπάρχει ήδη κάποιος χρήστης με τα στοιχεία που δώσατε.";
$ldapempty = "Αφήσατε κάποιο από τα πεδία κενό!";
$ldapfound = "πιστοποιήθηκε και τα στοιχεία που έδωσε είναι σωστά";
$ldapchoice = "Παρακαλούμε επιλέξτε το ίδρυμα στο οποίο ανήκετε!";
$ldapnorecords = "Δεν βρέθηκαν εγγραφές. Πιθανόν να δώσατε λάθος στοιχεία.";
$ldapwrongpasswd = "Το συνθηματικό που δώσατε είναι λανθασμένο. Παρακαλούμε δοκιμάστε ξανά";
$ldapproblem = "Υπάρχει πρόβλημα με τα στοιχεία του";
$ldapcontact = "Παρακαλούμε επικοινωνήστε με τον διαχειριστή του εξυπηρέτη LDAP.";
$ldaperror = "Δεν είναι δυνατή η σύνδεση στον εξυπηρέτη του LDAP.";
$ldapmailpass = "Το συνθηματικό σας είναι το ίδιο με αυτό της υπηρεσίας e-mail.";
$ldapback = "Επιστροφή στην";
$ldaplastpage = "προηγούμενη σελίδα";
$mailsubject = "Αίτηση " . $langOfTeacher . " - Υπηρεσία Τηλεκπαίδευσης";
$mailsubject2 = "Αίτηση " . $langOfStudent . " - Υπηρεσία Τηλεκπαίδευσης";
$contactphone = "Τηλέφωνο επικοινωνίας";
$contactpoint = "Επικοινωνία";
$searchuser = "Αναζήτηση Καθηγητών / Χρηστών";
$emailsuccess = "Το e-mail στάλθηκε!";
$langTheTeacher = 'Ο διδάσκων';
$langTheUser = 'Ο χρήστης';
$langDestination = 'Παραλήπτης:';
$langAsProf = "ως $langsTeacher";
$langTel = 'Τηλ.';
$langPassSameAuth = 'Το συνθηματικό σας είναι αυτό της υπηρεσίας πιστοποίησης του λογαριασμού σας.';
$langLdapRequest = 'Υπάρχει ήδη μια αίτηση για τον χρήστη';
$langLDAPUser = 'Χρήστης LDAP';
$langLogIn = 'Σύνδεση';
$langLogInWith = "Σύνδεση με";
$langOrLoginWith = 'Ή συνδεθείτε με';
$langAction = 'Ενέργεια';
$langRequiredFields = 'Τα πεδία με (*) είναι υποχρεωτικά';
$langCourseVisits = "Επισκέψεις ανά $langsCourse";
$langDurationVisitsPerCourse = "Διάρκεια συμμετοχής ανά $langsCourse";
$langSearchFor = 'Αναζήτηση στα ονόματα';
$langSearchExact = 'Για ακριβείς τιμές';
$langSearchStartsWith = 'Στην αρχή των ονομάτων';
$langSearchSubstring = 'Οπουδήποτε';
$langRequestForCourseCreationRights = "Αίτηση δημιουργίας $langsOfCourses - Υπηρεσία Τηλεκπαίδευσης";

// user registration
$langAuthUserName = "Δώστε το όνομα χρήστη:";
$langAuthPassword = "Δώστε το συνθηματικό σας:";
$langAuthenticateVia = "πιστοποίηση μέσω";
$langAuthenticateVia2 = "Διαθέσιμοι τρόποι πιστοποίησης του ιδρύματος";
$langStudentCannotRegister = "Για να εγγραφείτε στην πλατφόρμα επικοινωνήστε με τους διαχειριστές της πλατφόρμας.";
$langTeacherCannotRegister = "Για να εγγραφείτε ως χρήστης με δικαιώματα $langsOfTeacher, επικοινωνήστε με τους διαχειριστές της πλατφόρμας.";
$langCannotRegister = "Για να εγγραφείτε επικοινωνήστε με τους διαχειριστές της πλατφόρμας.";
$langConfirmUser = "Έλεγχος Στοιχείων Χρήστη";
$langUserData = "Στοιχεία χρήστη";
$langUsersData = "Στοιχεία χρηστών";
$langFileUserData = "Αρχείο με στοιχεία χρηστών (.xls, .xlsx)";
$langUsersAccount = "Λογαριασμοί χρηστών";
$langUserAccount = "Λογαριασμός $langOfStudent";
$langProfAccount = "Λογαριασμός $langOfTeacher";
$langUserAccountInfo1 = 'Αίτηση Νέου Λογαριασμού';
$langUserAccountInfo2 = 'Δημιουργία Νέου Λογαριασμού';
$langUserAccountInfo3 = 'Εναλλακτικά, μπορείτε να επιλέξετε';
$langUserAccountInfo4 = 'Σύνδεση με άλλο λογαριασμό';
$langNewAccount = 'Νέος Λογαριασμός';
$langNewAccountActivation = 'Ενεργοποίηση Λογαριασμού';
$langNewUserAccountActivation = "Ενεργοποίηση Λογαριασμού $langOfStudent";
$langNewProfAccountActivation = "Ενεργοποίηση Λογαριασμού $langOfTeacher";
$langNewAccountActivation1 = "την ενεργοποίηση λογαριασμού σας";
$langUserExistingAccount = "Στοιχεία Εισόδου";
$langMultiRegUserData = "Στοιχεία Λογαριασμών Χρηστών";
$langHybridAuthSetup1 = "<br>Για οδηγίες σχετικά με τον ορισμό των πεδίων <strong>";
$langHybridAuthSetup2 = " Id/Key</strong> και <strong>";
$langHybridAuthSetup3 = " Secret</strong> πατήστε <a href=";
$langHybridAuthSetup4 = " target='_blank' aria-label='(opens in a new tab)'>εδώ</a>.";
$langHybridAuthCallback = "<br>Ο σύνδεσμος <strong>callback</strong> της εφαρμογής είναι: ";
$langCustomEmailBody = "Προσαρμοσμένο email";
$langInfoEnableCourseRegistration = "Ο χρήστης μπορεί να εγγραφεί σε $langsCourses";
$langForcePasswordChange = "Αλλαγή του συνθηματικού κατά την είσοδο στην πλατφόρμα.";

// list requests
$langDateRequest = "Ημ/νία αίτησης";
$langDateReject = "Ημ/νία απόρριψης";
$langDateAccept = "Ημ/νία έγκρισης";
$langDateClosed = "Ημ/νία κλεισίματος";
$langDateCompleted = "Ημ/νία ολοκλήρωσης";

$langDateRequest_small = "Aίτησης";
$langDateReject_small = "Aπόρριψης";
$langDateClosed_small = "Kλεισίματος";
$langDateCompleted_small = "Oλοκλήρωσης";

$langRejectRequest = "Απόρριψη";
$langListRequest = "Λίστα Αιτήσεων";
$langTeacherRequestHasDeleted = "Η αίτηση διαγράφηκε!";
$langRejectRequestSubject = "Απόρριψη αίτησης εγγραφής στην Πλατφόρμα Ασύγχρονης Τηλεκπαίδευσης";
$langGoingRejectRequest = "Πρόκειται να απορρίψετε την αίτηση με στοιχεία:";
$langRequestSendMessage = "Αποστολή μηνύματος στο χρήστη στην διεύθυνση:";
$langRequestDisplayMessage = "στο μήνυμα θα αναφέρεται και το παραπάνω σχόλιο";
$langNoSuchRequest = "Δεν υπάρχει κάποια σχετική αίτηση με αυτό το ID. Δεν είναι δυνατή η επεξεργασία της αίτησης.";
$langTeacherRequestHasRejected = "Η αίτηση απορρίφθηκε";
$langRequestMessageHasSent = " και στάλθηκε ενημερωτικό μήνυμα στη διεύθυνση ";
$langRequestHasRejected = "Η αίτησή σας για εγγραφή στην πλατφόρμα $siteName απορρίφθηκε.";
$langRegistrationDateShort = "Ημ. εγγραφής";
$langRegistrationDate = "Ημερομηνία εγγραφής";
$langExpirationDate = "Ημερομηνία λήξης";
$langLastLogin = 'Τελευταία σύνδεση';
$langCourseRegistrationDate = "Ημ/νία εγγραφής στο $langsCourse";
$langUnknownDate = "(άγνωστη)";
$langUserID = "Αριθμός χρήστη";
$langStudentParticipation = "$langCourses στα οποία συμμετέχει ο χρήστης";
$langNoStudentParticipation = "Ο χρήστης δεν συμμετέχει σε κανένα $langsCourse";
$langExpireBeforeRegister = "Σφάλμα: H ημ/νια λήξης είναι πρίν την ημ/νια εγγραφής";
$langSuccessfulUpdate = "Τα στοιχεία του χρήστη ενημερώθηκαν";
$langNoUpdate = "Δεν είναι εφικτή η ενημέρωση των στοιχείων για το χρήστη με id";
$langUpdateNoChange = "Δεν πραγματοποιήθηκε καμία αλλαγή στα στοιχεία του χρήστη.";
$langError = "Σφάλμα";
$langGeneralError = "Παρουσιάστηκε σφάλμα. Παρακαλούμε επικοινωνήστε με τον διαχειριστή της πλατφόρμας.";
$langDirectoryCreateError = 'Δεν ήταν δυνατή η δημιουργία του υποκαταλόγου "%s".';
$langRegistrationError = "Λάθος Ενέργεια. Επιστρέψτε στην αρχική σελίδα της πλατφόρμας.";
$langUserNoRequests = "Δεν υπάρχουν ανοικτές αιτήσεις.";
$langCharactersNotAllowed = "Δεν επιτρέπονται στο password και στο username, οι χαρακτήρες: ',\" ή \\";
$langStar2 = "Στα πεδία με (**) ";
$langUserMerge = 'Συγχώνευση χρηστών';
$langUserMergeLegend = 'Συγχώνευση του χρήστη %s με...';
$langUserMergeTarget = 'Όνομα χρήστη με το οποίο θα γίνει συγχώνευση';
$langUserMergeForbidden = "Δεν είναι δυνατή η συγχώνευση $langsOfTeachers με μη-$langsTeachers. Παρακαλώ επιλέξτε κάποιον άλλο χρήστη.";
$langUserMergeAdminForbidden = "Η συγχώνευση διαχειριστών απαγορεύεται.";
$langUserMergeSuccess = "Η συγχώνευση του λογαριασμού «%s» με τον «%s» ολοκληρώθηκε. Έχει διατηρηθεί ο δεύτερος λογαριασμός.";
$langEditAuth = 'Αλλαγή τρόπου πιστοποίησης';
$langEditAuthMethod = 'Τρόπος πιστοποίησης';
$langEditAuthSetPass = 'Θα πρέπει να ορίσετε νέο κωδικό για το χρήστη.';
$langUnregForbidden = "Δεν επιτρέπεται να διαγράψετε τον χρήστη:";
$langUnregFirst = "Θα πρέπει να διαγράψετε πρώτα τον χρήστη από τα παρακάτω $langsCourses:";
$langUnregTeacher = "Είναι " . $langsTeacher . " στα παρακάτω $langsCourses:";
$langPlease = "Παρακαλούμε";
$langOtherDepartments = "Εγγραφή σε $langsCourses άλλων τμημάτων/σχολών";
$langNoLessonsAvailable = "Δεν υπάρχουν Διαθέσιμα $langCourses.";
$langUserPermissions = "Δικαιώματα";
$langUserWhitelist = "Whitelist Χρήστη";
$langUserHasConsent = "Έχει συναινέσει";
$langUserHasNoConsent = "Δεν έχει συναινέσει";
$langUserConsentUnknown = "Δεν έχει συναινέσει ακόμα ή δεν το έχει δει";

// formuser.php
$langUserRequest = "Αίτηση Δημιουργίας Λογαριασμού";
$langUserFillData = "Συμπλήρωση στοιχείων";
$langUserOpenRequests = "Ανοικτές αιτήσεις";
$langWarnReject = "Πρόκειται να απορρίψετε την αίτηση!";
$langWithDetails = "με στοιχεία";
$langNewUserDetails = "Στοιχεία Λογαριασμού Χρήστη-$langOfStudent";
$langInfoProfReq = "Αν επιθυμείτε να έχετε πρόβαση στην πλατφόρμα με δικαιώματα δημιουργίας $langsOfCourses, παρακαλώ συμπληρώστε την παρακάτω αίτηση. Η αίτηση θα σταλεί στον υπεύθυνο διαχειριστή ο οποίος θα δημιουργήσει το λογαριασμό και θα σας στείλει τα στοιχεία μέσω ηλεκτρονικού ταχυδρομείου.";
$langInfoStudReg = "Αν επιθυμείτε να έχετε πρόσβαση στην πλατφόρμα, παρακαλώ συμπληρώστε τα στοιχεία σας στην παρακάτω φόρμα. Ο λογαριασμός σας θα δημιουργηθεί αυτόματα.";
$langReason = "Αναφέρατε τους λόγους χρήσης της πλατφόρμας";
$langInfoStudReq = "Αν επιθυμείτε να αποκτήσετε δικαιώματα δημιουργίας μαθημάτων, παρακαλώ συμπληρώστε την παρακάτω αίτηση. Η αίτηση θα σταλεί στην ομάδα διαχείρισης της πλατφόρμας.";
$langInfoProf = "Σύντομα θα σας σταλεί mail από την Ομάδα Διαχείρισης της Πλατφόρμας Ασύγχρονης Τηλεκπαίδευσης, με τα στοιχεία του λογαριασμού σας.";
$langMailErrorMessage = "Παρουσιάστηκε σφάλμα κατά την αποστολή του μηνύματος.<br/>Η αίτησή σας καταχωρήθηκε στην πλατφόρμα, αλλά δεν στάλθηκε ενημερωτικό email στο διαχειριστή του συστήματος. <br/>Παρακαλούμε επικοινωνήστε με το διαχειριστή στη διεύθυνση:";
$langUserSuccess = "Νέος λογαριασμός $langOfStudent";
$langUserCreated = "Η δημιουργία νέου λογαριασμού πραγματοποιήθηκε με επιτυχία!";
$langEmailAddressErrors = "Η διεύθυνση email σας δεν είναι συμπληρωμένη ή δεν είναι επιβεβαιωμένη!";

$langAsUser = "(Λογαριασμός $langOfStudent)";
$langChooseReg = "Επιλογή τρόπου εγγραφής";
$langTryAgain = "Δοκιμάστε ξανά!";
$langViaReq = "Εγγραφή χρηστών μέσω αίτησης";
$langUserDurationAccount = "Χρονική διάρκεια λήξης λογαριασμών";
$langHere = "εδώ";
$langMailVerificationClick = "Παρακαλούμε πατήστε στη παρακάτω διεύθυνση:";
$langMailVerificationSubject = "Επιβεβαίωση Αίτησης Δημιουργίας Λογαριασμού $siteName";
$langMailChangeVerificationSubject = "Επιβεβαίωση e-mail λογαριασμού $siteName";
$langRequestWithMailVerify = "Η αίτηση σας έχει σταλεί. Σημειώστε ότι θα πρέπει να επιβεβαιώσετε την ηλεκτρονική διεύθυνση που δηλώσατε";
$langRegistrationWithMailVerify = "Η εγγραφή σας έχει ολοκληρωθεί. Σημειώστε ότι θα πρέπει να επιβεβαιώσετε την ηλεκτρονική διεύθυνση που δηλώσατε";
$langMailVerificationSuccess = "Θα πρέπει να επιβεβαιώσετε την ηλεκτρονική διεύθυνση που δηλώσατε.";
$langMailVerificationSuccess2 = "Για το σκοπό αυτό, ελέγξτε το ηλεκτρονικό σας ταχυδρομείο όπου θα σας έχει σταλεί email επιβεβαίωσης.
                                Μόλις η επιβεβαίωση ολοκληρωθεί, θα σας σταλεί δεύτερο e-mail με τα στοιχεία σας.";
$langMailVerificationNote = "(Σημ. Αν τυχόν δεν λάβετε email ελέγξτε τον φάκελο ανεπιθύμητης αλληλογραφίας)";
$langMailVerificationBody1 = "Ευχαριστούμε για την εγγραφή σας στο $siteName.<br><br>$langMailVerificationSuccess<br>$langMailVerificationClick<br>%s";
$langMailVerificationChangeBody = "Για να ενεργοποιηθεί ο λογαριασμός σας θα πρέπει να επιβεβαιωθεί η e-mail διεύθυνση σας.<br><br>$langMailVerificationClick<br>%s";
$langMailVerificationError = "Παρουσιάστηκε σφάλμα κατά την αποστολή του μηνύματος προς τη διεύθυνση %s.<br/><br/>Παρακαλούμε <a href='%s'>δοκιμάστε ξανά</a> ή επικοινωνήστε με το διαχειριστή στη διεύθυνση: %s";
$langMailVerificationError2 = "Παρουσιάστηκε σφάλμα. Παρακαλούμε επικοινωνήστε με το διαχειριστή της πλατφόρμας.";
$langMailVerificationToaddr = "στην ηλεκτρονική διεύθυνση";
$langMailVerificationCode = "Κωδικός επιβεβαίωσης";
$langMailVerificationNewCode = "Αποστολή κωδικού επιβεβαίωσης";
$langMailVerificationWrong = "Η διεύθυνση ηλεκτρονικού ταχυδρομείου δεν άλλαξε γιατί δεν είναι συμπληρωμένη ή περιέχει άκυρους χαρακτήρες";
$langMailVerificationAddrChange = "παρακαλούμε πληκτρολογήστε μία σωστή διεύθυνση";
$langMailVerificationSuccess3 = "Ελέγξτε ότι είναι σωστή η παρακάτω ηλεκτρονική διεύθυνση και πατήστε στην «<strong>$langMailVerificationNewCode</strong>»";
$langMailVerificationReq = "Είναι απαραίτητο να επιβεβαιωθεί η e-mail διεύθυνση σας προτού προχωρήσετε.<br /><br />$langMailVerificationSuccess3";
$langMailVerificationSuccess4 = "Σύντομα θα λάβετε ένα e-mail από την Ομάδα Διαχείρισης της Πλατφόρμας Ασύγχρονης Τηλεκπαίδευσης $siteName, με τις απαραίτητες οδηγίες για την ολοκλήρωση της εγγραφής σας";
$langMailVerification = "Επιβεβαίωση E-mail $langUsersOf";
$langMailVerificationNo = "Χρήστες που δεν έχουν επιβεβαιώσει το e-mail τους";
$langMailVerificationYes = "Χρήστες που έχουν επιβεβαιώσει το e-mail τους";
$langMailVerificationPending = "Χρήστες που εκκρεμεί η επιβεβαίωση του e-mail τους";
$langUsersWithNoMail = "Χρήστες που δεν έχουν δηλώσει e-mail";
$langMailVerificationNoU = "Δεν έχει επιβεβαιωθεί";
$langMailVerificationYesU = "Έχει επιβεβαιωθεί";
$langMailVerificationPendingU = "Εκκρεμεί επιβεβαίωση";
$langRegisteredUserAlreadyExists = 'Υπάρχει ήδη λογαριασμός με τα στοιχεία με τα οποία δοκιμάσατε να εγγραφείτε. Αν έχετε χάσει το συνθηματικό σας, μπορείτε να ορίσετε νέο.';

// mail_ver_settings.php
$langMailVerificationSettings = 'Ρυθμίσεις επιβεβαίωσης e-mail διεύθυνσης χρηστών';
$langMailVerificationNotice = "Εάν είναι υποχρεωτική η επιβεβαίωση του e-mail του $langOfUserS
                και η επιβεβαίωση εκκρεμεί, τότε ισχύουν τα παρακάτω μέχρι να ολοκληρωθεί
                η επιβεβαίωση:<br /><ul><li>η πλατφόρμα θα παραπέμπει τον χρήστη στη σελίδα επιβεβαίωσης του e-mail</li>
                <li>ο χρήστης δεν θα λαμβάνει e-mail με ανακοινώσεις από τα $langsCourses που παρακολουθεί</li></ul>";
$langMailVerificationNoticeAdmin = "Δεν είναι δυνατή η αλλαγή του χρήστη admin από αυτή την σελίδα.";
$langMailVerificationNoticeGuest = "Δεν είναι δυνατή η αλλαγή των guest χρηστών από αυτή την σελίδα.";
$langChangeTo = "Αλλαγή σε";
$langMailVerificationChanged = "Έγινε αλλαγή";
$langMailVerificationChangedNo = "Δεν επιλέξατε κάποια αλλαγή";
$langMailVerificationChangedNoAdmin = "Μηδενικός αριθμός χρηστών ή δεν επιτρέπεται η αλλαγή του χρήστη admin";
$langCourseUserRegDone = "Η εγγραφή χρήστη πραγματοποιήθηκε με επιτυχία.";
$langCourseUserRegError = "Παρουσιάστηκε σφάλμα κατά την εγγραφή χρήστη.";

/* ****************************************
 * api token.php
 ***************************************** */

$langNoApiToken = "Δεν έχουν δημιουργηθεί api tokens";
$langApiTokenDeleted = "Το token διαγράφηκε με επιτυχία";

/* * **********************************************************
 * restore_course.php
 * *********************************************************** */
$langInvalidArchive = "Μη έγκυρο αρχείο $langsOfCourse";
$langFirstMethod = "1ος τρόπος";
$langSecondMethod = "2ος τρόπος";
$langRequest1 = "Κάντε κλικ στο Browse για να αναζητήσετε το αντίγραφο ασφαλείας του $langsOfCourse που θέλετε να επαναφέρετε. Μετά κάντε κλικ στο 'Αποστολή'.";
$langRestore = "Επαναφορά";
$langRequest2 = "Αν το αντίγραφο ασφαλείας, από το οποίο θα ανακτήσετε το $langsCourse, είναι μεγάλο σε μέγεθος και δεν μπορείτε να το ανεβάσετε, τότε μπορείτε να πληκτρολογήσετε τη ακριβή διαδρομή (path) που βρίσκεται το αρχείο στον server.";
$langRestoreStep1 = "1° Ανάκτηση $langsOfCourse από αρχείο ή υποκατάλογο.";
$langFileNotFound = "Το αρχείο δεν βρέθηκε.";
$langFileSent = "Στάλθηκε ένα αρχείο";
$langFileSentName = "Όνομα:";
$langFileSentSize = "Μέγεθος:";
$langFileSentType = "Τύπος:";
$langFileSentTName = "Προσωρινό όνομα:";
$langFileUnzipping = "Αποσυμπίεση του αρχείου";
$langEndFileUnzip = "Τέλος αποσυμπίεσης";
$langLesFound = "$langCourses που βρέθηκαν μέσα στο αρχείο:";
$langLesFiles = "Αρχεία του $langsOfCourse:";
$langInvalidCode = "Μη αποδεκτός κωδικός $langsOfCourse";
$langCopyFiles = "Τα αρχεία του $langsOfCourse αντιγράφηκαν.";
$langCourseExists = "Υπάρχει ήδη ένα $langsCourse με αυτόν τον κωδικό !";
$langUserExists = "Στην πλατφόρμα υπάρχει ήδη ένας χρήστης με username";
$langUserExists2 = "Ονομάζεται";
$langWarning = "<em><font color='red'>ΠΡΟΣΟΧΗ!</font></em> Αν επιλέξετε να μην προστεθούν οι χρήστες του $langsOfCourse και το αντίγραφο ασφαλείας του $langsOfCourse, περιέχει υποσυστήματα με πληροφορίες που σχετίζονται με τους χρήστες (π.χ. 'Εργασίες Φοιτητών', 'Χώρος Ανταλλαγής Αρχείων' ή 'Ομάδες Χρηστών') τότε οι πληροφορίες αυτές <strong>ΔΕΝ</strong> θα ανακτηθούν.";
$langUserWith = "Σφάλμα! Ο χρήστης με userid";
$langAlready = "ήδη προστέθηκε";
$langWithUsername = "Ο χρήστης με username";
$langUserisAdmin = "είναι διαχειριστής";
$langUsernameSame = "το username του παραμένει ίδιο.";
$langUName = "Ονομάζεται";
$langInfo1 = "Το αντίγραφο ασφαλείας που στείλατε περιείχε τις παρακάτω πληροφορίες για το $langsCourse.";
$langInfo2 = "Μπορείτε να αλλάξετε τον κωδικό του $langsOfCourse και ό,τι άλλο θέλετε (π.χ. περιγραφή, καθηγητής κ.λπ.)";
$langCourseOldFac = "Παλιά $langFaculty";
$langCourseVis = "Τύπος πρόσβασης";
$langCourseType = "$langpre / $langpost";
$langPrevId = "Προηγούμενο user_id";
$langNewId = "Νέο user_id";
$langUsersWillAdd = "Οι χρήστες του $langsOfCourse θα προστεθούν";
$langErrorLang = "Πρόβλημα! Δεν υπάρχουν γλώσσες για το $langsCourse!";
$langRestoreUserExists = "%s: Ο λογαριασμός υπήρχε ήδη. Τρέχον ονοματεπώνυμο: %s. Ονοματεπώνυμο στο αρχείο: %s.";
$langRestoreUserNew = "%s: Ο λογαριασμός δημιουργήθηκε. Ονοματεπώνυμο: %s";
$langOldValue = 'Παλιά τιμή';

/* * ***************************************************************
 * search.php
 * *************************************************************** */
$langDoSearch = "Εκτέλεση Αναζήτησης";
$langSearch_terms = "Όροι Αναζήτησης: ";
$langSearchIn = "Αναζήτηση σε: ";
$langSearchWith = "Αναζήτηση με κριτήρια:";
$langNoResult = "Δεν βρέθηκαν αποτελέσματα";
$langIntroductionNote = "Εισαγωγικό Σημείωμα";
$langForum = "Περιοχή συζητήσεων";
$langOR = "Τουλάχιστον έναν από τους όρους";
$langNOT = "Κανέναν από τους ακόλουθους όρους";
$langKeywords = "Λέξεις κλειδιά";
$langTitle_Descr = "αφορά τον τίτλο ή τμήμα από τον τίτλο του $langsOfCourse";
$langKeywords_Descr = "μία ή περισσότερες λέξεις κλειδιά που προσδιορίζουν τη θεματική περιοχή του $langsOfCourse";
$langInstructor_Descr = "το όνομα ή τα ονόματα των καθηγητών του $langsOfCourse";
$langCourseCode_Descr = "ο κωδικός του $langsOfCourse";
$langDescription_Descr = "αφορά την περιγραφή του $langsOfCourse, των θεματικών ενοτήτων και των σχετικών πόρων";
$langAccessType = "Τύπος Πρόσβασης";
$langTypeClosed = "Κλειστό";
$langTypesClosed = "Κλειστά";
$langTypeOpen = "Ανοικτό";
$langTypesOpen = "Ανοικτά";
$langTypesInactive = 'Ανενεργά';
$langTypesAccessControlled = 'Ελεγχόμενης πρόσβασης';
$langTypeRegistration = "Ανοικτό με εγγραφή";
$langTypesRegistration = "Ανοικτά με εγγραφή";
$langTypeInactive = "Ανενεργό";
$langAllTypes = "(όλοι οι τύποι πρόσβασης)";
$langAllFacultes = "Σε όλες τις $langsFaculties";
$langSuccess = "Επιτυχία";
$langFailure = "Αποτυχία";
$langAuthRequest = "Απαιτείται εξακρίβωση στοιχείων";
$langAlreadySubscribe = "Είστε ήδη εγγεγραμμένος";
$langAs = "ως";
$langSearchDisabled = "Η μηχανή αναζήτησης είναι απενεργοποιημένη.
        Για περισσότερες πληροφορίες επικοινωνήστε με τους διαχειριστές της πλατφόρμας.";

/* * **********************************************************
 * upgrade.php
 * ********************************************************** */
$langUpgrade = "Αναβάθμιση";
$langLogFileWriteError = 'Σφάλμα κατά την εγγραφή του αρχείου καταγραφής:';
$langExplUpgrade = "Το πρόγραμμα αναβάθμισης θα τροποποιήσει το αρχείο ρυθμίσεων <em>config.php</em>.
   Επομένως πριν προχωρήσετε στην αναβάθμιση βεβαιωθείτε ότι ο web server
   μπορεί να έχει πρόσβαση στο <em>config.php</em>. Για λόγους ασφαλείας, οι
   τωρινές ρυθμίσεις του <em>config.php</em> θα κρατηθούν στο αρχείο
   <em>config_backup.php</em>.";
$langExpl2Upgrade = "Για λόγους ασφαλείας βεβαιωθείτε ότι έχετε κρατήσει αντίγραφα ασφαλείας των βάσεων δεδομένων.";
$langWarnUpgrade = "ΠΡΟΣΟΧΗ!";
$langUpgradeInProgress = 'Η χρήση της πλατφόρμας είναι προσωρινά αδύνατη, καθώς εδώ
    και %s βρίσκεται σε εξέλιξη διαδικασία αναβάθμισης. Παρακαλούμε περιμένετε να
    ολοκληρωθεί η διαδικασία πριν συνδεθείτε.';
$langUpgradeCont = "Για να προχωρήσετε στην αναβάθμιση της βάσης δεδομένων, δώστε το όνομα
   χρήστη και το συνθηματικό του διαχειριστή της πλατφόρμας.";
$langUpgDetails = "Στοιχεία Εισόδου Διαχειριστή";
$langUpgMan = "οδηγίες αναβάθμισης";
$langUpgLastStep = "πριν προχωρήσετε στο παρακάτω βήμα.";
$langUpgToSee = "Για να δείτε τις αλλαγές-βελτιώσεις της καινούριας έκδοσης του eClass κάντε κλικ";
$langUpgRead = "Αν δεν το έχετε κάνει ήδη, παρακαλούμε διαβάστε και ακολουθήστε τις";
$langUpgTooOld = 'Η έκδοση του Open eClass από την οποία γίνεται αναβάθμιση
   είναι πολύ παλιά. Παρακαλούμε αναβαθμίστε την εγκατάστασή σας πρώτα
   στην έκδοση 3.0 και στη συνέχεια στην τελευταία έκδοση.';
$langSuccessOk = "Επιτυχία";
$langSuccessBad = "Σφάλμα ή δεν χρειάζεται τροποποίηση";
$langUpgAdminError = "Τα στοιχεία που δώσατε δεν αντιστοιχούν στο διαχειριστή του συστήματος! Παρακαλούμε ξαναδοκιμάστε.";
$langUpgNoVideoDir = "Ο υποκατάλογος 'video' δεν υπάρχει και δεν μπόρεσε να δημιουργηθεί. Ελέγξτε τα δικαιώματα πρόσβασης.";
$langUpgNoVideoDir2 = "Υπάρχει ήδη ένας κατάλογος με όνομα 'video'!";
$langUpgNoVideoDir3 = "Δεν υπάρχει δικαίωμα εγγραφής στον υποκατάλογο 'video'!";
$langConfigError4 = "Δεν ήταν δυνατή η πρόσβαση στον κατάλογο του αρχείο ρυθμίσεων config.php! Ελέγξτε τα δικαιώματα πρόσβασης.";
$langConfigError1 = "Δεν ήταν δυνατή η λειτουργία αντιγράφου ασφαλείας του config.php! Ελέγξτε τα δικαιώματα πρόσβασης.";
$langConfigError2 = "Το αρχείο ρυθμίσεων config.php δεν μπόρεσε να διαβαστεί! Ελέγξτε τα δικαιώματα πρόσβασης.";
$langConfigError3 = "Δεν πραγματοποιήθηκε η εγγραφή των αλλαγών στο αρχείο ρυθμίσεων config.php! Ελέγξτε τα δικαιώματα πρόσβασης.";
$langUpgradeSuccess = "Η αναβάθμιση των βάσεων δεδομένων του eClass πραγματοποιήθηκε!";
$langUpgReady = "Είστε πλέον έτοιμοι να χρησιμοποιήσετε την καινούρια έκδοση του Open eClass!";
$langUpgSucNotice = "Παρουσιάστηκε κάποιο σφάλμα, πιθανόν κάποιο $langsCourse να μην δουλεύει εντελώς σωστά.<br>Σε αυτή την περίπτωση επικοινωνήστε μαζί μας στο <a href='mailto:eclass@gunet.gr'>eclass@gunet.gr</a> περιγράφοντας το πρόβλημα που παρουσιάστηκε και στέλνοντας (αν είναι δυνατόν) όλα τα μηνύματα που εμφανίστηκαν στην οθόνη σας.";
$langUpgCourse = "Αναβάθμιση $langsOfCourse";
$langUpgFileNotRead = "To αρχείο δεν μπόρεσε να διαβαστεί. Ελέγξτε τα δικαιώματα πρόσβασης.";
$langUpgFileNotModify = "Το αρχείο δεν μπόρεσε να τροποποιηθεί. Ελέγξτε τα δικαιώματα πρόσβασης.";
$langUpgNotChDir = "Δεν πραγματοποιήθηκε η αλλαγή στον κατάλογο αναβάθμισης! Ελέγξτε τα δικαιώματα πρόσβασης.";
$langUpgIndex = "Τροποποίηση αρχείου index.php του $langsOfCourse";
$langUpgIndexingNotice = "Λόγω του πλήθους των $langsOfCourses, οι μηχανές αναζήτησης και ευρετηριοποίησης έχουν απενεργοποιηθεί. Παρακαλούμε ανατρέξτε στις ρυθμίσεις της πλατφόρμας για την επαναφορά τους και ακολουθήστε τις οδηγίες για την ευρετηριοποίηση.";
$langIdxErrorPermissions = "Η λειτουργία αναζήτησης δεν λειτουργεί λόγω προβλήματος με τα δικαιώματα πρόσβασης στον κατάλογο (courses/idx/)";
$langSearchTooManyFiles = "Η λειτουργία αναζήτησης δεν λειτουργεί επειδή έφθασε στο μέγιστο αριθμό ανοικτών αρχείων στον κατάλογο (courses/idx/)";
$langCheckPerm = "Ελέγξτε τα δικαιώματα πρόσβασης";
$langUpgNotIndex = "Δεν πραγματοποιήθηκε η αλλαγή στον κατάλογο του $langsOfCourse";
$langUpgContact = "Στοιχεία Επικοινωνίας";
$langUpgAddress = "Διεύθυνση Ιδρύματος:";
$langUpgTel = "Τηλ. Επικοινωνίας:";
$langUpgReg = "Εγγραφή Χρηστών";
$langUpgForVersion = 'Αναβαθμίσεις έκδοσης:';
$langAddDirectoryIndexes = 'Προσθήκη αρχείων index σε υποφακέλους για λόγους ασφαλείας';
$langTable = "Πίνακας";
$langToTable = "στον πίνακα";
$langAddField = "Προσθήκη πεδίου";
$langAfterField = "μετά το πεδίο";
$langToA = "σε";
$langRenameField = "Μετονομασία πεδίου";
$langOfTable = "του πίνακα";
$langDeleteField = "Διαγραφή πεδίου";
$langDeleteTable = "Διαγραφή πίνακα";
$langMergeTables = "Ενοποίηση των πινάκων";
$langIndexExists = "Υπάρχει ήδη κάποιο index στον πίνακα";
$langIndexAdded = "Προστέθηκε index";
$langIndexCreation = "Δημιουργία indexes";
$langNotTablesList = "Πρόβλημα με την Β.Δ. Δεν ήταν δυνατή η εύρεση των πινάκων";
$langNotMovedDir = "Προσοχή: Δεν ήταν δυνατή η μεταφορά του υποκαταλόγου";
$langToDir = "στο φάκελο";
$langCorrectTableEntries = "Διόρθωση εγγραφών του πίνακα";
$langMoveIntroText = "Μεταφορά του εισαγωγικού κειμένου στον πίνακα";
$langEncodeDocuments = "Κωδικοποίηση των περιεχομένων του υποσυστήματος 'Έγγραφα'";
$langEncodeGroupDocuments = "Κωδικοποίηση των περιεχομένων του υποσυστήματος Ομάδες Χρηστών - 'Έγγραφα'";
$langEncodeDropBoxDocuments = "Κωδικοποίηση των περιεχομένων του υποσυστήματος Ανταλλαγή Αρχείων";
$langEncDropboxError = "Πρόβλημα κατά την μετονομασία στο υποσύστημα Ανταλλαγή Αρχείων";
$langWarnVideoFile = "Προσοχή: το αρχείο video";
$langChangeDBCharset = "Αλλαγή κωδικοποίησης βάσης δεδομένων";
$langToUTF = "σε UTF-8";
$langEncryptPass = "Κωδικοποίηση των συνθηματικών των χρηστών";
$langNotEncrypted = "ΠΡΟΣΟΧΗ! Η διαδικασία αναβάθμισης δεν μπόρεσε να κρυπτογραφήσει τα password και η πλατφόρμα δεν μπορεί να λειτουργήσει. Αφαιρέστε τη γραμμή «\$encryptedPasswd = true;» από το αρχείο ρυθμίσεων config.php";
$langUpgradeStart = 'Έναρξη αναβάθμισης';
$langUpgradeConfig = 'Αναβάθμιση αρχείου ρυθμίσεων (config.php)';
$langUpgradeMulUsernames = "Βρέθηκαν χρήστες με πολλαπλά usernames οπότε πραγματοποιήθηκαν οι παρακάτω αλλαγές:";
$langUpgradeChangeUsername = "Αλλαγή του ονόματος χρήστη από %s σε %s";
$langLogOutput = "Μηνύματα αναβάθμισης";
$langInnoDBMissing = 'Ο εξυπηρετητής της βάσης δεδομένων MySQL δεν υποστηρίζει
    την InnoDB storage engine. Θα πρέπει να ενεργοποιηθεί πριν συνεχίσετε, καθώς
    είναι απαραίτητη για τη σωστή λειτουργία της πλατφόρμας.';
$langErrorConnectDatabase = "Παρουσιάστηκε σφάλμα κατά τη σύνδεση με τη βάση δεδομένων:";
$langCheckDatabaseSettings = "Παρακαλούμε ελέγξτε τα στοιχεία και ξαναδοκιμάστε.";
$langDatabaseExists = 'Προσοχή: Η βάση δεδομένων "%s" υπάρχει ήδη. Οι πίνακες
    που περιέχονται σε αυτή θα διαγραφούν αν έχουν ονόματα ίδια με αυτά που
    χρησιμοποιεί η πλατφόρμα (είτε συμπτωματικά, είτε αν πρόκειται για υπάρχουσα
    εγκατάσταση του Open eClass). Πριν προχωρήσετε, επιβεβαιώστε ότι δεν υπάρχει
    πρόβλημα ή επιστρέψτε στο προηγούμενο βήμα και εισαγάγετε άλλο όνομα βάσης.';
$langAddingDirectoryIndex = 'Προσθήκη αρχείων index.html στους υποκαταλόγους μαθημάτων';
$langChangeDBEncoding = "Αλλαγή κωδικοποίησης της βάσης δεδομένων σε utf8mb4";
$langUpgradeDBInfoMessage = "Η αναβάθμιση της βάσης δεδομένων έχει ξεκινήσει.";
$langUpgradePopUpCloseWarning = "Προσοχή! Μην κλείσετε αυτό το παράθυρο γιατί θα διακοπεί η αναβάθμιση!";
$langUpgFinished = 'Ολοκληρώθηκε';
$langUpgUTF8MB4 = 'Μετατροπή πινάκων σε πλήρες εύρος Unicode';
$langEncodeUserProfilePics = 'Κωδικοποίηση εικόνων προφίλ χρηστών';
$langPreviousVersion = 'Προηγούμενη έκδοση';
$langUpgradeFinished = "Ολοκλήρωση αναβάθμισης";
$langUpgradeProcess = "Πορεία αναβάθμισης";

/* * *****************************************************************
 * course_tools.php
 * ****************************************************************** */
$langTool = "Εργαλείο";
$langUploadPage = "Ανέβασμα ιστοσελίδας";
$langAddExtLink = "Προσθήκη εξωτερικού συνδέσμoυ";
$langAddCoursePage = 'Προσθήκη σελίδας μαθήματος';
$langCoursePages = 'Σελίδες μαθήματος';
$langConfirmDeleteLink = "Επιβεβαίωση διαγραφής συνδέσμου";
$langOperations = "Ενέργειες σε εξωτερικούς σύνδεσμους";
$langInactiveTools = "Ανενεργά εργαλεία";
$langSubmitChanges = "Υποβολή αλλαγών";
$langActivateCourseTools = "Διαχείριση εργαλείων";
$iso639_2_code = "el";
$langNameOfLang['greek'] = "Ελληνικά";
$langNameOfLang['english'] = "Αγγλικά";
$langNameOfLang['spanish'] = "Ισπανικά";
$langNameOfLang['czech'] = "Τσέχικα";
$langNameOfLang['german'] = "Γερμανικά";
$langNameOfLang['italian'] = "Ιταλικά";
$langNameOfLang['french'] = "Γαλλικά";
$langNameOfLang['slovene'] = 'Σλοβενικά';
$langNameOfLang['slovak'] = 'Σλοβακικά';
$langNameOfLang['dutch'] = 'Ολλανδικά';
$langNameOfLang['icelandic'] = 'Ισλανδικά';
$langNameOfLang['croatian'] = 'Κροατικά';
$langNameOfLang['portuguese'] = 'Πορτογαλικά';
$langNameOfLang['variables'] = "Ονόματα μεταβλητών";
$charset = 'UTF-8';
$dateFormatShort = "%b %d, %y";
$dateFormatMiddle = "%d %b %Y";
$dateFormatLong = '%A, %d %B %Y';
$dateTimeFormatLong = '%d %B %Y / Ώρα: %R';
$dateTimeFormatShort = '%d %b %Y %R';
$dateTimeFormatLongFull = '%A, %d %B %Y / Ώρα: %R';
$timeNoSecFormat = '%R';
$langNoAdminAccess = '
        <strong>Η σελίδα που προσπαθείτε να μπείτε απαιτεί όνομα χρήστη και συνθηματικό.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε προτού προχωρήσετε σε άλλες ενέργειες. Πιθανόν, να έληξε η σύνοδός σας.';
$langLoginRequired = "
        <strong>Δεν είστε εγγεγραμμένος στο $langsCourse και επομένως δεν μπορείτε να χρησιμοποιήσετε το αντίστοιχο υποσύστημα.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να εγγραφείτε στο $langsCourse, αν η εγγραφή είναι ελεύθερη.";
$langSessionIsLost = "
        <strong>Η σύνοδος σας έχει λήξει.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε προτού προχωρήσετε σε άλλες ενέργειες.";
$langCheckProf = "
        <strong>Η ενέργεια που προσπαθήσατε να εκτελέσετε απαιτεί δικαιώματα διαχειριστή $langsOfCourse.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.";
$langCheckCourseAdmin = "
        <strong>Η ενέργεια που προσπαθήσατε να εκτελέσετε απαιτεί δικαιώματα διαχειριστή $langsOfCourse.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.";
$langLessonDoesNotExist = "
	<strong>Το $langsCourse που προσπαθήσατε να προσπελάσετε δεν υπάρχει.</strong>
	<br>Αυτό μπορεί να συμβαίνει γιατί εκτελέσατε μια μη επιτρεπτή ενέργεια ή λόγω τεχνικού προβλήματος
	στην πλατφόρμα.</p>";
$langCheckAdmin = "
        <strong>Η ενέργεια που προσπαθήσατε να εκτελέσετε απαιτεί δικαιώματα διαχειριστή.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.</p>";
$langCheckPowerUser = "
        <strong>Η ενέργεια που προσπαθήσατε να εκτελέσετε απαιτεί δικαιώματα διαχειριστή χρηστών και $langsOfCourses.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.";
$langCheckUserManageUser = "<strong>Η ενέργεια που προσπαθήσατε να εκτελέσετε απαιτεί δικαιώματα διαχειριστή χρηστών.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.";
$langCheckDepartmentManageUser = "<strong>Η ενέργεια που προσπαθήσατε να εκτελέσετε απαιτεί δικαιώματα διαχειριστή τμημάτων.</strong>
        <br>Η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.";
$langCheckGuest = "
        <strong>Η ενέργεια που προσπαθήσατε να εκτελέσετε δεν είναι δυνατή με δικαιώματα επισκέπτη χρήστη.</strong>
        <br>Για λόγους ασφάλειας η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.";
$langCheckMailVerify = "
        <strong>$langMailVerificationSuccess</strong>";
$langCheckPublicTools = "
        <strong>Προσπαθήσατε να αποκτήσετε πρόσβαση σε απενεργοποιημένο εργαλείο $langsOfCourse.</strong>
        <br>Για λόγους ασφάλειας η πλατφόρμα σάς ανακατεύθυνε αυτόματα στην αρχική σελίδα
        για να συνδεθείτε ξανά.";
$langWarnShibUser = "
        <strong>Προειδοποίηση:</strong> Επειδή η πιστοποίησή σας έγινε μέσω Shibboleth δεν έχετε αποσυνδεθεί από την πλατφόρμα!
        <br>Για να αποσυνδεθείτε θα πρέπει να κλείσετε τον browser σας.</p>";
$langCheckUserRegistration = "<strong>Η ενέργεια που προσπαθείτε να εκτελέσετε απαιτεί εγγραφή στο $langsCourse</strong>";

$langUserPortfolio = "Χαρτοφυλάκιο χρήστη";
$langPortfolio = "Χαρτοφυλάκιο";
$langMyPortfolio = "Το χαρτοφυλάκιο μου";
$langAdvancedSearch = "Σύνθετη αναζήτηση";
$langTitle = "Τίτλος";
$langType = "Τύπος";
$langSummaryProfile = "Συνοπτικό προφίλ";
$langMoreInfo = "ΠΕΡΙΣΣΟΤΕΡΕΣ ΠΛΗΡΟΦΟΡΙΕΣ";
$langAboutMe = "ΣΧΕΤΙΚΑ ΜΕ ΕΜΕΝΑ";
$langPersonalInfo = "ΠΡΟΣΩΠΙΚΑ ΣΤΟΙΧΕΙΑ";
$langMyInterests = "Τα ενδιαφέροντά μου";
$langEditProfile = "ΕΠΕΞΕΡΓΑΣΙΑ ΠΡΟΦΙΛ";
$langDeleteAccount ="ΔΙΑΓΡΑΦΗ ΛΟΓΑΡΙΑΣΜΟΥ";
$langLastVisit = "Τελευταία επίσκεψη";
$langMyCourses = "Τα μαθήματα μου";
$langAllAnnouncements = "Όλες";
$langRecentMessages = "Πρόσφατα μηνύματα";
$langWelcomeTo = "Καλως Ήρθατε στην ";

/* * *************************************************************
 * unreguser.php
 * ************************************************************** */
$langBackHome = "Επιστροφή στην αρχική σελίδα";
$langAdminNo = "Ο λογαριασμός του διαχειριστή της πλατφόρμας δεν μπορεί να διαγραφεί!";
$langExplain = "Για να διαγραφείτε από την πλατφόρμα, πρέπει πρώτα να απεγγραφείτε από τα $langsCourses που είστε εγγεγραμμένος.";
$langConfirm = "Επιβεβαίωση διαγραφής λογαριασμού";
$langDelSuccess = "Ο λογαριασμός σας έχει διαγραφεί.";
$langThanks = "Ευχαριστούμε για τη χρήση της πλατφόρμας!";

//unregcours.php
$langCoursDelSuccess = "Η απεγγραφή σας από το $langsCourse έγινε με επιτυχία";
$langCoursError = "Σφάλμα κατά την απεγγραφή του χρήστη";
$langConfirmUnregCours = "Θέλετε σίγουρα να απεγγραφείτε από το $langsCourse;";

/* * *****************************************************************
 * usage.php
 * ****************************************************************** */
$langCreateStatsGraph = "Επιλογή παραμέτρων";
$langPersonalStats = "Τα στατιστικά μου";
$langUserLogins = "Επισκέψεις χρηστών";
$langUserDuration = "Συμμετοχή χρηστών";
$langStartDate = "Ημερομηνία Έναρξης";
$langEndDate = "Ημερομηνία Λήξης";
$langAllUsers = "Όλοι οι χρήστες";
$langAllAuthTypes = "Όλοι οι τρόποι πιστοποίησης";
$langAllCourses = "Όλα τα $langsCourses";
$langSubmit = "Υποβολή";
$langCheck = "Έλεγχος";
$langModule = "Υποσύστημα";
$langValueType = "Είδος Στατιστικών";
$langQuantity = "Ποσοτικά";
$langProportion = "Ποσοστιαία";
$langStatsType = "Είδος Στατιστικών";
$langTotalVisits = "Συνολικές επισκέψεις";
$langTotalDuration = "Συνολική διάρκεια";
$langVisits = "Αριθμός Επισκέψεων";
$langHits = "Αριθμός Προβολών";
$langVisitsShort = "Αρ. Επισκέψεων";
$langHitsShort = "Αρ. Προβολών";
$langFirstLetterUser = "Πρώτο Γράμμα Επωνύμου";
$langFirstLetterCourse = "Πρώτο Γράμμα Τίτλου";
$langAndTotalCourseVisits = "και συνολικών επισκέψεων σε $langsCourses";
$langUsageVisits = "Επισκεψιμότητα";
$langFavourite = "Προτίμηση Υποσυστημάτων";
$langFavouriteCourse = "Προτίμηση $langOfCourses";
$langFavouriteCourses = "Δημοφιλέστερα $langCourses";
$langFavouriteExpl = "Παρουσιάζεται η προτίμηση ενός χρήστη ή όλων των χρηστών στα υποσυστήματα μέσα σε ένα χρονικό διάστημα.";
$langOldStats = "Συγκεντρωτικά";
$langOldStatsExpl = "Συγκεντρωτικά μηνιαία στατιστικά στοιχεία <u>παλιότερα των %s μηνών</u>.";
$langOldStatsLoginsExpl = "Συγκεντρωτικά μηνιαία στατιστικά σχετικά με τις εισόδους στην πλατφόρμα παλιότερα των %s μηνών.";
$langOldStatsExpireConfirm = "Επιβεβαίωση εμφάνισης παλιότερων στατιστικών (θα ξεκινήσει διαδικασία συγκέντρωσης στατιστικών παλιότερων των δεκατεσσάρων μηνών). Επιθυμείτε να συνεχίσετε;";
$langInterval = "Διάστημα";
$langDaily = "Ημερήσιο";
$langWeekly = "Εβδομαδιαίο";
$langMonthly = "Μηνιαίο";
$langYearly = "Ετήσιο";
$langSummary = "Συνολικά";
$langPerDay = "ανά ημέρα";
$langPerWeek = "ανά εβδομάδα";
$langPerMonth = "ανά μήνα";
$langPerYear = "ανά έτος";
$langRegisterActions = "Εγγραφές";
$langUnregisterActions = "Απεγγραφές";
$langMonthlyCourseRegistrations = "Εγγραφές χρηστών";
$langMonthlyCourseRegistration = "Εγγραφή χρήστη στο $langsCourse";
$langDurationOfVisits = "διάρκεια επισκέψεων";
$langDurationVisits = "Χρονική Διάρκεια Επισκέψεων";
$langDurationExpl = "Η χρονική διάρκεια των επισκέψεων σε κάθε υποσύστημα είναι σε λεπτά της ώρας και υπολογίζεται κατά προσέγγιση.";
$langMonths[1] = "Ιαν";
$langMonths[2] = "Φεβ";
$langMonths[3] = "Μαρ";
$langMonths[4] = "Απρ";
$langMonths[5] = "Μαϊ";
$langMonths[6] = "Ιουν";
$langMonths[7] = "Ιουλ";
$langMonths[8] = "Αυγ";
$langMonths[9] = "Σεπ";
$langMonths[10] = "Οκτ";
$langMonths[11] = "Νοε";
$langMonths[12] = "Δεκ";
// for monthly report
$langMonths['01'] = "Ιανουάριος";
$langMonths['02'] = "Φεβρουάριος";
$langMonths['03'] = "Μάρτιος";
$langMonths['04'] = "Απρίλιος";
$langMonths['05'] = "Μάιος";
$langMonths['06'] = "Ιούνιος";
$langMonths['07'] = "Ιούλιος";
$langMonths['08'] = "Αύγουστος";
$langMonths['09'] = "Σεπτέμβριος";
$langMonths['10'] = "Οκτώβριος";
$langMonths['11'] = "Νοέμβριος";
$langMonths['12'] = "Δεκέμβριος";
$langHidden = "Κλειστό";
$langAddress = "Διεύθυνση";
$langLoginDate = "Ημερ/νία εισόδου";
$langNoLogins = "Δεν έχουν γίνει είσοδοι το συγκεκριμένο χρονικό διάστημα.";
$langNoStatistics = "Δεν έχουν γίνει επισκέψεις το συγκεκριμένο χρονικό διάστημα.";
$langStatAccueil = "Για το χρονικό διάστημα που ζητήθηκε, διατίθεται και η παρακάτω πληροφορία για το σύνολο των χρηστών του $langsOfCourse:";
$langHost = "Υπολογιστής";
$langGroupUsage = 'Στατιστικά ομάδων χρηστών';
$langNoStats = "Δεν υπάρχουν διαθέσιμα στατιστικά";
$langDetails = "Αναλυτικά";
$langPlots = "Γραφήματα";
$langIpAddress = "Διεύθυνση IP";
$langLoginUser = "Είσοδοι";
$langUsageCoursesHeader = "Σύνολο $langsOfCourses";
$langUsageUsers = "Σύνολο χρηστών";
$langStatOfFaculty = "Αναφορές $langsOfFaculty";
$langHaveCreated = "Έχουν δημιουργηθεί";
$langInfoUserDuration = "Στους παρακάτω χρόνους συμμετοχής <strong>δεν</strong> συμπεριλαμβάνονται οι χρόνοι στη Τηλεσυνεργασία</em>.";
$langInfoUserDuration2 = "Για αυτά τα υποσυστήματα, κάντε κλικ στα αντίστοιχα κουμπιά.";
$langConfirmMonthlyReport = "Προσοχή! Η διαδικασία δημιουργίας αναφορών ενδεχομένως να καθυστερήσει αν εκτελείται για πρώτη φορά τον τρέχοντα μήνα.";
$langConfirmChartReport = "Προσοχή! Η διαδικασία δημιουργίας διαγραμμάτων ενδεχομένως να καθυστερήσει.";

// for platform statistics
$langUsersCourse = "Χρήστες ανά $langsCourse";
$langVisitsCourseStats = "Επισκέψεις σε σελίδες $langsOfCourses";
$langUserStats = "Στατιστικά Χρήστη";
$langTotalVisitsCourses = "Συνολικές επισκέψεις σε σελίδες $langsOfCourses";
$langDumpUserDuration = "Στατιστικά χρήσης";
$langDumpUserDurationToFile = "σε αρχείο τύπου Excel";
$langCodeUTF = "κωδικοποίηση UTF-8";
$langCodeWin = "κωδικοποίηση Windows-1253";
$langNoUserSelected = "Δεν επιλέξατε χρήστη";
$langRecordLog = "Καταγραφές ενεργειών";
$langSumFrom = "συνολικά";

/* * ***********************************************
 * log.class.php
 * *********************************************** */
$langUsersLog = "Ενέργειες χρηστών";
$langUserLog = "Ενέργειες χρήστη";
$langCourseActions = "Ενέργειες $langsOfCourse";
$langSystemActions = "Καταγραφές ενεργειών";
$langLogModules = "Είδος Υποσυστημάτων";
$langAllActions = "Όλες οι ενέργειες";
$langUnknownAction = "Άγνωστη ενέργεια";
$langUnknownModule = "Άγνωστο Υποσύστημα";
$langAllModules = "Όλα τα υποσυστήματα";
$langWithID = "με νούμερο";
$langNoUsersLog = "Δεν υπάρχουν καταγεγραμμένες ενέργειες";
$langModProfile = "Αλλαγή προφίλ";
$langPersoDetails = "Προσωπικά στοιχεία";
$langLoginFailures = "Αποτυχημένες προσπάθειες εισόδου";
$langLast15Days = "15 τελευταίων ημερών";
$langLast5Days = "5 τελευταίων ημερών";
$langLast10Days = "10 τελευταίων ημερών";
$langLast30Days = "30 τελευταίων ημερών";
$langLastMonth = "τον τελευταίο μήνα";
$langUnregUsers = "Απεγγραφές χρηστών από την πλατφόρμα";
$langLogExpireInterval = "Διάστημα διατήρησης καταγραφής ενεργειών";
$langLogPurgeInterval = "Διάστημα οριστικής διαγραφής καταγραφής ενεργειών";

/* * **************************************************************
 * video.php
 * *************************************************************** */
$langFileNot = "Παρουσιάστηκε σφάλμα κατά τη αποστολή του αρχείου!";
$langTitleMod = "Ο τίτλος του εγγράφου τροποποιήθηκε";
$langFAdd = "Το αρχείο προστέθηκε";
$langDelF = "Το αρχείο διαγράφηκε";
$langAddV = "Προσθήκη αρχείου";
$langAddVideoLink = "Σύνδεσμος βίντεο";
$langAddOpenDelosVideoLink = "Σύνδεσμος OpenDelos";
$langsendV = "Αποστολή αρχείου ήχου ή βίντεο";
$langDelList = "Διαγραφή όλων";
$langVideoMod = "Τα στοιχεία του συνδέσμου τροποποιήθηκαν";
$langVideoDeleted = "Όλοι οι σύνδεσμοι διαγράφηκαν";
$langURL = "Εξωτερικός σύνδεσμος προς τον εξυπηρετητή ήχου ή βίντεο";
$langCreator = "Δημιουργός";
$langpublisher = "Εκδότης";
$langNoVideo = "Δεν υπάρχουν διαθέσιμα πολυμεσικά αρχεία";
$langEmptyVideoTitle = "Παρακαλώ πληκτρολογήστε ένα τίτλο για το αρχείο σας";
$langColorboxCurrent = "πολυμέσο {current} από {total}";
$langVideoDirectory = "Γενικά πολυμεσικά αρχεία";
$langCatVideoDirectory = "Κατηγορίες πολυμεσικών αρχείων";
$langCatVideoDirectoryCreated = "Η κατηγορία προστέθηκε";
$langOpenDelosReplaceInfo = "Αν κάποιος επιλεγμένος σύνδεσμος ήδη υπάρχει στα πολυμέσα, θα ανανεωθεί με τα τρέχοντα στοιχεία";
$langDelosNewFileVersion = "Υπάρχει νεώτερη έκδοση του αρχείου στο OpenDelos.";
$langOpenDelosPublicVideos = "Δημόσια πολυμεσικά αρχεία";
$langOpenDelosPrivateVideos = "Ιδιωτικά πολυμεσικά αρχεία";
$langOpenDelosRequireAuth = "Για την εμφάνιση κλειστών πολυμεσικών αρχείων απαιτείται ξεχωριστή αυθεντικοποίηση με το OpenDelos";
$langOpenDelosRequireAuthHere = "εδώ";
$langOpenDelosAuth = "Αυθεντικοποίηση OpenDelos";
$langOpenDelosPrivateNote = "Σημείωση: Αν το μάθημά σας είναι 'ανοικτό' τότε τα κλειστά πολυμεσικά αρχεία θα είναι ορατά σε όλους τους χρήστες.";
$langOpenDelosHttpsError = "Η συνδεσιμότητα με το Open Delos δεν μπορεί να ενεργοποιηθεί γιατί ο τοπικός server χρησιμοποιεί HTTPS πρωτόκολλο, ενώ το Open Delos χρησιμοποιεί HTTP πρωτόκολλο. Οι νεότερες εκδόσεις των web browsers δεν επιτρέπουν μικτή χρήση των πρωτοκόλλων.";


/* * ***********************************************************
 * wiki.php
 * ************************************************************ */
$langWikis = "Διαθέσιμα wiki";
$langAddImage = "Πρόσθεσε εικόνα";
$langAdministrator = "Διαχειριστής";
$langContinue = "Συνέχεια";
$langDelImage = "Διαγραφή εικόνας";
$langGroups = "Ομάδες Χρηστών";
$langIs = "είναι";
$langLastname = "Επώνυμο";
$langLegendRequiredFields = "<span class=\"required\">*</span> δείχνει απαραίτητο πεδίο ";
$langProfileMenu = "Μενού Προφίλ Χρήστη";
$langProfileImage = "Εικόνα Προφίλ";
$langMyProfile = "Το προφίλ μου";
$langModifyProfile = "Αλλαγή του Προφίλ μου";
$langOfficialCode = "Κωδικός διαχείρισης";
$langPersonalCourseList = "Προσωπική λίστα $langsOfCourse";
$langPreview = "Παρουσίαση/Προβολή";
$langSaveChanges = "Αποθήκευση αλλαγών";
$langTheSystemIsCaseSensitive = "(γίνεται διάκριση μεταξύ κεφαλαίων και πεζών γραμμάτων.)";
$langUpdateImage = "Αλλαγή εικόνας";
$langUserIsPlaformAdmin = "είναι διαχειριστής της πλατφόρμας ";
$langUserid = "Ταυτότητα χρήστη";
$langWikiAccessControl = "Διαχείριση ελέγχου πρόσβασης ";
$langWikiAccessControlText = "Μπορείτε να θέσετε τα δικαιώματα πρόσβασης για τους χρήστες χρησιμοποιώντας το ακόλουθο πλέγμα: ";
$langWikiAllPages = "Όλες οι σελίδες";
$langWikiLockInfo = "Η σελίδα που θέλετε να αλλάξετε έχει κλειδωθεί επειδή γίνεται επεξεργασία της από κάποιον άλλο χρήστη. Δοκιμάστε ξανά σε λίγο.";
$langWikiLockTimeRemaining = "Χρόνος κλειδώματος επεξεργασίας: ";
$langWikiLockTimeEnd = "Η Wiki σελίδα έπαψε να είναι κλειδωμένη για επεξεργασία. Μπορείτε να συνεχίσετε να την επεξεργάζεστε, αλλά ενδέχεται να μην μπορέσετε να αποθηκεύσετε άμεσα τις αλλαγές σας";
$langWikiContentEmpty = "Αυτή η σελίδα είναι κενή, κάνε κλικ στο 'Αλλαγή της σελίδας' για να προσθέσετε περιεχόμενο";
$langWikiCourseMembers = "Μέλη $langsOfCourse ";
$langWikiCreateWiki = "Δημιουργία Wiki";
$langWikiCreatePrivilege = "Δημιουργήστε σελίδες ";
$langWikiNoDescription = "Δεν υπάρχει περιγραφή";
$langWikiCreationSucceed = "Η δημιουργία του Wiki ήταν επιτυχημένη";
$langWikiDeleteWiki = "Διαγραφή Wiki";
$langWikiDeletePage = "Διαγραφή της Σελίδας";
$langWikiDeletePageError = "Σφάλμα κατά τη διαγραφή της σελίδας";
$langWikiDeletePageWarning = "Είστε σίγουροι ότι θέλετε να διαγράψετε τη Wiki σελίδα;";
$langWikiDeleteWikiWarning = "ΠΡΟΕΙΔΟΠΟΙΗΣΗ: πρόκειται να διαγράψετε αυτό το wiki και όλες τις σελίδες του. Είστε βέβαιοι ότι θέλετε να συνεχίσετε;";
$langWikiDeletionSucceed = "Η διαγραφή του Wiki ήταν επιτυχημένη";
$langWikiDescription = "Περιγραφή του Wiki";
$langWikiDescriptionForm = "Περιγραφή Wiki";
$langWikiDescriptionFormText = "Μπορείτε να επιλέξετε έναν τίτλο για το wiki : ";
$langWikiDiffAddedLine = "Προστιθέμενη γραμμή ";
$langWikiDiffDeletedLine = "Διαγραμμένη γραμμή ";
$langWikiDiffMovedLine = "Μετακινημένη γραμμή ";
$langWikiDiffUnchangedLine = "Αμετάβλητη γραμμή ";
$langWikiDifferenceKeys = "Κλειδιά:";
$langWikiDifferencePattern = "Διαφορές μεταξύ της έκδοσης %1\$s (τροποποιημένης από %2\$s) και της έκδοσης %3\$s (τροποποιημένης από %4\$s)";
$langWikiDifferenceTitle = "Διαφορές:";
$langWikiEditLock = "Προειδοποίηση κλειδώματος";
$langWikiEditLastVersion = "Αλλαγή τελευταίας έκδοσης";
$langWikiEditPage = "Αλλαγή της σελίδας";
$langWikiEditPrivilege = "Αλλαγή σελίδων";
$langWikiEditProperties = "Αλλαγή ιδιοτήτων";
$langWikiEditionSucceed = "Οι αλλαγές πραγματοποιηθήκαν";
$langWikiExport = "Εξαγωγή του Wiki";
$langWikiGroupMembers = "Μέλη ομάδας";
$langWikiIdenticalContent = "Το περιεχόμενο παρέμεινε ίδιο. Καμία αλλαγή δεν αποθηκεύθηκε.";
$langWikiInvalidWikiId = "Μη έγκυρο Wiki";
$langWikiList = "Λίστα του Wiki";
$langWikiMainPage = "Κύρια σελίδα";
$langWikiMainPageContent = "%%% Βρίσκεστε στην κύρια σελίδα του Wiki.  %%% Επιλέξτε '''Αλλαγή της σελίδας''' για να αλλάξετε το περιεχόμενο.";
$langWikiNoWiki = "Δεν υπάρχει Wiki";
$langWikiNotAllowedToCreate = " Δεν επιτρέπεται να δημιουργήσετε σελίδα";
$langWikiNotAllowedToEdit = " Δεν επιτρέπεται να αλλάξετε τη σελίδα";
$langWikiNotAllowedToRead = "Δεν επιτρέπεται να διαβάσετε τη σελίδα";
$langWikiNumberOfPages = "Αριθμός σελίδων";
$langWikiOtherUsers = "Άλλοι χρήστες (*)";
$langWikiOtherUsersText = "(*) ανώνυμοι χρήστες και χρήστες που δεν είναι μέλη αυτού του $langsOfCourse...";
$langWikiPageMakeCurrent = "(τρέχουσα)";
$langSureToMakeWikiPageCurrent = "Είστε σίγουροι ότι θέλετε να κάνετε αυτή την έκδοση τρέχουσα;";
$langWikiPageRevertedVersion = "Επαναφορά παλαιότερης έκδοσης";
$langWikiPageDeleted = "Η σελίδα Wiki διαγράφηκε με επιτυχία";
$langWikiPageHistory = "Ιστορικό";
$langWikiPageNotLoaded = "Η σελίδα %s δεν ήταν δυνατόν να φορτωθεί";
$langWikiPagePrintable = "Εκτυπώσιμη μορφή";
$langWikiPageSaved = "Η σελίδα αποθηκεύθηκε";
$langWikiPreviewTitle = "Προεπισκόπηση: ";
$langWikiPreviewWarning = " ΠΡΟΕΙΔΟΠΟΙΗΣΗ: Αυτή η σελίδα είναι προεπισκόπηση! Οι τροποποιήσεις σας στο wiki δεν έχουν αποθηκευθεί ακόμα! Για να τις αποθηκεύσετε κάντε κλικ στο 'Αποθήκευση'.";
$langWikiProperties = "Ιδιότητες";
$langWikiReadPrivilege = "Διάβασε τις σελίδες";
$langWikiRecentChanges = "Πρόσφατες αλλαγές";
$langWikiRecentChangesPattern = "%1\$s τροποποιήθηκε στις %2\$s από %3\$s";
$langWikiShowDifferences = "Δείξε τις διαφορές";
$langWikiSearchInPages = "Αναζήτηση στις σελίδες";
$langWikiSearchResults = "Αποτελέσματα αναζήτησης";
$langWikiSearchMissingKeywords = "Δεν πληκτρολογήσατε λέξεις κλειδιά";
$langWikiTitle = "Τίτλος του wiki";
$langWikiTitleEdit = "Wiki : Αλλάξτε τις ιδιότητες";
$langWikiTitleNew = "Wiki : Δημιουργήστε καινούργιο Wiki";
$langWikiTitlePattern = "Wiki : %s";
$langWikiVersionInfoPattern = "(έκδοση από %1\$s τροποποιημένη από%2\$s)";
$langWikiVersionPattern = "%1\$s από %2\$s";
$lang_footer_p_CourseManager = "Υπεύθυνος για %s";
$lang_p_platformManager = "Διαχειριστής για το %s";
$langWikiUrl = "Όνομα για σύνδεσμο νέας σελίδας wiki";
$langWikiUrlLang = "Γλώσσα συνδέσμου";
$langWikiUrlImage = "URL εικόνας";
$langWikiNoContent = "Η σελίδα δεν έχει ακόμα περιεχόμενο. Χρησιμοποιήστε τον κειμενογράφο για να προσθέσετε περιεχόμενο.";
$langWrongWikiPageTitle = "Λάθος τίτλος σελίδας";
$langWikiPageNotFound = "Η σελίδα του του wiki δεν βρέθηκε";
$wiki_toolbar['Strongemphasis'] = "Έντονα";
$wiki_toolbar['Emphasis'] = "Πλαγιαστά";
$wiki_toolbar['Inserted'] = "Εισαγωγή";
$wiki_toolbar['Deleted'] = "Διαγραμμένα";
$wiki_toolbar['Inlinequote'] = "Σχόλιο";
$wiki_toolbar['Code'] = "Κώδικας";
$wiki_toolbar['Linebreak'] = "Αλλαγή γραμμής";
$wiki_toolbar['Blockquote'] = "Παράγραφος";
$wiki_toolbar['Preformatedtext'] = "Μορφοποιημένο κείμενο";
$wiki_toolbar['Unorderedlist'] = "Μη διατεταγμένη λίστα";
$wiki_toolbar['Orderedlist'] = "Διατεταγμένη λίστα";
$wiki_toolbar['Externalimage'] = "Εξωτερική εικόνα";
$wiki_toolbar['Link'] = "Σύνδεσμος";
$wiki_toolbar['Hr'] = "Οριζόντια Γραμμή";
$wiki_toolbar['H1'] = "Επικεφαλίδα 1";
$wiki_toolbar['H2'] = "Επικεφαλίδα 2";
$wiki_toolbar['H3'] = "Επικεφαλίδα 3";
$wiki_toolbar['H4'] = "Επικεφαλίδα 4";

/* * ***********************************************************
 * work.php
 * ************************************************************ */
$langBackAssignment = "Επιστροφή στη σελίδα της εργασίας";
$m['deadline_notif'] = "(Kενό για εργασία χωρίς προθεσμία υποβολής)";
$m['with_deadline'] = "Με Προθεσμία Υποβολής";
$m['late_submission'] = "Εκπρόθεσμη Υποβολή";
$langLateSubmissionEnable = "Ενεργοποίηση εκπρόθεσμης υποβολής";
$m['username'] = "Όνομα " . $langsOfStudent . " ";
$m['dirname'] = "Όνομα καταλόγου";
$m['max_grade'] = "Βαθμός";
$langAddGradeComments = "Προσθήκη σχολίων βαθμολογητή";
$m['tomorrow'] = "αύριο";
$m['pending'] = "Προς επιβεβαίωση";
$m['ofgroup'] = "ομάδας";
$langDeletedWorkByUser = "Διαγράφηκε η προηγούμενη υποβληθείσα εργασία που είχατε στείλει με το αρχείο";
$langDeletedWorkByGroup = "Διαγράφηκε η προηγούμενη εργασία που είχε υποβληθεί από κάποιο μέλος της ομάδας σας και βρισκόταν στο αρχείο";
$langByGroupMate = 'Από άλλο μέλος της ομάδας σας';
$langTheFile = 'Το αρχείο';
$langWasSubmitted = 'υποβλήθηκε στην εργασία.';
$m['group_sub'] = 'Επιλέξτε αν θέλετε να υποβάλετε το αρχείο αυτό εκ μέρους της ομάδας σας';
$m['group'] = 'ομάδα';
$m['already_group_sub'] = 'Έχει ήδη υποβληθεί η εργασία αυτή από κάποιο μέλος της ομάδας σας';
$m['delete_work'] = 'Διαγραφή';
$langSubmittedByOtherMember = 'Το αρχείο αυτό υποβλήθηκε από άλλο μέλος της';
$langYourGroup = 'ομάδας σας';
$langThisIsGroupAssignment = 'Η εργασία αυτή είναι ομαδική.';
$langGroupAssignmentPublish = 'Μπορείτε να στείλετε κάποιο υπάρχον αρχείο από
        <a href="%s">το χώρο αρχείων της ομάδας σας</a> επιλέγοντας «Δημοσίευση»
        για το αρχείο που θέλετε.';
$langGroupAssignmentNoGroups = 'Θα πρέπει <a href="%s">να εγγραφείτε σε κάποια
        ομάδα</a> πριν μπορέσετε να υποβάλετε κάποιο αρχείο.';
$m['noguest'] = 'Για να αποστείλετε εργασία πρέπει να συνδεθείτε ως κανονικός χρήστης.';
$langOneNonSubmission = 'Δεν έχει υποβληθεί μία εργασία';
$m['more_submissions'] = 'Έχουν υποβληθεί %d εργασίες';
$langMoreNonSubmissions = 'Δεν έχουν υποβληθεί %d εργασίες';
$m['plainview'] = 'Συνοπτική λίστα εργασιών - βαθμολογίας';
$m['WorkView'] = "Εργασίες $langsOfCourse";
$m['WorkSubsDelete']= 'Διαγραφή υποβολών εργασίας';
$langWorkDeleteAssignmentFile = 'Διαγραφή αρχείου εργασίας';
$langWorkDeleteAssignmentFileConfirm = 'Επιβεβαίωση διαγραφής αρχείου εργασίας';
$langWorkEdit = 'Τροποποίηση εργασίας';
$langWorkNoSubmission = 'Η εργασία δεν υπάρχει.';
$m['WorkGroupNoSubmission'] = 'Ομάδες χρηστών που δεν έχουν υποβάλει εργασία';
$langNoneWorkGroupNoSubmission = 'Δεν υπάρχουν ομάδες χρηστών που δεν έχουν υποβάλει εργασία';
$langWorkUserNoSubmission = 'Χρήστες που δεν έχουν υποβάλει εργασία';
$langNoneWorkUserNoSubmission = 'Δεν υπάρχουν χρήστες που δεν έχουν υποβάλει εργασία';
$m['WorkTitleValidation'] = 'Παρακαλώ εισάγετε Τίτλο Εργασίας';
$langSubmissionWorkInfo = 'Στοιχεία υποβολής εργασίας';
$langSubmissionStatusWorkInfo = 'Κατάσταση υποβολής εργασίας';
$m['comments_exist'] = 'Υπάρχουν σχόλια';
$m['email_users'] = 'Ενημέρωση μέσω ηλεκτρονικού ταχυδρομείου';
$langWorkEmailMessage = "Το παρακάτω μήνυμα αναφέρεται στην υποβολή σας στην εργασία με τίτλο «%s» του $langsOfCourse «%s»:";
$langWorkEmailSubject = 'Ενημέρωση εργασίας: %s';
$langLinkFollows = 'Δείτε περισσότερα στον παρακάτω σύνδεσμο:';
$m['grade_comment_date'] = 'Ημερομηνία σχολίων/βαθμολόγησης';
$langMoreSubmissions = 'Έχουν υποβληθεί %d εργασίες';
$langWorkGroupNoSubmission = 'Ομάδες χρηστών που δεν έχουν υποβάλει εργασία';
$langEmailToUsers = 'Ενημέρωση μέσω email';
$langWorkToAllUsers = "Σε όλους τους $langsOfStudentss";
$langWorkInfo = 'Στοιχεία εργασίας';
$langWorkAssignTo = "Ανάθεση σε";
$langWorkToUser = "Συγκεκριμένους $langsOfStudentss";
$langWorkToAllGroups = "Σε όλες τις $langGroups";
$langWorkToGroup = "Συγκεκριμένες $langGroups";
$langSubmShort = 'Υποβλ.';
$langNogrShort = 'Μη βαθμ.';
$langGroupAssignment =  "Ομαδική εργασία";
$langGroupSubmit = "Υποβλήθηκε εκ μέρους της";
$langOfGroup = "ομάδας";
$langUserAssignment = "Ατομική εργασία";
$langNoFileUploaded = "Δεν ανεβάσατε κάποιο αρχείο!";
$langWorkSubsDelete= "Διαγραφή υποβολών εργασίας";
$langWorkUserGroupNoSubmission = 'Χρήστες / ομάδες χωρίς υποβολή';
$langSubmitted = "Έχει υποβληθεί";
$langLateSubmission = "Εκπρόθεσμη Υποβολή";
$langSubDate = "Ημ/νία αποστολής";
$langGroupWorkIntro = "
	Παρακάτω εμφανίζονται οι διαθέσιμες εργασίες που έχουν ανατεθεί
	στα πλαίσια αυτού του $langsOfCourse. Παρακαλούμε επιλέξτε την εργασία όπου θέλετε
	να αποστείλετε το αρχείο ως εργασία της ομάδας σας, και συμπληρώστε
	τυχόν σχόλια που θέλετε να διαβάσει ο διδάσκων του $langsOfCourse. Σημειώστε ότι
        αν έχει υποβληθεί ήδη μια εργασία από εσάς ή άλλο μέλος της ομάδας σας
        και αποστείλετε ένα νέο αρχείο για την ίδια εργασία, τότε το παλιό
	αρχείο αυτό θα διαγραφεί και θα αντικατασταθεί από το νέο. Τέλος,
	δεν μπορείτε να στείλετε αρχείο σε εργασία που έχει ήδη βαθμολογηθεί
	από τον διδάσκοντα.";
$langAssignmentPasswordModalTitle = "Παρακαλώ πληκτρολογήστε τον κωδικό της εργασίας";
$langWillStartAt = 'έναρξη στις';
$langWillStart = 'θα ξεκινήσει σε';
$langGroupWorkSubmitted = "Έχει υποβληθεί";
$langGroupWorkDeadline_of_Submission = "Προθεσμία";
$langEmptyAsTitle = "Δεν συμπληρώσατε τον τίτλο της εργασίας";
$langEditSuccess = "Η διόρθωση των στοιχείων της εργασίας έγινε με επιτυχία!";
$langEditError = "Παρουσιάστηκε πρόβλημα κατά την διόρθωση των στοιχείων !";
$langNewAssign = "Δημιουργία Εργασίας";
$langNewAssignSuccess = "Η εργασία δημιουργήθηκε με επιτυχία!";
$langDeleted = "Η εργασία διαγράφηκε";
$langAssignmentSubsDeleted = "Οι υποβολές της εργασίας διαγράφηκαν";
$langAllAssignmentSubsDeleted = "Οι υποβολές όλων των εργασιών διαγράφηκαν";
$langDelError = "Η εργασία δεν διαγράφηκε. Παρακαλώ προσπαθήστε ξανά.";
$langDelAssign = "Διαγραφή Εργασίας";
$langDelWarn1 = "Πρόκειται να διαγράψετε την εργασία με τίτλο";
$langDelSure = "Είστε σίγουρος;";
$langWorkFile = "Αρχείο";
$langWorkMultipleFiles = "Πολλαπλά αρχεία - μέγιστος αριθμός:";
$langWorkFilesCountExceeded = 'Ο αριθμός αρχείων που υποβάλατε υπερβαίνει το μέγιστο επιτρεπτό.';
$langWorkFileLimit = 'Αρχεία (μέχρι)';
$langGradeType = "Τύπος Βαθμολογίας";
$langGradeNumbers = "Αριθμοί";
$langGradeNumber = "Αριθμός";
$langGradeScales = "Βαθμολογικές Κλίμακες";
$langGradeScale = "Βαθμολογική Κλίμακα";
$langGradeScalesSelect = "Επιλογή Κλίμακας";
$langGradeScalesDeleted = "Η βαθμολογική κλίμακα διαγράφηκε";
$langGradeScaleNotEditable = "Η κλίμακα δεν είναι πλέον επεξεργάσιμη γιατί έχει χρησιμοποιηθεί για την βαθμολόγηση μίας ή περισσότερων εργασιών.";
$langNoGradeScales = 'Δεν έχουν καταχωρηθεί βαθμολογικές κλίμακες.';
$langWording = 'Λεκτικό';
$langScales = 'Κλίμακες';
$langValue = 'Τιμή';
$langNewGradeScale = "Προσθήκη βαθμολογικής κλίμακας";
$langWorkSubType = "Τύπος Υποβολής";
$langWorkOnlineText = "Online Κείμενο";
$langZipDownload = "Κατέβασμα των εργασιών";
$langDelWarn2 = "Έχει αποσταλεί μία εργασία " . $langsOfStudent . ". Το αρχείο αυτό θα διαγραφεί!";
$langDelTitle = "Προσοχή!";
$langDelMany1 = "Έχουν αποσταλεί";
$langDelMany2 = "εργασίες " . $langsOfStudents . ". Τα αρχεία αυτά θα διαγραφούν!";
$langSubmissions = "Εργασίες που έχουν υποβληθεί";
$langPhase = "Φάση";
$langAssignmentsSubmission = "Υποβολή εργασιών";
$langAssignmentsSubmissionHasNoStarted = "Η διαδικασία υποβολής των εργασιών δεν έχει ξεκινήσει ακόμα.";
$langAssignmentsSubmissionInProgress = "Η διαδικασία υποβολής των εργασιών βρίσκεται σε εξέλιξη...";
$langAssignmentsSubmissionHasExpired = "Η διαδικασία υποβολής των εργασιών έχει λήξει.";
$langGradeReviewHasNotStarted = "Η διαδικασία αξιολόγησης από ομότιμους δεν έχει ξεκινήσει ακόμα.";
$langGradeReviewInProgress = "Η διαδικασία αξιολόγησης από ομότιμους βρίσκεται σε εξέλιξη...";
$langGradeReviewHasExpired = "Η διαδικασία αξιολόγησης από ομότιμους έχει λήξει.";
$langFinalGrade = "Τελική βαθμολογία";
$langFinalGradeProcessInProgress = "Η διαδικασία καταχώρησης τελικής βαθμολογίας είναι ενεργή";
$langReceivedFrom = "Έλαβε από";
$langgrade = "βαθμό";
$langPreviewGradesAssessments = "Προεπισκόπηση αξιολογήσεων";
$OldAssignmentsWillBeRemoved = "Οι παλιές αναθέσεις θα διαγραφόυν.";
$langAddFinalGradeHasNotStartedYet = "Η διαδικασία καταχώρησης βαθμού δεν έχει ξεκινήσει ακόμα.";
$m['WorkDelete'] = 'Διαγραφή εργασίας';
$langDeleteSubmission = 'Διαγραφή εργασίας';
$langNotice2 = "Ημερομηνία αποστολής";
$langNotice3 = "Αν στείλετε κάποιο άλλο αρχείο, το αρχείο που υπάρχει
	αυτή τη στιγμή θα διαγραφεί και θα αντικατασταθεί με το νέο.";
$langNotice3Multiple = "Προσοχή: Μπορείτε να υποβάλετε ένα ή περισσότερα νέα αρχεία - όλα τα αρχεία που είχατε υποβάλει
    στην εργασία αυτή θα διαγραφούν και θα αντικατασταθούν με τα νέα.";
$langSubmittedAndGraded = "Η εργασία αυτή έχει ήδη υποβληθεί και βαθμολογηθεί.";
$langSubmissionDescr = "Ο " . $langsStudent . " %s, στις %s, έστειλε το αρχείο με όνομα \"%s\".";
$langEndDeadline = "(η προθεσμία έχει λήξει)";
$langWEndDeadline = "(η προθεσμία λήγει αύριο)";
$langNEndDeadLine = "(η προθεσμία λήγει σήμερα)";
$langWarnAboutDeadLine = "Προσοχή! Επειδή η ημερομηνία υποβολής έχει παρέλθει η εργασία σας θα θεωρηθεί εκπρόθεσμη!";
$langDays = "ημέρες";
$langDaysLeft = "απομένουν";
$langGrades = "H βαθμολογία σας καταχωρήθηκε με επιτυχία";
$langUploadSuccess = "Το ανέβασμα της εργασίας σας ολοκληρώθηκε με επιτυχία !";
$langUploadError = "Πρόβλημα κατά το ανέβασμα της εργασίας!";
$langWorkGrade = "Η εργασία έχει βαθμολογηθεί με βαθμό";
$langGradeComments = "Σχόλια βαθμολογητή:";
$langGradeOk = "Καταχώριση αλλαγών";
$langGroupSubmit = "Αποστολή ομαδικής εργασίας";
$langGradeWork = "Σχόλια βαθμολογίας";
$langUserOnly = "Για να υποβάλετε μια εργασία πρέπει να κάνετε login στην πλατφόρμα.";
$langImportInvalidUsers = 'Τα παρακάτω ονόματα χρηστών δε βρέθηκαν στην πλατφόρμα:';
$langImportExtraUsers = 'Οι παρακάτω χρήστες βρέθηκαν, αλλά δεν είχαν υποβάλει συμμετοχή στην παρούσα εργασία:';
$langImportErrorLines = 'Οι παρακάτω εγγραφές είχαν κάποιο συντακτικό λάθος:<br>
 (π.χ. πάνω από δύο πεδία, το δεύτερο πεδίο δεν ήταν αριθμητικό ή υπερέβαινε το μέγιστο βαθμό)';
$langImportExtraGradebookUsers = "Οι παρακάτω χρήστες δεν συμμετείχαν στο βαθμολόγιο";
$langGradesImported = 'Οι βαθμοί καταχωρήθηκαν με επιτυχία!';
$langImportGrades = 'Εισαγωγή βαθμών από αρχείο';
$langImportGradesError = 'Δεν έγινε εισαγωγή λόγω των παρακάτω σφαλμάτων.
    Παρακαλούμε διορθώστε τα και ξαναδοκιμάστε.';
$langImportGradesHelp = 'Μπορείτε να αποστείλετε ένα αρχείο λογιστικού φύλλου (π.χ. xls, xlsx, csv) με δύο ή τρείς στήλες.
    Η πρώτη στήλη πρέπει να περιέχει τα ονόματα χρήστη των χρηστών που έχουν υποβάλλει εργασία.
    Η δεύτερη στήλη πρέπει να περιέχει έναν αριθμητικό βαθμό. Η τρίτη στήλη είναι προαιρετική και μπορεί
    να περιέχει ένα σχόλιο για τη βαθμολόγηση.';
$langImportGradesGradebookHelp = "Μπορείτε να αποστείλετε ένα αρχείο τύπου Excel (π.χ. xls, xlsx) με τη βαθμολογία των χρηστών.
    Η βαθμολογία των χρηστών πρέπει να συμπληρωθεί στην τελευταία στήλη του αρχείου που θα κατεβάσετε από το παρακάτω σύνδεσμο.<br><br>
    <strong>MHN</strong> αλλάξετε τη δομή του αρχείου (π.χ. αριθμό στηλών) γιατί η εισαγωγή των βαθμών θα αποτύχει. <br><br>
    Σημειώστε επίσης, ότι αν θέλετε να εισάγετε δεκαδικό βαθμό, χρησιμοποιήσετε το σύμβολο ´τελεία' π.χ. 9.5";
$langNoSubmissions = "Δεν έχουν υποβληθεί εργασίες";
$langNoAssign = "Δεν υπάρχουν εργασίες";
$langWorkWrongInput = 'Ο βαθμός πρέπει να είναι νούμερο. Παρακαλώ επιστρέψτε και ξανασυμπληρώστε το πεδίο.';
$langWarnForSubmissions = "Αν έχουν υποβληθεί εργασίες, αυτές θα διαγραφούν. ";
$langAssignmentActivated = "Η εργασία ενεργοποιήθηκε";
$langAssignmentDeactivated = "Η εργασία απενεργοποιήθηκε";
$langSaved = "Τα στοιχεία της εργασίας αποθηκεύτηκαν";
$langExerciseNotPermit = "Η υποβολή της εργασίας δεν επιτρέπεται!";
$langGraphResults = "Κατανομή βαθμολογιών εργασίας";
$langAddGrade = 'Υποβολή εργασίας/βαθμολογίας';
$langOnBehalfOf = 'Εκ μέρους του';
$langOnBehalfOfUserComment = 'Υποβλήθηκε από: %s, εκ μέρους του χρήστη: %s';
$langOnBehalfOfGroupComment = 'Υποβλήθηκε από: %s, εκ μέρους της ομάδας: %s';
$langDelWarnUserAssignment = 'Επιβεβαίωση διαγραφής εργασίας ' . $langOfUserS;
$langMyPersoDeadlines = "Οι διορίες μου";
$langAssignmentWillBeActive = 'Η εργασία θα ενεργοποιηθεί στις';
$langNotifyAssignmentSubmission = "Να ειδοποιηθώ (μέσω email) όταν γίνεται υποβολή εργασίας";
$langAssignmentPublished = "Υποβολή εργασίας";
$langHasAssignmentPublished = 'Έχει υποβληθεί μία εργασία';
$langExportGrades = "Εξαγωγή βαθμολογιών";
$langCommentsFile = "Αρχείο σχολίων";
$langPlagiarismCheck = "Αποστολή για έλεγχο λογοκλοπής";
$langPlagiarismAlreadyCheck = "To αρχείο έχει ήδη σταλεί για έλεγχο λογοκλοπής";
$langPlagiarismFileSent = "To αρχείο στάλθηκε για έλεγχο λογοκλοπής";
$langPlagiarismResult = "Αποτέλεσμα ελέγχου λογοκλοπής";
$langDownloadToPDF = "Αναφορά σε PDF";
$langGradeRubric = "Ρουμπρίκα";
$langGradeRubrics = "Ρουμπρίκες";
$langGradeRubricsSelect ="Επιλογή Ρουμπρίκας";
$langNewGradeRubric = "Δημιουργία ρουμπρίκας";
$langNoGradeRubrics = 'Δεν έχουν καταχωρηθεί ρουμπρίκες.';
$langTitleRubric = "Όνομα ρουμπρίκας";
$langRubricDesc = "Περιγραφή ρουμπρίκας";
$langRubricCrit = "Κριτήριο";
$langCriteria = "Κριτήρια";
$langRubricWeight = "Το άθροισμα των ποσοστών συμμετοχής των κριτηρίων θα πρέπει να είναι ίσο με 100";
$langAddRubricCriteria ="Νέο κριτήριο";
$langRubricOptions = "Επιλογές ρουμπρίκας";
$langRubricOption1 = "Να επιτρέπεται η προεπισκόπηση της ρουμπρίκας από τον εκπαιδευόμενο πριν τη βαθμολόγηση";
$langRubricOption2 = "Προβολή των βαθμών κάθε κριτηρίου στα άτομα προς βαθμολόγηση";
$langRubricDeleted = "Η ρουμπρίκα διαγράφηκε";
$langRubricUpdated = "Η ρουμπρίκα ενημερώθηκε";
$langRubricCreated = "H ρουμπρίκα δημιουργήθηκε με επιτυχία";
$langRubricNotEditable = "Τα κριτήρια της ρουμπρίκας δεν είναι επεξεργάσιμα γιατί η ρουμπρίκα έχει χρησιμοποιηθεί για την βαθμολόγηση μίας ή περισσότερων εργασιών.";
$langRubricNotDelete = "Η ρουμπρίκα δεν μπορεί να διαγραφεί γιατί έχει χρησιμοποιηθεί για την βαθμολόγηση μίας ή περισσότερων εργασιών.";
$langRubricGrade = "Βαθμ. με ρουμπρίκα";
$langRubricGrading = "Βαθμολόγηση με ρουμπρίκα";
$langGradedAt = 'βαθμολογήθηκε στις';
$langRubricCriteria = "Κριτήρια";
$langAssignmentType = "Τύπος Εργασίας";
$langAssignmentTypeEclass = "Eclass";
$langAssignmentTypeTurnitin = "TurnItIn";
$langAssignemtTypeTurnitinInfo = "Οι υποβολές των εργασιών θα σταλούν για έλεγχο λογοκλοπής μέσω του συστήματος Turnitin";
$langGradeReviews = "Αξιολόγηση από ομότιμους";
$langReviewsPerUser = "Αξιολογήσεις ανά χρήστη";
$langAllowableReviewValues = "Επιτρεπτές τιμές: 3-5";
$langReviewStart = "Έναρξη αξιολόγησης";
$langReviewEnd = "Λήξη αξιολόγησης";
$langReviewDateHelpBlock = "Κάντε κλικ για να ορίσετε μια διαφορετική (μελλοντική) Ημερομηνία Έναρξης Αξιολόγησης";
$langPeerReviewImpossible = "Το πλήθος των εργασιών δεν επαρκεί για να γίνει αξιολόγηση από ομότιμους.";
$langPeerReviewGrade = "Βαθμός αξιολόγησης";
$langTransferGrades = "Μεταφορά βαθμών";
$langPeerReviewCompletedByStudent = "Ολοκλήρωσε τις αξιολογήσεις του";
$langPeerReviewPendingByStudent = "Οι αξιολογήσεις του δεν έχουν ολοκληρωθεί";
$langPeerReviewMissingByStudent = "Δεν έχει εκτελέσει τις αξιολογήσεις του";
$langPeerReviewPerUserCompulsory = "Το πεδίο Αξιολογήσεις ανά χρήστη";
$langPeerReviewStartDateCompulsory = "Το πεδίο Έναρξη αξιολόγησης";
$langPeerReviewEndDateCompulsory = "Το πεδίο Λήξη αξιολόγησης";
$langPeerReviewDeadlineCompulsory = "Το πεδίο Προθεσμία υποβολής";
$langPeerReviewStartDateError = "Η ημερομηνία Έναρξης αξιολόγησης ";
$langPeerReviewStartDateError2 = "μεγαλύτερη από την υποβολή";
$langPeerReviewNoAssignments = "Δεν έχουν ανατεθεί ακόμα εργασίες";
$langPeerReviewAssignmentInfo1 = "Οι εργασίες ανατέθηκαν στους χρήστες. Διαγράφτηκαν οι παλιές αναθέσεις.";
$langPeerReviewAssignmentInfo2 = "Οι εργασίες ανατέθηκαν.";
$langNotGraded = "(Δεν βαθμολόγησε)";
$langDeletePeerReview = "Διαγραφή αξιολόγησης";
$langNoAssignmentsForReview = "Δεν υπάρχουν αναθέσεις";
$langConfirmDeleteStudentReview = "Επιβεβαίωση διαγραφής αξιολόγησης";
$langStudentReviewDeleted = "Η αξιολόγηση διαγράφηκε";
$langEndPeerReview = "Η περίοδος αξιολόγησης έληξε. Δεν μπορείτε να βαθμολογήσετε.";
$langAssignmentDistribution = 'Ανάθεση εργασιών προς αξιολόγηση';
$langNoPeerReview = 'Δεν θα γίνει αξιολόγηση.';
$langPendingPeerSubmissions = 'Αναμένονται οι εργασίες για την αξιολόγηση.';
$langPeerSubmissions = 'Εργασίες που έχουν ανατεθεί';
$langNoPeerReviewMultipleFiles = "Η εργασία δεν μπορεί να ανατεθεί προς αξιολόγηση επειδή δέχεται πολλαπλά αρχεία από τον κάθε χρήστη";

/* * ***********************************************************
 * list requests.php
 * ************************************************************ */
$langRequestStudent = "Η αίτηση έκλεισε!";
$langRequestReject = "Η αίτηση σας απορρίφθηκε!";
$langRequestApproved = "Η αίτηση σας εγκρίθηκε!";
$langWithCourseCreationRightsInfo = "Έχετε δικαιώματα δημιουργίας $langsOfCourses";
$langInPlatform = "στην πλατφόρμα";
$langInformativeEmail = "Στάλθηκε ενημερωτικό μήνυμα στη διεύθυνση";
$langRequest = "Αίτηση";

/* * ***********************************************************
  editpost.php
 * ************************************************************ */
$langErrorDataOne = "Λάθος στην ανάκτηση των στοιχείων από τη βάση δεδομένων";
$langErrorDataTwo = "Λάθος στην ανάκτηση των στοιχείων από τη βάση δεδομένων";
$langUnableUpdatePost = "Αδύνατο να ανανεωθεί το μήνυμά σας στη βάση δεδομένων ";
$langUnableUpdateTopic = "Αδύνατο να ανανεωθεί το θέμα σας στη βάση δεδομένων";
$langUnableDeletePost = "Αδύνατο να διαγραφεί το μήνυμα σας από τη βάση δεδομένων";
$langPostRemoved = "Αδύνατο να ανανεωθεί το προηγούμενο μήνυμά σας - το τελευταίο μήνυμα έχει μεταφερθεί";
$langUnableDeleteTopic = "Αδύνατο να διαγραφεί το θέμα από τη βάση δεδομένων ";
$langTopicInformation = "Δεν ήταν δυνατή η ερώτηση στη βάση δεδομένων.";
$langUserTopicInformation = "Δεν ήταν δυνατή η ερώτηση στη βάση δεδομένων.";
$langDeleteAttachment = "Διαγραφή συνημμένου";

/* * ***********************************************************
  newtopic.php
 * ************************************************************ */
$langErrorDataForum = "Τα δεδομένα του forum δεν είναι διαθέσιμα.";
$langErrorPost = "Η περιοχή συζητήσεων που προσπαθείτε να συμμετάσχετε δεν υπάρχει. Παρακαλώ προσπαθήστε ξανά.";
$langErrorEnterTopic = "Αδύνατη η εισαγωγή θέματος στη βάση δεδομένων.";
$langErrorEnterPost = "Αδύνατη η εισαγωγή μυνήματος στη βάση δεδομένων.";
$langErrorEnterTextPost = "Αδύνατη η εισαγωγή κειμένου!";
$langErrorEnterTopicTable = "Αδύνατη η ανανέωση του θέματος!";
$langErrorUpdatePostCount = "Αδύνατη η ανανέωση του μετρητή μηνυμάτων.";

/* * ***********************************************************
  vietopic.php
 * ************************************************************ */
$langAddTime = "Προσθήκη ενεργού χρόνου στους απενεργοποιημένους λογαριασμούς.";
$langRealised = "Πραγματοποιήθηκαν";
$langUpdates = "ενημερώσεις";


/* * ********************************************************************
  units.php
 * ********************************************************************* */
$langAddUnit = "Προσθήκη ενότητας";
$langShowUnitCarousel = "Εμφάνιση σε μία γραμμή";
$langShowUnitRow = "Εμφάνιση σε λίστα";
$langShowUnitTitle = "Εμφάνιση σε τίτλους";
$langEditUnit = "Επεξεργασία ενότητας";
$langEditUnitSection = "Επεξεργασία";
$langUnitTitle = "Τίτλος ενότητας";
$langUnitDescr = "Σύντομη περιγραφή";
$langUnitUnknown = "Άγνωστη ενότητα";
$langEmptyUnitTitle = "Παρακαλώ πληκτρολογήστε τον τίτλο της ενότητας";
$langCourseUnits = "Ενότητες";
$langCourseUnitDeleteConfirm = "Είστε σίγουρος/η ότι Θέλετε να διαγράψετε την συγκεκριμένη ενότητα?";
$langCourseUnitDeleted = "Η ενότητα διαγράφηκε";
$langCourseUnitAdded = "Η ενότητα προστέθηκε";
$langCourseUnitModified = "Τα στοιχεία της ενότητας τροποποιήθηκαν";
$langResourceCourseUnitDeleted = "Ο πόρος της ενότητας διαγράφηκε";
$langResourceUnitModified = "Τα στοιχεία του πόρου της ενότητας τροποποιήθηκαν";
$langInsertText = "κειμένου";
$langInsertDivider = "διαχωριστή";
$langInsertDoc = "εγγράφου";
$langInsertExercise = "άσκησης";
$langInsertVideo = "πολυμεσικού αρχείου";
$langInsertForum = "περιοχής συζητήσεων";
$langInsertWork = 'εργασίας';
$langInsertWorkCap = 'Εργασία';
$langInsertWiki = 'wiki';
$langInsertLink = "συνδέσμου";
$langInsertEBook = "ηλεκτρονικού βιβλίου";
$langInsertPoll = "ερωτηματολογίου";
$langInsertTcMeeting = "τηλεσυνεργασίας";
$langInsertGlossary =  "γλωσσαρίου";
$langInsertWall = "τοίχου";
$langInsertChat = "συνομιλίας";
$langInsertBlog = "ιστολογίου";
$langUnknownResType = "Πρόβλημα! Άγνωστος πόρος ενότητας";
$langNoExercises = "Δεν υπάρχουν ασκήσεις";
$langAddToCourseHome = "Εμφάνιση στην κεντρική σελίδα του $langsOfCourse";
$langSeenToCourseHome = "Εμφανίζεται στην κεντρική σελίδα του $langsOfCourse";
$langRemoveFromCourseHome = "Απόκρυψη από την κεντρική σελίδα του $langsOfCourse";
$langVia = 'μέσω';
$langStudentViewEnable = "Προβολή σελίδας σαν $langsStudent";
$langStudentViewDisable = "Προβολή σελίδας σαν $langsTeacher";
$langInactiveModule = "ανενεργό υποσύστημα";
$langAvailableUnitResources = "Εκπαιδευτικό υλικό";
$langNoUnits = "Δεν υπάρχουν ενότητες";
$langGoTo = "Μετάβαση σε";

/* * ********************************************************************
  units_prerequisites
 * ********************************************************************* */
$langUnitManage = 'Διαχείριση ενότητας';
$langUnitCompletion = "Ολοκλήρωση ενότητας";
$langUnitCompletionMessage = "Η ενότητα ολοκληρώθηκε με επιτυχία";
$langUnitExerciseAdd = "Η άσκηση προστέθηκε με επιτυχία";
$langManage = "Διαχείριση ενοτήτων";
$langUnitActivity = "δραστηριότητας";
$langUnitCompletionActivate = "Ενεργοποίηση Ολοκλήρωσης";
$langUnitCompletionDeactivate = "Απενεργοποίηση Ολοκλήρωσης";
$langUnitCompletionActivated = "Η ολοκλήρωση της ενότητας ενεργοποιήθηκε";
$langUnitCompletionDeactivated = "Η ολοκλήρωση της ενότητας απενεργοποιήθηκε";
$langOfUnitCompletion = "Δραστηριοτήτων ολοκλήρωσης ενοτήτων";
$langUnitPrerequisites = "Προαπαιτούμενη ενότητα";
$langNewUnitPrerequisite = "Προσθήκη προαπαιτούμενου";
$langNoUnitPrerequisite = "Δεν έχει οριστεί προαπαιτούμενη ενότητα.";
$langUnitHasNotCompletionEnabled = "Αδυναμία προσθήκης! Η ενότητα που επιλέξατε δεν έχει ενεργοποιημένη την ολοκλήρωση ενότητας.";
$langNewUnitPrerequisiteFailInvalid = "Αδυναμία προσθήκης! Παρακαλούμε επιλέξτε μία έγκυρη ενότητα.";
$langNewUnitPrerequisiteSuccess = "Το προαπαιτούμενο δημιουργήθηκε με επιτυχία!";
$langDelUnitPrerequisiteSuccess = "Το προαπαιτούμενο διαγράφηκε με επιτυχία!";
$langNewUnitPrerequisiteFailAlreadyIn = "Αδυναμία προσθήκης, η ενότητα που επιλέξατε υπάρχει ήδη στη λίστα με τα προαπαιτούμενα.";
$langsUnit = "ενότητα";
$langInvalidCourseUnitPrerequisites = "Η ολοκλήρωση της ενότητας δεν είναι ενεργοποιημένη.";
$langUnitNotCompleted = "Οι δραστηριότητες της προηγούμενης ενότητας δεν έχουν ολοκληρωθεί";
$langUnitNotStarted = "Η ενότητα δεν έχει ξεκινήσει";
$langAddToUnitCompletion = "Συμμετοχή στην ολοκλήρωση της ενότητας";
$langResourceBelongsToUnitPrereq = "Η δραστηριότητα συμμετέχει στην ολοκλήρωση της ενότητας";

/* * ********************************************************************
  mail_verify.php
 * ********************************************************************* */
$langMailVerify = "Επιβεβαίωση email";
$langMailVerifyCodeError = "Ο κωδικός επιβεβαίωσης είναι λάθος. Παρακαλούμε επαναλάβετε από την αρχή την διαδικασία.";
$langMailVerifyNoCode = "Ο σύνδεσμος που ακολουθήσατε δεν ισχύει. Παρακαλούμε επαναλάβετε από την αρχή την διαδικασία.";
$langMailVerifyNoId = "Ο σύνδεσμος που ακολουθήσατε είναι λάθος. Παρακαλούμε επαναλάβετε από την αρχή την διαδικασία.";
$langMailVerifyDB = "Παρουσιάστηκε σφάλμα. Παρακαλούμε επικοινωνήστε με τον διαχειριστή της πλατφόρμας.";
$langMailVerifyNoApplication = "Δεν βρέθηκε η αίτηση σας. Παρακαλούμε επαναλάβετε από την αρχή την διαδικασία.";
$langMailVerifyNoAccount = "Δεν βρέθηκε ο λογαριασμός σας. Παρακαλούμε επαναλάβετε από την αρχή την διαδικασία ή επικοινωνήστε με τον διαχειριστή της πλατφόρμας.";
$langMailVerifySuccess = "Το email σας επιβεβαιώθηκε με επιτυχία.";
$langMailVerifySuccess2 = "Το email σας έχει επιβεβαιωθεί με επιτυχία.";
$langMailVerifySuccessU = "Ο λογαριασμός σας ενεργοποιήθηκε.";
$langVerifiedMail = "Επιβεβαιωμένη διεύθυνση email";
$langMailNotVerified = "Το email σας δεν είναι επιβεβαιωμένο. Δεν θα μπορείτε να λαμβάνετε emails από τα $langsCourses έως ότου το επιβεβαιώσετε.
                Για να το επιβεβαιώσετε κάντε κλικ";

$langNoCookies = 'Προσοχή! Έχετε απενεργοποιημένα τα cookies στο πρόγραμμα πλοήγησης που χρησιμοποιείτε. Η σύνδεση δεν είναι δυνατή.';

/* * ***********************************
 * Help
 * ********************************** */
$langNoHelpTopic = "Δεν υπάρχει βοήθεια για το συγκεκριμένο θέμα";

/* * ************************************
  Glossary
 * *********************************** */

$langGlossary = 'Γλωσσάριο';
$langGlossaryTerm = 'Όρος';
$langGlossaryTerms = "Όροι";
$langGlossaryDefinition = 'Ορισμός';
$langAddGlossaryTerm = 'Προσθήκη όρου';
$langEditGlossaryTerm = 'Διόρθωση όρου';
$langGlossaryAdded = 'Η προσθήκη όρου πραγματοποιήθηκε';
$langGlossaryUpdated = 'Η αλλαγή πραγματοποιήθηκε με επιτυχία';
$langGlossaryDeleted = 'Η διαγραφή πραγματοποιήθηκε με επιτυχία';
$langGlossaryUrl = 'URL ορισμού';
$langGlossaryExpand = "Εμφάνιση ορισμών στις σελίδες του $langsOfCourse";
$langGlossaryIndex = 'Αλφαβητικό ευρετήριο όρων';
$langConfig = 'Ρυθμίσεις';
$langGlossaryOverLimit = "Το πλήθος όρων του γλωσσαρίου υπερβαίνει το όριο (%s), ως εκ τούτου οι ορισμοί των όρων δεν θα εμφανίζονται στις σελίδες του $langsOfCourse.";
$langNoGlossary = "Δεν υπάρχει γλωσσάριο";

/* * ******************************************
  Ebook
 * ***************************************** */

$langEBook = 'Ηλεκτρονικό βιβλίο';
$langEBooks = 'Ηλεκτρονικά βιβλία';
$langEBookCreate = "Δημιουργία Ηλεκτρονικού βιβλίου";
$langEBookEdit = 'Διόρθωση Ηλεκτρονικού βιβλίου';
$langEBookInfo = 'Στοιχεία Ηλεκτρονικού βιβλίου';
$langNoEBookSections = 'Δεν έχουν ορισθεί ενότητες';
$langNoEBook = "Δεν υπάρχουν ηλεκτρονικά βιβλία διαθέσιμα στο $langsCourse αυτό.";
$langEBookPages = $langPages . " Ηλεκτρονικού βιβλίου";
$langNewEBookPage = "Νέα Σελίδα";
$langEBookInfoEdit = "Επεξεργασία Στοιχείων / Ενοτήτων";
$langZipFile = 'Αρχείο ZIP';
$langSection = 'Ενότητα';
$langSubsection = 'Υποενότητα';
$langEBookDelConfirm = 'Επιβεβαίωση διαγραφής ηλεκτρονικού βιβλίου';
$langEBookSectionDelConfirm = 'Επιβεβαίωση διαγραφής κεφαλαίου';
$langEBookDeleted = 'Το βιβλίο με τίτλο «%s» διαγράφηκε.';
$langEBookReplace = 'Αντικατάσταση αρχείων';
$langEBookReplaceDoneZip = 'Τα περιεχόμενα του αρχείου ZIP αποσυμπιέστηκαν στο ηλεκτρονικό βιβλίο.';
$langEBookTitleModified = "Η αλλαγή του τίτλου του ηλεκτρονικού βιβλίου πραγματοποιήθηκε";
$langEBookSectionsModified = "Οι αλλαγές στις ενότητες του ηλεκτρονικού βιβλίου πραγματοποιήθηκαν";
$langEBookAdmin = "Διαχείριση ηλεκτρονικού βιβλίου";
$langFileAdmin = "Διαχείριση αρχείων";
$langEBookNoSections = "Δεν έχουν αντιστοιχιστεί σελίδες σε ενότητες";
$langEBookNoPages = "Δεν υπάρχουν ακόμα σελίδες στο ηλεκτρονικό βιβλίο";

/* * ******************************************
  Notes
 * ***************************************** */
$langAddNote = "Νέα σημείωση";
$langDocument = "Έγγραφο";
$langEmptyNoteTitle = "Νέα σημείωση";
$langEnterNote = "Εισαγάγετε σημείωση";
$langEvent = "Γεγονός";
$langLastUpdate = "Τελευταία ενημέρωση";
$langModifNote = "Αλλαγή σημείωσης";
$langNoNote = "Δεν έχετε σημειώσεις.";
$langNoteAdd = "Νέα σημείωση προστέθηκε.";
$langNoteBody = "Περιεχόμενο";
$langNoteDel = "Η σημείωση διαγράφηκε.";
$langNoteModified = "Η σημείωση άλλαξε.";
$langNoteModify = "Η σημείωση ενημερώθηκε.";
$langNoteNoTitle = "Κενός τίτλος";
$langNotes = "Οι σημειώσεις μου";
$langNotesDeleted = "Οι σημειώσεις σας διαγράφηκαν.";
$langPersonalEvent = "Προσωπικό γεγονός";
$langReferencedObject = "Αφορά";
$langSelectFromMenu = "Επιλέξτε...";
$langSureToDelNote = "Θέλετε σίγουρα να διαγραφεί η σημείωση;";
$langSureToDelNoteAll = "Θέλετε σίγουρα να διαγραφούν όλες οι σημειώσεις;";
$langNoteSaved = "Αποθηκεύτηκε με επιτυχία";
$langAllNotes = "Όλες οι σημειώσεις";
$langUserExpiresFieldEmpty = "Η ημερομηνία λήξης χρήστη είναι κενή ή δεν έχει οριστεί";

/* * ******************************************
  Personal calendar
 * ***************************************** */
$langAddEvent = "Νέο γεγονός";
$langAddAdminEvent = "Νέο γεγονός συστήματος";
$langDateTime = "Ημέρα και ώρα";
$langEmptyEventTitle = "Νέο γεγονός";
$langEventAdd = "Νέο γεγονός προστέθηκε.";
$langEventadmin = "γεγονότα συστήματος";
$langEventcourse = "γεγονότα $langsOfCourses";
$langEventdeadline = "προθεσμίες";
$langEventDel = "Το γεγονός διαγράφηκε.";
$langEventModified = "Το γεγονός άλλαξε.";
$langEventModify = "Το γεγονός ενημερώθηκε.";
$langEventNoTitle = "Κενός τίτλος";
$langEventpersonal = "προσωπικά γεγονότα";
$langEventsDeleted = "Τα γεγονότα σας διαγράφηκαν.";
$langEvery = "κάθε";
$langiCalExport = "Εξαγωγή iCal";
$langiCalFeed = "Ροή iCal";
$langiCalExplanation = "Το παρακάτω URL μπορεί να εισαχθεί σε οποιαδήποτε
    εφαρμογή υποστηρίζει εισαγωγή δεδομένων σε μορφή iCal, ώστε τα γεγονότα
    του προσωπικού σας ημερολογίου να συγχρονίζονται με αυτή.";
$langLanguageCode = "el-GR";
$langModifEvent = "Αλλαγή γεγονότος";
$langMonthsAbstract = "μήνες";
$langNoEvent = "Δεν υπάρχουν γεγονότα.";
$langNotValidInput = "Ο τίτλος ή η ημερομηνία του γεγονότος δεν είναι αποδεκτά.";
$langRepeat = "Επανάληψη";
$langShowTo = "Εμφάνιση σε";
$langShowToAdminsOnly = "διαχειριστές μόνο";
$langShowToAdminsandProfs = "διαχειριστές και $langsTeachers";
$langShowToAllregistered = "όλους τους εγγεγραμμένους";
$langShowToAll = "όλους τους χρήστες";
$langSureToDelEvent = "Θέλετε σίγουρα να διαγραφεί το γεγονός;";
$langSureToDelEventAll = "Θέλετε σίγουρα να διαγραφούν όλα τα γεγονότα;";
$langUntil = "μέχρι";
$langWeek = "Εβδομάδα";
$langsWeek = "εβδομάδα";
$langWeeks = "εβδομάδες";

/* * ******************************************
  Messages for jQuery tools
 * ***************************************** */

$langJQSelectNum = 'Επιλέχτηκαν # από #';
$langJQNoneSelected = 'Επιλέξτε';
$langJQCheckAll = 'Επιλογή όλων';
$langJQUncheckAll = 'Αφαίρεση όλων';
$langPopUp = 'Αναδυόμενο για εικόνες';
$langPopUpFrame = 'Αναδυόμενο για πολυμέσα';
$langPwStrengthTooShort = "Πολύ σύντομο";
$langPwStrengthWeak = "Αδύναμο";
$langPwStrengthGood = "Καλό";
$langPwStrengthStrong = "Δυνατό";

/* * ******************************************
  Messages for Course Metadata
 * ***************************************** */
$langOpenCourses = "Ανοικτά Ακαδημαϊκά $langCourses";
$langOpenCoursesShort = "Ανοικτά $langsCourses";
$langCourseMetadata = "Μεταδεδομένα $langsOfCourse";
$langOpenCoursesReviewer = "OpenCourses Reviewer";
$langHelpOpenCoursesReviewer = "διαχειρίζεται $langsCourses, χρήστες και εγκρίνει ανοιχτά $langsCourses";
$langCourseMetadataControlPanel = "Πίνακας Ελέγχου OpenCourses";
$langOpenCoursesCharacteristics = "Ποιοτικά/Ποσοτικά χαρακτηριστικά";
$langOpenCoursesCharacter = "Χαρακτηρισμός $langOfCourse";
$langOpenCoursesOpenAccess = "Τύπος Πρόσβασης (Ανοικτή)";
$langOpenCoursesMandatoryMetadata = "Υποχρεωτικά Μεταδεδομένα $langOfCourse (συμπληρωμένα)";
$langOpenCoursesLicense = "Άδεια Διάθεσης";
$langOpenCoursesTeacherConfirm = "Δήλωση Καθηγητή - Το Διαθέσιμο Εκπαιδευτικό Υλικό καλύπτει το 100% της Διδακτέας Ύλης";
$langOpenCoursesHasDocuments = "Έχει Εκπαιδευτικό Υλικό";
$langOpenCoursesHasUnits = "Έχει Θεματικές Ενότητες";
$langOpenCoursesHasMediaFiles = "Έχει πολυμεσικά αρχεία";
$langOpenCoursesTeacherConfirmVideo = "Δήλωση Καθηγητή - Οι Βιντεοσκοπημένες Διαλέξεις καλύπτουν το 80% της Διδακτέας Ύλης";
$langOpenCoursesFiles = "Αρχεία";
$langOpenCoursesIsAMinusLevel = "Open Courses Α-";
$langOpenCoursesIsALevel = "Open Courses Α";
$langOpenCoursesIsAPlusLevel = "Open Courses Α+";
$langOpenCoursesLevel = "Επίπεδο";
$langOpenCoursesAMinusLevel = "A-";
$langOpenCoursesALevel = "A";
$langOpenCoursesAPlusLevel = "A+";
$langListOpenCourses = "Ευρετήριο Ανοικτών Ακαδημαϊκών $langOfCourses";
$langListOpenCoursesShort = "Ευρετήριο $langOfCourses";
$langOpenCourseShort = "Ανοικτό Ακαδ. $langCourse";
$langNumOpenCourses = "ανοικτά $langsCourses";
$langNumOpenCourse = "ανοικτό $langsCourse";
$langMetaCommentary = "Μετασχολιασμός";
$langOpenCoursesType = "$langCourse τύπου";
$langOpenCoursesWasNotSet = "Το $langsCourse δεν έχει χαρακτηριστεί ως τύπου Open Courses";
$langOpenCoursesWasSet = "Το $langsCourse έχει χαρακτηριστεί";
$langLastSubmission = "Τελευταία Υποβολή";
$langCMeta['courseGroup'] = $langCourse;
$langCMeta['instructorGroup'] = "Διδάσκοντες";
$langCMeta['curriculumGroup'] = "Προγράμματα Σπουδών";
$langCMeta['unitsGroup'] = "Θεματικές Ενότητες";
$langCMeta['el'] = "Ελληνικά";
$langCMeta['en'] = "Αγγλικά";
$langCMeta['false'] = "όχι";
$langCMeta['true'] = "ναι";
$langCMeta['undergraduate'] = "Προπτυχιακό";
$langCMeta['graduate'] = "Μεταπτυχιακό";
$langCMeta['doctoral'] = "Διδακτορικό";
$langCMeta['compulsory'] = "Υποχρεωτικό";
$langCMeta['optional'] = "Επιλογής";
$langCMeta['slides'] = "Διαφάνειες";
$langCMeta['notes'] = "Σημειώσεις";
$langCMeta['video lectures'] = "Βιντεοδιαλέξεις";
$langCMeta['podcasts'] = "Podcasts";
$langCMeta['audio material'] = "Ηχητικό υλικό";
$langCMeta['multimedia material'] = "Πολυμεσικό υλικό";
$langCMeta['interactive exercises'] = "Διαδραστικές ασκήσεις";
$langCMeta['course_instructor_firstName'] = "Όνομα διδάσκοντος";
$langCMeta['course_instructor_lastName'] = "Επώνυμο διδάσκοντος";
$langCMeta['course_instructor_fullName'] = "Πλήρες όνομα διδάσκοντος";
$langCMeta['course_instructor_moreInformation'] = "Περισσότερα για τον διδάσκοντα";
$langCMeta['course_instructor_cv'] = "Σύνδεσμος σε βιογραφικό ή σύντομο βιογραφικό (έως 10 γραμμές)";
$langCMeta['course_instructor_photo'] = "Φωτογραφία διδάσκοντος";
$langCMeta['course_instructor_registrationCode'] = "Αριθμός Πανεπιστημιακού Μητρώου";
$langCMeta['course_title'] = "Τίτλος $langOfCourse";
$langCMeta['help_course_title'] = "όπως αναφέρεται στο Πρόγραμμα Σπουδών";
$langCMeta['course_url'] = "Δικτυακός τόπος $langsOfCourse";
$langCMeta['help_course_url'] = "Σελίδα του $langsOfCourse ή/και σύνδεσμο στο Learning Management System (LMS)
    του Ιδρύματος (π.χ. στο eClass, Moodle, Blackboard, ή όποιο άλλο LMS)";
$langCMeta['course_code'] = "Κωδικός $langOfCourse";
$langCMeta['help_course_code'] = "όπως αναφέρεται στο Πρόγραμμα Σπουδών";
$langCMeta['course_level'] = "Επίπεδο $langsOfCourse";
$langCMeta['help_course_level'] = "Επιλέξτε";
$langCMeta['course_yearOfStudy'] = "Έτος σπουδών";
$langCMeta['help_course_yearOfStudy'] = "Επιλέξτε 1 έως 6 όπως αναφέρεται στο Πρόγραμμα Σπουδών";
$langCMeta['course_semester'] = "Εξάμηνο";
$langCMeta['help_course_semester'] = "Επιλέξτε 1 έως 12 όπως αναφέρεται στο Πρόγραμμα Σπουδών";
$langCMeta['course_type'] = "Τύπος $langsOfCourse";
$langCMeta['help_course_type'] = "Επιλέξτε";
$langCMeta['course_credithours'] = "Διδακτικές ώρες στο εξάμηνο";
$langCMeta['help_course_credithours'] = "Δηλώστε το αριθμό των διδακτικών ωρών του $langsOfCourse στη διάρκεια του εξαμήνου";
$langCMeta['course_coTeaching'] = "Συνδιδασκαλία";
$langCMeta['help_course_coTeaching'] = "Επιλέξτε ανάλογα:
    <ul><li>εάν ο συνάδελφός σας συμμετέχει στο άνοιγμα του $langsOfCourse</li>
    <li>εάν το τμήμα που σας αντιστοιχεί είναι αυτόνομο</li>
    <li>τις διδακτικές ώρες που αντιστοιχούν στο τμήμα σας</li></ul>";
$langCMeta['course_coTeachingColleagueOpensCourse'] = "Συμμετοχή συναδέλφου στο άνοιγμα του $langsOfCourse";
$langCMeta['course_coTeachingAutonomousDepartment'] = "Αυτόνομο τμήμα";
$langCMeta['course_coTeachingDepartmentCreditHours'] = "Διδακτικές ώρες συνδιδασκαλίας";
$langCMeta['course_language'] = "Γλώσσα διδασκαλίας";
$langCMeta['course_targetGroup'] = "Ομάδα στόχος";
$langCMeta['help_course_targetGroup'] = "Π.χ. Οι φοιτητές/απόφοιτοι του τμήματος Υ.
    Ενδιαφερόμενοι για τη θεματική περιοχή Ζ.";
$langCMeta['course_credits'] = "Διδακτικές μονάδες";
$langCMeta['help_course_credits'] = "Όπως αναφέρεται στο Πρόγραμμα Σπουδών. Ορατό μόνο στους φοιτητές, όχι στο ευρύ κοινό.
    Την πληροφορία αυτή μπορεί να την παρακάμψει ένα μέλος ΔΕΠ/ΕΠ και να την εισάγει η τοπική ομάδα υποστήριξης";
$langCMeta['course_description'] = "Περιγραφή $langsOfCourse";
$langCMeta['course_contents'] = "Περιεχόμενα $langsOfCourse";
$langCMeta['help_course_contents'] = "Προτείνεται λεκτική περιγραφή που να περιλαμβάνει τα εξής:
    <ul><li>Δομή περιεχομένων (course outline) και </li>
    <li>περιεχόμενα (θέματα) $langsOfCourse  (topics)</li></ul>";
$langCMeta['course_objectives'] = "Μαθησιακοί στόχοι $langsOfCourse";
$langCMeta['help_course_objectives'] = "Θα απεικονίζεται ως πληροφορία σε διαφορετικό σημείο του ανοικτού $langsOfCourse
    σε σχέση με τη συνοπτική περιγραφή<br/><br/>
    Προτείνεται λεκτική περιγραφή που να περιλαμβάνει τα εξής:
    <ul><li>Αντικειμενικοί Στόχοι $langsOfCourse – επιδιωκόμενα μαθησιακά αποτελέσματα – μαθησιακοί στόχοι</li>
    <li>Tι αναμένεται ο εκπαιδευόμενος να γνωρίζει, να κατανοεί και να κάνει μετά την επιτυχή ολοκλήρωση του  $langsOfCourse</li></ul>";
$langCMeta['course_keywords'] = "Λέξεις κλειδιά";
$langCMeta['course_coursePhoto'] = "Προτεινόμενη φωτογραφία για το $langsCourse";
$langCMeta['course_contentDevelopment'] = "Ομάδα ανάπτυξης περιεχομένου";
$langCMeta['help_course_contentDevelopment'] = "Η ομάδα που έχει βοηθήσει στην ανάπτυξη του περιεχομένου του $langsOfCourse";
$langCMeta['course_format'] = "Τύποι εκπαιδευτικού υλικού";
$langCMeta['help_course_format'] = "Επιλέξτε (περισσότερους από έναν) τους τύπους υλικού που διαθέτει το $langsCourse";
$langCMeta['course_featuredBooks'] = "Προτεινόμενα συγγράμματα";
$langCMeta['course_structure'] = "Οργάνωση $langsOfCourse";
$langCMeta['help_course_structure'] = "Διαθέσιμο μόνο στους φοιτητές όχι στο ευρύ κοινό<br/>
    Δομή και συχνότητα διδασκαλίας
    <ul><li>Ώρες γραφείου</li>
    <li>Διαλέξεις (Lectures) ( π.χ. 2 φορές την εβδομάδα, τρίωρες διαλέξεις) για 13 εβδομάδες</li>
    <li>Φροντιστήριο (Recitations) (1 φορά την εβδομάδα, 2 ώρες)</li>
    <li>Εργαστήρια</li>
    <li>Άλλα</li></ul>";
$langCMeta['course_teachingMethod'] = "Μέθοδος διδασκαλίας";
$langCMeta['help_course_teachingMethod'] = "Διαθέσιμο μόνο στους φοιτητές όχι στο ευρύ κοινό<br/>
    Λεκτική περιγραφή των διδακτικών και μαθησιακών  μεθόδων που χρησιμοποιούνται.
    Π.χ. Διδασκαλία καθ΄ έδρας και συμπληρωματική-ενισχυτική εκπαίδευση μέσω ασύγχρονης πλατφόρμα.
    Εργαστήριο.";
$langCMeta['course_assessmentMethod'] = "Μέθοδοι αξιολόγησης/βαθμολόγησης";
$langCMeta['help_course_assessmentMethod'] = "Διαθέσιμο μόνο στους φοιτητές όχι στο ευρύ κοινό<br/>
    Λεκτική περιγραφή των μεθόδων αξιολόγησης , βαθμολόγησης και κριτηρίων αξιολόγησης  που χρησιμοποιούνται.
    Μπορεί κανείς να αναφερθεί στα εξής:
    <ul><li>Εξετάσεις</li>
    <li>Πρόοδοι</li>
    <li>Επιτρεπόμενο υλικό κατά τις εξετάσεις/προόδους</li>
    <li>Παλαιότερα θέματα εξετάσεων/προόδων</li></ul>";
$langCMeta['course_prerequisites'] = "Προαπαιτoύμενα";
$langCMeta['help_course_prerequisites'] = "Προτείνεται λεκτική περιγραφή που να περιλαμβάνει τα εξής:
    <ul><li>Γενικές προαπαιτούμενες γνώσεις και πιθανή προετοιμασία για παρακολούθηση του $langsOfCourse</li>
    <li>Κωδικοί και σύνδεσμοι προαπαιτούμενων $langsOfCourses</li></ul>";
$langCMeta['course_literature'] = "Επιπλέον συνιστώμενη βιβλιογραφία και υλικό προς μελέτη";
$langCMeta['help_course_literature'] = "Προτείνεται λεκτική περιγραφή που να περιλαμβάνει τα εξής:
    <ul><li>Βιβλία- κείμενα (Text/books)</li>
    <li>Συγγράμματα (επανάληψη)</li>
    <li>Βιβλιογραφία</li>
    <li>Online readings</li>
    <li>Πηγές στο Διαδίκτυο</li>
    <li>Πηγές στη βιβλιοθήκη του ιδρύματος</li>
    <li>Άλλα σχετικά ανοικτά $langsCourses άλλων ιδρυμάτων εσωτερικού ή εξωτερικού</li>
    <li>Άρθρα (Articles)</li>
    <li>Ταινίες (Films)</li></ul>
    Η κάθε πρόταση, συστήνεται να συνοδεύεται από ένα μικρό σχολιασμό του τύπου σε τι είναι χρήσιμο προκειμένου να παρακινηθεί ο ενδιαφερόμενος";
$langCMeta['course_recommendedComponents'] = "Άλλα προτεινόμενα $langsCourses του ιδρύματος σχετικών με το πρόγραμμα σπουδών";
$langCMeta['course_assignments'] = "Αναθέσεις εργασιών";
$langCMeta['help_course_assignments'] = "Προτείνεται λεκτική περιγραφή που να περιλαμβάνει τα εξής:
    <ul><li>Eργασίες (Homework)</li>
    <li>Τests</li>
    <li>Βαθμολόγηση (Grading): Πως μετράνε οι εργασίες στο τελικό βαθμό</li></ul>";
$langCMeta['course_requirements'] = "Απαιτήσεις $langsOfCourse";
$langCMeta['help_course_requirements'] = "Προτείνεται λεκτική περιγραφή που να περιλαμβάνει τα εξής:
    <ul><li>Τεχνικές απαιτήσεις (Technical Requirements)</li>
    <li>Άλλες απαιτήσεις (Other Requirements), Eργασίες (Homework)</li></ul>";
$langCMeta['course_remarks'] = "Παρατηρήσεις";
$langCMeta['course_acknowledgments'] = "Ευχαριστίες";
$langCMeta['help_course_acknowledgments'] = "Π.χ. σε εκδοτικό οίκο ή άλλο μέλος ΔΕΠ για παραχώρηση εκπαιδευτικού υλικού";
$langCMeta['course_eudoxusCode'] = "Κωδικός $langsOfCourse στο Εύδοξο";
$langCMeta['course_eudoxusURL'] = "Σύνδεσμος συγγράμματος στον Εύδοξο";
$langCMeta['course_kalliposURL'] = "Σύνδεσμος συγγράμματος στον Κάλλιπο";
$langCMeta['help_course_kalliposURL'] = "Σε περίπτωση που αναπτυχθεί ηλεκτρονικό σύγγραμμα στο πλαίσιο του προγράμματος Κάλλιππος.
    Για περισσότερες πληροφορίες ανατρέξτε στο σύνδεσμο: http://www.kallipos.gr";
$langCMeta['course_thematic'] = "Θεματική επιστημονική περιοχή";
$langCMeta['help_course_thematic'] = "Θεματική ταξινόμηση σύμφωνα με πρότυπα βιβλιοθηκονομίας. Θα υπάρχουν συγκεκριμένες επιλογές.
    Η συμπλήρωση πιθανόν να γίνει σε συνεργασία με την αντίστοιχη βιβλιοθήκη του τμήματος ή της σχολής. Θα υπάρξουν διευκρινήσεις
    σε επόμενη έκδοση.";
$langCMeta['course_subthematic'] = "Θεματική επιστημονική υπο-περιοχή";
$langCMeta['course_license'] = "Άδεια χρήσης Creative Commons (CC)";
$langCMeta['help_course_license'] = "Θα πρέπει να πραγματοποιηθεί η επιλογή άδειας χρήσης CC σε συνεργασία με το μέλος ΔΕΠ και σε
    συμφωνία με την αντίστοιχη πολιτική του ιδρύματος.";
$langCMeta['course_institution'] = "Ίδρυμα";
$langCMeta['course_institutionDescription'] = "Περιγραφή Ιδρύματος";
$langCMeta['course_department'] = "Τίτλος τμήματος";
$langCMeta['course_sector'] = "Τομέας";
$langCMeta['course_curriculumTitle'] = "Tίτλος προγράμματος σπουδών";
$langCMeta['course_curriculumDescription'] = "Περιγραφή προγράμματος σπουδών";
$langCMeta['course_outcomes'] = "Μαθησιακά αποτελέσματα";
$langCMeta['course_curriculumKeywords'] = "Λέξεις κλειδιά προγράμματος σπουδών";
$langCMeta['course_curriculumLevel'] = "Επίπεδο Προγράμματος Σπουδών";
$langCMeta['course_curriculumTargetGroup'] = "Ομάδα στόχος Προγράμματος Σπουδών";
$langCMeta['course_numberOfUnits'] = "Αριθμός Θεματικών Ενοτήτων";
$langCMeta['course_unit_title'] = "Τίτλος Θεματικής Ενότητας";
$langCMeta['course_unit_description'] = "Αναλυτική περιγραφή Θεματικής Ενότητας";
$langCMeta['course_unit_keywords'] = "Λέξεις – κλειδιά ανά ενότητα";
$langCMeta['course_confirmCurriculum'] = "Το ψηφιακό $langsCourse καλύπτει το 100% της διδακτέας ύλης";
$langCMeta['course_confirmVideolectures'] = "Οι βιντεο-διαλέξεις καλύπτουν το 80% της διδακτέας ύλης";
$langCMeta['asfa'] = "Ανωτάτη Σχολή Καλών Τεχνών";
$langCMeta['auth'] = "Αριστοτέλειο Πανεπιστήμιο Θεσσαλονίκης";
$langCMeta['aua'] = "Γεωπονικό Πανεπιστήμιο Αθηνών";
$langCMeta['duth'] = "Δημοκρίτειο Πανεπιστήμιο Θράκης";
$langCMeta['ihu'] = "Διεθνές Πανεπιστήμιο της Ελλάδος";
$langCMeta['uoa'] = "Εθνικό και Καποδιστριακό Πανεπιστήμιο Αθηνών";
$langCMeta['ntua'] = "Εθνικό Μετσόβιο Πολυτεχνείο";
$langCMeta['eap'] = "Ελληνικό Ανοικτό Πανεπιστήμιο";
$langCMeta['ionio'] = "Ιόνιο Πανεπιστήμιο";
$langCMeta['aueb'] = "Οικονομικό Πανεπιστήμιο Αθηνών";
$langCMeta['aegean'] = "Πανεπιστήμιο Αιγαίου";
$langCMeta['uowm'] = "Πανεπιστήμιο Δυτικής Μακεδονίας";
$langCMeta['uth'] = "Πανεπιστήμιο Θεσσαλίας";
$langCMeta['uoi'] = "Πανεπιστήμιο Ιωαννίνων";
$langCMeta['uoc'] = "Πανεπιστήμιο Κρήτης";
$langCMeta['uom'] = "Πανεπιστήμιο Μακεδονίας";
$langCMeta['upatras'] = "Πανεπιστήμιο Πατρών";
$langCMeta['unipi'] = "Πανεπιστήμιο Πειραιά";
$langCMeta['upelop'] = "Πανεπιστήμιο Πελοποννήσου";
$langCMeta['panteion'] = "Πάντειον Πανεπιστήμιο";
$langCMeta['tuc'] = "Πολυτεχνείο Κρήτης";
$langCMeta['hua'] = "Χαροκόπειο Πανεπιστήμιο";
$langCMeta['teiath'] = "ΤΕΙ Αθήνας";
$langCMeta['teikoz'] = "ΤΕΙ Δυτικής Μακεδονίας";
$langCMeta['teiep'] = "ΤΕΙ Ηπείρου";
$langCMeta['teithe'] = "ΤΕΙ Θεσσαλονίκης";
$langCMeta['teiion'] = "ΤΕΙ Ιονίων Νήσων";
$langCMeta['teikav'] = "ΤΕΙ Αν. Μακεδονίας και Θράκης";
$langCMeta['teikal'] = "ΤΕΙ Πελοποννήσου";
$langCMeta['teicrete'] = "ΤΕΙ Κρήτης";
$langCMeta['teiste'] = "ΤΕΙ Στερεάς Ελλάδας";
$langCMeta['teilar'] = "ΤΕΙ Θεσσαλίας";
$langCMeta['teiwest'] = "ΤΕΙ Δυτικής Ελλάδας";
$langCMeta['teipir'] = "ΤΕΙ Πειραιά";
$langCMeta['teiser'] = "ΤΕΙ Κεντρικής Μακεδονίας";
$langCMeta['aspete'] = "Ανώτατη Σχολή Παιδαγωγικής και Τεχνολογικής Εκπαίδευσης";
$langCMeta['otherinst'] = "Άλλο Ίδρυμα";
$langCMeta['othersubj'] = "Άλλο Επιστημονικό Πεδίο";
$langCMeta['natural'] = "Θετικές και Φυσικές Επιστήμες";
$langCMeta['agricultural'] = "Γεωργικές Επιστήμες";
$langCMeta['engineering'] = "Μηχανική και Τεχνολογία";
$langCMeta['social'] = "Κοινωνικές Επιστήμες";
$langCMeta['medical'] = "Ιατρική, Επιστήμες και Επαγγέλματα Υγείας";
$langCMeta['humanities'] = "Ανθρωπιστικές Επιστήμες και Τέχνες";
$langCMeta['independents'] = "Ανεξάρτητα Τμήματα";
$langCMeta['othersubsubj'] = "Άλλο Επιστημονικό Υπο-Πεδίο";
$langCMeta['othernatural'] = "Άλλες Φυσικές Επιστήμες";
$langCMeta['maths'] = "Μαθηματικά";
$langCMeta['cis'] = "Επιστήμες Υπολογιστών, Πληροφορικής, Τηλεπικοινωνιών";
$langCMeta['phys'] = "Φυσική";
$langCMeta['chem'] = "Χημεία";
$langCMeta['environ'] = "Γεωεπιστήμες και Επιστήμες Περιβάλλοντος";
$langCMeta['biology'] = "Βιολογικές Επιστήμες";
$langCMeta['otheragri'] = "Άλλες Γεωργικές Επιστήμες";
$langCMeta['agrifor'] = "Γεωργία, Δασοκομία και Αλιεία";
$langCMeta['animal'] = "Επιστήμες Ζωικής Παραγωγής";
$langCMeta['agribio'] = "Γεωργική Βιοτεχνολογία";
$langCMeta['rural'] = "Αγροτική Ανάπτυξη και Διοίκηση";
$langCMeta['othereng'] = "Άλλες Επιστήμες Μηχανικής και Τεχνολογίας";
$langCMeta['civil'] = "Επιστήμες Πολιτικού Μηχανικού";
$langCMeta['eeeeie'] = "Επιστήμες Ηλεκτρολόγου Μηχανικού";
$langCMeta['mcec'] = "Επιστήμες Μηχανικού Η/Υ και Ηλεκτρονικού Μηχανικού";
$langCMeta['mechan'] = "Επιστήμες Μηχανολόγου Μηχανικού";
$langCMeta['chemic'] = "Επιστήμες Χημικού Μηχανικού";
$langCMeta['mateng'] = "Μηχανική Υλικών";
$langCMeta['medeng'] = "Βιοϊατρική Μηχανική";
$langCMeta['enveng'] = "Μηχανική Περιβάλλοντος";
$langCMeta['architects'] = "Αρχιτεκτονική και σχέδιο";
$langCMeta['engecon'] = "Μηχανική Οικονομίας και Διοίκησης";
$langCMeta['othersoc'] = "Άλλες Κοινωνικές Επιστήμες";
$langCMeta['psych'] = "Ψυχολογία";
$langCMeta['edusoc'] = "Εκπαίδευση";
$langCMeta['sociology'] = "Κοινωνιολογία";
$langCMeta['law'] = "Νομική Επιστήμη - Δίκαιο";
$langCMeta['political'] = "Πολιτικές Επιστήμες";
$langCMeta['ecobi'] = "Οικονομικά και Διοίκηση Επιχειρήσεων";
$langCMeta['ecogeosoc'] = "Κοινωνική και Οικονομική Γεωγραφία";
$langCMeta['mediacomm'] = "ΜΜΕ και Επικοινωνίες";
$langCMeta['infoscie'] = "Επιστήμη της πληροφόρησης";
$langCMeta['anthro'] = "Ανθρωπολογία";
$langCMeta['othermed'] = "Άλλες Ιατρικές Επιστήμες";
$langCMeta['basicmed'] = "Βασική Ιατρική";
$langCMeta['clinicalmed'] = "Κλινική Ιατρικη";
$langCMeta['healthsci'] = "Επιστήμες Υγείας";
$langCMeta['veterin'] = "Κτηνιατρική";
$langCMeta['hcare'] = "Επαγγέλματα Υγείας";
$langCMeta['medbio'] = "Ιατρική Βιοτεχνολογία";
$langCMeta['physedu'] = "Επιστήμες Φυσικής Αγωγής και Ποιότητας Ζωής";
$langCMeta['fnscie'] = "Επιστήμες Τροφίμων και Διατροφής";
$langCMeta['otherhum'] = "Άλλες Ανθρωπιστικές Επιστήμες";
$langCMeta['hisarch'] = "Ιστορία και Αρχαιολογία";
$langCMeta['langlit'] = "Γλώσσα και Λογοτεχνία";
$langCMeta['philosophy'] = "Φιλοσοφία, Ηθική, Θρησκεία";
$langCMeta['arts'] = "Τέχνες";
$langCMeta['pedagogy'] = "Παιδαγωγική";
$langCMeta['otherinddep'] = "Άλλα Ανεξάρτητα Τμήματα";
$langCMeta['milit'] = "Στρατιωτικές Σχολές";
$langCMeta['instructor_add'] = "Προσθήκη διδάσκοντος";

/* * ******************************************
  Messages for Big Blue Button
 * ***************************************** */

$langBBBConf = "Ρυθμίσεις Big Blue Button";
$langAddServer = "Προσθήκη εξυπηρετητή";
$langAddBBBServerInfo = "Στοιχεία νέου εξυπηρετητή BigBlueButton";
$langUpdateBBBServer = "Στοιχεία εξυπηρετητή BigBlueButton";
$langAvailableBBBServers = "Διαθέσιμοι εξυπηρετητές BigBlueButton";
$langNoAvailableBBBServers = "Δεν υπάρχουν διαθέσιμοι εξυπηρετητές.";
$langExtAppConfig = 'Εξωτερικά εργαλεία';
$langBBBConfig = 'Ρυθμίσεις BigBlueButton';
$langBBBEnabled = 'Διαθέσιμος';
$langBBBRemoveServer = 'Κατάργηση';
$langBBBServerOrderP = "Σειρά";
$langBBBServerLoad = "Φόρτος";
$langBBBMics = "Μικρόφωνα";
$langBBBCameras = "Κάμερες";
$langBBBConfigLB = 'Κατανομή φορτίου';
$langBBBLBWeights = 'Υπολογισμός φορτίου';
$langBBBLBWeightParticipant = "Βάρος χρήστη";
$langBBBLBWeightMic = "Βάρος μικροφώνου";
$langBBBLBWeightCamera = "Βάρος κάμερας";
$langBBBLBWeightRoom = "Βάρος τηλεσυνεργασίας";
$langBBBLBWeightParticipantInfo = "Προτεινόμενη τιμή: 1";
$langBBBLBWeightMicInfo = "Προτεινόμενη τιμή: 2";
$langBBBLBWeightCameraInfo = "Προτεινόμενη τιμή: 2";
$langBBBLBWeightRoomInfo = "Προτεινόμενη τιμή: 50";
$langBBBLBMethod = 'Μέθοδος Κατανομής φορτίου';
$langBBBLBMethodWO = "$langBBBServerOrderP μόνο";
$langBBBLBMethodWLL = "$langBBBServerOrderP, λιγότερος φόρτος";
$langBBBLBMethodWLR = "$langBBBServerOrderP, λιγότερα δωμάτια";
$langBBBLBMethodWLC = "$langBBBServerOrderP, λιγότεροι χρήστες";
$langBBBLBMethodWLM = "$langBBBServerOrderP, λιγότερα μικρόφωνα";
$langBBBLBMethodWLV = "$langBBBServerOrderP, λιγότερες κάμερες";
$langBBBLBMethodWOInfo = "$langBBBLBMethodWO: Λαμβάνεται υπόψιν μόνο η σειρά των εξυπηρετητών. Πρώτα γεμίζει ο εξυπηρετητης με τη χαμηλότερη σειρά και μετά χρησιμοποιείται ο επόμενος";
$langBBBLBMethodWLLInfo = "$langBBBLBMethodWLL: Λαμβάνεται υπόψιν πρώτα η σειρά των εξυπηρετητών και στη συνέχεια ο εξυπηρετητής με τον λιγότερο φόρτο";
$langBBBLBMethodWLRInfo = "$langBBBLBMethodWLR: Λαμβάνεται υπόψιν πρώτα η σειρά των εξυπηρετητών και στη συνέχεια ο εξυπηρετητής με τα λιγότερα δωμάτια";
$langBBBLBMethodWLCInfo = "$langBBBLBMethodWLC: Λαμβάνεται υπόψιν πρώτα η σειρά των εξυπηρετητών και στη συνέχεια ο εξυπηρετητής με τους λιγότερους χρήστες";
$langBBBLBMethodWLMInfo = "$langBBBLBMethodWLM: Λαμβάνεται υπόψιν πρώτα η σειρά των εξυπηρετητών και στη συνέχεια ο εξυπηρετητής με τα λιγότερα μικρόφωνα";
$langBBBLBMethodWLVInfo = "$langBBBLBMethodWLV: Λαμβάνεται υπόψιν πρώτα η σειρά των εξυπηρετητών και στη συνέχεια ο εξυπηρετητής με τις λιγότερες κάμερες";
$langBBBmuteOnStart = "Σίγαση μικροφώνου όλων των χρηστών κατά την είσοδο";
$langBBBlockSettingsDisableCam = "Να μην επιτρέπεται διαμοιρασμός κάμερας από τους φοιτητές";
$langBBBwebcamsOnlyForModerator = "Εμφάνιση κάμερας φοιτητών μόνο στους καθηγητές";
$langBBBlockSettingsDisableMic = "Να μην επιτρέπεται η χρήση μικροφώνου από τους φοιτητές";
$langBBBlockSettingsDisablePrivateChat = "Απενεργοποίηση ιδιωτικών συνομιλιών μεταξύ φοιτητών";
$langBBBlockSettingsDisablePublicChat = "Απενεργοποίηση δημόσιων συνομιλιών από τους φοιτητές";
$langBBBlockSettingsDisableNote = "Απενεργοποίηση κοινόχρηστων σημειώσεων από τους φοιτητές";
$langBBBlockSettingsHideUserList = "Απόκρυψη λίστας χρηστών στους φοιτητές (μέσα στο BBB)";
$langBBBHideParticipants = "Απόκρυψη συμμετεχόντων";
$langBBBEnableRecordings = 'Δυνατότητα καταγραφής βιντεοδιαλέξεων';

$langBBBNotStarted = "Η τηλεσυνεργασία δεν έχει ξεκινήσει ακόμα";
$langBBBHasEnded = "Η τηλεσυνεργασία έχει ολοκληρωθεί";
$langNoBBBSesssions = "Δεν υπάρχουν προγραμματισμένες τηλεσυνεργασίες";
$langBBB = "Τηλεσυνεργασία";
$langNewBBBSession = "Νέα Τηλεσυνεργασία";
$langNewBBBSessionInfo = "Στοιχεία νέας τηλεσυνεργασίας";
$langNewBBBSessionEnd = "Λήξη";
$langNewBBBSessionType = "Είδος τηλεσυνεργασίας";
$langNewBBBSessionPublic = "Συμμετέχουν <strong>όλοι</strong> οι εγγεγραμμένοι χρήστες <strong>της πλατφόρμας</strong>";
$langNewBBBSessionPrivate = "Συμμετέχουν <strong>μόνο</strong>  εγγεγραμμένοι χρήστες <strong>του $langsOfCourse</strong>";
$langBBBSessionJoin = "Σύνδεση";
$langBBBUpdateSuccessful = "Η ενημέρωση ολοκληρώθηκε με επιτυχία";
$langBBBDeleteSuccessful = "Η διαγραφή ολοκληρώθηκε με επιτυχία";
$langNewBBBSessionStatus = "Κατάσταση";
$langBBBAddSuccessful = "Ο προγραμματισμός της νέας τηλεσυνεργασίας πραγματοποιήθηκε με επιτυχία.";
$langBBBNoteEnableJoin = "Ο σύνδεσμος είναι ενεργός μόνο για όσες τηλεσυνεργασίες είναι σε εξέλιξη.";
$langBBBNoteEnableJoinEditor = "Ο σύνδεσμος ενεργοποιείται 15 λεπτά πριν την καθορισμένη ώρα έναρξης.";
$langBBBNoParticipation = "Δεν υπάρχει συμμετοχή.";
$langBBBNotifyUsers = "Ειδοποίηση συμμετεχόντων για τον προγραμματισμό της τηλεσυνεργασίας ";
$langBBBNotifyExternalUsers = "Ειδοποίηση εξωτερικών συμμετεχόντων για τον προγραμματισμό της τηλεσυνεργασίας";
$langBBBExternalUsers = "Εξωτερικοί συμμετέχοντες";
$langBBBNotifyExternalUsersHelpBlock = "Συμπληρώστε τις email διευθύνσεις των εξωτερικών συμμετεχόντων";
$langBBBSessionAvailable = "Ενεργοποίηση συμμετοχής";
$langBBBMinutesBefore = "λεπτά νωρίτερα από την προγραμματισμένη έναρξη";
$langBBBAnnDisplay = "Εμφάνιση στις ανακοινώσεις";
$langBBBScheduledSession = "Προγραμματισμός τηλεσυνεργασίας";
$langBBBScheduleSessionInfo = "Η τηλεσυνεργασία με τίτλο ";
$langBBBScheduleSessionInfo2 = "προγραμματίστηκε για τις ";
$langBBBScheduleSessionInfo3 = "είναι τώρα διαθέσιμη.";
$langBBBScheduleSessionInfoJoin = "Συνδεθείτε για να την παρακολουθήσετε κάνοντας κλικ παρακάτω ";
$langBBBNotServerAvailableStudent = "Η εξυπηρέτηση τηλεσυνεργασιών δεν είναι δυνατή. Επικοινωνήστε με τον $langsTeacher του $langsOfCourse.";
$langBBBNotServerAvailableTeacher = "Η τηλεσυνεργασία δεν είναι ενεργοποιημένη στο μάθημα.";
$langBBBServerOrder = "Σειρά προτίμησης κατά την επιλογή εξυπηρέτη";
$langBBBConnectionError = "Η σύνδεση με τον εξυπηρέτη τηλεσυνεργασιών δεν είναι δυνατή";
$langBBBConnectionErrorOverload = "Η σύνδεση με τον εξυπηρέτη τηλεσυνεργασιών δεν είναι δυνατή. Είτε δεν έχει ενεργοποιηθεί είτε δεν μπορούν να συνδεθούν άλλοι χρήστες.";
$langBBBGetUsersError = "Δεν ήταν δυνατή η ανάκτηση πληροφοριών για την τηλεσυνεργασία ";
$langBBBCreationRoomError = "Η δημιουργία αίθουσας  στον εξυπηρέτη τηλεσυνεργασιών δεν είναι δυνατή";
$langOMNotSupported = "Η σύνδεση δεν είναι δυνατή λόγω μη υποστήριξης των κλήσεων της πλατφόρμας";
$langBBBRecord = "Καταγραφή τηλεσυνεργασίας";
$langBBBRecordUserParticipation = "Παρουσιολόγιο τηλεσυνεργασίας";
$langWangBBBAttendance = "Προσοχή! Μην κλείσετε αυτό το παράθυρο γιατί θα σταματήσει η καταγραφή των παρουσιών των χρηστών στην Τηλεδιάσκεψη!";
$langBBBImportRecordings = "Εισαγωγή καταγεγραμμένων τηλεσυνεργασιών στα πολυμέσα";
$langBBBImportRecordingsOK = "Η εισαγωγή στα πολυμέσα ολοκληρώθηκε με επιτυχία!";
$langBBBImportRecordingsNo = "Η εισαγωγή στα πολυμέσα δεν πραγματοποιήθηκε επειδή δεν υπάρχει δυνατότητα καταγραφής ή δεν έχει ολοκληρωθεί η επεξεργασία της καταγραφής.";
$langBBBImportRecordingsNoNew = "Δε βρέθηκαν νεότερες καταγραφές για τη συγκεκριμένη συνεδρία.";
$langMaxUsers = "Μέγ. αριθμός χρηστών";
$langMaxRooms = "Μέγ. αριθμός δωματίων";
$langBBBDefaultNewRoom = "Προεπιλεγμένες τιμές για νέες τηλεσυνεργασίες";
$langBBBMaxDuration = "Μέγ. διάρκεια τηλεσυνεργασίας";
$langInMinutes = "σε λεπτά. 0 για κανένα περιορισμό";
$langBBBMaxPartPerRoom = 'Μέγ. αριθμός συμμετεχόντων ανά τηλεσυνεργασία';
$langBBBMaxPartPerRoomInfo = '0 για μη περιορισμό';
$langPresharedKey = "Διαμοιραζόμενο κλειδί";
$langBBBSessionMaxUsers = "Μέγ. αριθμός συμμετεχόντων";
$langBBBSessionSuggestedUsers = "Προτεινόμενο πλήθος συμμετεχόντων";
$langBBBSessionSuggestedUsers2 = "για περισσότερους από 80, προτείνεται το 50% των εγγεγραμμένων στο $langsCourse";
$langBBBNoServerForRecording = "Η καταγραφή της τηλεσυνεργασίας δεν είναι ενεργοποιημένη";
$langBBBAlertTitle = "Παρακαλώ πληκτρολογείστε τον τίτλο της τηλεσυνεργασίας";
$langBBBAlertMaxParticipants = "Παρακαλώ ορίστε το μέγιστο πλήθος συμμετεχόντων";
$langBBBServerAlertHostname = "Παρακαλώ πληκτρολογείστε το hostname του εξυπηρέτη";
$langBBBServerAlertName = "Παρακαλώ πληκτρολογείστε το όνομα του εξυπηρέτη";
$langBBBServerAlertIP = "Παρακαλώ πληκτρολογείστε σωστά την ip του εξυπηρετητή";
$langBBBServerAlertKey = "Παρακαλώ πληκτρολογείστε το διαμοιραζόμενο κλειδί του εξυπηρέτη";
$langBBBServerAlertAPIUrl = "Παρακαλώ πληκτρολογείστε το ΑPI url του εξυπηρετητή";
$langBBBServerAlertMaxRooms = "Παρακαλώ πληκτρολογείστε σωστά το μέγιστο πλήθος δωματίων του εξυπηρέτη";
$langBBBServerAlertMaxUsers = "Παρακαλώ πληκτρολογείστε σωστά το μέγιστο πλήθος συνδεδεμένων χρηστών του εξυπηρέτη";
$langBBBServerAlertOrder = "Παρακαλώ πληκτρολογείστε σωστά τη σειρά επιλογής του εξυπηρετητή";
$langBBBMaxUsersJoinError = "Έχει συμπληρωθεί ο μέγιστος αριθμός συμμετεχόντων στην τηλεσυνεργασία. Παρακαλώ δοκιμάστε να συνδεθείτε αργότερα ή επικοινωνήστε με τον $langsOfTeacher του $langsOfCourse.";
$langBBBEndHelpBlock = "Κάντε κλικ για να ορίσετε Ημερομηνία Λήξης Τηλεσυνεργασίας";
$langBBBWelcomeMsg = "Καλώς ήρθατε στην Υπηρεσία Τηλεσυνεργασίας!";
$langBBBAddCourse = "Προσθήκη μαθήματος";
$langBBBDeleteCourseSuccess = "Απενεργοποιήθηκε ο εξυπηρετητής τηλεσυνεργασίας για το μάθημα";
$langBBBAddCourseSuccess = "Η προσθήκη έγινε με επιτυχία!";
$langBBBAddCourseFail = "Αδυναμία προσθήκης, παρακαλούμε επιλέξτε ένα έγκυρο κωδικό μαθήματος";
$langBBBAddCourseFailExits = "Το μάθημα υπάρχει ήδη";
$langUseOfTc = "Χρήση του εξυπηρέτη";
$langToAllCourses = "Σε όλα τα $langsCourses";
$langToAllCoursesInfo = "Επιλέξτε αν ο εξυπηρέτης θα μπορεί να χρησιμοποιείται από όλα τα $langsCourses ή από ορισμένα";
$langToSomeCourses = "Σε συγκεκριμένα $langsCourses";
$langToSomeCoursesInfo = "Ο εξυπηρέτης θα μπορεί να χρησιμοποιείται από συγκεκριμένα $langsCourses. Για να ορίσετε ποια $langsCourses θα τον χρησιμοποιούν μεταβείτε στην \"Αναζήτηση $langsOfCourses\" και επιλέξτε \"Ενέργειες\".";
$langToNoCourses = "Σε κανένα από τα $langsCourses";
$langBBBCronRunning = 'Η αυτόματη καταγραφή παρουσιών στην τηλεσυνεργασία είναι ενεργή.';
$langBBBCronStopped = 'Προσοχή! Η αυτόματη καταγραφή παρουσών στην τηλεσυνεργασία έχει σταματήσει! {Ελέγξτε τις ρυθμίσεις}';
$langBBBCronEnable = 'Σημείωση: Μπορείτε να ενεργοποιήσετε αυτόματη καταγραφή παρουσιών στην τηλεσυνεργασία χωρίς επιπλέον ενέργειες των συντονιστών (άνοιγμα παραθύρου καταγραφής). {Διαβάστε περισσότερα}';
$langBBBCronEnableTitle = 'Οδηγίες ενεργοποίησης αυτόματου παρουσιολογίου τηλεδιασκέψεων';
$langBBBCronEnableInstructions = '
<p>Εφόσον η υπηρεσία φιλοξενείται σε περιβάλλον Unix / Linux, μπορείτε να προσθέσετε την παρακάτω εντολή ως cron job στον εξυπηρετητή, δίνοντας <code>crontab -e</code>:</p>
<pre>
* * * * *  /usr/bin/php {webRoot}/modules/tc/tc_cron_attendance.php
</pre>
<p>Ανάλογα με το σύστημα φιλοξενίας, πιθανόν να χρειαστεί κάποια αλλαγή στην πλήρη διαδρομή της εντολής της php.</p>
<p>Εναλλακτικά, μπορείτε να ενεργοποιήσετε φόρτωση της διεύθυνση / URL:<br>
<code>{cronURL}</code><br>
Για παράδειγμα, αυτό μπορεί να γίνει μέσω κάποιου εξωτερικού συστήματος webcron.</p>
<p>Σε κάθε περίπτωση, η κλήση πρέπει να γίνεται κάθε ένα λεπτό προκειμένου τα δεδομένα καταγραφής να είναι ακριβή.</p>';

/* * ******************************************
  Messages for Zoom API
 * ***************************************** */
$langZoomCreateMeetingError = 'Προέκυψε σφάλμα κατά την δημιουργία του zoom meeting.';
$langZoomAccessTokenError = 'Σφάλμα κατά την δημιουργία zoom access token.';
$langZoomUserCreateError = 'Σφάλμα κατά την δημιουργία χρήστη Zoom.';
$langZoomListUsersError = 'Σφάλμα κατά την εμφάνιση των χρηστών του zoom λογαριασμού.';
$langZoomUserExistsError = 'Προέκυψε σφάλμα κατά την αναζήτηση του χρήστη με email: ';
$langZoomUserTypeError = "Σφάλμα κατά την αλλαγή άδειας χρήσης. Ο λογαριασμός του χρήστη πρέπει να είναι 'με πληρωμή'.";
$langZoomUserNotRegistered = 'Δεν βρέθηκε εγγεγραμμένος χρήστης στην υπηρεσία UoA Zoom με διεύθυνση email: ';
$langZoomUserNotFound = 'Δημιουργήθηκε πρόβλημα κατά την εύρεση του χρήστη.';
$langZoomSuccessRegister = 'Επιτυχής δημιουργία λογαριασμού. Παρακαλώ ακολουθήστε τον σύνδεσμο στο email σας.';
$langShowZoomApiUsers = 'Εμφάνιση Χρηστών Zoom';
$langZoomConnect = "Επιλογή τρόπου σύνδεσης με την υπηρεσία Zoom";
$langZoomConnectViaApi = "Με χρήση του Zoom API";
$langZoomConnectNoApi = "Χωρίς τη χρήση του Zoom API";
$langNoApiCredentials = "Δεν έχει ρυθμιστεί η πιστοποίηση μέσω API";
$langEmptyParameter = "Κενή παράμετρος";
$langNoEmptySeats = "Δεν υπάρχουν διαθέσιμες θέσεις";
$langZoomErrorUserNotFound = "Δεν βρέθηκε ο χρήστης στο λογαριασμό του Zoom";
$langFree = "Ελεύθερη";
$langPaid = "Με πληρωμή";


/* * ***********************************************************
 * blog.php
 * ************************************************************ */
$langBlog = "Ιστολόγιο";
$langCourseBlog = "Ιστολόγιο $langsOfCourse";
$langBlogPosts = "Αναρτήσεις ιστολογίου";
$langBlogPopular = "Δημοφιλείς αναρτήσεις";
$langBlogPostDelSucc = "Η διαγραφή της ανάρτησης ήταν επιτυχής";
$langBlogPostDelFail = "Η διαγραφή της ανάρτησης απέτυχε";
$langBlogPostNotFound = "Η ανάρτηση δεν βρέθηκε";
$langBlogAddPost = "Προσθήκη ανάρτησης";
$langBlogEmpty = "Δεν υπάρχουν αναρτήσεις ιστολογίου";
$langBlogNewerPosts = "Νεότερες αναρτήσεις";
$langBlogOlderPosts = "Παλαιότερες αναρτήσεις";
$langBlogPostUser = " - από τον χρήστη ";
$langSureToDelBlogPost = "Είστε σίγουρος ότι θέλετε να διαγράψετε την ανάρτηση";
$langBlogPostBody = "Σώμα Ανάρτησης";
$langBlogPostTitle = "Τίτλος Ανάρτησης";
$langBlogPost = "Ανάρτηση Ιστολογίου";
$langModifBlogPost = "Αλλαγή της ανάρτησης";
$langEmptyBlogPostTitle = "Παρακαλώ πληκτρολογήστε τον τίτλο της ανάρτησης";
$langBlogPostSaveSucc = "Η ανάρτηση αποθηκεύτηκε με επιτυχία";
$langBlogPostSaveFail = "Υπήρξε πρόβλημα κατά την αποθήκευση της ανάρτησης";
$langBlogPostHistory = "Ιστορικό αναρτήσεων";
$langBlogPostNotAllowedCreate = "Δεν έχετε δικαίωμα δημιουργίας ανάρτησης";
$langBlogPostNotAllowedDel = "Δεν έχετε δικαίωμα διαγραφής της ανάρτησης";
$langBlogPostNotAllowedEdit = "Δεν έχετε δικαίωμα επεξεργασίας της ανάρτησης";
$langReturnBlog = "Επιστροφή στο ιστολόγιο";
$langBlogPerm = "Δικαιώματα σύνταξης αναρτήσεων ιστολογίου";
$langBlogPermStudents = "Ο $langsTeacher και οι $langsStudents έχουν δικαίωμα σύνταξης";
$langBlogPermTeacher = "Ο $langsTeacher μόνο έχει δικαίωμα σύνταξης";

/* * ***********************************************************
 * personal blog
 * ************************************************************ */
$lang_personal_blog = "Ενεργοποίηση προσωπικού ιστολογίου";
$lang_personal_blog_commenting = "Ενεργοποίηση σχολιασμού σε αναρτήσεις προσωπικού ιστολογίου";
$lang_personal_blog_rating = "Ενεργοποίηση αξιολόγησης σε αναρτήσεις προσωπικού ιστολογίου";
$lang_personal_blog_sharing = "Ενεργοποίηση διαμοιρασμού σε κοινωνικά δίκτυα σε αναρτήσεις προσωπικού ιστολογίου";
$langPersoBlogDisabled = "Τα Προσωπικά Ιστολόγια είναι απενεργοποιημένα από τους διαχειριστές της πλατφόρμας.";
$langMyBlog = "Το ιστολόγιό μου";
$langUserBlog = "Προσωπικό Ιστολόγιο";
$langBlogUserNotExist = "Ο ιδιοκτήτης αυτού του προσωπικού ιστολογίου δεν υπάρχει";

/* * ***********************************************************
 * comments
 * ************************************************************ */
$langCommentsDelConfirm = "Είστε σίγουροι πως θέλετε να διαγράψετε το σχόλιο;";
$langCommentsDelSuccess = "Το σχόλιο διαγράφηκε με επιτυχία";
$langCommentsDelFail = "Η διαγραφή του σχολίου απέτυχε";
$langCommentsLoadFail = "Το σχόλιο δεν ήταν δυνατό να βρεθεί";
$langCommentsSaveConfirm = "Επιβεβαίωση υποβολής του σχολίου";
$langCommentsSaveSuccess = "Το σχόλιο υποβλήθηκε με επιτυχία";
$langCommentsSaveFail = "Η αποθήκευση του σχολίου απέτυχε";
$langCommentsNewNoPerm = "Δεν έχετε δικαίωμα δημιουργίας του σχολίου";
$langCommentsDelNoPerm = "Δεν έχετε δικαίωμα διαγραφής του σχολίου";
$langCommentsEditNoPerm = "Δεν έχετε δικαίωμα επεξεργασίας του σχολίου";
$langCourseCommenting = "Σχολιασμός στην αρχική σελίδα του $langsOfCourse";
$langBlogCommenting = "Σχολιασμός αναρτήσεων ιστολογίου";
$langBlogPostCommenting = "Σχολιασμός ανάρτησης";
$langCommentsEn = "Ενεργοποιημένος σχολιασμός";
$langCommentsDis = "Απενεργοποιημένος σχολιασμός";

/* * ***********************************************************
 * rating
 * ************************************************************ */
$langCourseRating = "Αξιολόγηση $langsOfCourse";
$langForumPostRating = "Αξιολόγηση αναρτήσεων περιοχών συζητήσεων";
$langBlogRating = "Αξιολόγηση αναρτήσεων ιστολογίου";
$langRatingEn = "Ενεργοποιημένη αξιολόγηση";
$langRatingDis = "Απενεργοποιημένη αξιολόγηση";
$langUserHasRated = "Έχετε υποβάλει την αξιολόγησή σας";
$langRatingAverage = "Μέση Βαθμολογία: ";
$langRatingVote = " αξιολόγηση";
$langRatingVotes = " αξιολογήσεις";
$langCourseAnonymousRating = "Αξιολόγηση $langsOfCourse από ανώνυμους χρήστες";
$langRatingAnonEn = "Επιτρέπεται η αξιολόγηση ";
$langRatingAnonDis = "Δεν επιτρέπεται η αξιολόγηση";
$langRatingAnonDisCourse = "Η αξιολόγηση από ανώνυμους χρήστες είναι απενεργοποιημένη για $langsCourses με μη ελεύθερη πρόσβαση χωρίς εγγραφή.";
$langRateIt = "Αξιολόγησέ το";

/* * ***********************************************************
 * sharing
 * ************************************************************ */
$langCourseSharing = "Διαμοιρασμός σελίδας $langsOfCourse σε κοινωνικά δίκτυα";
$langBlogSharing = "Διαμοιρασμός αναρτήσεων ιστολογίου σε κοινωνικά δίκτυα";
$langSharingEn = "Ενεργοποιημένος διαμοιρασμός";
$langSharingDis = "Απενεργοποιημένος διαμοιρασμός";
$langShare = "Μοιράσου το";
$langSharingDisAdmin = "Ο Διαμοιρασμός σε κοινωνικά δίκτυα είναι καθολικά απενεργοποιημένος από τον διαχειριστή της πλατφόρμας.";
$langSharingDisCourse = "Ο Διαμοιρασμός σε κοινωνικά δίκτυα είναι απενεργοποιημένος για $langsCourses με μη ελεύθερη πρόσβαση χωρίς εγγραφή.";
$langEnableSocialSharingLiks = "Ενεργοποίηση διαμοιρασμού σε κοινωνικά δίκτυα";

/* * ***********************************************************
 * Abuse Report
 * ************************************************************ */
$langAbuseReport = 'Αναφορά κατάχρησης';
$langAbuseReports = 'Αναφορές κατάχρησης';
$langAbuseReportEn = 'Ενεργοποιημένη αναφορά κατάχρησης';
$langAbuseReportDis = 'Απενεργοποιημένη αναφορά κατάχρησης';
$langAbuseReportCat = 'Αιτία αναφοράς κατάχρησης';
$langSpam = 'Spam';
$langRudeness = 'Απρεπείς εκφράσεις';
$langAbuseReportCatError = 'Δεν επιλέξατε αιτία για την αναφορά κατάχρησης';
$langAbuseReportMsgError = 'Πρέπει να συμπληρώσετε ένα μήνυμα αιτιολόγησης για να καταχωρήσετε μια αναφορά κατάχρησης';
$langAbuseReportSaveSuccess = "Η αποστολή της αναφοράς προς τους διαχειριστές του $langsOfCourse έγινε επιτυχώς. Η ενημέρωσή τους πραγματοποιήθηκε με την αποστολή μηνύματος από το υποσύστημα Ανταλλαγής Μηνυμάτων.";
$langAbuseReportPMBody = 'Μόλις καταχώρησα μια αναφορά κατάχρησης για %s. <br/>
<strong>Αιτία:</strong><br/> %s <br/>
<strong>Αιτιολογία:</strong><br/> %s <br/>
<strong>Περιεχόμενο:</strong><br/> %s <br/>
<a class="outtabs" href="%s">Μετάβαση στο περιεχόμενο</a>';
$langAbuseReportClosePMBody = 'Μόλις έκλεισα μια αναφορά κατάχρησης για %s. <br/>
<strong>Αιτία:</strong><br/> %s <br/>
<strong>Αιτιολογία:</strong><br/> %s <br/>
<strong>Περιεχόμενο:</strong><br/> %s <br/>
<a class="outtabs" href="%s">Μετάβαση στο περιεχόμενο</a>';
$langAComment = 'ένα σχόλιο';
$langAForumPost = 'μια ανάρτηση περιοχών συζητήσεων';
$langNoAbuseReports = "Δεν υπάρχουν αναφορές κατάχρησης για αυτό το $langsCourse";
$langAbuseResourceType = 'Τύπος περιεχομένου';
$langAbuseReportClose = 'Κλείσιμο αναφοράς';
$langVisitReportedResource = 'Μετάβαση στο αναφερόμενο περιεχόμενο';
$langEditReportedResource = 'Επεξεργασία αναφερόμενου περιεχομένου';
$langDeleteReportedResource = 'Διαγραφή αναφερόμενου περιεχομένου';
$langConfirmAbuseReportClose = 'Είστε σίγουροι ότι θέλετε να χαρακτηρίσετε αυτή την αναφορά ως επιλυμένη;';
$langConfirmDeleteReportedResource = 'Είστε σίγουροι ότι θέλετε να διαγράψετε το αναφερόμενο περιεχόμενο;';
$langCloseReportSuccess = 'Η αναφορά χαρακτηρίστηκε ως επιλυμένη.';
$langAbuseReportStatus = 'Κατάσταση αναφοράς';
$langAbuseReportOpen = 'Ανοιχτή αναφορά';
$langAbuseReportClosed = 'Κλειστή αναφορά';

/* * ***********************************************************
 * Social Wall
 * ************************************************************ */
$langWall = 'Τοίχος';
$langWallExtVideo = 'Εξωτερικό βίντεο';
$langWallPostSaved = 'Η ανάρτηση αποθηκεύθηκε';
$langWallMessageEmpty = 'Το μήνυμα της ανάρτησης ήταν κενό';
$langWallExtVideoLink = 'Διεύθυνση βίντεο Youtube ή Vimeo';
$langWallExtVideoLinkNotValid = 'Η τιμή του πεδίου για τη διεύθυνση του βίντεο δεν είναι έγκυρη διεύθυνση των υπηρεσιών Youtube ή Vimeo';
$langNoWallPosts = "Δεν υπάρχουν αναρτήσεις στον τοίχο του $langsOfCourse";
$langWallUser = 'Ο χρήστης ';
$langWallSharedVideo = ' μοιράστηκε ένα βίντεο';
$langWallSharedPost = ' μοιράστηκε μια ανάρτηση';
$langWallPostDeleted = 'Η διαγραφή της ανάρτησης πραγματοποιήθηκε επιτυχώς';
$langWallPostDelConfirm = 'Είστε σίγουροι ότι επιθυμείτε να διαγράψετε αυτή την ανάρτηση;';
$langWallPost = 'Ανάρτηση τοίχου';
$langWallPinPost = 'Μόνιμη τοποθέτηση στην κορυφή του τοίχου';
$langWallUnPinPost = 'Απομάκρυνση από την κορυφή του τοίχου';
$langWallGeneralSuccess = 'Η ενέργεια εκτελέστηκε επιτυχώς';
$langWallAttachedResources = 'Συνημμένοι πόροι';
$langWallHiddenResource = 'Μη ορατός πόρος';

/**************************************************************
 * Custom Profile Fields
 * ************************************************************ */
$langCPFAdmin = 'Διαχείριση προσαρμοσμένων πεδίων προφίλ χρήστη';
$langCPFCategoryNameAlert = 'Η συμπλήρώση του πεδίου για το όνομα της κατηγορίας είναι υποχρεωτική';
$langCPFCatAddedSuccess = 'Η κατηγορία πεδίων προφίλ προστέθηκε επιτυχώς';
$langCPFNoCats = 'Δεν υπάρχουν κατηγορίες πεδίων προφίλ';
$langCPFNewField = 'Προσθήκη πεδίου προφίλ';
$langCPFConfirmCatDelete = 'Διαγράφοντας αυτή την κατηγορία θα διαγραφούν και τα πεδία του προφίλ που ανήκουν σε αυτή, καθώς και τα αντίστοιχα δεδομένα από το προφίλ
των χρηστών. Είστε σίγουροι ότι θέλετε να προχωρήσετε στη διαγραφή;';
$langCPFConfirmFieldDelete = 'Διαγράφοντας αυτό το πεδίο θα διαγραφούν και τα αντίστοιχα δεδομένα από το προφίλ των χρηστών. Είστε σίγουροι ότι θέλετε να προχωρήσετε στη διαγραφή;';
$langCPFCatDelSuccess = 'Η κατηγορία των πεδίων προφίλ διαγράφηκε με επιτυχία';
$langCPFCatModSuccess = 'Η κατηγορία των πεδίων προφίλ τροποποιήθηκε με επιτυχία';
$langCPFShortName = 'Σύντομο όνομα';
$langCPFText = 'Πεδίο κειμένου';
$langCPFTextarea = 'Περιοχή κειμένου';
$langCPFDate = 'Πεδίο ημερομηνίας';
$langCPFMenu = 'Μενού επιλογής';
$langCPFFieldDatatype = 'Τύπος πεδίου';
$langCPFFieldDelSuccess = 'Το πεδίο προφίλ διαγράφηκε επιτυχώς';
$langCPFFieldRequired = 'Υποχρεωτικό πεδίο';
$langCPFFieldRegistration = 'Εμφάνιση στη φόρμα εγγραφής';
$langCPFFieldUserType = 'Τύπος χρήστη';
$langCPFFieldVisibility = 'Ορατό';
$langCPFFieldNameAlert = 'Το όνομα του πεδίου προφίλ πρέπει να συμπληρωθεί υποχρεωτικά';
$langCPFFieldShortNameAlert = 'Το σύντομο όνομα του πεδίου προφίλ πρέπει να συμπληρωθεί υποχρεωτικά';
$langCPFFieldAddSuccess = 'Το πεδίο προφίλ προστέθηκε επιτυχώς';
$langCPFFieldEdit = 'Επεξεργασία πεδίου';
$langCPFFieldEditSuccess = 'Η επεξεργασία του πεδίου προφίλ έγινε επιτυχώς';
$langCPFNoFieldinCat = 'Δεν υπάρχουν πεδία προφίλ σε αυτή την κατηγορία';
$langCPFUniqueShortname = 'Το σύντομο όνομα του πεδίου προφίλ πρέπει να είναι μοναδικό στην πλατφόρμα';
$langCPFCreateUniqueShortnameError = 'Το σύντομο όνομα του πεδίου προφίλ που συμπληρώσατε έχει ξαναχρησιμοποιηθεί στην πλατφόρμα. Η διαδικασία δημιουργίας του πεδίου προφίλ ακυρώθηκε.';
$langCPFEditUniqueShortnameError = 'Το σύντομο όνομα του πεδίου προφίλ που συμπληρώσατε έχει ξαναχρησιμοποιηθεί στην πλατφόρμα. Η διαδικασία επεξεργασίας του πεδίου προφίλ ακυρώθηκε.';
$langCPFMenuOptions = 'Επιλογές μενού';
$langCPFMenuOptionsExplan = 'Εισάγετε μια επιλογή ανά γραμμή';
$langCPFMenuOptionsAlert = 'Πρέπει να εισάγετε τουλάχιστον μια επιλογή για το μενού';
$langCPFMenuOptionsChangeExplan = 'Η αλλαγή των επιλογών μπορεί να οδηγήσει σε ασυνέπειες για πεδία που έχουν ήδη περιεχόμενο';
$langCPFChangeOrder = 'Αλλαγή διάταξης';
$langCPFSortOrderSuccess = 'Η διάταξη των κατηγοριών και των πεδίων αποθηκεύθηκε.';
$langCPFAdminSideMenuLink = 'Πεδία προφίλ χρήστη';
$langCPFLinkValidFail = 'Το πεδίο %s δεν είναι έγκυρη διαδικτυακή διεύθυνση. ';
$langCPFDateValidFail = 'Το πεδίο %s δεν είναι έγκυρη ημερομηνία. ';

/**************************************************************
 * e-Portfolio
 * ************************************************************ */
$langEPFAdmin = 'Διαχείριση πεδίων e-Portfolio χρήστη';
$langEPFAdminSideMenuLink = 'Πεδία e-Portfolio χρήστη';
$langEPFCatDelSuccess = 'Η κατηγορία των πεδίων e-Portfolio διαγράφηκε επιτυχώς';
$langEPFCatModSuccess = 'Η κατηγορία των πεδίων e-Portfolio τροποποιήθηκε επιτυχώς';
$langEPFUniqueShortname = 'Το σύντομο όνομα του πεδίου e-Portfolio πρέπει να είναι μοναδικό στην πλατφόρμα';
$langEPFFieldNameAlert = 'Το όνομα του πεδίου e-Portfolio πρέπει να συμπληρωθεί υποχρεωτικά';
$langEPFFieldShortNameAlert = 'Το σύντομο όνομα του πεδίου e-Portfolio πρέπει να συμπληρωθεί υποχρεωτικά';
$langEPFFieldEditSuccess = 'Η επεξεργασία του πεδίου e-Portfolio έγινε επιτυχώς';
$langEPFEditUniqueShortnameError = 'Το σύντομο όνομα του πεδίου e-Portfolio που συμπληρώσατε έχει ξαναχρησιμοποιηθεί στην πλατφόρμα. Η διαδικασία επεξεργασίας του πεδίου e-Portfolio ακυρώθηκε.';
$langEPFFieldAddSuccess = 'Το πεδίο e-Portfolio προστέθηκε επιτυχώς';
$langEPFCreateUniqueShortnameError = 'Το σύντομο όνομα του πεδίου e-Portfolio που συμπληρώσατε έχει ξαναχρησιμοποιηθεί στην πλατφόρμα. Η διαδικασία δημιουργίας του πεδίου e-Portfolio ακυρώθηκε.';
$langEPFFieldDelSuccess = 'Το πεδίο e-Portfolio διαγράφηκε επιτυχώς';
$langEPFCatAddedSuccess = 'Η κατηγορία πεδίων e-Portfolio προστέθηκε επιτυχώς';
$langEPFNoCats = 'Δεν υπάρχουν κατηγορίες πεδίων e-Portfolio';
$langEPFNewField = 'Προσθήκη πεδίου e-Portfolio';
$langEPFConfirmCatDelete = 'Διαγράφοντας αυτή την κατηγορία θα διαγραφούν και τα πεδία του e-Portfolio που ανήκουν σε αυτή, καθώς και τα αντίστοιχα δεδομένα από το e-Portfolio των χρηστών. Είστε σίγουροι ότι θέλετε να προχωρήσετε στη διαγραφή;';
$langEPFConfirmFieldDelete = 'Διαγράφοντας αυτό το πεδίο θα διαγραφούν και τα αντίστοιχα δεδομένα από το e-Portfolio των χρηστών. Είστε σίγουροι ότι θέλετε να προχωρήσετε στη διαγραφή;';
$langMyePortfolio = 'Το e-Portfolio μου';
$langUserePortfolio = 'e-Portfolio χρήστη';
$langePortfolioChangeSucc = 'Οι αλλαγές στο e-Portfolio αποθηκεύθηκαν επιτυχώς';
$langPersInfo = 'Προσωπικά στοιχεία';
$langEduEmpl = 'Εκπαίδευση και εργασία';
$langAchievements = 'Διακρίσεις - επιτεύγματα';
$langGoalsSkills = 'Στόχοι και δεξιότητες';
$langBirthDate = 'Ημερομηνία γέννησης';
$langBirthPlace = 'Τόπος γέννησης';
$langGender = 'Φύλο';
$langMale = 'Άνδρας';
$langFemale = 'Γυναίκα';
$langAboutMe = 'Σχετικά με μένα';
$langAboutMeDescr = '<p>Λίγα λόγια για τον εαυτό σας</p>';
$langPersWebsite = 'Προσωπική σελίδα';
$langEducation = 'Εκπαίδευση';
$langEducationDescr = '<p>Σπουδές, ακαδημαϊκά προσόντα κ.λπ.</p>';
$langEmployment = 'Επαγγελματική εμπειρία';
$langCertAwards = 'Πιστοποιήσεις και βραβεία';
$langPublications = 'Δημοσιεύσεις';
$langPersGoals = 'Προσωπικοί στόχοι';
$langAcademicGoals = 'Ακαδημαϊκοί στόχοι';
$langCareerGoals = 'Επαγγελματικοί στόχοι';
$langPersSkills = 'Προσωπικές δεξιότητες';
$langAcademicSkills = 'Ακαδημαϊκές δεξιότητες';
$langCareerSkills = 'Επαγγελματικές δεξιότητες';
$langFBProfile = 'Facebook προφίλ';
$langTwitterAccount = 'Twitter λογαριασμός';
$langLinkedInProfile = 'LinkedIn προφίλ';
$langBio = 'Βιογραφικό';
$langBioQuota = 'Όριο αποθηκευτικού χώρου για το βιογραφικό';
$langUploadBioFailSize = 'Το μέγεθος του αρχείου ξεπερνάει το μέγιστο επιτρεπτό όριο (%d MB)';
$langBioDeletedSuccess = 'Το αρχείο του βιογραφικού διαγράφηκε επιτυχώς';
$langUploadBio = 'Ανέβασμα Βιογραφικού';
$langUploadBioSuccess = 'Το αρχείο του βιογραφικού ανέβηκε επιτυχώς';
$langUploadBioFailType = 'Το αρχείου που προσπαθήσατε να ανεβάσετε δεν είναι PDF';
$langBioPermFileType = 'Επιτρέπεται το ανέβασμα μόνο αρχείων PDF.';
$langBioMaxSize = 'Το μέγιστο επιτρεπόμενο όριο του αρχείου είναι %s MB.';
$lang_eportfolio_enable = 'Ενεργοποίηση e-Portfolio χρηστών';
$langePortfolioDisabled = 'Τo e-Portfolio των χρηστών είναι απενεργοποιημένo από τους διαχειριστές της πλατφόρμας.';
$langUserePortfolioDisabled = 'Τo e-Portfolio του χρήστη είναι απενεργοποιημένo.';
$langePortfolioDisableWarning = 'Το e-Portfolio σας είναι απενεργοποιημένο και επομένως δεν είναι ορατό σε άλλους χρήστες και επισκέπτες της πλατφόρμας.';
$langAddResePortfolio = 'Προσθήκη σε e-Portfolio';
$langAddGroupWorkSubePortfolio = 'Προσθήκη υποβολής ομάδας "%s" σε e-Portfolio';
$langResourcesCollection = 'Συλλογή πόρων';
$langePortfolioResourceAdded = 'Ο πόρος προστέθηκε επιτυχώς στη συλλογή σας';
$langePortfolioResourceRemoved = 'Ο πόρος αφαιρέθηκε επιτυχώς από τη συλλογή σας';
$langePortfolioRemoveResource = 'Αφαίρεση';
$langePortfolioSureToRemoveResource = 'Είστε σίγουροι ότι θέλετε να αφαιρέσετε αυτόν τον πόρο από τη συλλογή σας;';
$langePortfolioCollectionUserInfo = 'Στη συλλογή πόρων του e-Portfolio μπορείτε να προσθέσετε πόρους από τα υποσυστήματα: ιστολόγιο (προσωπικό και μαθημάτων), εργασίες μαθημάτων και προσωπικά έγγραφα, εφόσον αυτά είναι ενεργοποιημένα.
Οι αντίστοιχες καρτέλες εμφανίζονται μόνο αν έχουν προστεθεί πόροι από τα σχετικά υποσυστήματα στη συλλογή.';
$langePortfolioNoResInCollection = 'Δεν έχουν προστεθεί πόροι στη συλλογή';
$langEnabledePortfolioButtonsLabel = 'Ενεργοποιημένο e-Portfolio';
$langPageLink = 'Σύνδεσμος σελίδας';
$langCopiedSucc = 'Αντιγράφηκε';
$langCopiedErr = 'Πατήστε Ctrl+c για αντιγραφή';
$langNoCompleted = "Μη ολοκληρωμένο";
$langResourceExists = "Ο πόρος υπάρχει ήδη.";

/* * ******************************************
  Widgets
 * ***************************************** */
$langWidgets = "Μικροεφαρμογές";
$langMyWidgets = "Οι μικροεφαρμογές μου";
$langCourseWidgets = "Mικροεφαρμογές $langsOfCourse";
$langInstalledWidgets = "Εγκατεστημένες Μικροεφαρμογές";
$langNoInstalledWidgets = "Δεν υπάρχουν εγκατεστημένες μικροεφαρμογές";
$langAvailableWidgets = "Διαθέσιμες Μικροεφαρμογές";
$langNoAvailableWidgets = "Δεν υπάρχουν διαθέσιμες μικροεφαρμογές προς εγκατάσταση.";
$langWidgetInstall = "Εγκατάσταση";
$langWidgetUninstall = "Απεγκατάσταση";
$langWidgetAdmin = "Διαχείρισης";
$langWidgetPersonal = "Προσωπικό";
$langWidgetCourse = "$langOfCourse";
$langHomePageMainContent = "Κύριο περιεχόμενο Αρχικής Σελίδας";
$langHomePageSidebarContent = "Στήλη κυρίου περιεχομένου Αρχικής Σελίδας";
$langPortfolioMainContent = "Κύριο περιεχόμενο Χαρτοφυλακίου";
$langPortfolioSidebarContent = "Στήλη κυρίου περιεχομένου Χαρτοφυλακίου";
$langCourseHomeMainContent = "Κύριο περιεχόμενο Αρχικής Σελίδας $langOfCourse";
$langCourseHomeSidebarContent = "Στήλη κυρίου περιεχομένου Αρχικής Σελίδας $langOfCourse";
/* * ******************************************
  Theme Options
 * ***************************************** */
$langThemeSettings = 'Ρυθμίσεις Εμφάνισης';
$langThemeHomePage = 'Ρυθμίσεις αρχικής σελίδας';
$langSiteTitle = 'Τίτλος πλατφόρμας';
$langSiteDescr = 'Περιγραφή αρχικής σελίδας';
$langActiveTheme = 'Ενεργό Θέμα';
$langPreviewState = 'Βρίσκετε σε κατάσταση προεπισκόπησης του θέματος';
$langThemeInstalled = 'Το θέμα εγκαταστάθηκε με επιτυχία';
$langAvailableThemes = 'Διαθέσιμα Θέματα';
$langDefaultThemeSettings = 'Open eClass Default';
$langThemeSettingsDelete = 'Είστε σίγουρος ότι θέλετε να διαγράψετε το συγκεκριμένο θέμα?';
$langThemeSettingsName = "Όνομα Θέματος";
$langGeneralSettings = 'Γενικές Ρυθμίσεις';
$langLayout = 'Layout';
$langLayoutConfig = 'Ρυθμίσεις Layout';
$langFluid = 'Fluid';
$langBoxed = 'Boxed';
$langFluidContainerWidth = 'Μέγιστο Πλάτος Επιφάνειας Εργασίας';
$langLogo = 'Λογότυπο';
$langLogoConfig = 'Ρυθμίσεις Λογότυπου';
$langLogoNormal = "(Κανονικό)";
$langLogoSmall = "(Για μικρές οθόνες)";
$langMainMenuLinkColor = "Χρώμα Συνδέσμου Ομάδας Επιλογών";
$langMainMenuConfiguration = "Ρυθμίσεις Ομάδας Επιλογών";
$langMainMenuBgColor = "Χρώμα Φόντου Ομάδας Επιλογών";
$langMainMenuLinkHoverColor = "Χρώμα Hovered Συνδέσμου Ομάδας Επιλογών";
$langMainMenuActiveLinkColor = "Χρώμα Ενεργού Συνδέσμου Ομάδας Επιλογών";
$langSubMenuConfig = "Ρυθμίσεις Επιλογών Ομάδων";
$langSubMenuLinkColor = "Χρώμα Συνδέσμου Επιλογών";
$langSubMenuLinkHoverColor = "Χρώμα Hovered Συνδέσμου Επιλογών";
$langSubMenuLinkBgHoverColor = "Χρώμα Φόντου Hovered Συνδέσμου Επιλογών";
$langSubMenuLinkBgActive = "Χρώμα Φόντου Ενεργού Συνδέσμου Επιλογών";
$langSubMenuLinkColorActive = "Χρώμα Συνδέσμου Ενεργού Συνδέσμου Επιλογών";
$langBgColor = 'Χρώμα Φόντου';
$langBorderColorLeftRight = "Χρώμα border";
$langBgColorConfig = 'Ρυθμίσεις Φόντου';
$langLinksCongiguration = 'Ρυθμίσεις Συνδέσμων';
$langBgHeaderCongiguration = "Χρώμα Φόντου";
$langBgFooterCongiguration = "Χρώμα Φόντου";
$langButtonsColorCongiguration = "Κουμπί Primary-button";
$langTextColor = "Χρώμα Κειμένου";
$langBorderTextColor = "Χρώμα border";
$langButtonsColorWhiteCongiguration = "Κουμπί Secondary-button";
$langHoverTextColor = "Χρώμα Hovered Κειμένου";
$langHoverBorderTextColor = "Χρώμα Hovered-border κουμπιου";
$langHoverWhiteColorButton = "Χρώμα Hovered Κουμπιού";
$langLinkColor = 'Χρώμα Συνδέσμων';
$langLinkHoverColor = 'Χρώμα Hovered Συνδέσμων';
$langDeleteLinkColor = "Χρώμα Συνδέσμου Διαγραφής";
$langBgImg = "Εικόνα Φόντου";
$langRepeatedImg = 'Επαναλαμβανόμενη Εικόνα';
$langStretchedImg = 'Τεντωμένη Εικόνα';
$langFixedImg = 'Σταθερή Εικόνα';
$langNavSettings = 'Σελίδα Μαθήματος';
$langSaveAs = 'Αποθήκευση ως ...';
$langLoginConfiguration = "Ρυθμίσεις Οθόνης Σύνδεσης";
$langLoginBgGradient = "Gradient φόντου";
$langLoginImg = "Εικόνα φόντου οθόνης σύνδεσης";
$langLoginBanner = "Banner αρχικής σελίδας";
$langFormLoginPlacementCenter = "Κεντρική Στοίχιση (Με αφαίρεση εικόνας σύνδεσης αν υπάρχει)";
$langFormLoginPlacementLeft = "Στοίχιση στα αριστερά (Με εικόνας σύνδεσης στο δεξί μέρος αν υπάρχει)";
$langThemeOptionsName = "Όνομα Ρυθμίσεων Θέματος";
$langLinkColorHeader = 'Χρώμα Συνδέσμων';
$langHoverLinkColorHeader = 'Χρώμα Hovered Συνδέσμων';
$langActiveLinkBgColorHeader = "Χρώμα Φόντου Ενεργού Συνδέσμου";
$langActiveLinkColorHeader = "Χρώμα Ενεργού Συνδέσμου";
$langHoveredActiveLinkColorHeader = "Χρώμα hovered ενεργού συνδέσμου";
$langLinkColorFooter = 'Χρώμα Συνδέσμων';
$langHoverLinkColorFooter = 'Χρώμα hovered συνδέσμων';
$langPortFolioProfileContainer = "Χρώμα φόντου";
$langBgColorWrapperJumbotron = "Gradient φόντου στον container της οθόνης σύνδεσης";
$langBgColorWrapperHeader= "Χρώμα φόντου στον container του Header";
$langBgColorWrapperFooter= "Χρώμα φόντου στον container του Footer";
$langFooterUploadImage = "Ανέβασμα εικόνας στο Footer";
$langShadowHeader = "Shadow στο κάτω μέρος της επικεφαλίδας";
$langTransparentBasicWrappers = "Επιλογή χρώματος transparent στο κύριο περιεχόμενο:";
$langNavContainer = "Containers";
$langNavSettingsHeader = "Header";
$langNavSettingsFooter = "Footer";
$langNavLinks = "Σύνδεσμοι";
$langNavButtons = "Κουμπί";
$langLoginConfigurationSettings = "Οθόνη Σύνδεσης";
$langHomepageContainer = "Χρώμα φόντου (<small> Ανακοινώσεις </small>)";
$langPortfolioCoursesContainer = "Χρώμα φόντου (<small>Τα μαθήματα μου, Ανακοινώσεις, Μηνύματα</small>)";
$langBgColorConfigRightColumn = "Ρυθμίσεις Φόντου (<small>Δεξιά στήλη με το περιεχόμενο του μαθήματος</small>)";
$langBgBorderLeftColor = "Χρώμα border στο αριστερό άκρο της στήλης περιοχομένου";
$langHelpCourseUI = "(<small>Αριστερή στήλη με τα εργαλεία του μαθήματος</small>)";
$langNavHyperTexts = "Τυπογραφία";
$langPHyperTextColor = "Χρώμα επικεφαλίδων - κειμένων";
$langBgPanels = "Χρώμα φόντου";
$langBgHoveredPanels = "Χρώμα hovered φόντου";
$langConcerngingPanels = "Αναφορικά με τα panels της πλατφόρμας";
$langConcerngingCommentsPanels = "Αναφορικά με τα panels - σχόλια σε ιστολόγιο και μάθημα";
$langConcerngingQuestionnairePanels = "Αναφορικά με τα panels - ερωτηματολόγια";
$langConcerngingExercisePanels = "Αναφορικά με τα panels - εμφάνιση ερωτήσεων στις ασκήσεις";
$langConcerngingReportsPanels = "Αναφορικά με τα panels - αναφορές χρηστών στις συνεδρίες";
$langPanels = "Card";
$langForms = "Φόρμες";
$langBgForms = "Χρώμα φόντου";
$langColorLabel = "Χρώμα Ετικέτας";
$langFormUploadImage = "Επιλογή εικόνας στις φόρμες";
$langAboutRegistrationImageUpload = "Φόρμα εγγραφής χρήστη";
$langAboutFaqImageUpload = "Συχνές ερωτήσεις";
$langRegistrationUploadImage = "Επιλογή εικόνας στην φόρμα εγγραφής";
$langFaqUploadImage = "Επιλογή εικόνας στις συχνές ερωτήσεις";
$langFormImg = "Επιλογή εικόνας στις φόρμες";
$langFormRegistrationImg = "Επιλογή εικόνας στην φόρμα εγγραφής";
$langfaqImg = "Επιλογή εικόνας στις συχνές ερωτήσεις";
$langTables = "Table";
$langBgTables = "Χρώμα φόντου";
$langBgBorderBottomHeadTables = "Χρώμα border στο κάτω μέρος της επικεφαλίδας (thead)";
$langBgBorderBottomRowTables = "Χρώμα border στο κάτω μέρος των γραμμών (tr)";
$langBoxShadowRowTables = "Σκιά στο κάτω μέρος των γραμμών (box shadow)";
$langTabs = "Tabs";
$langHoverTextColor = "Χρώμα Hovered Κειμένου";
$langActiveTextColor = "Χρώμα Ενεργού Κειμένου";
$langAccordions = "Accordion" ;
$langAccordionsBorderBottom = "Χρώμα border στο κάτω μέρος" ;
$langclBorderPanels = "Χρώμα border";
$langBoxShadowPanels = "Σκιά (box shadow)";
$langHoveredBoxShadowPanels = "Χρώμα hovered σκιάς (box shadow)";
$langLists = "List Group";
$langBgColorList = "Χρώμα φόντου";
$langclBorderBottomLists = "Χρώμα border στο κάτω μέρος συνδέσμου";
$langclLists = "Χρώμα συνδέσμου";
$langclHoveredLists = "Χρώμα Hovered συνδέσμου";
$langContextualMenu = "Contextual Menu";
$langContextualMenuInfo = "Αφορά το μενού επιλογών χρήστη και μαθήματος";
$langBgColorListMenu = "Χρώμα φόντου συνδέσμων επιλογών";
$langclBorderBottomListMenu = "Χρώμα border στο κάτω μέρος επιλογών";
$langclHoveredclHoveredListMenu = "Χρώμα Hovered συνδέσμων επιλογών";
$langclListMenuUsername = "Χρώμα κειμένου στο όνομα χρήστη";
$langclListMenuLogout = "Χρώμα συνδέσμου αποσύνδεσης";
$langclListMenuDeletion = "Χρώμα συνδέσμου επιλογής διαγραφής";
$langbgBorderContextualMenu = "Χρώμα border";
$langclListMenu = "Χρώμα συνδέσμου";
$langbgHoveredListMenu = "Χρώμα Hovered φόντου συνδέσμου επιλογής" ;
$langBgColorMenuCont = "Χρώμα φόντου";
$langAddPaddingListGroup = "Προσθήκη padding στη λίστα συνδέσμων";
$langAddPadding = "Προσθήκη padding";
$langButtonColorWhiteCongiguration = "Χρώμα φόντου";
$langButtonsColorDel = "Κουμπί Delete-button";
$langbgDeleteButtonColor = "Χρώμα φόντου";
$langclDeleteButtonColor = "Χρώμα κειμένου";
$langbgHoveredDeleteButtonColor = "Χρώμα hovered φόντου";
$langclHoveredDeleteButtonColor = "Χρώμα hovered κειμένου";


$langButtonsColorSuccess = "Κουμπί Save-button";
$langbgSuccessButtonColor = "Χρώμα φόντου";
$langclSuccessButtonColor = "Χρώμα κειμένου";
$langbgHoveredSuccessButtonColor = "Χρώμα hovered φόντου";
$langclHoveredSuccessButtonColor = "Χρώμα hovered κειμένου";
$langButtonsColorHelp = "Κουμπί Help-button";
$langbgHelpButtonColor = "Χρώμα φόντου";
$langclHelpButtonColor = "Χρώμα κειμένου";
$langbgHoveredHelpButtonColor = "Χρώμα hovered φόντου";
$langclHoveredHelpButtonColor = "Χρώμα hovered κειμένου";



$langBgBorderForms = "Χρώμα border φόρμας";
$langSubmitComment = "Υποβολή σχόλιου";
$langBriefProfilePortfolioTextColor = "Χρώμα κειμένων";
$langRadio = "Radio";
$langRadios = "Ρυθμίσεις radio κουμπιού";
$langBgRadios = "Χρώμα φόντου";
$langBgBorderRadios = "Χρώμα border";
$langClRadios = "Χρώμα κειμένου";
$langBgClRadios = "Χρώμα φόντου και κειμένου ενεργού radio κουμπιού";
$langClIconRadios = "Χρώμα icon ενεργού radio κουμπιού";
$langClInactiveRadios = "Χρώμα κειμένου ανενεργού radio κουμπιού";
$langCheckbox = "Checkboxes";
$langCheckboxes = "Ρυθμίσεις checkbox κουμπιού";
$langBgCheckboxes = "Χρώμα φόντου";
$langBgBorderCheckboxes = "Χρώμα border";
$langClCheckboxes = "Χρώμα κειμένου" ;
$langBgActiveCheckboxes = "Χρώμα φόντου ενεργού checkbox";
$langClActiveCheckboxes = "Χρώμα κειμένου ενεργού checkbox";
$langClIconCheckboxes = "Χρώμα icon ενεργού checkbox";
$langClInactiveCheckboxes = "Χρώμα κειμένου ανενεργού checkbox";
$langInputText = "Input-TextArea";
$langBgInput = "Χρώμα φόντου";
$langclBorderInput = "Χρώμα border";
$langclInputText = "Χρώμα κειμένου";
$langSelectOption = "Select";
$langSettingSelect = "Ρυθμίσεις επιλογής";
$langBgSelect = "Χρώμα φόντου";
$langclBorderSelect = "Χρώμα border";
$langclOptionSelect = "Χρώμα κειμένου";
$langbgHoveredSelectOption = "Χρώμα hovered φόντου επιλογής";
$langclHoveredSelectOption = "Χρώμα hovered κειμένου επιλογής";
$langbgOptionSelected = "Χρώμα φόντου ενεργής επιλογής";
$langclOptionSelected = "Χρώμα κειμένου ενεργής επιλογής";
$langModals = "Modal";
$langSettingModals = "Ρυθμίσεις Modal";
$langBgModal = "Χρώμα φόντου";
$langclBorderModal = "Χρώμα border";
$langclTextModal = "Χρώμα κειμένων";
$langclDeleteIconModal = "Χρώμα εικονιδίου διαγραφής";
$langclXmarkModal = "Χρώμα εικονιδίου (κλείσιμο modal)";
$langNavBody = "Body";
$langNavSettingsAgenda = "Agenda";
$langAgendaSettings = "Ρυθμίσεις στα ημερολόγια";
$langBgColorAgenda = "Χρώμα φόντου";
$langBgBorderColorAgenda = "Χρώμα border";
$langBgBorderColorAgendaEvent = "Χρώμα border στα slots (ημερολόγιο γεγονότων και κρατήσεων)";
$langBgColorHeaderAgenda = "Χρώμα φόντου επικεφαλίδας ημερολογίου";
$langclColorHeaderAgenda = "Χρώμα κειμένων επικεφαλίδας ημερολογίου";
$langclColorBodyAgenda = "Χρώμα κειμένων (ημέρες, ώρες, λεπτά)";
$langbgColorHoveredBodyAgenda = "Χρώμα hovered φόντου (ημέρες, ώρες, λεπτά)";
$langclColorHoveredBodyAgenda = "Χρώμα hovered κειμένου (ημέρες, ώρες, λεπτά)";
$langbgColorActiveDateTime = "Χρώμα φόντου ενεργού slot (μικρό ημερολόγιο)";
$langbgColorDeactiveDateTime = "Χρώμα φόντου ανενεργού slot (μικρό ημερολόγιο)";
$langtextColorActiveDateTime = "Χρώμα κειμένου ενεργού slot(μικρό ημερολόγιο)";
$langMPopover = "Menu Popover";
$langMenuPopover = "Ρυθμίσεις Menu Popover";
$langBgMenuPopover = "Χρώμα φόντου";
$langBgBorderMenuPopover = "Χρώμα border";
$langBgMenuPopoverOption = "Χρώμα φόντου μενού επιλογών";
$langclMenuPopoverOption = "Χρώμα κειμένου συνδέσμου επιλογής";
$langclBorderBottomMenuPopoverOption = "Χρώμα border στο κάτω μέρος του συνδέσμου επιλογής";
$langBgHoveredMenuPopoverOption = "Χρώμα Hovered φόντου συνδέσμου επιλογών";
$langclHoveredMenuPopoverOption = "Χρώμα Hovered κειμένου συνδέσμου επιλογών";
$langclDeleteMenuPopoverOption = "Χρώμα συνδέσμου επιλογής διαγραφής";
$langInputTextEditor = "Συντάκτης Κειμένου";
$langBgTextEditor = "Χρώμα φόντου";
$langBgBorderTextEditor = "Χρώμα border";
$langClTextEditor = "Χρώμα εργαλείων";
$langNavSettingsScrollBar = "ScrollBar";
$langSettingsScrollBar = "Ρυθμίσεις ScrollBar";
$langNavSettingsBadges = "Badge";
$BgScrollBar = "Χρώμα φόντου";
$langBgColorScrollBar = "Χρώμα φόντου μπάρας";
$langBgHoveredColorScrollBar = "Χρώμα hovered φόντου μπάρας";
$langNavMoreOptions = "Περισσότερες επιλογές";
$langContainerBgColor = "Χρώμα φόντου";
$langBorderContainerBgColor = "Χρώμα border";
$langAboutChatContainer = "Ρυθμίσεις περιεχομένου στην συνομιλία του μαθήματος";
$langAboutCourseInfoContainer = "Ρυθμίσεις περιεχομένου στην παρουσίαση/προβολή του μαθήματος";
$langAboutUnitsContainer = "Ρυθμίσεις περιεχομένου στις θεματικές ενότητες του μαθήματος";
$langNavSettingsProgressBar = "ProgressBar";
$langInfoProgressBar = "Θα πρέπει να συμπληρωθούν και οι τρεις επιλογές ώστε να αλλάξει το progress bar";
$langSettingsProgressBar = "Ρυθμίσεις ProgressBar";
$langBackProgressBar = "Χρώμα φόντου στο πίσω μέρος του κειμένου της μπάρας";
$langBgProgressBar = "Χρώμα φόντου μπάρας (όχι γεμισμένη)";
$langBgColorProgressBarAndText = "Χρώμα φόντου μπάρας και χρώμα κειμένου (γεμισμένη μπάρα)";
$langNavSettingsTooltip = "Tooltip";
$langNavSettingsAlert = "Alert";
$langSettingsAlertInfo = "Ρυθμίσεις Alert-info";
$langSettingsAlertWarning = "Ρυθμίσεις Alert-Warning";
$langSettingsAlertSuccess = "Ρυθμίσεις Alert-Success";
$langSettingsAlertDanger = "Ρυθμίσεις Alert-Danger";
$langSettingsTooltip = "Ρυθμίσεις Tooltip";
$langbgColorTooltip = "Χρώμα φόντου";
$langTextColorTooltip = "Χρώμα κειμένου";
$langBgColorListItem = "Χρώμα φόντου λίστας";
$langBgBorderColorListItem = "Χρώμα border στο κάτω μέρος της λίστας";

/* * ***********************************************************
 * Validation
 * ************************************************************ */
$langTheField = 'Το πεδίο';
$langTheFieldIsRequired = 'Το πεδίο είναι απαραίτητο.';
$langFormErrors = 'Η φόρμα περιέχει λάθη. Παρακαλώ διορθώστε τα και επανυποβάλετε την φόρμα.';

/* * ***********************************************************
 * Other
 * ************************************************************ */
$langMoreOptions = 'Περισσότερες επιλογές';
$langLessOptions = 'Λιγότερες επιλογές';
$langMyCoursesSide = "Τα $langsCourses μου";
$langMyMessagesSide = 'Τα μηνύματα μου';
$langNewMyMessagesSide = 'Νέα Μηνύματα';
$langQuickNotesSide = 'Γρήγορη σημείωση';
$langNotesNotifications = "Ειδοποιήσεις";
$langNumOpenCoursesBanner = "ανοικτά<br>$langsCourses";
$langNumOpenCourseBanner = "ανοικτό<br>$langsCourse";
$langDropboxNumUnreadMessages = "Μη αναγνωσμένα μηνύματα";
$langNationalOpenCourses = "Εθνική Πύλη Ανοικτών Μαθημάτων";
$langExtAppName = "Εφαρμογή";
$langClearSettings = "Καθαρισμός Ρυθμίσεων";
$langNotConfigured = 'Δεν έχει ρυθμιστεί';
$langEnableAfterConfig = 'Για να ενεργοποιήσετε αυτό το εργαλείο θα πρέπει πρώτα να εισάγετε τις απαιτούμενες ρυθμίσεις.';
$langUnknownSetting = 'Άγνωστη ρύθμιση';
$langAPITokenExists = "Έχει δημιουργηθεί ήδη ένα token. Αν θέλετε να δημιουργήσετε νέο, κάντε κλικ στο 'Δημιουργία νέου token'";
$langAPITokenShortDesc = "Δημιουργία token για χρήση του eClass API.";
$langAPITokenLongDesc = "Λεπτομέρειες σχετικά με τις υποστηριζόμενες κλήσεις του API μπορείτε να βρείτε
<a href='https://docs.openeclass.org/el/developers/eclass_api' target='_blank' aria-label='Open Eclass api - (opens in a new tab)'>εδώ</a>.";
$langCreateAPIToken = 'Δημιουργία νέου Token';
$langAPITokenCreated = "Το token δημιουργήθηκε. Αντιγράψτε το έτσι ώστε να το χρησιμοποιήσετε στην εφαρμογή σας.";
$langAPITokenAccess = 'Πρόσβαση μέσω του API';
$langAPITokenIP = 'Εισαγάγετε μία ή περισσότερες διευθύνσεις IP ή υποδίκτυα σε μορφή CIDR χωρισμένα με κενά.';

$langExtAppAll = "Όλα";
$langExtAppGeneral = "Γενικά εργαλεία";
$langExtAppTeleconference = "Εργαλεία Τηλεδιάσκεψης";
$langExtAppCloud = "Εργαλεία αποθήκευσης αρχείων";
$langExtAppOther = "Διάφορα εργαλεία";

/* * ***********************************************************
 * Auto Judge
 * ************************************************************ */
//auto_judge.php
$langauto_judge = 'Ρυθμίσεις Αυτόματου Κριτή';
$langHackerEarth = "Κλειδί HackerEarth";
$langAutoJudge = "Ρυθμίσεις αυτόματου κριτή του $siteName";
$langAutoJudgeSupportedLanguages = 'Υποστηριζόμενες Γλώσσες';
$langAutoJudgeSupportsInput = 'Υποστηρίζει μεταβλητά δεδομένα εισόδου';
$langAutoJudgeInputNotSupported = 'Δεν υποστηρίζεται από υπηρεσία μεταγλώττισης';
$langAutoJudgeConnector = "Επιθυμητή υπηρεσία μεταγλώττισης";
$langAutoJudgeUpdated = "Οι ρυθμίσεις αυτόματου κριτή ενημερώθηκαν με επιτυχία";

//antivirus.php
$langAntivirus = "Ρυθμίσεις λογισμικού προστασίας έναντι ιών του $siteName";
$langAntivirusUpdated = "Οι ρυθμίσεις του λογισμικού προστασίας έναντι ιών ενημερώθηκαν με επιτυχία";
$langAntivirusConnector = "Εγκατεστημένο Λογισμικό";
$langAntivirusPath = "Θέση Λογισμικού";
$langAntivirusConfig = "Ρυθμίσεις Λογισμικού";
$langAntivirusInfected = "Το αρχείο αυτό δεν έγινε αποδεκτό, καθώς φαίνεται να είναι μολυσμένο. Παρακαλώ επικοινωνήστε με το διαχειριστή.";

//waf.php
$langWaf = "Ρυθμίσεις τείχους προστασίας εφαρμογής ιστού του $siteName";
$langWafConnector = "Τείχος προστασίας";
$langWafUpdated = "Οι ρυθμίσεις του λογισμικού τείχους προστασίας εφαρμογής ιστού ενημερώθηκαν με επιτυχία";
$langWafConfig = "Ρυθμίσεις Φίλτρου";

//SFA

$langSFAConf = 'Ρύθμιση 2FA:';
$langSFAType = 'Συνθηματικό 2FA:';
$langSFAInsert = 'Εναλλακτικά, εισάγετε τον παρακάτω στην εφαρμογή 2FA:';
$langSFAusage = 'Για να χρησιμοποιηθεί το Second Factor Authentication, ο χρήστης που το ενεργοποιεί απο το προφίλ του θα πρέπει να εγκαταστήσει ένα app τύπου Google Authenticator, απο αυτά που είναι διαθέσιμα:';
$langsecondfaDescription = 'Οι περισσότεροι χρήστες χρησιμοποιούν μόνο ένα επίπεδο ασφάλειας για το λογαριασμό τους, τον κωδικό πρόσβασής τους. Με την επαλήθευση σε 2 βήματα, θα προστατεύσετε το λογαριασμό σας με κάτι που γνωρίζετε (τον κωδικό πρόσβασής σας) και κάτι που έχετε στην κατοχή σας (το τηλέφωνο ή το κλειδί ασφαλείας σας)';
$langSFAfail = 'Λάθος Απάντηση 2FA';
$langSFAremove = 'Απενεργοποίησε 2FA';
$langSFAkeep = 'Διατήρησε 2FA';
$langSFAadd = 'Ενεργοποίησε 2FA';
$langSFATypeWYS = 'Πληκτρολογήστε τον κωδικό που εμφανίζει η εφαρμογή 2FA:';
$langSFAScan = 'Σαρώστε την παρακάτω εικόνα με την εφαρμογή 2FA:';
$langsecondfaUpdated = 'Οι ρυθμίσεις του λογισμικού 2FA ενημερώθηκαν με επιτυχία';

// scenarios edit
$langAutoJudgeEnable = 'Αυτόματος Κριτής';
$langAutoJudgeInput = 'Είσοδος';
$langAutoJudgeOutput = 'Έξοδος';
$langAutoJudgeExpectedOutput = 'Αναμενόμενη έξοδος';
$langOperator = 'Τελεστής';
$langAutoJudgeWeight = 'Βαθμοί';
$langAutoJudgeProgrammingLanguage = 'Γλώσσα Προγραμματισμού';
$langAutoJudgeResult = 'Αποτέλεσμα';

// messages & misc
$langAutoJudgeEmptyFile = "Το αρχείο που επιχειρείτε να ανεβάσετε είναι κενό. Η εργασία δεν υποβλήθηκε.";
$langAutoJudgeInvalidFileType = "Εσφαλμένος τύπος αρχείου. Αναμενόμενος: %s, Δόθηκε: %s";
$langAutoJudgeSum = 'Άθροισμα';
$langAutoJudgeNewScenario = 'Νέο σενάριο';
$langAutoJudgeShowWorkResultRpt = 'Προβολή αναφοράς αποτελεσμάτων';
$langAutoJudgeRank = 'Κατάταξη';
$langAutoJudgeScenariosPassed = 'Περασμένα Σενάρια';

// asserts
$langAutoJudgeAssertions = array(
    "eq" => "είναι ίσο με",
    "same" => "είναι ίδιο με",
    "notEq" => "δεν είναι ίσο με",
    "notSame" => "δεν είναι ίδιο με",
    "integer" => "είναι ακέραιος",
    "float" => "είναι δεκαδικός",
    "digit" => "είναι ψηφίο",
    "boolean" => "είναι boolean",
    "notEmpty" => "δεν είναι κενό",
    "notNull" => "δεν είναι Null",
    "string" => "είναι string",
    "startsWith" => "αρχίζει με",
    "endsWith" => "τελειώνει με",
    "contains" => "περιέχει",
    "numeric" => "είναι αριθμητικό",
    "isArray" => "είναι array",
    "true" => "είναι true",
    "false" => "είναι false",
    "isJsonString" => "είναι JSON string ",
    "isObject" => "είναι αντικείμενο",
);

// result report
$langAutoJudgeDetailedReport = 'Αυτόματος κριτής: Αναλυτική αναφορά';
$langAutoJudgeResultsFor = 'Αποτελέσματα για';
$langAutoJudgeNotEnabledForReport = 'Ο αυτόματος κριτής δεν είναι ενεργοποιημένος για την συγκεκριμένη εργασία.';
$langAutoJudgeDownloadPdf = 'Λήψη σε μορφή PDF';
$langAutoJudgeConnectionError = "Σφάλμα σύνδεσης με την υπηρεσία μεταγλώττισης. Παρακαλούμε αναφέρατε το σφάλμα στη διεύθυνση dnna@dnna.gr";

// Tags
$langTag = 'Ετικέτα';
$langTags = 'Ετικέτες';
$langTagNotFound = 'Η ετικέτα δεν αντιστοιχεί σε κανέναν πόρο.';

// Messages for external tools
$langAnalyticsDescription = '<p>Μπορείτε να συνδέσετε την πλατφόρμα με κάποια
    εξωτερική υπηρεσία ανάλυσης επισκέψεων (Web Analytics, π.χ. Google
    Analytics, Piwik) προκειμένου να διατηρούνται αναλυτικά στατιστικά
    για τους επισκέπτες.</p>';
$langUserWayShortDescription = "<p>Επιλογές προσβασιμότητας μέσω της υπηρεσίας UserWay. Δείτε περισσότερες πληροφορίες στο <a href='https://userway.org/'>https://userway.org/</a></p>";
$langUserWayLongDescription = "<p>Επιλογές προσβασιμότητας μέσω της υπηρεσίας UserWay. Δείτε περισσότερες πληροφορίες στο <a href='https://userway.org/'>https://userway.org/</a></p>";
$langOpenDelosDescription = "<p>Το OpenDelos είναι η πλατφόρμα ανοικτού λογισμικού που σχεδιάζει το GUNET για τη Διαχείριση, Καταγραφή και Μετάδοση Βιντεοδιαλέξεων.</p>
<p>Η πλατφόρμα υποστηρίζει τη δράση <a href='http://ocw-project.gunet.gr/'>Ανοικτών Ακαδημαϊκών $langOfCourses</a> σε συνδυασμό με την <a href='http://openeclass.org/'>πλατφόρμα Open eClass</a> και την εθνική πύλη αναζήτησης $langsOfCourses που επίσης αναπτύσσει το GUNET.</p>";
$langBBBDescription = "Το ανοικτό λογισμικό <a href=\"https://www.bigbluebutton.org/\" target=\"_blank\">BigBlueButton</a> αποτελεί  ένα πλήρες σύστημα άμεσης web-based επικοινωνίας και συνεργασίας $langsOfTeachers και $langsOfStudents.</p>
<p>Δεν απαιτείται εγκατάσταση πρόσθετου υλικού (Software ή Hardware) και εκτελείται απευθείας από τον πλοηγό διαδικτύου (Internet Explorer, Firefox, Chrome, Safari, κ.α)r. Για τη σύνδεση του Open eClass με μία εγκατεστημένη πλατφόρμα BigBlueButton επιλέξτε <a href=\"bbbmoduleconf.php\">Ρυθμίσεις</a>.</p>";
$langBBBLongDescription = "Σύνδεση με την υπηρεσία τηλεδιάσκεψης BigBlueButton.";
$langAutojudgeDescription = "<p>Ο αυτόματος κριτής είναι ένα εργαλείο που επιτρέπει την αυτόματη διόρθωση προγραμματιστικών εργασιών. Πιο συγκεκριμένα, μέσω του εργαλείου ο καθηγητής μπορεί να ορίσει σενάρια που περιλαμβάνουν input και output βάσει των οποίων οι αναρτώμενες εργασίες βαθμολογούνται αυτόματα.</p><p>Το συγκεκριμένο υποσύστημα συνδέεται με τρίτες υπηρεσίες μεταγλώττισης οι οποίες μπορούν να επιλεχθούν στις <a href=\"autojudgemoduleconf.php\">Ρυθμίσεις</a>.</p>";
$langFtpShortDescription = "Σύνδεση με υπηρεσία FTP";
$langFtpLongDescription = "Πληκτρολογήστε το σύνδεσμο FTP";
$langGoogleDriveShortDescription = "Υποστήριξη λειτουργίας κατεβάσματος αρχείων από το Google Drive.";
$langGoogleDriveLongDescription = "Long description about google drive";
$langOneDriveShortDescription = "Υποστήριξη λειτουργίας κατεβάσματος αρχείων από το One Drive.";
$langOneDriveLongDescription = "Long description about one drive";
$langDropboxShortDescription = "Υποστήριξη λειτουργίας κατεβάσματος αρχείων από το Dropbox.";
$langDropboxLongDescription = "Long description about dropbox";
$langOwnCloudShortDescription = "Υποστήριξη λειτουργίας κατεβάσματος αρχείων από το Own Cloud.";
$langOwnCloudLongDescription = "Long description about own cloud";
$langWebDAVShortDescription = "Υποστήριξη λειτουργίας κατεβάσματος αρχείων μέσω WebDav.";
$langWebDAVLongDescription = "Long Description about web dav";
$langAntivirusDescription = "<p>Σύνδεση με εγκατεστημένο λογισμικό προστασίας έναντι ιών</p>";
$langWafDescription = "<p>Ενεργοποίηση τείχους προστασίας εφαρμογής ιστού</p>";
$langOpenMeetingsDescription = "<p>Το υποσύστημα <strong>Τηλεσυνεργασίας</strong> της πλατφόρμας Open eClass υποστηρίζεται λειτουργικά από το ανοικτό λογισμικό <a href=\"http://openmeetings.apache.org/\" target=\"_blank\">Apache OpenMeetings</a> το οποίο αποτελεί  ένα πλήρες σύστημα άμεσης web-based επικοινωνίας και συνεργασίας $langsOfTeachers και $langsOfStudents.</p>
<p>Το OpenMeetings ανήκει στις εφαρμογές τηλεδιάσκεψης / σύγχρονης τηλεκπαίδευσης που δεν απαιτούν την εγκατάσταση πρόσθετου υλικού (Software ή Hardware). Η εφαρμογή εκτελείται απευθείας από τον πλοηγό διαδικτύου (Internet Explorer, Firefox, Chrome, Safari, κ.α) με χρήση του Adobe Flash Player. Για τη σύνδεση του Open eClass με μία εγκατεστημένη πλατφόρμα OpenMeetings επιλέξτε <a href=\"openmeetingsconf.php\">Ρυθμίσεις</a>.</p>";
$langUnplagShortDescription = "Σύνδεση με υπηρεσία ελέγχου λογοκλοπής (plagiarism). Η υπηρεσία ελέγχου λογοκλοπής είναι εμπορικό προϊόν και προσφέρεται από την εταιρεία Unicheck (πρώην Unplag). Δείτε περισσότερες πληροφορίες στο <a href=\"https://unicheck.com\">https://unicheck.com</a>";
$langUnplagLongDescription = "Σύνδεση με υπηρεσία ελέγχου λογοκλοπής.";
$langTurnitinShortDescription = "Σύνδεση με υπηρεσία λογοκλοπής (plagiarism).
Η υπηρεσία ελέγχου λογοκλοπής είναι εμπορικό προϊόν και προσφέρεται από την εταιρεία Turnitin.
Δείτε περισσότερες πληροφορίες στο <a href=\"https://turnitin.com\">https://turnitin.com</a>";
$langLimesurveyShortDescription = "Σύνδεση με υπηρεσία στατιστικής έρευνας (survey).
Η υπηρεσία στατιστικής έρευνας είναι εμπορικό προϊόν και προσφέρεται από την εταιρεία LimeSurvey GmbH.
Δείτε περισσότερες πληροφορίες στο <a href=\"https://www.limesurvey.org\">https://www.limesurvey.org</a>";
$langLimesurveyLongDescription = "Σύνδεση με υπηρεσία στατιστικής έρευνας.";
$langPanoptoShortDescription = "Σύνδεση με υπηρεσία διαχείρισης βίντεο.
Η υπηρεσία βίντεο είναι εμπορικό προϊόν και προσφέρεται από την εταιρεία Panopto Inc.
Δείτε περισσότερες πληροφορίες στο <a href=\"https://www.panopto.com\">https://www.panopto.com</a>";
$langPanoptoLongDescription = "Σύνδεση με υπηρεσία διαχείρισης βίντεο.";
$langColmoocDescription = 'Διασύνδεση με τα υποσυστήματα Conversational Agent και Learning Analytics του έργου <a href="https://colmooc.eu/">colMOOC</a>.';
$langH5PShortDescription = "Διαδραστικό περιεχόμενου τύπου H5P";
$langH5PLongDescription = "Διαδραστικό περιεχόμενου τύπου H5P";
$langLtiPublishShortDescription = "Δημοσίευση $langsOfCourses μεσω πρωτοκόλλου LTI.";
$langLtiPublishLongDescription = "Δημοσίευση $langsOfCourses μεσω πρωτοκόλλου LTI.";
$langLtiPublishFrameAncestorsTooltip = "Λίστα urls χωριζομενη με κόμματα πχ https://url1, https://url2";
$langGoogleMeetShortDescription = "Σύνδεση με την υπηρεσία τηλεδιάσκεψης Google Meet.";
$langGoogleMeetLongDescription = "Σύνδεση με την υπηρεσία τηλεδιάσκεψης Google Meet.";
$langMsTeamsShortDescription = "Σύνδεση με την υπηρεσία τηλεδιάσκεψης Microsoft Teams.";
$langMsTeamsLongDescription = "Σύνδεση με την υπηρεσία τηλεδιάσκεψης Microsoft Teams.";
$langAIShortDescription = "Υπηρεσία Τ.Ν.";
$langAILongDescription = "Υπηρεσία Τ.Ν.";
$langZoomShortDescription = "Σύνδεση με την υπηρεσία τηλεδιάσκεψης Zoom.";
$langZoomLongDescription = "Σύνδεση με την υπηρεσία τηλεδιάσκεψης Zoom.";
$langWebexShortDescription = "Σύνδεση με την υπηρεσία τηλεδιάσκεψης Webex.";
$langWebexLongDescription = "Σύνδεση με την υπηρεσία τηλεδιάσκεψης Webex.";
$langJitsiShortDescription = "Το ανοικτό λογισμικό <a href=\"https://jitsi.org/\" target=\"_blank\">Jitsi</a> αποτελεί μια υπηρεσία τηλεδιάσκεψης. Κάντε κλικ στις <a href=\"jitsiconf.php\">Ρυθμίσεις</a> για να την ενεργοποιήσετε. Σημειώστε ότι η υπηρεσία προτείνεται για τηλεδιασκέψεις μέχρι 30 άτομα.";
$langJitsiLongDescription = "Σύνδεση με την υπηρεσία τηλεδιάσκεψης <em>Jitsi</em> (μέχρι <strong>30</strong> άτομα).";
$langJitsiUrl = "Μπορείτε να το αλλάξετε αν θέλετε να χρησιμοποιήσετε κάποιον διαφορετικό Jitsi server.";
$langSolrShortDescription = "Το ανοικτό λογισμικό <a href=\"https://solr.apache.org/\" target=\"_blank\">Solr</a> αποτελεί μια πλατφόρμα αναζήτησης. Κάντε κλικ στις <a href=\"solrconf.php\">Ρυθμίσεις</a> για να την ενεργοποιήσετε.";
$langSolrLongDescription = "Σύνδεση με την πλατφόρμα αναζήτησης <em>Solr</em>.";
$langSolrUrl = "Μπορείτε να το αλλάξετε για να δείχνει στη σωστή διεύθυνση της εγκατάστασης Solr.";
$langWebexUrl = "Μπορείτε να το αλλάξετε αν θέλετε να χρησιμοποιήσετε κάποιον διαφορετικό WebEx server.";
$langZoomUrl = "Μπορείτε να το αλλάξετε αν θέλετε να χρησιμοποιήσετε κάποιον διαφορετικό Zoom server.";
$langChooseTCServer = "Επιλογή υπηρεσίας Τηλεσυνεργασίας";
$langGoToGoogleMeetLink = "Κάντε κλικ στο 'Μετάβαση στο Google Meet' παρακάτω, για να μεταφερθείτε στο περιβάλλον της Google έτσι ώστε να δημιουργήσετε το σύνδεσμο της τηλεσυνεργασίας.
    Αφού τον δημιουργήσετε, αντιγράψτε τον και επικολλήστε τον στο πεδίο 'Σύνδεσμος'";
$langGoToGoogleMeetLinkText = "Μετάβαση στο Google Meet";
$langGoToZoomLink = "Κάντε κλικ στο 'Μετάβαση στο Zoom' παρακάτω, για να μεταφερθείτε στο περιβάλλον του Zoom έτσι ώστε να δημιουργήσετε το σύνδεσμο της τηλεσυνεργασίας.
    Αφού τον δημιουργήσετε, αντιγράψτε τον και επικολλήστε τον στο πεδίο 'Σύνδεσμος'";
$langGoToWebexLink = "Κάντε κλικ στο 'Μετάβαση στο Webex' παρακάτω, για να μεταφερθείτε στο περιβάλλον του Webex έτσι ώστε να δημιουργήσετε το σύνδεσμο της τηλεσυνεργασίας.
    Αφού τον δημιουργήσετε, αντιγράψτε τον και επικολλήστε τον στο πεδίο 'Σύνδεσμος'";
$langGoToMicrosoftTeamsLink = "Κάντε κλικ στο 'Μετάβαση στο Microsoft Teams' παρακάτω, για να μεταφερθείτε στο περιβάλλον της Microsoft έτσι ώστε να δημιουργήσετε το σύνδεσμο της τηλεσυνεργασίας.
    Αφού τον δημιουργήσετε, αντιγράψτε τον και επικολλήστε τον στο πεδίο 'Σύνδεσμος'";
$langGoToMicrosoftTeamsLinkText = "Μετάβαση στο Microsoft Teams";
$langGoToZoomLinkText = "Μετάβαση στο Zoom";
$langGoToWebexLinkText = "Μετάβαση στο Webex";

// Messages for OpenMeetings
$langOpenMeetingsConf = "Ρυθμίσεις \"OpenMeetings\" του $siteName";
$langAddOpenMeetingsServerInfo = "Στοιχεία νέου εξυπηρετητή OpenMeetings";
$langUpdateOpenMeetingsServer = "Στοιχεία εξυπηρετητή OpenMeetings";
$langAvailableOpenMeetingsServers = "Διαθέσιμοι εξυπηρετητές OpenMeetings";
$langOpenMeetingsServer = "Όνομα του εξυπηρετητή";
$langPort = "Πόρτα";
$langOpenMeetingsAdminUser ="Username διαχειριστή OpenMeetings";
$langOpenMeetingsAdminPass ="Password διαχειριστή OpenMeetings";
$langOpenMeetingsModuleKey = "Module key";
$langOpenMeetingsWebApp = "Όνομα WebApp";

// Mindmap
$langMindmap = "Νοητικός χάρτης";
$langScreenshot = "Στιγμιότυπο οθόνης";
$langOpenEx = "Άνοιγμα παραδείγματος";
$langEditEn = "Ενεργοποίηση τροποποίησης";
$langEditDis = "Απενεργοποίηση τροποποίησης";
$langAddNode = "Προσθήκη κόμβου";
$langRemoveNode = "Αφαίρεση κόμβου";
$langResetMap = "Καθαρισμός χάρτη";
$langSaveFile = "Αποθήκευση αρχείου";
$langSaveInDoc = "Αποθήκευση στα έγγραφα";
$langOpenFile = "άνοιγμα αρχείου";
$langEditMind = "Τροποποίηση";
$langToggle = "Εναλλαγή";
$langOpenMind = "Άνοιγμα";
$langPleaseSelectNode = "Παρακαλώ επιλέξτε ένα κόμβο.";
$langPlzClickNode = "Προσπαθήστε να κάνετε κλικ σε ένα κόμβο";
$langPlzDblClickNode = "Προσπαθήστε να κάνετε διπλό κλικ σε ένα κόμβο";
$langPleaseChooseFile = "Παρακαλώ επιλέξτε αρχείο";
$langThemeDefault = "Προεπιλογή";
$langThemePrimary = "Βασικό";
$langThemeDanger = "Κίνδυνος";
$langThemeSuccess = "Επιτυχία";
$langThemeGreenSea = "Βεραμάν";
$langThemeOrange = "Πορτοκαλί";
$langThemePumpkin = "Κολοκύθα";
$langThemePomegranate = "Ρόδι";
$langThemeClouds = "Σύννεφα";
$langPleaseEnterName = "Παρακαλώ εισάγετε όνομα";
$langMindMapSaved = "Ο νοητικός χάρτης αποθηκεύθηκε";


/* * *********************************************
 * coursecategory.php
 * ********************************************* */
$langCourseCategoryActions = "Κατηγορίες Μεταδεδομένων";
$langCourseCategoryDel = "Διαγραφή κατηγορίας";
$langCourseCategoryEdit = "Επεξεργασία κατηγορίας";
$langAllCourseCategories = "Κατηγορίες Μεταδεδομένων";
$langCourseCategoryProErase = "Υπάρχουν τιμές που ανήκουν σε αυτή την κατηγορία μεταδεδομένων";
$langCourseCategoryNoErase = "Η διαγραφή της κατηγορίας μεταδεδομένων δεν είναι δυνατή.";
$langCourseCategoryErase = "Η κατηγορία μεταδεδομένων διαγράφηκε";
$langEditCourseCategorySuccess = "Η επεξεργασία πραγματοποιήθηκε επιτυχώς";
$langCourseCategory2 = "(π.χ. Μέγεθος Ομάδας)";
$langCourseCategoryMultiple = "Πολλαπλότητα";
$langCourseCategoryMultiple2 = "Η κατηγορία μεταδεδομένων θα έχει πολλαπλές τιμές";
$langCourseCategorySearchable = "Αναζητήσιμη";
$langCourseCategorySearchable2 = "Η κατηγορία μεταδεδομένων θα συμμετέχει στην ειδική εργαλειοθήκη αναζήτησης";
$langCourseCategoryActive2 = "Η κατηγορία μεταδεδομένων θα εμφανίζεται στους χρήστες";
$langCourseCategoryOrdering2 = "(π.χ. 1, 2, κ.ο.κ.)";
$langEditCourseCategoryValues = "Επεξεργασία τιμών";
$langCourseCategoryValues = "Τιμές Κατηγοριών Μεταδεδομένων";
$langCourseCategoryValueAdd = "Προσθήκη τιμής κατηγορίας";
$langCourseCategoryValueDel = "Διαγραφή τιμής κατηγορίας";
$langCourseCategoryValueEdit = "Επεξεργασία τιμής κατηγορίας";
$langAllCourseCategoryValues = "Τιμές Κατηγοριών Μεταδεδομένων";
$langCourseCategoryValueErase = "Η τιμή της κατηγορίας μεταδεδομένων διαγράφηκε";
$langEditCourseCategoryValueSuccess = "Η επεξεργασία πραγματοποιήθηκε επιτυχώς";
$langCourseCategoryValue2 = "(π.χ. 1 - 30)";
$langCourseCategoryValueOrdering2 = "(π.χ. 1, 2, κ.ο.κ.)";
$langCourseCategoryValueActive2 = "Η τιμή κατηγορίας μεταδεδομένων θα εμφανίζεται στους χρήστες";
$langInactiveCourseCategories = "Ανενεργές κατηγορίες";
$langActiveCourseCategories = "Ενεργές κατηγορίες";

// Course Prerequisites
$langCoursePrerequisites = "Προαπαιτούμενα";
$langNewCoursePrerequisite = "Προσθήκη Προαπαιτούμενου";
$langNoCoursePrerequisites = "Δεν υπάρχουν προαπαιτούμενα";
$langRemovePrerequisite = "Διαγραφή Προαπαιτούμενου";
$langDelWarnCoursePrerequisite = "Επιβεβαίωση διαγραφής προαπαιτούμενου";
$langNewCoursePrerequisiteSuccess = "Το προαπαιτούμενο δημιουργήθηκε με επιτυχία!";
$langDelCoursePrerequisiteSuccess = "Το προαπαιτούμενο διαγράφηκε με επιτυχία!";
$langNewCoursePrerequisiteHelp2 = "Για να προστεθεί ένα $langsCourse ως προαπαιτούμενο, θα πρέπει να διαθέτει Επιβράβευση Ολοκλήρωσης μαθήματος.";
$langNewCoursePrerequisiteFailInvalid = "Αδυναμία προσθήκης, παρακαλούμε επιλέξτε ένα έγκυρο $langsCourse.";
$langNewCoursePrerequisiteFailSelf = "Αδυναμία προσθήκης, το $langsCourse σας δεν μπορεί να επιλεχθεί ως προαπαιτούμενο του εαυτού του.";
$langNewCoursePrerequisiteFailAlreadyIn = "Αδυναμία προσθήκης, το $langsCourse που επιλέξατε υπάρχει ήδη στη λίστα με τα προαπαιτούμενα.";
$langNewCoursePrerequisiteFailBadgeMissing = "Αδυναμία προσθήκης, το $langsCourse που επιλέξατε δεν έχει ενεργοποιημένη την Ολοκλήρωσης μαθήματος.";
$langPrerequisitesNotComplete = "Τα προαπαιτούμενα $langsCourses για εγγραφή δεν έχουν ολοκληρωθεί";

// Messages for Lti Consumer
$langLtiConsumer = "Εξωτερικές εφαρμογές LTI";
$langLtiPublishTool = "Δημοσίευση ως εργαλείο LTI";
$langNewLTITool = "Προσθήκη νέας εφαρμογής LTI";
$langNewTIITool = "Προσθήκη νέας εφαρμογής TurnItIn (LTI)";
$langLTIProviderUrl = "LTI Provider URL";
$langLTIProviderKey = "LTI Provider Key";
$langLTIProviderSecret = "LTI Provider Secret";
$langLTIProviderCartridgeUrl = "LTI Cartridge URL";
$langLTIProviderHelp1 = "Εφόσον η απομακρυσμένη πλατφόρμα το υποστηρίζει, μπορείτε να εισάγετε το <b>Cartridge URL</b> και να επιλέξετε <b>Προσθήκη Legacy LTI</b>, στη συνέχεια θα σας ζητηθεί αυτόματα να εισάγετε το <b>Key</b> και το <b>Secret</b>, δε θα χρειαστείτε το Provider URL καθώς θα εισαχθεί αυτόματα.";
$langLTIProviderHelp2 = "Σε αντίθετη περίπτωση, στην απομακρυσμένη πλατφόρμα θα πρέπει να επιλέξετε τη χειροκίνητη προσθήκη υπό το πρότυπο <b>LTI 1.0/1.1</b> και να εισάγετε το <b>Provider URL</b>, το <b>Key</b> και το <b>Secret</b>, δε θα χρειαστείτε το Cartridge URL.";
$langNewLTIAppStatus = "Κατάσταση";
$langNewLTIAppActive = "Ενεργή";
$langNewLTIAppInActive = "Μη ενεργή";
$langNoLTIApps = "Δεν υπάρχουν Εξωτερικές Εφαρμογές LTI.";
$langNoPUBLTIApps = "Δεν υπάρχουν Δημοσιευμένα Εργαλεία LTI.";
$langLTIAPPlertTitle = "Παρακαλώ πληκτρολογήστε τον τίτλο της Εφαρμογής LTI";
$langLTIAPPlertURL = "Παρακαλώ πληκτρολογήστε το URL του LTI Provider";
$langLTIAPPlertKey = "Παρακαλώ πληκτρολογήστε το Key του LTI Provider";
$langLTIAPPlertSecret = "Παρακαλώ πληκτρολογήστε το Secret του LTI Provider";
$langLTIAppAddSuccessful = "Η καταχώριση της Εξωτερικής Εφαρμογής LTI ολοκληρώθηκε με επιτυχία.";
$langTIIAppAddSuccessful = "Η καταχώριση της TurnItIn Εφαρμογής ολοκληρώθηκε με επιτυχία.";
$langPUBLTIAppAddSuccessful = "Η καταχώριση της δημοσίευσης ως εφαρμογή LTI ολοκληρώθηκε με επιτυχία.";
$langLTIAppUpdateSuccessful = "Η ενημέρωση ολοκληρώθηκε με επιτυχία";
$langLTILaunchContainer = "Περιβάλλον προβολής";
$langLTILaunchContainerEmbed = "Ενσωματωμένο";
$langLTILaunchContainerNewWindow = "Νέο παράθυρο";
$langLTILaunchContainerExistingWindow = "Τρέχον παράθυρο";
$langLTIVersion = "Έκδοση LTI";
$langLTIVersion1_1 = "LTI 1.0/1.1";
$langLTIVersion1_3 = "LTI 1.3";
$langLTIProviderPublicKeysetUrl = "LTI Provider Public keyset";
$langLTIProviderInitiateLoginUrl = "LTI Provider Initiate login URL";
$langLTIProviderRedirectionUri = "LTI Provider Redirection URI";
$langTurnitinConf = "Ρυθμίσεις \"TurnItIn\" του $siteName";
$langTurnitinConfDetails = "Λεπτομέρειες ρύθμισης εργαλείου";
$langTurnitinEnabled = "Ενεργοποιημένο";
$langNoAvailableTurnitinTemplates = "Δεν υπάρχουν διαθέσιμες εφαρμογές LTI.";
$langTiiApp = "Εφαρμογή TurnItIn";
$langTurnitinIntegration = "Ενσωμάτωση με TurnItIn";
$langTurnitinNewAssignNotice = "Σημείωση: μετά τη δημιουργία TurnItIn εργασίας πρέπει να επισκεφτείτε την οθόνη της και να συνδεθείτε στο TurnItIn για να αρχικοποιηθούν οι επιλογές σας.";
$langTiiFeedbackReleaseDate = "Προθεσμία αποτελεσμάτων";
$langTiiSubmissionSettings = "Ρυθμίσεις υποβολής";
$langTiiSubmissionNoStore = "Χωρίς αποθήκευση υποβολών";
$langTiiSubmissionStandard = "Προεπιλεγμένο αποθετήριο δημοσιεύσεων";
$langTiiSubmissionInstitutional = "Ιδρυματικό αποθετήριο δημοσιεύσεων";
$langTiiCompareAgainst = "Σύγκριση έναντι";
$langTiiStudentPaperCheck = "Προεπιλεγμένο αποθετήριο δημοσιεύσεων";
$langTiiInternetCheck = "Υλικό στο Internet";
$langTiiJournalCheck = "Επιστημονικά περιοδικά και λοιπές δημοσιεύσεις";
$langTiiInstitutionCheck = "Ιδρυματικό αποθετήριο";
$langTiiSimilarityReport = "Αναφορά Ομοιότητας";
$langTiiReportGenImmediatelyNoResubmit = "Παραγωγή αναφορών άμεσα (χωρίς επανυποβολή)";
$langTiiReportGenImmediatelyWithResubmit = "Παραγωγή αναφορών άμεσα (επανυποβολή έως την προθεσμία): Μετά από 3 υποβολές, οι αναφορές παράγονται έπειτα από 24 ώρες";
$langTiiReportGenOnDue = "Παραγωγή αναφορών μετά την προθεσμία υποβολής (επανυποβολή έως την προθεσμία)";
$langTiiSViewReports = "Πρόσβαση φοιτητών στην Αναφορά Ομοιότητας";
$langTiiExcludeBiblio = "Εξαίρεση του βιβλιογραφικού υλικού";
$langTiiExcludeQuoted = "Εξαίρεση του αναφερόμενου υλικού";
$langTiiExcludeSmall = "Εξαίρεση μικρών πηγών";
$langTiiExcludeType = "Τύπος εξαίρεσης";
$langTiiExcludeTypeWords = "Λέξεις";
$langTiiExcludeValue = "Τιμή εξαίρεσης";
$langTiiInstructorCustomParameters = "Προσαρμοσμένες παράμετροι";
$langTiiSelectContent = "Επιλογή Περιεχομένου";
$langTiiSelectContentDesc = "Παρακαλούμε χρησιμοποιήστε την επιλογή περιεχομένου για να ορίσετε τον τίτλο, τη μέγιστη βαθμολογία και τις ημερομηνίες της Εργασίας, τα πεδία θα μεταφερθούν αυτόματα από τις επιλογές στο Turnitin.";
$langTiiSelectedContent = "Επιλεγμένο επιτυχώς";
$langTiiSelectContentAutoComplete = "Το πεδίο θα συμπληρωθεί αυτόματα κατά τη διαδικασία επιλογής περιεχομένου.";
$langLTIOptions = "Επιλογές Turnitin";
$langUseOfApp = "Χρήση της εφαρμογής";
$langUseOfAppInfo = "Επιλέξτε σε ποια $langsCourses θα χρησιμοποιείται η εφαρμογή";
$langUseOfService = "Χρήση της υπηρεσίας";
$langUseOfServiceInfo = "Επιλέξτε σε ποια $langsCourses θα χρησιμοποιείται η υπηρεσία";
$langLimesurveyConf = "Ρυθμίσεις \"LimeSurvey\" του $siteName";
$langLimesurveyAppAddSuccessful = "Η καταχώριση της LimeSurvey Εφαρμογής ολοκληρώθηκε με επιτυχία.";
$langLimesurveyAppDeleteSuccessful = "Η διαγραφή ολοκληρώθηκε με επιτυχία";
$langLimesurveyEnabled = "Ενεργοποιημένο";
$langNewLimesurveyTool = "Προσθήκη νέας εφαρμογής LimeSurvey (LTI)";
$langNoAvailableLimesurveyTemplates = "Δεν υπάρχουν διαθέσιμες εφαρμογές LTI.";
$langLimesurveyApp = "Εφαρμογή LimeSurvey";
$langLimesurveyLTIOptions = "Επιλογές LimeSurvey";
$langLimesurveyIntegration = "Ενσωμάτωση με LimeSurvey";
$langPanoptoConf = "Ρυθμίσεις \"Panopto\" του $siteName";
$langPanoptoConfDetails = "Λεπτομέρειες Εφαρμογής Panopto";
$langPanoptoAppAddSuccessful = "Η καταχώριση της Panopto Εφαρμογής ολοκληρώθηκε με επιτυχία.";
$langPanoptoAppDeleteSuccessful = "Η διαγραφή της Panopto Εφαρμογής ολοκληρώθηκε με επιτυχία.";
$langPanoptoEnabled = "Ενεργοποιημένο";
$langNewPanoptoTool = "Προσθήκη νέας εφαρμογής Panopto (LTI)";
$langNoAvailablePanoptoTemplates = "Δεν υπάρχουν διαθέσιμες εφαρμογές LTI.";
$langPanoptoApp = "Εφαρμογή Panopto";
$langPanoptoLTIOptions = "Επιλογές Panopto";
$langPanoptoIntegration = "Ενσωμάτωση με Panopto";


// Messages for colmooc
$langColmooc = "colMOOC";
$langColmoocCreateAgentFailed = "Ανιχνεύθηκε σφάλμα κατά τη δημιουργία της συζήτησης. Παρακαλούμε ξαναπροσπαθήστε.";
$langColmoocCreateAgentSuccess = "Η συζήτηση δημιουργήθηκε επιτυχώς. Παρακαλούμε ενημερώστε τους σπουδαστές σας οτι μπορούν να προχωρήσουν με την εγγραφή στη συζήτηση.";
$langColmoocRegisterStudentFailed = "Ανιχνεύθηκε σφάλμα κατά την εγγραφή στη συζήτηση. Παρακαλούμε ξαναπροσπαθήστε.";
$langColmoocRegisterStudentSuccess = "Η συζήτηση ολοκληρώθηκε επιτυχώς. Παρακαλούμε κλείστε αυτόν το διάλογο και επιστρέψτε στη λίστα συζητήσεων.";
$langColmoocRegisterStudentNoPartner = "Αποτυχημένη εύρεση συνεργάτη. Παρακαλούμε ξαναπροσπαθήστε.";
$langColmoocFollowLink1 = "Παρακαλούμε πατήστε το σύνδεσμο";
$langColmoocFollowLink2 = "για να μεταφερθείτε στο περιβάλλον του ColMOOC";
$langColMoocAgentNeeded = "Παρακαλούμε επισκεφθείτε τη νέα συζήτηση για να μεταφερθείτε στο περιβάλλον του ColMOOC και να δημιουργήσετε τον Agent για να μπορούν να έχουν πρόσβαση οι σπουδαστές σας.";
$langColMoocAgentCreateOrEdit = "Παρακαλούμε επιλέξτε Δημιουργία ή Επεξεργασία του Agent για να μεταφερθείτε στο περιβάλλον του ColMOOC.";
$langColMoocSessionStatusNoPair = "Δε βρέθηκε συνομιλητής";
$langColMoocSessionStatusFinished = "Ολοκληρώθηκε";
$langColMoocSessionStatusNoFinalAnswer = "Δε δόθηκε τελική απάντηση";
$langColMoocCompletions = "Αριθμός ολοκληρώσεων";
$langColmoocPairLog = "Καταγραφή Ζευγών";
$langColmoocCompletionsLog = "Καταγραφή Ολοκληρώσεων";
$langColmoocModerator = "Συντονιστής";
$langColmoocPartner = "Συνομιλητής";

// Learning Analytics
$langLearningAnalytics = 'Μαθησιακή Αναλυτική';
$langRequiredTitle = 'Το πεδίο "Τίτλος" είναι υποχρεωτικό.';
$langAnalyticsUpdateSuccess = 'Οι δραστηριότητες ενημερώθηκαν με επιτυχία!';
$langAnalyticsInsertSuccess = 'Η εισαγωγή της δραστηριότητας έγινε με επιτυχία!';
$langAnalyticsDeleteSuccess = "Η δραστηριότητα διαγράφηκε με επιτυχία!";
$langAnalyticsDeactivated = "Η δραστηριότητα απενεργοποιήθηκε!";
$langAnalyticsActivated = "Η δραστηριότητα ενεργοποιήθηκε";
$langAnalyticsElementDeleteSuccess = "Το κριτήριο της δραστηριότητας διαγράφηκε με επιτυχία";
$langAnalyticsMinValueRequired = 'Το πεδίο "Ελάχιστη τιμή" είναι υποχρεωτικό.';
$langAnalyticsMaxValueRequired = 'Το πεδίο "Μέγιστη τιμή" είναι υποχρεωτικό.';
$langAnalyticsLowThresholdRequired = 'Το πεδίο "Κάτω όριο" είναι υποχρεωτικό.';
$langAnalyticsHighThresholdRequired = 'Το πεδίο "Άνω όριο" είναι υποχρεωτικό.';
$langAnalyticsWeightRequired = 'Το πεδίο "Βαρύτητα" είναι υποχρεωτικό.';
$langAnalyticsElementInsertSuccess = "Η προσθήκη έγινε με επιτυχία!";
$langAnalyticsTotalAnalytics = 'Συνολικά Αποτελέσματα';
$langAnalyticsViewPerUserGeneral = 'Προβολή ανά χρήστη';
$langAnalyticsPageNotAvailableForUsers = 'Η σελίδα δεν είναι διαθέσιμη για χρήστες';
$langAnalyticsNoAnalytics = 'Δεν έχουν οριστεί δραστηριότητες.';
$langAnalyticsConfirm = 'Επιβεβαίωση';
$langAnalyticsAdvancedLevel = 'Προχωρημένο Επίπεδο';
$langAnalyticsMiddleLevel = 'Μέσο επίπεδο';
$langAnalyticsCriticalLevel = 'Κρίσιμο Επίπεδο';
$langAnalyticsNoElements = 'Δεν έχουν οριστεί ακόμα παράμετροι.';
$langAnalyticsGradeLimits = 'Όρια Βαθμολογίας';
$langAnalyticsThresholds = 'Κατώφλια';
$langAnalyticsWeight = 'Βαρύτητα';
$langAnalyticsConfirmDeletion = 'Είστε σίγουροι πως θέλετε να διαγραφεί η παράμετρος;';
$langAnalyticsResource = 'Πηγή';
$langAnalyticsParameters = 'Παράμετροι δραστηριότητας';
$langAnalyticsTimeFrame = 'Χρονικό Διάστημα';
$langAnalyticsCalculation = 'Υπολογισμός';
$langAnalyticsNoUsersToDisplay = 'Δεν υπάρχουν χρήστες για προβολή αποτελεσμάτων.';
$langPercentage = 'Ποσοστό';
$lampAnalyticsStatus = 'Κατάσταση';
$langAnalyticsNotAvailable = 'Μη διαθέσιμο';
$langAnalyticsStartDescription = 'Ημερομηνία από την οποία θα υπολογίζονται οι δραστηριότητες.';
$langAnalyticsEndDescription = 'Ημερομηνία μέχρι την οποία θα υπολογίζονται οι δραστηριότητες.';
$langAnalyticsMinValue = 'Κατώτερη τιμή';
$langAnalyticsMaxValue = 'Ανώτερη τιμή';
$langAnalyticsResourceNotAvailable = 'Δεν υπάρχουν διαθέσιμες πηγές.';
$langAnalyticsStatus = 'Επίπεδο';

// h5p
$langH5p = "Περιεχόμενο H5P";
$langH5pInstall = "Εγκατάσταση πακέτων και βιβλιοθηκών διαδραστικού περιεχομένου τύπου H5P";
$langH5pUpdateComplete = 'Η ενημέρωση των πακέτων και βιβλιοθηκών ολοκληρώθηκε!';
$langH5pInteractiveContent = 'Διαδραστικό περιεχόμενο τύπου H5P';
$langH5pInteractiveContentByStudents = "Διαδραστικό περιεχόμενο τύπου H5P από $langsOfStudentss";
$langH5pNoContent = 'Δεν υπάρχει διαδραστικό περιεχόμενο τύπου H5P';
$langH5pSaveSuccess = "Το διαδραστικό περιεχόμενο τύπου H5P αποθηκεύτηκε με επιτυχία";
$langH5pDeleteSuccess = "Το διαδραστικό περιεχόμενο τύπου H5P διαγράφτηκε με επιτυχία";
$langOfH5p = "διαδραστικού περιεχομένου";
$langTypeH5P = "Τύπος H5P";
$langImportH5P = "Μπορείτε να εισάγετε ένα έτοιμο αρχείο διαδραστικού περιεχομένου τύπου H5P μέσω της παρακάτω φόρμας.";
$langCreatedBy = "δημιουργήθηκε από";
$langH5pInfoUpdate = "Κάντε κλικ στο 'Ενημέρωση' έτσι ώστε οι διαθέσιμοι τύποι διαδραστικού περιεχομένου H5P
                    να ενημερωθούν με τις πιο πρόσφατες αλλαγές (αν υπάρχουν). <br>
                    Δείτε περισσότερες λεπτομέρειες στο
                    <a href='https://h5p.org/content-types-and-applications/' target='_blank' aria-label='Ενημέρωση H5p - (opens in a new tab)'>https://h5p.org/content-types-and-applications/</a>
                    για τους διαθέσιμους τύπους περιεχομένων.";
$langUpdateRequired = "Χρειάζεται ενημέρωση";
$langReuseActivate = "Ενεργοποίηση Διαμοιρασμού";
$langReuseDeactivate = "Απενεργοποίηση Διαμοιρασμού";
$langEmailBody = "Email Body";
$langCustomEmailBody = "Προσαρμοσμένο Email Body";
$langCustomMailHelp = "
<p>Placeholder μεταβλητών</p>
</br>
<ul>
  <li>[first] : Όνομα</li>
  <li>[last] : Επώνυμο</li>
  <li>[id] : Αριθμός μητρώου</li>
  <li>[email] : Διεύθυνση e-mail</li>
  <li>[phone] : Τηλέφωνο</li>
  <li>[username] : Όνομα χρήστη</li>
  <li>[password] : Κωδικός χρήστη</li>
</ul>";

$lang_disable_name_surname_change = "Να μην επιτρέπεται να αλλάζουν οι χρήστες το όνομα και το επώνυμο";
$lang_disable_email_change = "Να μην επιτρέπεται να αλλάζουν οι χρήστες το e-mail";
$lang_disable_am_change = "Να μην επιτρέπεται να αλλάζουν οι χρήστες τον αριθμό μητρώου";

$langMaintenanceOn = "Ενεργοποίηση συντήρησης";
$langMaintenanceOff = "Απενεργοποίηση συντήρησης";
$langMaintenance = "Συντήρηση";
$langMaintenanceChange = "Αλλαγή κειμένου συντήρησης";
$langMaintenanceMode = "Λειτουργία συντήρησης";

// ticketing (aka request)
$langRequests = "Αιτήματα";
$langMyRequests = "Τα αιτήματά μου";
$langSingleRequest = 'Αίτημα';
$langNewRequest = "Νέο αίτημα";
$langEditRequest = "Επεξεργασία αιτήματος";
$langRequestCreated = 'Το αίτημα δημιουργήθηκε.';
$langRequestNoType = 'Το τύπος δεν υπάρχει.';
$langRequestDeleted = 'Το αίτημα διαγράφτηκε.';
$langWatchers = 'Παρατηρητές';
$langRequestState = 'Κατάσταση αιτήματος';
$langRequestStateNew = 'Νέο';
$langRequestStateAssigned = 'Ανειλημμένο';
$langRequestStateLocked = 'Κλειδωμένο';
$langRequestStateClosed = 'Κλειστό';
$langOpenedOn = 'Δημιουργία';
$langUpdatedOn = 'Τροποποίηση';
$langChangeState = 'Αλλαγή κατάστασης σε';
$langChangeAssignees = 'Αλλαγή ανάθεσης σε: %s (από: %s)';
$langChangeWatchers = 'Αλλαγή παρατηρητών σε: %s (από: %s)';
$langTakeRequest = 'Ανάληψη αιτήματος';
$langRequestTaken = 'Ο χρήστης %s ανέλαβε το αίτημα.';
$langRequestBasicType = 'Βασικό αίτημα';
$langRequestFieldChange = 'Αλλαγή πεδίου %s σε: %s';
$langHourAgo = '%d ώρα πριν';
$langHoursAgo = '%d ώρες πριν';
$langMinuteAgo = '%d λεπτό πριν';
$langMinutesAgo = '%d λεπτά πριν';
$langDayAgo = '%d μέρα πριν';
$langDaysAgo = '%d μέρες πριν';
$langHourAgo = '%d ώρα πριν';
$langHoursAgo = '%d ώρες πριν';
$langShowClosedRequests = 'Εμφάνιση κλειστών αιτημάτων';
$langChangeDescription = 'Περιγραφή αλλαγών';
$lang_pass_submit = 'Αποστολή';
$langInsertExerciseCap = "Άσκηση";
$langPollStart = "Έναρξη";
$langSections = 'Ενότητες';
$langCategoryEssay = "Εργασία";
$langCategoryExcercise = "Άσκηση";
$langCategoryDescription = "Περιγραφή";
$langViewStatics = "Στατιστικά Επισκεψιμότητας";
$langTypeOutMessage = "Πληκτρολογήστε το μήνυμα σας ...";
$langDateHasExpire = "Η ημερομηνία έχει παρέλθει. Δοκιμάστε πάλι.";
$langCalculateNewDuration = "Υπολογισμός νέας διάρκειας";
$langChooseDayAgain = "Δεν μπορείτε να επιλέξετε διαφορετικές μέρες. Δοκιμάστε πάλι.";
$langMessageInfo = "Πληροφορίες μηνύματος";
$langMessageContent = "Περιεχόμενο μηνύματος";


$langCreateCourseLeftForm = "Η δημιουργία μαθήματος είναι η πιο σημαντική ενέργεια του χρήστη – εκπαιδευτή στην πλατφόρμα.</br></br>
                             Πληκτρολογήστε έναν τίτλο για το μάθημά σας.</br></br>
                             Πληκτρολογήστε μια σύντομη περιγραφή για το μάθημα.</br></br>
                             Επιλέξτε τη Σχολή ή το Τμήμα στα πλαίσια του οποίου προσφέρεται το μάθημα ή την κατηγορία μαθημάτων στην οποία ανήκει.</br></br>
                             Επιλέξτε μία από τις διαθέσιμες μορφές μαθημάτων. </br></br>
                             Καθορίστε, προαιρετικά, την άδεια διάθεσης του μαθήματός σας.</br></br>
                             Καθορίστε τον τύπο πρόσβασης στο μάθημά σας. </br></br>
                             Για να ολοκληρωθεί η διαδικασία δημιουργίας του μαθήματός σας, πατήστε το κουμπί με την ένδειξη «Δημιουργία Μαθήματος».";


$langEclassInfo = "Η πλατφόρμα Open eClass αποτελεί ένα ολοκληρωμένο Σύστημα Διαχείρισης Ηλεκτρονικών Μαθημάτων. Ακολουθεί τη φιλοσοφία του λογισμικού ανοικτού κώδικα και υποστηρίζει την υπηρεσία Ασύγχρονης Τηλεκπαίδευσης χωρίς περιορισμούς και δεσμεύσεις. Η πρόσβαση στην υπηρεσία γίνεται με τη χρήση ενός απλού φυλλομετρητή (web browser) χωρίς την απαίτηση εξειδικευμένων τεχνικών γνώσεων.";
$langSaidForUs = "Είπαν για εμάς";
$langCloseOptions = "Κλείσιμο επιλογών";
$langOpenOptions = "Άνοιγμα επιλογών";
$langShowOnlyLoginScreen = "Εμφάνιση μόνο της φόρμας σύνδεσης";
$langHomepageTexts = "Κείμενα αρχικής σελίδας";
$langAccountStatus = "Κατάσταση λογαριασμού";



/* * **********************************************************
 * course invitation
 * ********************************************************** */

$langCourseInvitationHelp = 'Αν η επιλογή είναι ενεργή, οι διαχειριστές μαθημάτων μπορούν να προσκαλούν εξωτερικούς χρήστες στην πλατφόρμα για εγγραφή στο μάθημά τους.';
$langCourseUsersInvitation = "Πρόσκληση χρηστών σε μάθημα";
$langcourseExternalUsersInviation = "Πρόσκληση εξωτερικών χρηστών";
$langCourseInviteOne = "Πρόσκληση χρήστη";
$langCourseInviteMany = "Πρόσκληση χρηστών";
$langDeleteInvitation = "Διαγραφή πρόσκλησης";
$langDeleteInvitationSuccess = "Η πρόσκληση διαγράφτηκε";
$langCourseInvitationSubject = "Πρόσκληση εγγραφής στην πλατφόρμα";
$langCourseInvitationBody1 = "Έχετε λάβει πρόσκληση εγγραφής στην πλατφόρμα $siteName προκειμένου να συμμετάσχετε στο μάθημα";
$langCourseInvitationBody2 = "Για να προχωρήσετε στην εγγραφή, παρακαλούμε ακολουθήστε τον παρακάτω σύνδεσμο.";
$langCourseInvitationSent = "Η πρόσκληση στάλθηκε!";
$langCourseInvitationsSent = "Οι προσκλήσεις στάλθηκαν σε";
$langUserWithEmail = "Ο χρήστης με e-mail";
$langAlreadyAccount = "είχε ήδη λογαριασμό στην πλατφόρμα και προστέθηκε στο μάθημά σας.";
$langAlreadyRegistered = "ήταν ήδη εγγεγραμμένος στο μάθημα σας.";
$langAlreadyRegisteredUsers = "Οι παρακάτω χρήστες είχαν ήδη λογαριασμό στην πλατφόρμα και προστέθηκαν στο μάθημα";
$langInvitationCustomEmail = "
     <p>Placeholder μεταβλητών</p>
     <br>
     <ul>
         <li>[email] : Διεύθυνση e-mail</li>
         <li>[link] : Σύνδεσμος εγγραφής</li>
     </ul>";
$langErrorInserting = "Οι παρακάτω εγγραφές του αρχείου που αποστείλατε είχαν κάποιο πρόβλημα. Είτε το e-mail δεν είναι έγκυρο, είτε τα πεδία ήταν περισσότερα από τα αναμενόμενα:";
$langCourseInvitationUsersExcelInfo = "Μπορείτε να αποστείλετε ένα αρχείο λογιστικού φύλλου (π.χ. xls, xlsx, csv) με μία ή τρείς στήλες.
 Η πρώτη στήλη πρέπει να περιέχει τα e-mail των χρηστών που επιθυμείτε να προσκαλέσετε στο μάθημα.
 Η δεύτερη και τρίτη στήλη μπορούν προαιρετικά να περιέχουν το επίθετο και όνομα κάθε χρήστη.
 Σημειώστε ότι χρήστες που υπάρχουν ήδη στην πλατφόρμα με το e-mail θα προστεθούν αμέσως στο μάθημα χωρίς να λάβουν πρόσκληση και χωρίς άλλη ειδοποίηση.";
$langSendReminder = "Αποστολή υπενθύμισης";
$langNoLongerValid = 'Ο σύνδεσμος που ακολουθήσατε δεν είναι πλέον έγκυρος.';
$langInvitationAlreadyUsed = 'Έχετε ήδη εγγραφεί στην πλατφόρμα μέσω του
    συνδέσμου που ακολουθήσατε. Μπορείτε τώρα να συνδεθείτε με όνομα χρήστη τη
    διεύθυνση e-mail σας και τον κωδικό πρόσβασης που είχατε επιλέξει.';
$langRegisterAsVisitor = 'Εγγραφή ως επισκέπτης';
$langCourseInvitation = 'Πρόσκληση εγγραφής στο μάθημα';
$langMetaTeacher = "Εκπαιδευτικός";
$langMetaLearner = "Μαθητής";
$langMetaAuthor = "Συγγραφέας";
$langMetaManager = "Διαχειριστής";
$langCourseInvitationReceived = 'Έχετε λάβει πρόσκληση συμμετοχής στο ανωτέρω μάθημα.';
$langInvitationClickToAccept = 'Επιλέξτε το παρακάτω κουμπί για να εγγραφείτε και να μεταβείτε στο μάθημα.';
$langInvitationAcceptViaCAS = 'Εφόσον <strong>διαθέτετε</strong> λογαριασμό στο <strong>κεντρικό σύστημα
    πιστοποίησης (%s)</strong>, παρακαλούμε συνδεθείτε με τον ιδρυματικό σας λογαριασμό
    επιλέγοντας το παρακάτω κουμπί.';
$langLoginAndRegister = 'Σύνδεση και εγγραφή';
$langInviteEclassLoginCreate = 'Παρακαλούμε εισαγάγετε παρακάτω τα στοιχεία σας για να εγγραφείτε στην πλατφόρμα.';
$langInviteEclassLoginAlt = 'Εναλλακτικά, <strong>εφόσον δε διαθέτετε
    λογαριασμό στο κεντρικό σύστημα πιστοποίησης</strong>, παρακαλούμε
    εισαγάγετε παρακάτω τα στοιχεία που χρειάζονται για να δημιουργήσετε
    λογαριασμό επισκέπτη στην πλατφόρμα.';
$langSameAsYourEmail = 'ταυτίζεται με τη διεύθυνση e-mail σας';


/* * **********************************************************
 * User available date for reservation
 * ********************************************************** */

$langAvailableDateForUser = "Οι διαθέσιμες ημέρες μου";
$langDisplayAvailableUsersForBooking = "Διαθέσιμοι χρήστες για κράτηση";
$langWarningInfoBookingTutor = "<div class='TextBold' style='color:#ffa500;'>Με ΠΟΡΤΟΚΑΛΙ χρώμα εμφανίζεται η κράτηση προς τον υπεύθυνο από άλλον χρήστη.</br>(Μη δυνατότητα κράτησης).</div>";
$langBlueInfoBookingTutor = "<div class='TextBold' style='color:#337ab7;'>Με ΜΠΛΕ χρώμα εμφανίζεται η διαθέσιμη ημερομηνία του υπευθύνου για να κάνετε κράτηση.</br>Κάντε κλικ στο διαθέσιμο slot για υποβολή κράτησης.</div>";
$langSuccessInfoBookingTutor = "<div class='TextBold' style='color:#1E7E0E;'>Με ΠΡΑΣΙΝΟ χρώμα εμφανίζεται κράτηση που κάνετε προς τον υπεύθυνο (Αναμονή έγκρισης ή απορρίψης από τον υπεύθυνο).</br>Δυνατότητα ακύρωσης κάνοντας κλικ στο slot της κράτησης.</div>";
$langPinkInfoBookingTutor = "<div class='TextBold' style='color:#ffc0cb;'>Με ΡΟΖ χρώμα εμφανίζεται η κράτηση σας προς τον υπεύθυνο (Εγκριση αιτήματος από τον υπεύθυνο).</br>Κάντε κλικ στο διαθέσιμο slot για ακύρωση κράτησης.</div>";
$langIndividualGroupBookings = "Ενεργοποίηση εργαλείου κρατήσεων στο προφίλ του χρήστη και στις ομάδες χρηστών";
$langWithTutor = "Στον υπεύθυνο";
$langHistoyBooking = "Κρατήσεις που έχουν παρέλθει";
$langBookingHasDeleted = "Η κράτηση διαγράφηκε επιτυχώς!";
$ThereIsABookingWithTheSameSlot = "Η κράτησή σας με τον συγκεκριμένο χρήστη δεν ολοκληρώθηκε καθώς έχετε κάνει κράτηση σε κάποιον άλλον την ίδια ημέρα και ώρα έναρξης.";
$langExistBookingForThisDateDelete = "Δεν μπορείτε να διαγράψετε την συγκεκριμένη ημερομηνία.
                                      Κάποιος χρήστης έχει κάνει κράτηση στο συγκεκριμένο slot.
                                      Επεξεργαστείτε το αίτημα από την επιλογή -- Οι κρατήσεις μου -- και δοκιμάστε πάλι.
                                      Επικοινωνήστε με τον διαχειριστή της πλατφόρμας αν αντιμετωπίζετε κάποιο πρόβλημα.";
$langSuccessBookingUser = "<div class='TextBold' style='color:#1E7E0E;'>Με ΠΡΑΣΙΝΟ χρώμα εμφανίζεται η διαθέσιμη ημερομηνία σας για κράτηση από κάποιον χρήστη.</br>
                            Δυνατότητα ακύρωσης κάνοντας κλικ στο slot της ημερομηνίας μόνο σε ενδεχόμενο που δεν έχει γίνει κράτηση από κάποιον χρήστη.</br>
                            Σε διαφορετική περίπτωση , η ακύρωση γίνεται από την σελίδα των κρατήσεων μου.</div>";
$langPinkBookingUser = "<div class='TextBold' style='color:#ffc0cb;'>Με ΡΟΖ χρώμα εμφανίζεται η κράτηση από κάποιον χρήστη.</br>Δυνατότητα ακύρωσης κράτησης μόνο από την σελίδα --Οι κρατήσεις μου-- .</div>";
$langMoveOnLoginPage = "Κατευθυνθείτε στην οθόνη συνδέσης μέσω της επιλογής <span style='font-weight:700;'> «Σύνδεση» </span> στο πάνω μέρος της σελίδας.";

$langImportant = "Μόνιμη τοποθέτηση στην κορυφή της πλατφόρμας";
$langNotImportant = "Απομάκρυνση από την κορυφή της πλατφόρμας";
$langExistImportantAnnounce = "Υπάρχει ήδη μια καταχωρημένη ανακοίνωση στην κορυφή της πλατφόρμας. </br> Η ενέργεια δεν ολοκληρώθηκε.";
$langAboutImportantAnnouncement = "Ρυθμίσεις μόνιμης τοποθετημένης ανακοίνωσης στην κορυφή της σελίδας";
$langbgContainerImportantAnnouncement = "Χρώμα φόντου";
$langclContainerImportantAnnouncement = "Χρώμα κειμένου";
$langclLinkImportantAnnouncement = "Χρώμα συνδέσμου";
$langclHoveredLinkImportantAnnouncement = "Χρώμα hovered συνδέσμου";
$langDisplayAnnouncement = "Προβολή";
$langDontDisplayAgain = "Να μην εμφανιστεί ξανά";
$langNotRegistered = "Μη εγγεγραμένοι";
$langEnableQuickNote = "Ενεργοποίησηση σημειώσεων χρηστών";
$langNoExistNotifications = "Δεν υπάρχουν διαθέσιμες ειδοποιήσεις για το συγκεκριμένο μάθημα.";
$langViewPlatform = "Επιλογή εμφάνισης πλατφόρμας";
$langViewBoxedType = "Οριοθετημένο πλάτος";
$langViewFluidType = "Πλήρες πλάτος";
$langHelpBoxedWidthInfo = "Το πλάτος των header και footer διαμορφώνεται ανάλογα με τις ρυθμίσεις layout με μέγιστο πλάτος (1920px)";
$langHelpFluidWidthInfo = "Το πλάτος των header και footer διαμορφώνεται ανάλογα με το πλάτος της τρέχουσας οθόνης";
$langNavSettingsnavsettingsMainSection = "Main";
$langAddOpacityImage = "Προσθήκη χρώματος στην εικόνα φόντου από την επιλογή «χρώμα φόντου»";
$langFavicon = "Favicon";


/* * ************************************************************************
 * Collaboration messages / Collaboration platform is not always enabled.
 * ************************************************************************ */
$langCollaborationPlatform = "Πλατφόρμα συνεργασίας";
$langEnableCollaboration = "Ενεργοποίηση πλατφόρμας συνεργασίας";
$langAlwaysEnabledCollaboration = "Μόνιμα ενεργοποιημένη";

$langTypeCourse = "μάθημα";
$langTypeCollaboration = "Συνεργασία";
$langCourseFormat = "Μορφή";
$langWithCourseUnits = "Μορφή με ενότητες";
$langMyCollaborations = "Οι συνεργασίες μου";
$langNoParticipatedInCollab = "Δεν συμμετέχετε σε κάποια συνεργασία";
$langPreviewCollaboration = " συνεργασίας";
$langUnregCollaboration = "Απεγγραφή από την συνεργασία";
$langListOfCollaboration = "Παρακάτω εμφανίζεται η λίστα με τις συνεργασίες στις οποίες συμμετέχετε.";
$langDisableCollaborationModulesHelp = "Μπορείτε να επιλέξετε ποια από τα παρακάτω υποσυστήματα επιθυμείτε να απενεργοποιηθούν από όλες τις συνεργασίες της πλατφόρμας.";
$langDefaultModulesCollaborationHelp = "Τα παρακάτω υποσυστήματα είναι ενεργοποιημένα εξ ορισμού στις νέες συνεργασίες της πλατφόρμας κατά τη δημιουργία τους.";
$langWelcomeStudCollab = "«<strong>Συνεργασίες</strong>» και την κατηγορία που περιλαμβάνει τις διαθέσιμες ηλεκτρονικές συνεργασίες.";
$langWelcomeProfCollab = "«<strong>$langCourseCreate</strong>» και την μορφή «<strong>συνεδρίας</strong>» για να δημιουργήσετε τις ηλεκτρονικές σας συνεργασίες.";
$langNotEnrolledToCollaborations = "Δεν έχετε εγγραφεί σε συνεργασίες";
$langSumCollaborationEnrolled = "Συνεργασίες που συμμετέχω";
$langWikiEditionNoSucceed = "Ένα ή περισσότερα υποσυστήματα πρέπει να είναι ενεργοποιημένα εξ ορισμού.";
$m['password_collab'] = "Συνθηματικό συνεργασίας";
$langLabelCollabUserRequest = "Αίτηση εγγραφής στη συνεργασία";
$langInfoAboutCollabRegistration = "Η συνεργασία που επιλέξατε είναι κλειστή. Για να εγγραφείτε, θα πρέπει
        να συμπληρώσετε την παρακάτω αίτηση, η οποία θα καταγραφεί και θα αποσταλεί στους διαχειριστές της συνεργασίας.";
$langRequestReasonsCollab = "Αναφέρετε τους λόγους που επιθυμείτε την εγγραφή σας στη συνεργασία.";
$langCollabDes = "Περιγραφή συνεργασίας";
$langThisCollabDescriptionIsEmpty = "Η συνεργασία δεν διαθέτει περιγραφή";
$langSameAsYourEmail = 'ίδιο με τη διεύθυνση e-mail σας';
$langCollabInvitation = "Πρόσκληση εγγραφής στην συνεργασία";
$langCollab = "Συνεργασία";

/* * ************************************************************************
 * Session module.
 * ************************************************************************ */
$langSession = "Συνεδρίες";
$langAddSession = "Προσθήκη συνεδρίας";
$langIndividualSession = "Ατομική συνεδρία";
$langGroupSession = "Ομαδική συνεδρία";
$langSelectUser = "Επιλογή χρήστη";
$langSelectConsultant = "Επιλογή συμβούλου";
$langAddSessionCompleted = "Η δημιουργία της συνεδρίας ολοκληρώθηκε με επιτυχία";
$langAddSessionNotCompleted = "Η δημιουργία της συνεδρίας δεν ολοκληρώθηκε";
$langAddInCorrectDateVal = "Έχετε καταχωρίσει λανθασμένη ημερομηνία λήξης.";
$langStatement = "Κατάσταση";
$langIndividualSessions = "Ατομικές συνεδρίες";
$langGroupSessions = "Ομαδικές συνεδρίες";
$langInProgress = "Σε εξέλιξη...";
$langSessionHasNotStarted = "Δεν έχει ξεκινήσει ακόμα...";
$langSessionHasExpired = "Έχει παρέλθει";
$langLeaveSession = "Αποχώρηση από την συνεδρία";
$langDelSessionSuccess = "Η συγκεκριμένη συνεδρία διαγράφηκε με επιτυχία";
$langMySessions = "Οι συνεδρίες μου";
$langContinueToDelSession = "Θέλετε να προχωρήσετε στην συγκεκριμένη ενέργεια?";
$langContinueToLeaveSession = "Θέλετε να αποχωρήσετε από την συγκεκριμένη συνεδρία?";
$langLeaveSession = "Αποχώρηση από την συνεδρία";
$langLeaveSessionSuccess = "Αποχωρήσατε με επιτυχία από την συγκεκριμένη συνεδρία";
$langEditSession = "Επεξεργασία συνεδρίας";
$langCompleteSession = "Ολοκλήρωση συνεδρίας";
$langSessionResourseDeleted = "Ο πόρος στην συγκεκριμένη συνεδρία διαγράφηκε επιτυχώς!";
$langNoAvailableSessionRecourses = "Δεν υπάρχουν διαθέσιμοι πόροι στην συγκεκριμένη συνεδρία";
$langResourceCompleted = "Ο πόρος ενημερώθηκε επιτυχώς";
$langAddResource = "Προσθήκη πόρου";
$langEditResource = "Επεξεργασία πόρου";
$langSSession = "Συνεδρία";
$langTypeRemote = "Τύπος";
$langNotRemote = "Δια ζώσης";
$langRemote = "Εξ αποστάσεως";
$langIndividualS = "Ατομική";
$langGroupS = "Ομαδική";
$langNotDisplay = "Μη εμφανής";
$langStartEndSessionDateTime = "Ώρα έναρξης - λήξης συνεδρίας";
$langDateMaxMinutes = "Η διάρκεια συνεδρίας πρέπει είναι 45 λεπτά.";
$langConsultant = "Σύμβουλος";
$langDetailsSession = "Λεπτομέρειες συνεδρίας";
$langAvailableSession = "Νέα συνεδρία";
$langInfoNewSession = "Στο ημερολόγιο θα βρείτε όλες τις συνεδρίες που έχετε καταχωρήσει ως σύμβουλος στην τρέχουσα συνεργασία.
                        Σε αυτά τα slots δεν μπορείτε να προσθέσετε καινούρια συνεδρία παρά μόνο στα ελεύθερα.</br>
                        Επιλέγοντας το επιθυμητό slot και αφού πατήσετε το κουμπί «προσθήκη» στο νέο παράθυρο που θα εμφανιστεί,
                        θα καταχωρίσετε προσωρινά την νέα ημερομηνία ενάρξης και λήξης της συνεδρίας. </br></br>
                        <strong>Η καταχώριση ολοκληρώνεται κάνοντας υποβολή στην φόρμα από το κουμπί «υποβολή».</strong>";
$langInfoNewSessionCoordinator = "<strong>Στο ημερολόγιο εμφανίζονται όλες οι συνεδρίες του συμβούλου τον οποίο επιλέξατε ως υπεύθυνος συνεδρίας.</strong></br>
                        Σε αυτά τα slots δεν μπορεί να προστεθεί κάποια καινούρια συνεδρία παρά μόνο στα ελεύθερα.</br>
                        Επιλέγοντας το επιθυμητό slot και αφού πατήσετε το κουμπί «προσθήκη» στο νέο παράθυρο που θα εμφανιστεί,
                        θα καταχωρίσετε προσωρινά την νέα ημερομηνία ενάρξης και λήξης της συνεδρίας. </br></br>
                        <strong>Η καταχώριση ολοκληρώνεται κάνοντας υποβολή στην φόρμα από το κουμπί «υποβολή».</strong>";

$langInfoEditSession = "Στο ημερολόγιο θα δείτε όλες τις συνεδρίες που έχετε καταχωρήσει ως σύμβουλος της τρέχουσας συνεργασίας.
                        Το πράσινο χρώμα αφορά την τρέχων συνεδρία που θέλετε να επεξεργαστείτε.
                        Επιλέγοντας ένα διαφορετικό slot και αφού πατήσετε το κουμπί «προσθήκη»,
                        θα καταχωρίσετε προσωρινά την νέα ημερομηνία ενάρξης και λήξης της συνεδρίας. </br></br>
                        <strong>Η καταχώριση ολοκληρώνεται κάνοντας υποβολή στην φόρμα από το κουμπί «αλλαγή».</strong></br></br>
                        <strong>Μπορείτε επίσης να αλλάξετε την διάρκεια της τρέχουσας συνεδρίας αλλάζοντας το μέγεθος του πράσινου slot</strong>";
$langInfoEditSessionCoordinator = "<strong>Στο ημερολόγιο θα δείτε όλες τις συνεδρίες που έχει καταχωρήσει ο επιλεγμένος υπεύθυνος συνεδρίας.</strong></br>
                        Το πράσινο χρώμα αφορά την τρέχων συνεδρία που θέλετε να επεξεργαστείτε.
                        Επιλέγοντας ένα διαφορετικό slot και αφού πατήσετε το κουμπί «προσθήκη»,
                        θα καταχωρίσετε προσωρινά την νέα ημερομηνία ενάρξης και λήξης της συνεδρίας. </br></br>
                        <strong>Η καταχώριση ολοκληρώνεται κάνοντας υποβολή στην φόρμα από το κουμπί «αλλαγή».</strong></br>
                        <strong>Μπορείτε επίσης να αλλάξετε την διάρκεια της τρέχουσας συνεδρίας αλλάζοντας το μέγεθος του πράσινου event.</strong>";
$langEmptyUploadFile = "Δεν έχετε επιλέξει κάποιο αρχείο για ανέβασμα.";
$langUploadDocCompleted = "Το ανέβασμα ολοκληρώθηκε με επιτυχία.";
$langSessionType = "Μορφή συνεδρίας";
$langRemoteConference = "Τηλεδιάσκεψη";
$langTcNotStartedYet = "Η τηλεδιάσκεψη δεν έχει ξεκινήσει ακόμα";
$langAddTcSession = "Δημιουργία συνδέσμου τηλεδιάσκεψης";
$langPercentageSessionCompletion = "Ποσοστό ολοκλήρωσης συνεδρίας";
$langAllSessions = "Όλες οι συνεδρίες";
$langSessionHasNotBadge = "Η συνεδρία δεν διαθέτει πόρους ολοκλήρωσης.";
$langRegisteredUsers = "Εγγεγραμένοι χρήστες";
$langDoNotChooseResource = "Το αρχείο σας θα πρέπει να αντιστοιχεί σε κάποια δραστηριότητα ολοκλήρωσης.</br>
                            Αν το πεδίο «Αφορά» είναι κενό τότε δεν υπάρχουν πόροι ολοκλήρωσης της συνεδρίας
                            και δεν μπορείτε να ανεβάσετε κάποιο αρχείο.";
$langWithSubmittedUploadedFile = "Με υποβολή παραδοτέου";
$langSubmittedUploadedFile = "Υποβολή παραδοτέου";
$langMyUploadedFiles = "Τα παραδοτέα μου";
$langViewScreensThemes = "Προβολή θεμάτων";
$langOldThemeInfo = "Λόγω αλλαγών στην εμφάνιση της πλατφόρμας τα παλιά θέματα που τυχόν είχατε δημιουργήσει δεν είναι συμβατά.
                    Θα πρέπει να επιλέξετε κάποιο από τα παρακάτω. Μπορείτε να κάνετε κλικ στο 'Προβολή θεμάτων' για να δείτε
                    πως θα εμφανίζεται η πλατφόρμα.";
$langOldThemeInfoLocation = "Σημειώστε ότι το περιεχόμενο των παλιών θεμάτων (εικόνες, λογότυπα κ.λπ.) θα το βρείτε στο";
$langWhatTypeOfCourse = "Διαθέσιμος τύπος μαθήματος";
$langPageCollaboration = "Σελίδα συνεργασίας";
$langLinkFb = "Σύνδεσμος Facebook";
$langLinkTw = "Σύνδεσμος Twitter";
$langLinkLn = "Σύνδεσμος LinkedIn";
$langLinkBanner = "Σύνδεσμος Banner";
$langShowCoursesInTable = "Εμφάνιση μαθημάτων σε μορφή πίνακα";
$langShowCoursesInPics = "Εμφάνιση μαθημάτων σε μορφή εικόνων";
$langDeliverableInserted = "Δημιουργήσατε με επιτυχία το παραδοτέο";
$langCreateDeliverable = "Δημιουργία παραδοτέου";
$langImgFormsDes = "Συμπληρώστε τα υποχρεωτικά πεδία στην εικονιζόμενη φόρμα";
$langThePageIs = "Βρίσκεστε στην σελίδα:";
$langFrameOpens = "Άνοιγμα παραθύρου";
$langListChoices = "Λίστα επιλογών";
$langAccuratePath = "Ακριβής διαδρομή";
$langOptForColor = "Επιλογή χρώματος";
$langDisplayOptionsImg = "Απεικόνιση ρυθμίσεων";
$langCoursesAndRegistration = "Εγγραφές και διαθέσιμα μαθήματα";
$langOpenNewTab = "Άνοιγμα σε νέα καρτέλα";
$langCurrentMonth = "Τρέχων μήνα";
$langPagination = "Σελιδοποίηση";
$langOpenCloseTools = "Άνοιγμα - κλείσιμο εργαλείων";
$langBreadcrumb = "Πλοήγηση";
$langSelectedLang = "Επιλογή γλώσσας";
$langCourseSelection = "Επιλογή μαθήματος";
$langFillInField = "Συμπληρώστε το πεδίο";
$langColorRequiredField = "Προειδοποίηση υποχρεωτικού πεδίου";
$langRedText = "Κείμενο με κόκκινο χρώμα";
$langGreenText = "Κείμενο με πράσινο χρώμα";
$langBlueText = "Κείμενο με μπλε χρώμα";
$langOrangeText = "Κείμενο με πορτοκαλί χρώμα";
$langColorFocus = "Χρώμα εστίασης (Focus) σε περιοχές κειμένων και κουμπιά";
$langbgPanelEvents = "Χρώμα φόντου (Panel event)";
$langMaxHeight = "Μέγιστο ύψος";
$langPositionJumbotronText = "Στοίχηση κειμένου";
$langTopPositionJumbotronText = "Στοίχηση κειμένου στο πάνω μέρος";
$langCenterPositionJumbotronText = "Κεντρική στοίχηση";
$langBottomPositionJumbotronText = "Στοίχηση κειμένου στο κάτω μέρος";
$langJumbotronWithVideo = "Το αρχείο που ανεβάσατε είναι τύπου .mp4 με πλήρη ονομασία << video.mp4 >>";
$langMaxHeightMaxScreenJumbotron = "Εναλλακτικά το ύψος διαμορφώνεται ανάλογα με ύψος της τρέχουσας οθόνης.";
$langEnableBoxLogo = "Ενεργοποίηση χρώμα φόντου στο περιεχόμενο του λογότυπου";
$langButtonInBriefProfile = "Κουμπιά σύντομου προφίλ";
$langMaxHeightHalfMaxScreenJumbotron = "Εναλλακτικά το ύψος διαμορφώνεται ανάλογα με ύψος της τρέχουσας οθόνης.";
$langHelpJumbotronInfoText = "Σε περίπτωση που το επιλέξετε, το μέγιστο ύψος που είναι καταχωρημένο παύει να ισχύει.";
$langMaxWidthTextJumbotron = "Μέγιστο πλάτος κειμένου";
$langEnableContactInfo = "Ενεργοποίηση φόρμας επικοινωνίας";
$langHelpDeskEmailDoesNotExist = "Δεν βρέθηκε διεύθυνση e-mail στην πλατφόρμα για την αποστολή μηνύματος.";
$langFormContactMessage = "Φόρμα επικοινωνίας - μήνυμα από";
$langDoNotOverrideDeliverable = "Το παραδοτέο σας έχει ελεγχθεί από τον σύμβουλο και δεν μπορεί να αντικατασταθεί.";
$langUploadDeliverableFromUser = "Έχει γίνει υποβολή παραδοτέου από τον ωφελούμενο. Δείτε τα στοιχεία παρακάτω:";
$langAboutDeliverable = "Σχετικά με";

$langCreateReference = "Δημιουργία αναφοράς";
$langInfoUploadReference = "Για την δημιουργία αναφοράς μπορείτε είτε να ανεβάσετε ένα αρχείο από τον υπολογιστή σας
                            είτε να δημιουργήσετε ένα αρχείο .txt συμπληρώνοντας τον τίτλο και το περιεχόμενο του.";
$langDownloadNotEnd = "Το αρχείο δεν ανέβηκε. Δοκιμάστε πάλι.";
$langReference = "Αναφορά";
$langFileCreation = "Δημιουργία αρχείου";
$langMaterialForUser = "Έντυπο καταγραφής χρήστη";
$langAddMaterialForUser = "Προσθέτε το σχόλιο σας";
$langDelMaterialSuccess = "Το έντυπο καταγραφής διαγράφηκε με επιτυχία.";
$langLinkFooterImage = "Σύνδεσμος εικόνας footer";
$langScrollToTop = "Κύληση προς τα πάνω";
$langExistsTheSameSession = "Η συνεδρία δεν δημιουργήθηκε καθώς υπάρχει άλλη καταχωριμένη συνεδρία του συγκεκριμένου συμβούλου την ίδια ώρα.";
$langViewAllSession = "Προβολή προγράμματος όλων των καταχωρημένων συνεδρίων";
$langUsersParticipants = "Συμμετέχουν";
$langBgColorLinkBanner = "Χρώμα φόντου συνδέσμου banner";
$langbgCardAnnouncementDate = "Χρώμα φόντου container ημερομηνίας";
$langTextColorCardAnnouncementDate = "Χρώμα κειμένου ημερομηνίας";
$langwidthOfForm = "Το πλάτος της φόρμας εκτείνεται στο επί % του πλάτους του κύριου περιεχομένου της σελίδας.";
$langStrechedImgOfForm = "Το ύψος της εικόνας εκτείνεται στο ίδιο ύψος της φόρμας εγγραφής.";
$langWidthOfFormInfo = "Η συγκεκριμένη επιλογή δεν αφορά την εικόνα στην φόρμα εγγραφής χρήστη.";
$langEnable_prevent_download_url = "Ενεργοποίηση μεθόδων αποφυγής λήψης αρχείων .pdf από χρήστες στο εργαλείο των Εγγράφων.";
$langFirstShow = "Αρχική εμφάνιση";
$langEnablePreventDownloadPdf = "Ενεργοποίηση μεθόδων αποφυγής λήψης αρχείου";
$langDisablePreventDownloadPdf = "Απενεργοποίηση μεθόδων αποφυγής λήψης αρχείου";
$langPreventEnablePDF = "Η διαδικασία ενεργοποιήθηκε.";
$langPreventDisablePDF = "Η διαδικασία απενεργοποιήθηκε.";
$langChooseContactImg = "Επιλογή εικόνας στην επικοινωνία";
$langNumberScaleDiffAnswers = "Ο μέγιστος αριθμός κλίμακας που καταχωρίσατε θα πρέπει να ισούται με τον αριθμό των πιθανών απαντήσεων που δώσατε.";
$langInfoAddSliderLabels = "Προσθέστε στο πεδίο κειμένου τις πιθανές απαντήσεις που θα περιλαμβάνει η κλίμακα με βάση τον μέγιστο αριθμό της.</br>
                            Η κάθε απάντηση χωρίζεται με το σύμβολο | .</br>
                            Π.χ αν ο μέγιστος αριθμός της κλίμακας είναι 5 τότε θα πρέπει να δώσετε 5 πιθανές απαντήσεις της μορφής: (καθόλου|πολύ λίγο|λίγο|πολύ|πάρα πολύ).";
$langTableDimension = "Δημιουργήστε την διάσταση του πίνακα (N*N) καταχωρόντας τον αριθμό των στηλών και γραμμών του.</br></br>
                       <ul><li>Στήλες = Ερωτήσεις προς τον χρήστη</li><li>Γραμμές = Απαντήσεις από τον χρήστη</li></ul>";
$langNumberOfColumns = "Αριθμός στηλών";
$langNumberOfRows = "Αριθμός γραμμών";
$langWriteQuestion = "Γράψτε την ερώτηση...";
$langNumberRowColBigger = "Ο αριθμός των γραμμών και στηλών του πίνακα θα πρέπει να είναι μεγαλυτερος του μηδέν.";
$langRowsColumnsInsertd = "Οι γραμμές και οι στήλες του πίνακα καταχωρήθηκαν με επιτυχία.";
$langSubmitQuestions = "Υποβολή ερωτήσεων";
$langEditRowsColsTable = "Επεξεργασία διαστάσεων και ερωτήσεων του πίνακα";
$langQuestionsInsertd = "Οι ερωτήσεις προστέθηκαν με επιτυχία.";
$langNumberColumnsSmallerThanQ = "Ο αριθμός των στηλών που καταχωρίσατε είναι μικρότερος από τις διαθέσιμες καταχωρημένες ερωτήσεις.";
$langUserAnswer = "Απάντηση χρήστη";
$langAddRowsColumns = "Καταχώριση";
$langCurrentDuration = "Τρέχουσα διάρκεια";
$langMaxHeightHalfMaxScreenJumbotron = "Εναλλακτικά το ύψος διαμορφώνεται στο μισό ύψος της τρέχουσας οθόνης.";
$langOfSubmitQuestionnaire = "Με υποβολή εργαλείου";
$langUsersAnswers = "Απαντήσεις χρηστών";
$langEnablePagination = "Ενεργοποίηση σελιδοποίησης";
$langPreviousQuestion = "Προηγούμενη";
$langNextQuestion = "Επόμενη";
$langAddConsultantComments = "Οι παρατηρήσεις του συμβούλου προστέθηκαν με επιτυχία.";
$langContinueToDelComment = "Θέλετε να προχωρήσετε στην διαγραφή των σχολίων για τον χρήστη?";
$langInfoCommentsConsultant = "Σε περίπτωση που επιλέξετε χρήστη για τον οποίο έχετε υποβάλει τις παρατηρήσεις σας, τότε o <strong>τίτλος</strong> και
                                τα <strong>σχόλια</strong> θα διαγραφούν και θα αντικατασταθούν με τις νέες τιμές.";
$langDelConsultantComments = "Τα σχόλια διαγράφηκαν με επιτυχία.";
$langNotifyCommentsConsultant = "Ειδοποίηση μέσω email στον χρήστη σχετικά με τα τις παρατηρήσεις του συμβούλου";
$langVisibleToUser = "Ορατή προς τον ωφελούμενο";
$langConsent = "Συναίνεση χρήστη";
$langAttendanceCriterion = "Κριτήριο καταχώρισης παρουσιών";
$langConsultingTools = "Εργαλεία συμβουλευτικής";
$langChooseOtherSession = "Έχετε επιλέξει διαφορετική συνεδρία από την τρέχουσα. Δοκιμάστε πάλι!";
$langEditSessionSection = "Επεξεργασία συνεδρίας";
$langInsertTcMeetingSession = "τηλεργασίας";
$langCompleteCriteriaSession = "Κριτήρια ολοκλήρωσης";
$langSelectToolsPolls = "Εργαλεία συμβουλευτικής";
$langSubmitParticipation = "Συμμετοχή χρήστη";
$langCreateReferenceNotes = "Σημειώσεις";
$langAutomaticCompletion = "Με αυτόματη ολοκλήρωση (μόλις παρέλθει ο χρόνος συνεδρίας)";
$langUserPollAnswer = "απάντησε";
$langStartSession = "Έναρξη συνεδρίας";
$langFinishSession = "Λήξη συνεδρίας";
$langEnableRequiredAnswer = "Υποχρεωτική απάντηση σε κάθε ερώτηση";
$langNoAnswers = "Δεν υπάρχουν απαντήσεις για την συγκεκριμένη ερώτηση";
$langCriteriaBelowParticipateInCompletion = "Τα παρακάτω κριτήρια συμμετέχουν στην ολοκλήρωση συνεδρίας";
$langTheResource = "Ο πόρος";
$langAlreadyUsed = "χρησιμοποιείται από κάποιον ωφελούμενο και δεν μπορεί να διαγραφεί.";
$langListCompletionCriteria = "Λίστα κριτηρίων";
$langUserParticipation = "Συμμετοχή ωφελούμενου";
$langFirstShow = "Αρχική εμφάνιση";
$langNowAllowNullDuration = "Η διάρκεια δεν μπορεί να είναι μηδενική.";
$langShowUnitTitle = "Εμφάνιση σε τίτλους";
$langDownloadPdfNotAllowed = "Μη επιτρεπτή λήψη αρχείου";
$langDisplayRightContentInCPage = "Εμφάνιση ημερολογίου, ανακοινώσεων κ.λπ.";
$langCoursePage = "Σελίδα $langsOfCourse";
$langCoursePrintSetting = "Ρυθμίσεις εμφάνισης αναφορών";
$langCoursePrintHeaderImage = "Εικόνα κεφαλίδας";
$langCoursePrintFooterImage = "Εικόνα υποσέλιδου";
$langReportImageNotFound = "Οι εικόνες πρέπει να βρίσκονται στον κατάλογο με τίτλο Report_Images στα Εγγραφα";

// AI-related language constants - Greek translations
$langAI = "AI";
$langAINode = "Κόμβος Τεχνητής Νοημοσύνης";
$langAIGenerateQuestions = 'Δημιουργία Ερωτήσεων με χρήση Τ.Ν.';
$langAIQuestionGeneration = 'Δημιουργία Ερωτήσεων με χρήση Τ.Ν.';
$langAINotAvailable = 'Η λειτουργία Τ.Ν. δεν είναι διαθέσιμη';
$langContentRequired = 'Το περιεχόμενο είναι απαραίτητο';
$langQuestionsGenerated = 'Δημιουργήθηκαν με επιτυχία %d ερωτήσεις';
$langNoQuestionsGenerated = 'Δεν δημιουργήθηκαν ερωτήσεις';
$langAIGenerationError = 'Σφάλμα κατά τη δημιουργία ερωτήσεων';
$langQuestionsSaved = '%d ερωτήσεις αποθηκεύτηκαν στη βάση ερωτήσεων';
$langSaveError = 'Σφάλμα κατά την αποθήκευση ερωτήσεων';
$langAIQuestionInfo = 'Χρησιμοποιήστε Τ.Ν. για να δημιουργήσετε ερωτήσεις από το περιεχόμενό σας. Το AI θα αναλύσει το κείμενό σας και θα δημιουργήσει ερωτήσεις κατάλληλες για αξιολογήσεις.';
$langProvider = 'Πάροχος';
$langProviders = 'Πάροχοι';
$langContent = 'Περιεχόμενο';
$langEnterContent = 'Εισάγετε το περιεχόμενο από το οποίο θέλετε να δημιουργήσετε ερωτήσεις...';
$langContentHelp = 'Επικολλήστε το περιεχόμενο του μαθήματος, κείμενο εγγράφου ή οποιοδήποτε εκπαιδευτικό υλικό εδώ.';
$langQuestionCount = 'Αριθμός Ερωτήσεων';
$langDifficulty = 'Δυσκολία';
$langQuestionTypes = 'Τύποι Ερωτήσεων';
$langGenerateQuestions = 'Δημιουργία Ερωτήσεων';
$langGeneratedQuestions = 'Δημιουργημένες Ερωτήσεις';
$langSelectQuestions = 'Επιλέξτε τις ερωτήσεις που θέλετε να αποθηκεύσετε στη βάση ερωτήσεων';
$langCorrectAnswer = 'Σωστή Απάντηση';
$langExplanation = 'Επεξήγηση';
$langQuestionCategory = 'Κατηγορία Ερώτησης';
$langSaveToQuestionBank = 'Αποθήκευση στη Βάση Ερωτήσεων';
$langGenerateNew = 'Δημιουργία Νέων Ερωτήσεων';
$langUsageTips = 'Συμβουλές Χρήσης';
$langTip1 = 'Παρέχετε σαφές, καλά δομημένο περιεχόμενο για καλύτερη δημιουργία ερωτήσεων';
$langTip2 = 'Ελέγξτε όλες τις δημιουργημένες ερωτήσεις πριν την αποθήκευση για να εξασφαλίσετε την ακρίβεια';
$langTip3 = 'Συνδυάστε διαφορετικούς τύπους ερωτήσεων για ολοκληρωμένες αξιολογήσεις';
$langTip4 = 'Χρησιμοποιήστε κατάλληλα επίπεδα δυσκολίας ανάλογα με το επίπεδο των μαθητών σας';
$langSelectAll = 'Επιλογή Όλων';
$langAIUserForbidden = "Ο χρήστης δεν έχει δικαίωμα να χρησιμοποιήσει τη λειτουργία Τ.Ν.";
$langAINotEnabledCourse = "Η λειτουργία Τ.Ν. δεν είναι ενεργοποιημένη για το $langsCourse";
$langAPIKeyNotConfigured = "Δεν είναι ρυθμισμένο το API key";
$langProviderDisabled = "Ο πάροχος είναι απενεργοποιημένος";
$langSelectLanguageModel = "Διαλέξτε γλωσσικό μοντέλο";

// AI Course Creation
$langAICourseAssistant = 'Βοηθός Δημιουργίας Μαθήματος με Τ.Ν.';
$langAIGenerateCourse = 'Δημιουργία Μαθήματος με Τ.Ν.';
$langAIExtractFromSyllabus = 'Δημιουργία από αρχείο';
$langAIGenerateFromPrompt = 'Δημιουργία από Περιγραφή';
$langAIUploadSyllabus = 'Ανέβασμα αρχείου PDF με περιγραφή ή αναλυτικό πρόγραμμα μαθήματος';
$langAICoursePrompt = 'Περιγράψτε τις απαιτήσεις του μαθήματος';
$langAIPromptPlaceholder = 'π.χ., Δημιουργία προχωρημένου μεταπτυχιακού μαθήματος μηχανικής μάθησης για φοιτητές πληροφορικής, οργανωμένο σε εβδομαδιαίες ενότητες, που καλύπτει νευρωνικά δίκτυα, βαθιά μάθηση και πρακτικές εφαρμογές...';
$langAIExtractButton = 'Εξαγωγή Δεδομένων Μαθήματος';
$langAIGenerating = 'Δημιουργία δεδομένων μαθήματος...';
$langAIExtracting = 'Εξαγωγή από αναλυτικό πρόγραμμα...';
$langAIExtractionSuccess = 'Τα δεδομένα του μαθήματος εξήχθησαν με επιτυχία';
$langAIGenerationSuccess = 'Τα δεδομένα του μαθήματος δημιουργήθηκαν με επιτυχία';
$langAIGenerationFailed = 'Απέτυχε η δημιουργία δεδομένων μαθήματος';
$langPromptTooShort = 'Η περιγραφή του μαθήματος είναι πολύ σύντομη';
$langPromptTooLong = 'Η περιγραφή του μαθήματος είναι πολύ μεγάλη';
$langAIPreviewData = 'Προεπισκόπηση Δημιουργημένων Δεδομένων';
$langAIApplyData = 'Εφαρμογή στη Φόρμα';
$langAIClearForm = 'Καθαρισμός Φόρμας';
$langAIRetry = 'Δοκιμάστε Ξανά';
$langAISyllabusUpload = 'Ανέβασμα Αναλυτικού Προγράμματος PDF';
$langAIManualPrompt = 'Χειροκίνητη Περιγραφή';
$langAIToggleAssistant = 'Βοηθός Τ.Ν.';
$langAICloseAssistant = 'Κλείσιμο Βοηθού';
$langFileSizeExceeded = 'Το μέγεθος του αρχείου ξεπερνά το επιτρεπτό όριο';
$langInvalidFileType = 'Μη έγκυρος τύπος αρχείου. Επιτρέπονται μόνο PDF αρχεία';
$langAISyllabusInputMethod = 'Μέθοδος Εισόδου';
$langAIUploadFile = 'Ανέβασμα Αρχείου';
$langAIDownloadFromURL = 'Λήψη από URL';
$langAISyllabusURL = 'URL Περιεχομένου Μαθήματος';
$langAIURLDownloadFailed = 'Απέτυχε η λήψη περιεχομένου από URL';
$langAIInvalidURL = 'Μη έγκυρο URL';
$langAIURLNotAccessible = 'Το URL δεν είναι προσβάσιμο';
$langAIDownloading = 'Λήψη από URL...';
$langAIURLDescription = 'Εισάγετε τη διεύθυνση URL μιας ιστοσελίδας ή ενός PDF αρχείου με την περιγραφή του μαθήματος. Το περιεχόμενο θα ληφθεί αυτόματα και θα επεξεργαστεί.';
$langAIPromptDescription = 'Περιγράψτε λεπτομερώς το μάθημά σας συμπεριλαμβανομένων θεμάτων, στόχων, ομάδας-στόχου, επιπέδου και τυχόν ειδικών απαιτήσεων.';
$langAIMaxFileSize = 'Μέγιστο μέγεθος αρχείου: 10MB. Μόνο PDF αρχεία.';
$langAIPreviewTitle = 'Τίτλος';
$langAIPreviewCode = 'Κωδικός';
$langAIPreviewInstructor = 'Διδάσκων';
$langAIPreviewLanguage = 'Γλώσσα';
$langAIPreviewFormat = 'Μορφή';
$langAIPreviewKeywords = 'Λέξεις Κλειδιά';
$langAIPreviewDescription = 'Περιγραφή';
$langAIPreviewSource = 'Πηγή';
$langAIShowFullDescription = 'Εμφάνιση πλήρους περιγραφής';
$langAIHideDescription = 'Απόκρυψη περιγραφής';
$langAISourceDownloaded = 'Λήφθηκε από URL';
$langAISourceWebURL = 'Εξήχθη από ιστοσελίδα';
$langAISourceUploaded = 'Ανέβηκε αρχείο';
$langAIPDFParsingFailed = 'Απέτυχε η ανάγνωση του αρχείου PDF. Το αρχείο μπορεί να είναι κατεστραμμένο, κρυπτογραφημένο ή να περιέχει μόνο εικόνες.';
$langAIPDFNoText = 'Δεν βρέθηκε αναγνώσιμο κείμενο στο PDF. Το αρχείο μπορεί να περιέχει μόνο εικόνες ή σαρωμένο περιεχόμενο.';
$langAIPDFTextExtractionError = 'Σφάλμα κατά την εξαγωγή κειμένου από το αρχείο PDF.';
$langSelectAIProvider = "Διαλέξτε πάροχο Τ.Ν.";
$langNoLangModels = "Δεν υπάρχουν διαθέσιμα γλωσσικά μοντέλα";
$langLanguageModel = "Γλωσσικό Μοντέλο";
$langLanguageModelName = "Όνομα γλωσσικού μοντέλου";
$langAITokenDeleted =  "Διαγράφηκε το κλειδί του παρόχου Τ.Ν.";
$langAIConfigSaved = "Η ρύθμιση του παρόχου Τ.Ν. αποθηκεύτηκε με επιτυχία";
$langAIEvaluation = "Αξιολόγηση με Τ.Ν.";
$langEnableAIEvaluation = "Ενεργοποίηση Αξιολόγησης με Τ.Ν.";
$langAIEvaluationDescription = "Επιτρέπει στην Τ.Ν. να αξιολογεί αυτόματα και να προτείνει βαθμούς για τις απαντήσεις των $langsOfStudents.";
$langEvaluationCriteria = "Κριτήρια Αξιολόγησης";
$langEvaluationCriteriaPlaceholder = "Περιγράψτε τι αναζητάτε σε μια καλή απάντηση. Να είστε συγκεκριμένοι για βασικές έννοιες, παραδείγματα και δείκτες ποιότητας.";
$langEvaluationCriteriaHelp = "Συμπληρώστε σαφή κριτήρια που θα χρησιμοποιήσει η Τ.Ν. για την αξιολόγηση των απαντήσεωνν. Να είστε συγκεκριμένοι για το τι συνιστά καλή απάντηση.";
$langMaxPoints = "Μέγιστη Βαθμολογίαί";
$langMaxPointsHelp = "Η μέγιστη βαθμολογία που μπορεί να δοθεί για αυτή την ερώτηση";
$langDefinedInQuestionStatement = "καθορίζεται στη διατύπωση της ερώτησης";
$langSampleResponses = "Δείγματα Απαντήσεων (Προαιρετικό)";
$langSampleResponsesPlaceholder = "Παραδείγματα απαντήσεων για καθοδήγηση της αξιολόγησης Τ.Ν.:\n\nΠαράδειγμα καλής απάντησης | καλή\nΠαράδειγμα κακής απάντησης | κακή\n\nΜορφή: απάντηση | ποιότητα (καλή/κακή/μέτρια)";
$langSampleResponsesHelp = "Παρέχετε παραδείγματα απαντήσεων με δείκτες ποιότητας. Μορφή: 'απάντηση | ποιότητα' (μία ανά γραμμή). Αυτό βοηθά την Τ.Ν. να κατανοήσει τις προσδοκίες σας.";
$langSaveAIConfig = "Αποθήκευση Διαμόρφωσης Τ.Ν.";
$langAIConfigDisabled = "Η αξιολόγηση Τ.Ν. απενεργοποιήθηκε";
$langAIEvaluationsFound = "Υπάρχουν αξιολογήσεις Τ.Ν. προς επισκόπηση";
$langReviewAIEvaluations = "Επισκόπηση Αξιολογήσεων Τ.Ν.";
$langFreeTextNoAnswerConfig = "Οι ερωτήσεις ελεύθερου κειμένου δεν χρειάζονται διαμόρφωση απαντήσεων - μόνο ρυθμίσεις αξιολόγησης Τ.Ν. αν είναι διαθέσιμες";
$langAIEvaluationPromptRequired = "Τα κριτήρια αξιολόγησης είναι υποχρεωτικά όταν η αξιολόγηση Τ.Ν. είναι ενεργοποιημένη";
$langAIMaxPointsRequired = "Οι μέγιστοι βαθμοί πρέπει να είναι μεγαλύτεροι από 0";
$langHighConfidence = "Υψηλή Εμπιστοσύνη";
$langMediumConfidence = "Μέση Εμπιστοσύνη";
$langLowConfidence = "Χαμηλή Εμπιστοσύνη";
$langConfidence = "Εμπιστοσύνη";
$langReasoning = "Αιτιολόγηση";
$langAddToExercise = "Προσθήκη στην Άσκηση";
$langQuestionsAddedToExercise = '%d ερωτήσεις προστέθηκαν στην άσκηση';
$langTestConnection = "Δοκιμή Σύνδεσης";
$langDefaultFillInBlanks = "Συμπληρώστε τα κενά.";
$langAIService = "Νησίδα Λειτουργικότητας Τ.Ν.";
$langAIServices  = "Νησίδες Λειτουργικότητας Τ.Ν.";
$langAddProvider = "Προσθήκη Παρόχου";
$langAssignAIToModule = "Ρυθμίσεις Νησίδας Λειτουργικότητας Τ.Ν.";
$langAIModuleDeleted = "Διαγράφηκε η Νησίδα Λειτουργικότητας Τ.Ν.";

// AI Free Text Evaluation
$langAIAssistedGrading = "Αυτόματη Αξιολόγηση με Τ.Ν.";
$langAIGradingDescription = "Ενεργοποίηση αυτόματης αξιολόγησης απαντήσεων και πρότασης βαθμών με βάση τα κριτήριά σας";
$langAIEvaluationCriteria = "Κριτήρια Αξιολόγησης";
$langAIEvaluationPromptPlaceholder = "Περιγράψτε τι αναζητάτε σε μια καλή απάντηση. Π.χ., 'Ο φοιτητής θα πρέπει να επιδείξει κατανόηση των βασικών εννοιών, να παρέχει συγκεκριμένα παραδείγματα και να δείχνει κριτική σκέψη.'";
$langAIEvaluationPromptHelp = "Καθορίστε ξεκάθαρα τι συνιστά μια καλή απάντηση. Η Τ.Ν. θα χρησιμοποιήσει αυτό για να αξιολογήσει τις απαντήσεις των φοιτητών.";
$langSampleResponses = "Δείγματα Απαντήσεων";
$langExampleGoodResponse = "Παράδειγμα καλής απάντησης...";
$langExampleResponse = "Παράδειγμα απάντησης...";
$langHighQuality = "Υψηλή Ποιότητα";
$langMediumQuality = "Μέση Ποιότητα";
$langLowQuality = "Χαμηλή Ποιότητα";
$langAddSample = "Προσθήκη Δείγματος";
$langSelectScore = "Επιλογή Ποιότητας";
$langOptional = "Προαιρετικό";
$langScore = "Βαθμός";
$langReasoning = "Αιτιολόγηση";
$langAISuggestion = "Πρόταση Τ.Ν.";
$langAISyllabusStructured = "Δομημένα Τμήματα Συλλάβου";
$langAISyllabusBibliography = "Βιβλιογραφία";
$langAISyllabusTeachingMethod = "Μέθοδοι Διδασκαλίας";
$langAISyllabusAssessmentMethod = "Μέθοδοι Αξιολόγησης";
$langAISyllabusPrerequisites = "Προαπαιτούμενα";
$langAISyllabusInstructors = "Διδάσκοντες";
$langAISyllabusTargetGroup = "Ομάδα Στόχος";
$langAISyllabusTextbooks = "Προτεινόμενα Συγγράμματα";
$langAISyllabusAdditionalInfo = "Επιπλέον Πληροφορίες";
$langInvalidScore = "Μη έγκυρος βαθμός";
$langRequestAlreadySent = "Έχει ήδη σταλεί αίτημα εγγραφής για αυτό το μάθημα";
$langRejectedRequests = "Απορριφθείσες Αιτήσεις Χρηστών";
$langAcceptedRequests = "Εγκεκριμένες Αιτήσεις Χρηστών";
