<?php

/*
 *  ========================================================================
 *  * Open eClass
 *  * E-learning and Course Management System
 *  * ========================================================================
 *  * Copyright 2003-2024, Greek Universities Network - GUnet
 *  *
 *  * Open eClass is an open platform distributed in the hope that it will
 *  * be useful (without any warranty), under the terms of the GNU (General
 *  * Public License) as published by the Free Software Foundation.
 *  * The full license can be read in "/info/license/license_gpl.txt".
 *  *
 *  * Contact address: GUnet Asynchronous eLearning Group
 *  *                  e-mail: info@openeclass.org
 *  * ========================================================================
 *
 */

if (isset($_REQUEST['u']) and $is_admin) {
    $statsuser = intval($_REQUEST['u']);
    $add_link = "&amp;u=$statsuser";
} else {
    $statsuser = $uid;
    $add_link = '';
}

$urlback = "../../main/portfolio.php";
if ($is_admin) {
    $urlback = "../admin/listusers.php";
}
$action_bar = action_bar(array(
    array('title' => $langDurationVisitsPerCourse,
        'url' => "$_SERVER[SCRIPT_NAME]?t=u$add_link&amp;per_course_dur=TRUE",
        'icon' => 'fa-solid fa-chart-line',
        'level' => 'primary'
    )
),false);
$tool_content .= $action_bar;

if ($is_admin) {
    $toolName = "$langStatOf: "  . q(uid_to_name($statsuser)) . " (" . q(uid_to_name($statsuser, 'username')) . ")";
    $navigation[] = array('url' => '../admin/index.php', 'name' => $langAdmin);
    $navigation[] = array('url' => '../admin/listusers.php', 'name' => $langListUsers);
}
$head_content .=
    "<script type='text/javascript'>
        startdate = null;
        interval = 1;
        enddate = null;
        module = null;
        user = $statsuser;
        course = null;
        stats = 'u';
    </script>";

require_once 'modules/usage/form.php';

/****   Plots   ****/
$tool_content .= "<div class='plotscontainer mt-4'><div class='col-12'>";
$tool_content .= plot_placeholder("generic_userstats", "$langHits $langAnd $langDuration");
$tool_content .= "</div></div>";

$tool_content .= "<div class='plotscontainer mt-4'><div class='col-12'><div id='coursepref_pie_container'>";
$tool_content .= plot_placeholder("coursepref_pie", $langFavouriteCourse);
$tool_content .= "</div></div></div>";

$tool_content .= "<div class='plotscontainer mt-4'><div class='col-12'><div id='module_container'>";
$tool_content .= plot_placeholder("course_stats", $langModule);
$tool_content .= "</div></div></div>";

/****   Datatables   ****/
$tool_content .= "<div class='col-sm-12 mt-4'><div class='panel panel-default detailscontainer'>";
$tschema = "<thead><tr class='list-header'>"
        . "<th>$langDate</th>"
        . "<th>$langCourse</th>"
        . "<th>$langModule</th>"
        . "<th>$langHits</th>"
        . "<th>$langDuration</th>"
        . "</tr></thead>"
        . "<tbody></tbody>"
        . "<tfoot><tr><th>$langTotal</th><th></th><th></th><th></th><th></th></tr></tfoot>";
$tool_content .= table_placeholder("udetails1", "table-default table-striped table-logs", $tschema, "$langHits $langAnd $langDuration");
$tool_content .= "</div></div>";
