<?php
/*
 *  ========================================================================
 *  * Open eClass
 *  * E-learning and Course Management System
 *  * ========================================================================
 *  * Copyright 2003-2024, Greek Universities Network - GUnet
 *  *
 *  * Open eClass is an open platform distributed in the hope that it will
 *  * be useful (without any warranty), under the terms of the GNU (General
 *  * Public License) as published by the Free Software Foundation.
 *  * The full license can be read in "/info/license/license_gpl.txt".
 *  *
 *  * Contact address: GUnet Asynchronous eLearning Group
 *  *                  e-mail: info@openeclass.org
 *  * ========================================================================
 *
 */

$require_current_course = TRUE;

require_once '../../include/baseTheme.php';
require_once 'modules/wall/wall_functions.php';

$posts_per_page = 10;

if (visible_module(MODULE_ID_WALL) or course_type($course_id) == 'wall' or $is_editor) {
    if (isset($_GET['page'])) {
        $page = intval($_GET['page']);
        if ($page > 1) {// the first page is shown in index.php
            $posts = Database::get()->queryArray("SELECT id, user_id, content, extvideo, FROM_UNIXTIME(timestamp) as datetime, pinned  FROM wall_post WHERE course_id = ?d ORDER BY pinned DESC, timestamp DESC LIMIT ?d,?d", $course_id, ($page-1)*$posts_per_page, $posts_per_page);
            if (count($posts) != 0) {
                echo generate_infinite_container_html($posts, $posts_per_page, ++$page);
            }
        }
    }
}
