import type { Body, Meta } from '@uppy/utils/lib/UppyFile';
import type { PluginOpts } from './BasePlugin.js';
import BasePlugin from './BasePlugin.js';
import type { State } from './Uppy.js';
/**
 * UIPlugin is the extended version of BasePlugin to incorporate rendering with Preact.
 * Use this for plugins that need a user interface.
 *
 * For plugins without an user interface, see BasePlugin.
 */
declare class UIPlugin<Opts extends UIPluginOptions, M extends Meta, B extends Body, PluginState extends Record<string, unknown> = Record<string, unknown>> extends BasePlugin<Opts, M, B, PluginState> {
    #private;
    isTargetDOMEl: boolean;
    el: HTMLElement | null;
    parent: unknown;
    title: string;
    getTargetPlugin<Me extends Meta, Bo extends Body>(target: PluginTarget<Me, Bo>): UIPlugin<any, Me, Bo> | undefined;
    /**
     * Check if supplied `target` is a DOM element or an `object`.
     * If it’s an object — target is a plugin, and we search `plugins`
     * for a plugin with same name and return its target.
     */
    mount<Me extends Meta, Bo extends Body>(target: PluginTarget<Me, Bo>, plugin: UIPlugin<any, Me, Bo>): HTMLElement;
    /**
     * Called when plugin is mounted, whether in DOM or into another plugin.
     * Needed because sometimes plugins are mounted separately/after `install`,
     * so this.el and this.parent might not be available in `install`.
     * This is the case with @uppy/react plugins, for example.
     */
    render(state: Record<string, unknown>, container?: HTMLElement): any;
    update(state: Partial<State<M, B>>): void;
    unmount(): void;
    onMount(): void;
    onUnmount(): void;
}
export default UIPlugin;
export type PluginTarget<M extends Meta, B extends Body> = string | Element | typeof BasePlugin | typeof UIPlugin | BasePlugin<any, M, B>;
export interface UIPluginOptions extends PluginOpts {
    target?: PluginTarget<any, any>;
    replaceTargetContent?: boolean;
    direction?: 'ltr' | 'rtl';
}
//# sourceMappingURL=UIPlugin.d.ts.map