import { jsx as _jsx, jsxs as _jsxs } from "preact/jsx-runtime";
import isDragDropSupported from '@uppy/utils/lib/isDragDropSupported';
import classNames from 'classnames';
import { h } from 'preact';
import AddFiles from './AddFiles.js';
import AddFilesPanel from './AddFilesPanel.js';
import EditorPanel from './EditorPanel.js';
import FileCard from './FileCard/index.js';
import FileList from './FileList.js';
import PickerPanelContent from './PickerPanelContent.js';
import PanelTopBar from './PickerPanelTopBar.js';
import Slide from './Slide.js';
// http://dev.edenspiekermann.com/2016/02/11/introducing-accessible-modal-dialog
// https://github.com/ghosh/micromodal
const WIDTH_XL = 900;
const WIDTH_LG = 700;
const WIDTH_MD = 576;
const HEIGHT_MD = 330;
export default function Dashboard(props) {
    const isNoFiles = props.totalFileCount === 0;
    const isSingleFile = props.totalFileCount === 1;
    const isSizeMD = props.containerWidth > WIDTH_MD;
    const isSizeHeightMD = props.containerHeight > HEIGHT_MD;
    const dashboardClassName = classNames({
        'uppy-Dashboard': true,
        'uppy-Dashboard--isDisabled': props.disabled,
        'uppy-Dashboard--animateOpenClose': props.animateOpenClose,
        'uppy-Dashboard--isClosing': props.isClosing,
        'uppy-Dashboard--isDraggingOver': props.isDraggingOver,
        'uppy-Dashboard--modal': !props.inline,
        'uppy-size--md': props.containerWidth > WIDTH_MD,
        'uppy-size--lg': props.containerWidth > WIDTH_LG,
        'uppy-size--xl': props.containerWidth > WIDTH_XL,
        'uppy-size--height-md': props.containerHeight > HEIGHT_MD,
        // We might want to enable this in the future
        // 'uppy-size--height-lg': props.containerHeight > HEIGHT_LG,
        // 'uppy-size--height-xl': props.containerHeight > HEIGHT_XL,
        'uppy-Dashboard--isAddFilesPanelVisible': props.showAddFilesPanel,
        'uppy-Dashboard--isInnerWrapVisible': props.areInsidesReadyToBeVisible,
        // Only enable “centered single file” mode when Dashboard is tall enough
        'uppy-Dashboard--singleFile': props.singleFileFullScreen && isSingleFile && isSizeHeightMD,
    });
    // Important: keep these in sync with the percent width values in `src/components/FileItem/index.scss`.
    let itemsPerRow = 1; // mobile
    if (props.containerWidth > WIDTH_XL) {
        itemsPerRow = 5;
    }
    else if (props.containerWidth > WIDTH_LG) {
        itemsPerRow = 4;
    }
    else if (props.containerWidth > WIDTH_MD) {
        itemsPerRow = 3;
    }
    const showFileList = props.showSelectedFiles && !isNoFiles;
    const numberOfFilesForRecovery = props.recoveredState
        ? Object.keys(props.recoveredState.files).length
        : null;
    const numberOfGhosts = props.files
        ? Object.keys(props.files).filter((fileID) => props.files[fileID].isGhost)
            .length
        : 0;
    const renderRestoredText = () => {
        if (numberOfGhosts > 0) {
            return props.i18n('recoveredXFiles', {
                smart_count: numberOfGhosts,
            });
        }
        return props.i18n('recoveredAllFiles');
    };
    const dashboard = (
    // biome-ignore lint/a11y/useAriaPropsSupportedByRole: ...
    _jsxs("div", { className: dashboardClassName, "data-uppy-theme": props.theme, "data-uppy-num-acquirers": props.acquirers.length, "data-uppy-drag-drop-supported": !props.disableLocalFiles && isDragDropSupported(), "aria-hidden": props.inline ? 'false' : props.isHidden, "aria-disabled": props.disabled, "aria-label": !props.inline
            ? props.i18n('dashboardWindowTitle')
            : props.i18n('dashboardTitle'), onPaste: props.handlePaste, onDragOver: props.handleDragOver, onDragLeave: props.handleDragLeave, onDrop: props.handleDrop, children: [_jsx("div", { "aria-hidden": "true", className: "uppy-Dashboard-overlay", tabIndex: -1, onClick: props.handleClickOutside }), _jsxs("div", { className: "uppy-Dashboard-inner", role: props.inline ? undefined : 'dialog', style: {
                    width: props.inline && props.width ? props.width : '',
                    height: props.inline && props.height ? props.height : '',
                }, children: [!props.inline ? (_jsx("button", { className: "uppy-u-reset uppy-Dashboard-close", type: "button", "aria-label": props.i18n('closeModal'), title: props.i18n('closeModal'), onClick: props.closeModal, children: _jsx("span", { "aria-hidden": "true", children: "\u00D7" }) })) : null, _jsxs("div", { className: "uppy-Dashboard-innerWrap", children: [_jsx("div", { className: "uppy-Dashboard-dropFilesHereHint", children: props.i18n('dropHint') }), showFileList && _jsx(PanelTopBar, { ...props }), numberOfFilesForRecovery && (_jsxs("div", { className: "uppy-Dashboard-serviceMsg", children: [_jsx("svg", { className: "uppy-Dashboard-serviceMsg-icon", "aria-hidden": "true", focusable: "false", width: "21", height: "16", viewBox: "0 0 24 19", children: _jsxs("g", { transform: "translate(0 -1)", fill: "none", fillRule: "evenodd", children: [_jsx("path", { d: "M12.857 1.43l10.234 17.056A1 1 0 0122.234 20H1.766a1 1 0 01-.857-1.514L11.143 1.429a1 1 0 011.714 0z", fill: "#FFD300" }), _jsx("path", { fill: "#000", d: "M11 6h2l-.3 8h-1.4z" }), _jsx("circle", { fill: "#000", cx: "12", cy: "17", r: "1" })] }) }), _jsx("strong", { className: "uppy-Dashboard-serviceMsg-title", children: props.i18n('sessionRestored') }), _jsx("div", { className: "uppy-Dashboard-serviceMsg-text", children: renderRestoredText() })] })), showFileList ? (_jsx(FileList, { id: props.id, i18n: props.i18n, uppy: props.uppy, files: props.files, resumableUploads: props.resumableUploads, hideRetryButton: props.hideRetryButton, hidePauseResumeButton: props.hidePauseResumeButton, hideCancelButton: props.hideCancelButton, showLinkToFileUploadResult: props.showLinkToFileUploadResult, showRemoveButtonAfterComplete: props.showRemoveButtonAfterComplete, metaFields: props.metaFields, toggleFileCard: props.toggleFileCard, handleRequestThumbnail: props.handleRequestThumbnail, handleCancelThumbnail: props.handleCancelThumbnail, recoveredState: props.recoveredState, individualCancellation: props.individualCancellation, openFileEditor: props.openFileEditor, canEditFile: props.canEditFile, toggleAddFilesPanel: props.toggleAddFilesPanel, isSingleFile: isSingleFile, itemsPerRow: itemsPerRow, containerWidth: props.containerWidth, containerHeight: props.containerHeight })) : (_jsx(AddFiles, { i18n: props.i18n, i18nArray: props.i18nArray, acquirers: props.acquirers, handleInputChange: props.handleInputChange, maxNumberOfFiles: props.maxNumberOfFiles, allowedFileTypes: props.allowedFileTypes, showNativePhotoCameraButton: props.showNativePhotoCameraButton, showNativeVideoCameraButton: props.showNativeVideoCameraButton, nativeCameraFacingMode: props.nativeCameraFacingMode, showPanel: props.showPanel, activePickerPanel: props.activePickerPanel, disableLocalFiles: props.disableLocalFiles, fileManagerSelectionType: props.fileManagerSelectionType, note: props.note, proudlyDisplayPoweredByUppy: props.proudlyDisplayPoweredByUppy })), _jsx(Slide, { children: props.showAddFilesPanel ? (_jsx(AddFilesPanel, { ...props, isSizeMD: isSizeMD }, "AddFiles")) : null }), _jsx(Slide, { children: props.fileCardFor ? _jsx(FileCard, { ...props }, "FileCard") : null }), _jsx(Slide, { children: props.activePickerPanel ? (_jsx(PickerPanelContent, { ...props }, "Picker")) : null }), _jsx(Slide, { children: props.showFileEditor ? (_jsx(EditorPanel, { ...props }, "Editor")) : null }), _jsx("div", { className: "uppy-Dashboard-progressindicators", children: props.progressindicators.map((target) => {
                                    // TODO
                                    // Here we're telling typescript all `this.type = 'progressindicator'` plugins inherit from `UIPlugin`
                                    // This is factually true in Uppy right now, but maybe it doesn't have to be
                                    return props.uppy.getPlugin(target.id).render(props.state);
                                }) })] })] })] }));
    return dashboard;
}
