import { jsx as _jsx, jsxs as _jsxs } from "preact/jsx-runtime";
import classNames from 'classnames';
import { nanoid } from 'nanoid/non-secure';
import { h } from 'preact';
import { useCallback, useEffect, useState } from 'preact/hooks';
import getFileTypeIcon from '../../utils/getFileTypeIcon.js';
import ignoreEvent from '../../utils/ignoreEvent.js';
import FilePreview from '../FilePreview.js';
import RenderMetaFields from './RenderMetaFields.js';
export default function FileCard(props) {
    const { files, fileCardFor, toggleFileCard, saveFileCard, metaFields, requiredMetaFields, openFileEditor, i18n, i18nArray, className, canEditFile, } = props;
    const getMetaFields = () => {
        return typeof metaFields === 'function'
            ? metaFields(files[fileCardFor])
            : metaFields;
    };
    const file = files[fileCardFor];
    const computedMetaFields = getMetaFields() ?? [];
    const showEditButton = canEditFile(file);
    const storedMetaData = {};
    computedMetaFields.forEach((field) => {
        storedMetaData[field.id] = file.meta[field.id] ?? '';
    });
    const [formState, setFormState] = useState(storedMetaData);
    const handleSave = useCallback((ev) => {
        ev.preventDefault();
        saveFileCard(formState, fileCardFor);
    }, [saveFileCard, formState, fileCardFor]);
    const updateMeta = (newVal, name) => {
        setFormState({
            ...formState,
            [name]: newVal,
        });
    };
    const handleCancel = () => {
        toggleFileCard(false);
    };
    const [form] = useState(() => {
        const formEl = document.createElement('form');
        formEl.setAttribute('tabindex', '-1');
        formEl.id = nanoid();
        return formEl;
    });
    useEffect(() => {
        document.body.appendChild(form);
        form.addEventListener('submit', handleSave);
        return () => {
            form.removeEventListener('submit', handleSave);
            document.body.removeChild(form);
        };
    }, [form, handleSave]);
    return (
    // biome-ignore lint/a11y/noStaticElementInteractions: ...
    _jsxs("div", { className: classNames('uppy-Dashboard-FileCard', className), "data-uppy-panelType": "FileCard", onDragOver: ignoreEvent, onDragLeave: ignoreEvent, onDrop: ignoreEvent, onPaste: ignoreEvent, children: [_jsxs("div", { className: "uppy-DashboardContent-bar", children: [_jsx("div", { className: "uppy-DashboardContent-title", 
                        // biome-ignore lint/a11y/useSemanticElements: ...
                        role: "heading", "aria-level": 1, children: i18nArray('editing', {
                            file: (_jsx("span", { className: "uppy-DashboardContent-titleFile", children: file.meta ? file.meta.name : file.name })),
                        }) }), _jsx("button", { className: "uppy-DashboardContent-back", type: "button", form: form.id, title: i18n('finishEditingFile'), onClick: handleCancel, children: i18n('cancel') })] }), _jsxs("div", { className: "uppy-Dashboard-FileCard-inner", children: [_jsxs("div", { className: "uppy-Dashboard-FileCard-preview", style: { backgroundColor: getFileTypeIcon(file.type).color }, children: [_jsx(FilePreview, { file: file }), showEditButton && (_jsx("button", { type: "button", className: "uppy-u-reset uppy-c-btn uppy-Dashboard-FileCard-edit", onClick: (event) => {
                                    // When opening the image editor we want to save any meta fields changes.
                                    // Otherwise it's confusing for the user to click save in the editor,
                                    // but the changes here are discarded. This bypasses validation,
                                    // but we are okay with that.
                                    handleSave(event);
                                    openFileEditor(file);
                                }, children: i18n('editImage') }))] }), _jsx("div", { className: "uppy-Dashboard-FileCard-info", children: _jsx(RenderMetaFields, { computedMetaFields: computedMetaFields, requiredMetaFields: requiredMetaFields, updateMeta: updateMeta, form: form, formState: formState }) }), _jsxs("div", { className: "uppy-Dashboard-FileCard-actions", children: [_jsx("button", { className: "uppy-u-reset uppy-c-btn uppy-c-btn-primary uppy-Dashboard-FileCard-actionsBtn", 
                                // If `form` attribute is supported, we want a submit button to trigger the form validation.
                                // Otherwise, fallback to a classic button with a onClick event handler.
                                type: "submit", form: form.id, children: i18n('saveChanges') }), _jsx("button", { className: "uppy-u-reset uppy-c-btn uppy-c-btn-link uppy-Dashboard-FileCard-actionsBtn", type: "button", onClick: handleCancel, form: form.id, children: i18n('cancel') })] })] })] }));
}
