declare function abortOn(this: {
    abort: (cause: string) => void;
    then?: Promise<any>['then'];
}, signal?: AbortSignal): {
    abort: (cause: string) => void;
    then?: Promise<any>["then"];
};
type Handler = {
    shouldBeRequeued?: boolean;
    fn: () => (...args: any[]) => Promise<void> | void;
    priority: number;
    abort: (cause?: unknown) => void;
    done: () => void;
};
type QueueOptions = {
    priority?: number;
};
export interface AbortablePromise<T> extends Promise<T> {
    abort(cause?: unknown): void;
    abortOn: (...args: Parameters<typeof abortOn>) => AbortablePromise<T>;
}
export type WrapPromiseFunctionType<T extends (...args: any[]) => any> = (...args: Parameters<T>) => AbortablePromise<Awaited<ReturnType<T>>>;
export declare class RateLimitedQueue {
    #private;
    limit: number;
    constructor(limit?: number);
    run(fn: Handler['fn'], queueOptions?: QueueOptions): Handler | Omit<Handler, 'fn' | 'priority'>;
    wrapSyncFunction(fn: () => void, queueOptions: QueueOptions): (...args: Parameters<Handler["fn"]>) => {
        abortOn: typeof abortOn;
        abort: Handler["abort"];
    };
    wrapPromiseFunction<T extends (...args: any[]) => any>(fn: T, queueOptions?: QueueOptions): (...args: Parameters<T>) => AbortablePromise<Awaited<ReturnType<T>>>;
    resume(): void;
    /**
     * Freezes the queue for a while or indefinitely.
     *
     * @param {number | null } [duration] Duration for the pause to happen, in milliseconds.
     *                                    If omitted, the queue won't resume automatically.
     */
    pause(duration?: number | null): void;
    /**
     * Pauses the queue for a duration, and lower the limit of concurrent requests
     * when the queue resumes. When the queue resumes, it tries to progressively
     * increase the limit in `this.#increaseLimit` until another call is made to
     * `this.rateLimit`.
     * Call this function when using the RateLimitedQueue for network requests and
     * the remote server responds with 429 HTTP code.
     *
     * @param {number} duration in milliseconds.
     */
    rateLimit(duration: number): void;
    get isPaused(): boolean;
}
export declare const internalRateLimitedQueue: unique symbol;
export {};
//# sourceMappingURL=RateLimitedQueue.d.ts.map